/* $NoKeywords:$ */
/**
 * @file
 *
 * mns3or.c
 *
 * OR memory specific function to support S3 resume
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project: AGESA
 * @e sub-project: (Mem/NB/OR)
 * @e \$Revision: 59560 $ @e \$Date: 2011-09-26 11:43:44 -0600 (Mon, 26 Sep 2011) $
 *
 **/
/*****************************************************************************
*
* Copyright (C) 2012 Advanced Micro Devices, Inc.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Advanced Micro Devices, Inc. nor the names of
*       its contributors may be used to endorse or promote products derived
*       from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* ***************************************************************************
*
*/

/*
 *----------------------------------------------------------------------------
 *                                MODULES USED
 *
 *----------------------------------------------------------------------------
 */



#include "AGESA.h"
#include "AdvancedApi.h"
#include "amdlib.h"
#include "Ids.h"
#include "OptionMemory.h"
#include "mm.h"
#include "mn.h"
#include "S3.h"
#include "mfs3.h"
#include "mnor.h"
#include "cpuRegisters.h"
#include "cpuFamRegisters.h"
#include "cpuFamilyTranslation.h"
#include "F15PackageType.h"
#include "mnS3or.h"
#include "heapManager.h"
#include "Filecode.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)

#define FILECODE PROC_MEM_NB_OR_MNS3OR_FILECODE

/*----------------------------------------------------------------------------
 *                           TYPEDEFS AND STRUCTURES
 *
 *----------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------
 *                        PROTOTYPES OF LOCAL FUNCTIONS
 *
 *----------------------------------------------------------------------------
 */
BOOLEAN
MemS3ResumeConstructNBBlockOr (
  IN OUT   VOID *S3NBPtr,
  IN OUT   MEM_DATA_STRUCT *MemPtr,
  IN       UINT8 NodeID
  );

UINT16
STATIC
MemNS3GetRegLstPtrOr (
  IN OUT   MEM_NB_BLOCK *NBPtr,
  IN OUT   DESCRIPTOR_GROUP *DescriptPtr
  );

AGESA_STATUS
STATIC
MemNS3GetDeviceRegLstOr (
  IN       UINT32 RegisterLstID,
     OUT   VOID **RegisterHeader
  );

VOID
STATIC
MemNS3SetDfltPllLockTimeOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN       VOID *Value,
  IN OUT   VOID *ConfigPtr
  );

VOID
MemNS3SetDynModeChangeOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  );

VOID
MemNS3SaveMR0Or (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  );

VOID
MemNS3RestoreMR0SetPPDOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  );

VOID
STATIC
MemNS3GetCSROr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN       VOID *Value,
  IN OUT   VOID *ConfigPtr
  );

VOID
STATIC
MemNS3SetCSROr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  );
/*----------------------------------------------------------------------------
 *                          DEFINITIONS AND MACROS
 *
 *----------------------------------------------------------------------------
 */
PCI_SPECIAL_CASE PciSpecialCaseFuncOr[] = {
  {MemNS3GetCSROr, MemNS3SetCSROr},
  {MemNS3GetBitFieldNb, MemNS3SetBitFieldNb},
  {MemNS3GetNBPStateDepRegUnb, MemNS3SetNBPStateDepRegUnb},
  { (VOID (*) (ACCESS_WIDTH, PCI_ADDR, VOID *, VOID *)) memDefRet, MemNS3SetDfltPllLockTimeOr},
  { (VOID (*) (ACCESS_WIDTH, PCI_ADDR, VOID *, VOID *)) memDefRet, MemNS3SetDisAutoCompUnb},
  { (VOID (*) (ACCESS_WIDTH, PCI_ADDR, VOID *, VOID *)) memDefRet, MemNS3SetDynModeChangeOr},
  { (VOID (*) (ACCESS_WIDTH, PCI_ADDR, VOID *, VOID *)) memDefRet, MemNS3DisableChannelNb},
  {MemNS3SaveNBRegiserUnb, MemNS3RestoreNBRegiserUnb},
  {MemNS3GetBitFieldNb, MemNS3SetPreDriverCalUnb},
  { (VOID (*) (ACCESS_WIDTH, PCI_ADDR, VOID *, VOID *)) memDefRet, MemNS3SetMemClkFreqValUnb},
  {MemNS3SaveMR0Or, MemNS3RestoreMR0SetPPDOr}
};

PCI_REG_DESCRIPTOR ROMDATA S3PciPreSelfRefDescriptorOr[] = {
  {{0, 0, 0}, FUNC_2, 0x110, 0xFFFFF8E7},
  {{0, 0, 0}, FUNC_1, 0x40,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x48,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x50,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x58,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x60,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x68,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x70,  0xFFFF0703},
  {{0, 0, 0}, FUNC_1, 0x78,  0xFFFF0703},
  {{0, 1, 0}, FUNC_1, 0x140, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x148, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x150, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x158, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x160, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x168, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x170, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x178, 0x000000FF},
  {{0, 0, 0}, FUNC_1, 0x44,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x4C,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x54,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x5C,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x64,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x6C,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x74,  0xFFFF0707},
  {{0, 0, 0}, FUNC_1, 0x7C,  0xFFFF0707},
  {{0, 1, 0}, FUNC_1, 0x144, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x14C, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x154, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x15C, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x164, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x16C, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x174, 0x000000FF},
  {{0, 1, 0}, FUNC_1, 0x17C, 0x000000FF},
  {{0, 0, 0}, FUNC_1, 0xF0,  0xFF00FF87},
  {{0, 0, 0}, FUNC_1, 0x120, 0x00FFFFFF},
  {{0, 0, 0}, FUNC_1, 0x124, 0x00FFFFFF},
  {{0, 0, 0}, FUNC_2, 0x10C, 0x07F3FBF9},
  {{0, 0, 0}, FUNC_2, 0x114, 0xFFFFFC00},
  {{0, 0, 0}, FUNC_2, 0x118, 0xF773FFFF},
  {{0, 0, 0}, FUNC_2, 0x11C, 0xAFFFFFFF},
  {{0, 0, 0}, FUNC_2, 0x1B0, 0xFFD3FF3F},
  {{0, 2, 0}, FUNC_2, 0x1B4, 0x000003FF}
};

CONST PCI_REGISTER_BLOCK_HEADER ROMDATA S3PciPreSelfRefOr = {
  0,
  (sizeof (S3PciPreSelfRefDescriptorOr) / sizeof (PCI_REG_DESCRIPTOR)),
  S3PciPreSelfRefDescriptorOr,
  NULL
};

CONDITIONAL_PCI_REG_DESCRIPTOR ROMDATA S3CPciPreSelfDescriptorOr[] = {
   // DCT 0
  {{7, 0, 1}, DCT0,   0x40,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x44,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x48,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x4C,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x50,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x54,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x58,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x5C,  0x7FF83FEF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x60,  0x7FF83FE3, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x64,  0x7FF83FE3, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x68,  0x7FF83FE3, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x6C,  0x7FF83FE3, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x78,  0x00020000, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT0,   0x80,  0x0000FFFF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x84,  0x00800003, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x88,  0x3F000000, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x8C,  0x00070000, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x90,  0x0BFDF100, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0xA4,  0x00F07900, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0xA8,  0x3F60FFBC, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x200, 0x3F1F1F1F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x204, 0x0F3F0F3F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x208, 0x07070707, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT0,   0x20C, 0x00000F1F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT0,   SET_S3_NB_PSTATE_OFFSET (0x210, 0), 0xFFCF000F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT0,   SET_S3_NB_PSTATE_OFFSET (0x210, 1), 0xFFCF000F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT0,   SET_S3_NB_PSTATE_OFFSET (0x210, 2), 0xFFCF000F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT0,   SET_S3_NB_PSTATE_OFFSET (0x210, 3), 0xFFCF000F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x214, 0x000F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x218, 0x0F0F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x21C, 0x001F1F00, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT0,   0x220, 0x00001F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT0,   0x224, 0x0000070F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x228, 0xFFFFFFFF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 1, 1}, DCT0,   0x22C, 0x0000001F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x230, 0x0F0F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x234, 0x0F0F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x238, 0x0F0F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x23C, 0x0F0F0F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT0,   0x240, 0x000077FF, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 1, 1}, DCT0,   0x244, 0x0000000F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x248, 0x3F3F1F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x24C, 0x3F3F3F0F, DCT0_MASK, DCT0_ANY_DIMM_MASK},

  // DCT 1
  {{7, 0, 1}, DCT1,   0x40,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x44,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x48,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x4C,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x50,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x54,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x58,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x5C,  0x7FF83FEF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x60,  0x7FF83FE3, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x64,  0x7FF83FE3, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x68,  0x7FF83FE3, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x6C,  0x7FF83FE3, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x78,  0x00020000, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT1,   0x80,  0x0000FFFF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x84,  0x00800003, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x88,  0x3F000000, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x8C,  0x00070000, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x90,  0x0BFDF102, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0xA8,  0x3F60FFBC, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x200, 0x3F1F1F1F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x204, 0x0F3F0F3F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x208, 0x07070707, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT1,   0x20C, 0x00000F1F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT1,   SET_S3_NB_PSTATE_OFFSET (0x210, 0), 0xFFC7000F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT1,   SET_S3_NB_PSTATE_OFFSET (0x210, 1), 0xFFC7000F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT1,   SET_S3_NB_PSTATE_OFFSET (0x210, 2), 0xFFC7000F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{2, 0, 1}, DCT1,   SET_S3_NB_PSTATE_OFFSET (0x210, 3), 0xFFC7000F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x214, 0x000F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x218, 0x0F0F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x21C, 0x001F1F00, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT1,   0x220, 0x00001F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT1,   0x224, 0x0000070F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x228, 0xFFFFFFFF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 1, 1}, DCT1,   0x22C, 0x0000001F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x230, 0x0F0F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x234, 0x0F0F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x238, 0x0F0F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x23C, 0x0F0F0F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 2, 1}, DCT1,   0x240, 0x000077FF, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 1, 1}, DCT1,   0x244, 0x0000000F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x248, 0x3F3F1F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x24C, 0x3F3F3F0F, DCT1_MASK, DCT1_ANY_DIMM_MASK},

  // DCT 0
  // Phy Initialization
  {{5, 3, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x0B),  0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFPllRegWaitTime, 0, DCT0_MASK, ANY_DIMM_MASK},
  // 3. Phy voltage related
  {{1, 1, 1}, DCT0,   BFDataRxVioLvl, 0x00000018, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFClkRxVioLvl, 0x00000018, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFCmpVioLvl, 0x0000C000, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFCmdRxVioLvl, 0x00000018, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFCsrComparator, 0x0000000C, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFAddrRxVioLvl, 0x00000018, DCT0_MASK, ANY_DIMM_MASK},
  // DCT 1
  // Phy Initialization
  {{5, 3, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x0B), 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFPllRegWaitTime, 0, DCT1_MASK, ANY_DIMM_MASK},
  // 3. Phy voltage related
  {{1, 1, 1}, DCT1,   BFDataRxVioLvl, 0x00000018, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFClkRxVioLvl, 0x00000018, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFCmpVioLvl, 0x0000C000, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFCmdRxVioLvl, 0x00000018, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFAddrRxVioLvl, 0x00000018, DCT1_MASK, ANY_DIMM_MASK},

  // 4. Frequency Change
  // Check if a channel needs to be disabled
  {{1, 1, 1}, DCT0,   BFCKETri, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{6, 3, 1}, DCT0,   0, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFCKETri, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{6, 3, 1}, DCT1,   0, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},

  {{3, 3, 1}, DCT0,   BFPllLockTime, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{3, 3, 1}, DCT1,   BFPllLockTime, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{7, 0, 1}, DCT0,   0x94,  0x0FFFEC1F, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{7, 0, 1}, DCT1,   0x94,  0x0FFFEC1F, ANY_DIMM_MASK, ANY_DIMM_MASK},

  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x04), 0x003F3F3F, DCT0_MASK, ANY_DIMM_MASK},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x04), 0x003F3F3F, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFProcOdtAdv, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFProcOdtAdv, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFSkewMemClk, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFSkewMemClk, 0, DCT1_MASK, ANY_DIMM_MASK},

  {{9, 0, 1}, DCT0,   0x94, 0, DCT0_MASK, DCT0_ANY_DIMM_MASK},
  {{9, 0, 1}, DCT1,   0x94, 0, DCT1_MASK, DCT1_ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFPllLockTime, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFPllLockTime, 0, DCT1_MASK, ANY_DIMM_MASK},

  // DCT 0
  // 5. Phy Fence
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x0C), 0x7FFF3FFF, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFDataFence2, 0x00007FFF, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFClkFence2, 0x0000000F, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFCmdFence2, 0x0000000F, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFAddrFence2, 0x0000000F, DCT0_MASK, ANY_DIMM_MASK},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x00),  0x70777777, DCT0_MASK, ANY_DIMM_MASK},

  // 6. Phy Compensation Init
  {{4, 3, 1}, DCT0,   BFDisablePredriverCal, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFDataByteTxPreDriverCal2Pad1, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFDataByteTxPreDriverCal2Pad2, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFDataByteTxPreDriverCal, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFCmdAddr0TxPreDriverCal2Pad1, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFCmdAddr0TxPreDriverCal2Pad2, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFCmdAddr1TxPreDriverCal2Pad1, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFCmdAddr1TxPreDriverCal2Pad2, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFAddrTxPreDriverCal2Pad1, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFAddrTxPreDriverCal2Pad2, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFAddrTxPreDriverCal2Pad3, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFAddrTxPreDriverCal2Pad4, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFCmdAddr0TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFCmdAddr1TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFAddrTxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFClock0TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFClock1TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT0,   BFClock2TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},
  // DCT 1
  // 5. Phy Fence
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x0C), 0x7FFF0FFF, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFDataFence2, 0x00007FFF, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFClkFence2, 0x0000000F, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFCmdFence2, 0x0000000F, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFAddrFence2, 0x0000000F, DCT1_MASK, ANY_DIMM_MASK},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x00),  0x70777777, DCT1_MASK, ANY_DIMM_MASK},
  // 6. Phy Compensation Init
  {{1, 2, 1}, DCT1,   BFDataByteTxPreDriverCal2Pad1, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFDataByteTxPreDriverCal2Pad2, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFDataByteTxPreDriverCal, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFCmdAddr0TxPreDriverCal2Pad1, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFCmdAddr0TxPreDriverCal2Pad2, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFCmdAddr1TxPreDriverCal2Pad1, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFCmdAddr1TxPreDriverCal2Pad2, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFAddrTxPreDriverCal2Pad1, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFAddrTxPreDriverCal2Pad2, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFAddrTxPreDriverCal2Pad3, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFAddrTxPreDriverCal2Pad4, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFCmdAddr0TxPreDriverCalPad0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFCmdAddr1TxPreDriverCalPad0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFAddrTxPreDriverCalPad0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFClock0TxPreDriverCalPad0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFClock1TxPreDriverCalPad0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{8, 2, 1}, DCT1,   BFClock2TxPreDriverCalPad0, 0, DCT0_MASK, ANY_DIMM_MASK},

  {{1, 2, 1}, DCT0,   BFDisablePredriverCal, 0, DCT0_MASK + DCT1_MASK, ANY_DIMM_MASK}
};

CONST CPCI_REGISTER_BLOCK_HEADER ROMDATA S3CPciPreSelfRefOr = {
  0,
  (sizeof (S3CPciPreSelfDescriptorOr) / sizeof (CONDITIONAL_PCI_REG_DESCRIPTOR)),
  S3CPciPreSelfDescriptorOr,
  PciSpecialCaseFuncOr
};

CONDITIONAL_PCI_REG_DESCRIPTOR ROMDATA S3CPciPostSelfDescriptorOr[] = {
  // DCT0 MR0 value and CS Enable map
  {{10, 0, 1}, DCT0, 0,  0, DCT0_MASK, ANY_DIMM_MASK},
  // DCT1 MR0 value and CS Enable map
  {{10, 0, 1}, DCT1, 0,  0, DCT1_MASK, ANY_DIMM_MASK},
  // DCT0
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x10),  0x03FF03FF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x11),  0x03FF03FF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x12),  0x03FF03FF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x13),  0x03FF03FF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x14),  0x03FF03FF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x15),  0x03FF03FF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x16),  0x03FF03FF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x17),  0x03FF03FF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x18),  0x03FF03FF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x19),  0x03FF03FF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x1A),  0x03FF03FF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x1B),  0x03FF03FF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x20),  0x03FF03FF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x21),  0x03FF03FF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x23),  0x03FF03FF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x24),  0x03FF03FF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x26),  0x03FF03FF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x27),  0x03FF03FF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x29),  0x03FF03FF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x2A),  0x03FF03FF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x01),  0xFFFFFFFF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x02),  0xFFFFFFFF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x03),  0xFFFFFFFF, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x101), 0xFFFFFFFF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x102), 0xFFFFFFFF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x103), 0xFFFFFFFF, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x201), 0xFFFFFFFF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x202), 0xFFFFFFFF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x203), 0xFFFFFFFF, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x301), 0xFFFFFFFF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x302), 0xFFFFFFFF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x303), 0xFFFFFFFF, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x05),  0x3E3E3E3E, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x06),  0x3E3E3E3E, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x07),  0x3E3E3E3E, DCT0_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x105), 0x3E3E3E3E, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x106), 0x3E3E3E3E, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x107), 0x3E3E3E3E, DCT0_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x205), 0x3E3E3E3E, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x206), 0x3E3E3E3E, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x207), 0x3E3E3E3E, DCT0_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x305), 0x3E3E3E3E, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x306), 0x3E3E3E3E, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x307), 0x3E3E3E3E, DCT0_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x30),  0x00FF00FF, DCT0_DDR3_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x31),  0x00FF00FF, DCT0_DDR3_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x32),  0x00FF00FF, DCT0_DDR3_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x33),  0x00FF00FF, DCT0_DDR3_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x34),  0x00FF00FF, DCT0_DDR3_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x35),  0x00FF00FF, DCT0_DDR3_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x36),  0x00FF00FF, DCT0_DDR3_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x37),  0x00FF00FF, DCT0_DDR3_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x38),  0x00FF00FF, DCT0_DDR3_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x39),  0x00FF00FF, DCT0_DDR3_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x3A),  0x00FF00FF, DCT0_DDR3_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x3B),  0x00FF00FF, DCT0_DDR3_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x40),  0x00FF00FF, DCT0_DDR3_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x41),  0x00FF00FF, DCT0_DDR3_MASK, 0x01},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x43),  0x00FF00FF, DCT0_DDR3_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x44),  0x00FF00FF, DCT0_DDR3_MASK, 0x04},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x46),  0x00FF00FF, DCT0_DDR3_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x47),  0x00FF00FF, DCT0_DDR3_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x49),  0x00FF00FF, DCT0_DDR3_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x4A),  0x00FF00FF, DCT0_DDR3_MASK, 0x40},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 0, 0x0D),  0x037F037F, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFPhyClkConfig0, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFPhyClkConfig1, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFPhyClkConfig2, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFPhyClkConfig3, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFPhy0x0D0F0F13, 0x00000083, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFAddrCmdTri, 0x0000000A1, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFReserved00C, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFEnRxPadStandby, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFEccDLLPwrDnConf, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT0,   BFTriDM, 0, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFDisDllShutdownSR, 0x00000001, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFReserved4_0,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_1,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_2,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_3,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_4,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_5,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_6,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_7,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_8,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_9,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_A,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_B,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_C,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_D,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_E,  0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_F,  0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved4_10, 0x0000001F, DCT0_MASK, 0x01},
  {{1, 2, 1}, DCT0,   BFReserved4_11, 0x00001F00, DCT0_MASK, 0x01},
  {{1, 1, 1}, DCT0,   BFReserved5_0,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_1,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_2,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_3,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_4,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_5,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_6,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_7,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_8,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_9,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_A,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_B,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_C,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_D,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_E,  0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_F,  0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved5_10, 0x0000001F, DCT0_MASK, 0x04},
  {{1, 2, 1}, DCT0,   BFReserved5_11, 0x00001F00, DCT0_MASK, 0x04},
  {{1, 1, 1}, DCT0,   BFReserved6_0,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_1,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_2,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_3,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_4,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_5,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_6,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_7,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_8,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_9,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_A,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_B,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_C,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_D,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_E,  0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_F,  0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved6_10, 0x0000001F, DCT0_MASK, 0x10},
  {{1, 2, 1}, DCT0,   BFReserved6_11, 0x00001F00, DCT0_MASK, 0x10},
  {{1, 1, 1}, DCT0,   BFReserved7_0,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_1,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_2,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_3,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_4,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_5,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_6,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_7,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_8,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_9,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_A,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_B,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_C,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_D,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_E,  0x0000001F, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_F,  0x00001F00, DCT0_MASK, 0x40},
  {{1, 2, 1}, DCT0,   BFReserved7_10, 0x0000001F, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved7_11, 0x00001F00, DCT0_MASK, 0x40},
  {{1, 1, 1}, DCT0,   BFReserved8_0, 0x00000003, DCT0_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT0,   BFReserved8_1, 0x0000007C, DCT0_MASK, ANY_DIMM_MASK},

    // DCT1
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x10),  0x03FF03FF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x11),  0x03FF03FF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x12),  0x03FF03FF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x13),  0x03FF03FF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x14),  0x03FF03FF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x15),  0x03FF03FF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x16),  0x03FF03FF, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x17),  0x03FF03FF, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x18),  0x03FF03FF, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x19),  0x03FF03FF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x1A),  0x03FF03FF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x1B),  0x03FF03FF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x20),  0x03FF03FF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x21),  0x03FF03FF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x23),  0x03FF03FF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x24),  0x03FF03FF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x26),  0x03FF03FF, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x27),  0x03FF03FF, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x29),  0x03FF03FF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x2A),  0x03FF03FF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x01),  0xFFFFFFFF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x02),  0xFFFFFFFF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x03),  0xFFFFFFFF, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x101), 0xFFFFFFFF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x102), 0xFFFFFFFF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x103), 0xFFFFFFFF, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x201), 0xFFFFFFFF, DCT1_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x202), 0xFFFFFFFF, DCT1_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x203), 0xFFFFFFFF, DCT1_MASK, 0x10},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x301), 0xFFFFFFFF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x302), 0xFFFFFFFF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x303), 0xFFFFFFFF, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x05),  0x3E3E3E3E, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x06),  0x3E3E3E3E, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x07),  0x3E3E3E3E, DCT1_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x105), 0x3E3E3E3E, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x106), 0x3E3E3E3E, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x107), 0x3E3E3E3E, DCT1_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x205), 0x3E3E3E3E, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x206), 0x3E3E3E3E, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x207), 0x3E3E3E3E, DCT1_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x305), 0x3E3E3E3E, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x306), 0x3E3E3E3E, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x307), 0x3E3E3E3E, DCT1_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x30),  0x00FF00FF, DCT1_DDR3_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x31),  0x00FF00FF, DCT1_DDR3_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x32),  0x00FF00FF, DCT1_DDR3_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x33),  0x00FF00FF, DCT1_DDR3_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x34),  0x00FF00FF, DCT1_DDR3_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x35),  0x00FF00FF, DCT1_DDR3_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x36),  0x00FF00FF, DCT1_DDR3_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x37),  0x00FF00FF, DCT1_DDR3_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x38),  0x00FF00FF, DCT1_DDR3_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x39),  0x00FF00FF, DCT1_DDR3_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x3A),  0x00FF00FF, DCT1_DDR3_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x3B),  0x00FF00FF, DCT1_DDR3_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x40),  0x00FF00FF, DCT1_DDR3_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x41),  0x00FF00FF, DCT1_DDR3_MASK, 0x02},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x43),  0x00FF00FF, DCT1_DDR3_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x44),  0x00FF00FF, DCT1_DDR3_MASK, 0x08},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x46),  0x00FF00FF, DCT1_DDR3_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x47),  0x00FF00FF, DCT1_DDR3_MASK, 0x20},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x49),  0x00FF00FF, DCT1_DDR3_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x4A),  0x00FF00FF, DCT1_DDR3_MASK, 0x80},
  {{0, 0, 1}, FUNC_2, SET_S3_SPECIAL_OFFSET (DCT_PHY_FLAG, 1, 0x0D),  0x037F037F, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFPhyClkConfig0, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFPhyClkConfig1, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFPhyClkConfig2, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFPhyClkConfig3, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFPhy0x0D0F0F13, 0x00000083, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFAddrCmdTri, 0x0000000A1, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFReserved00C, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFEnRxPadStandby, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFEccDLLPwrDnConf, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 2, 1}, DCT1,   BFTriDM, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFDisDllShutdownSR, 0, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFReserved4_0,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_1,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_2,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_3,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_4,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_5,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_6,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_7,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_8,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_9,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_A,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_B,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_C,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_D,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_E,  0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_F,  0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved4_10, 0x0000001F, DCT1_MASK, 0x02},
  {{1, 2, 1}, DCT1,   BFReserved4_11, 0x00001F00, DCT1_MASK, 0x02},
  {{1, 1, 1}, DCT1,   BFReserved5_0,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_1,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_2,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_3,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_4,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_5,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_6,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_7,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_8,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_9,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_A,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_B,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_C,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_D,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_E,  0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_F,  0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved5_10, 0x0000001F, DCT1_MASK, 0x08},
  {{1, 2, 1}, DCT1,   BFReserved5_11, 0x00001F00, DCT1_MASK, 0x08},
  {{1, 1, 1}, DCT1,   BFReserved6_0,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_1,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_2,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_3,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_4,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_5,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_6,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_7,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_8,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_9,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_A,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_B,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_C,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_D,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_E,  0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_F,  0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved6_10, 0x0000001F, DCT1_MASK, 0x20},
  {{1, 2, 1}, DCT1,   BFReserved6_11, 0x00001F00, DCT1_MASK, 0x20},
  {{1, 1, 1}, DCT1,   BFReserved7_0,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_1,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_2,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_3,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_4,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_5,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_6,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_7,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_8,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_9,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_A,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_B,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_C,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_D,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_E,  0x0000001F, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_F,  0x00001F00, DCT1_MASK, 0x80},
  {{1, 2, 1}, DCT1,   BFReserved7_10, 0x0000001F, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved7_11, 0x00001F00, DCT1_MASK, 0x80},
  {{1, 1, 1}, DCT1,   BFReserved8_0, 0x00000003, DCT1_MASK, ANY_DIMM_MASK},
  {{1, 1, 1}, DCT1,   BFReserved8_1, 0x0000007C, DCT1_MASK, ANY_DIMM_MASK},

  {{0, 0, 0}, FUNC_2, 0x1B4, 0x08000000, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x180, 0x02000000, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x58,  0x1F00001F, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x5C,  0x00000001, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x80,  0xE7E7E7E7, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x84,  0xE7E7E7E7, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x1B8, 0x00000010, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_3, 0x44,  0x00400004, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_4, 0x128, 0x0003F000, ANY_DIMM_MASK, ANY_DIMM_MASK},
  // Release NB P-state force
  {{0, 2, 0}, FUNC_5, 0x170, 0x00006EDB, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_2, 0x118, 0x00040000, ANY_DIMM_MASK, ANY_DIMM_MASK},
  {{0, 0, 0}, FUNC_2, 0x118, 0x00080000, ANY_DIMM_MASK, ANY_DIMM_MASK},
};

CONST CPCI_REGISTER_BLOCK_HEADER ROMDATA S3CPciPostSelfRefOr = {
  0,
  (sizeof (S3CPciPostSelfDescriptorOr) / sizeof (CONDITIONAL_PCI_REG_DESCRIPTOR)),
  S3CPciPostSelfDescriptorOr,
  PciSpecialCaseFuncOr
};

MSR_REG_DESCRIPTOR ROMDATA S3MSRPreSelfRefDescriptorOr[] = {
  {{0, 0, 0}, 0xC0010010, 0x00000000007F0000},
  {{0, 0, 0}, 0xC001001A, 0x0000FFFFFF800000},
  {{0, 0, 0}, 0xC001001D, 0x0000FFFFFF800000},
  {{0, 0, 0}, 0xC001001F, 0x0044601080000600}
};

CONST MSR_REGISTER_BLOCK_HEADER ROMDATA S3MSRPreSelfRefOr = {
  0,
  (sizeof (S3MSRPreSelfRefDescriptorOr) / sizeof (MSR_REG_DESCRIPTOR)),
  S3MSRPreSelfRefDescriptorOr,
  NULL
};

VOID *MemS3RegListOr[] = {
  (VOID *)&S3PciPreSelfRefOr,
  NULL,
  (VOID *)&S3CPciPreSelfRefOr,
  (VOID *)&S3CPciPostSelfRefOr,
  (VOID *)&S3MSRPreSelfRefOr,
  NULL,
  NULL,
  NULL
};

/*----------------------------------------------------------------------------
 *                            EXPORTED FUNCTIONS
 *
 *----------------------------------------------------------------------------
 */
/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function initializes the northbridge block for S3 resume
 *
 *     @param[in,out]   *S3NBPtr   - Pointer to MEM_NB_BLOCK.
 *     @param[in,out]   *MemPtr  - Pointer to MEM_DATA_STRUCT.
 *     @param[in]       NodeID   - Node ID of the target node.
 *
 *      @return         BOOLEAN
 *                         TRUE - This is the correct constructor for the targeted node.
 *                         FALSE - This isn't the correct constructor for the targeted node.
 */
BOOLEAN
MemS3ResumeConstructNBBlockOr (
  IN OUT   VOID *S3NBPtr,
  IN OUT   MEM_DATA_STRUCT *MemPtr,
  IN       UINT8 NodeID
  )
{
  UINT32  PackageType;
  INT32 i;
  MEM_NB_BLOCK *NBPtr;

  NBPtr = ((S3_MEM_NB_BLOCK *)S3NBPtr)->NBPtr;

  //
  // Determine if this is the expected NB Type
  //
  GetLogicalIdOfSocket (MemPtr->DiesPerSystem[NodeID].SocketId, &(MemPtr->DiesPerSystem[NodeID].LogicalCpuid), &(MemPtr->StdHeader));
  if (!MemNIsIdSupportedOr (NBPtr, &(MemPtr->DiesPerSystem[NodeID].LogicalCpuid))) {
    return FALSE;
  }

  NBPtr->MemPtr = MemPtr;
  NBPtr->MCTPtr = &(MemPtr->DiesPerSystem[NodeID]);
  NBPtr->PciAddr.AddressValue = MemPtr->DiesPerSystem[NodeID].PciAddr.AddressValue;
  MemNInitNBRegTableOr (NBPtr, NBPtr->NBRegTable);
  NBPtr->Node = ((UINT8) NBPtr->PciAddr.Address.Device) - 24;
  NBPtr->Dct = 0;
  NBPtr->Channel = 0;
  NBPtr->Ganged = FALSE;
  NBPtr->NodeCount = MAX_NODES_SUPPORTED_OR;
  NBPtr->DctCount = MAX_DCTS_PER_NODE_OR;

  for (i = 0; i < EnumSize; i++) {
    NBPtr->IsSupported[i] = FALSE;
  }

  for (i = 0; i < NumberOfHooks; i++) {
    NBPtr->FamilySpecificHook[i] = (BOOLEAN (*) (MEM_NB_BLOCK *, VOID *)) memDefTrue;
  }

  LibAmdMemFill (NBPtr->DctCache, 0, sizeof (NBPtr->DctCache), &MemPtr->StdHeader);

  NBPtr->SwitchDCT = MemNSwitchDCTNb;
  NBPtr->SwitchChannel = MemNSwitchChannelNb;
  NBPtr->MemNCmnGetSetFieldNb = MemNCmnGetSetFieldOr;
  NBPtr->GetBitField = MemNGetBitFieldNb;
  NBPtr->SetBitField = MemNSetBitFieldNb;
  NBPtr->MemNIsIdSupportedNb = MemNIsIdSupportedOr;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3ExitSelfRefReg = (VOID (*) (MEM_NB_BLOCK *, AMD_CONFIG_PARAMS *)) memDefRet;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3GetConPCIMask = MemNS3GetConPCIMaskUnb;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3GetConMSRMask = (VOID (*) (MEM_NB_BLOCK *, DESCRIPTOR_GROUP *)) memDefRet;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3Resume = MemNS3ResumeUNb;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3RestoreScrub = MemNS3RestoreScrubNb;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3GetRegLstPtr = MemNS3GetRegLstPtrOr;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3GetDeviceRegLst = MemNS3GetDeviceRegLstOr;
  ((S3_MEM_NB_BLOCK *)S3NBPtr)->MemS3SpecialCaseHeapSize = 0;
  NBPtr->FamilySpecificHook[DCTSelectSwitch] = MemNS3DctCfgSelectUnb;

  // AM3r2 does not support Dll shutdown
  PackageType = LibAmdGetPackageType (&(NBPtr->MemPtr->StdHeader));
  if (PackageType != PACKAGE_TYPE_AM3r2) {
    NBPtr->IsSupported[SetDllShutDown] = TRUE;
  }

  return TRUE;
}

/*----------------------------------------------------------------------------
 *                              LOCAL FUNCTIONS
 *
 *----------------------------------------------------------------------------*/
/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function returns the register list for each device for OR
 *
 *     @param[in,out]   *NBPtr   - Pointer to the MEM_NB_BLOCK
 *     @param[in, out]  *DescriptPtr - Pointer to DESCRIPTOR_GROUP
 *     @return          UINT16 - size of the device descriptor on the target node.
 */
UINT16
STATIC
MemNS3GetRegLstPtrOr (
  IN OUT   MEM_NB_BLOCK *NBPtr,
  IN OUT   DESCRIPTOR_GROUP *DescriptPtr
  )
{
  UINT8 i;
  UINT16 Size;
  Size = 0;
  for (i = PRESELFREF; i <= POSTSELFREF; i ++) {
    DescriptPtr->PCIDevice[i].Type = (UINT8) (DEV_TYPE_PCI_PRE_ESR + i);
    DescriptPtr->PCIDevice[i].Node = NBPtr->Node;
    DescriptPtr->PCIDevice[i].RegisterListID = 0xFFFFFFFF;
    if ((PCI_REGISTER_BLOCK_HEADER *) MemS3RegListOr[PCI_LST_ESR_OR - PCI_LST_ESR_OR + i] != NULL) {
      DescriptPtr->PCIDevice[i].RegisterListID = PCI_LST_ESR_OR + i;
      Size += sizeof (PCI_DEVICE_DESCRIPTOR);
    }
    DescriptPtr->CPCIDevice[i].Type = (UINT8) (DEV_TYPE_CPCI_PRE_ESR + i);
    DescriptPtr->CPCIDevice[i].Node = NBPtr->Node;
    DescriptPtr->CPCIDevice[i].RegisterListID = 0xFFFFFFFF;
    if ((CPCI_REGISTER_BLOCK_HEADER *) MemS3RegListOr[CPCI_LST_ESR_OR - PCI_LST_ESR_OR + i] != NULL) {
      DescriptPtr->CPCIDevice[i].RegisterListID = CPCI_LST_ESR_OR + i;
      Size += sizeof (CONDITIONAL_PCI_DEVICE_DESCRIPTOR);
    }
    DescriptPtr->MSRDevice[i].Type = (UINT8) (DEV_TYPE_MSR_PRE_ESR + i);
    DescriptPtr->MSRDevice[i].RegisterListID = 0xFFFFFFFF;
    if ((MSR_REGISTER_BLOCK_HEADER *) MemS3RegListOr[MSR_LST_ESR_OR - PCI_LST_ESR_OR + i] != NULL) {
      DescriptPtr->MSRDevice[i].RegisterListID = MSR_LST_ESR_OR + i;
      Size += sizeof (MSR_DEVICE_DESCRIPTOR);
    }
    DescriptPtr->CMSRDevice[i].Type = (UINT8) (DEV_TYPE_CMSR_PRE_ESR + i);
    DescriptPtr->CMSRDevice[i].RegisterListID = 0xFFFFFFFF;
    if ((CMSR_REGISTER_BLOCK_HEADER *) MemS3RegListOr[CMSR_LST_ESR_OR - PCI_LST_ESR_OR + i] != NULL) {
      DescriptPtr->CMSRDevice[i].RegisterListID = CMSR_LST_ESR_OR + i;
      Size += sizeof (CONDITIONAL_MSR_DEVICE_DESCRIPTOR);
    }
  }
  return Size;
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function return the register list according to the register ID.
 *
 *     @param[in]   RegisterLstID - value of the Register list ID.
 *     @param[out]  **RegisterHeader - pointer to the address of the register list.
 *     @return      none
 */
AGESA_STATUS
STATIC
MemNS3GetDeviceRegLstOr (
  IN       UINT32 RegisterLstID,
     OUT   VOID **RegisterHeader
  )
{
  if (RegisterLstID >= (sizeof (MemS3RegListOr) / sizeof (VOID *))) {
    ASSERT(FALSE); // RegisterListID exceeded size of Register list
    return AGESA_FATAL;
  }
  if (MemS3RegListOr[RegisterLstID] != NULL) {
    *RegisterHeader = MemS3RegListOr[RegisterLstID];
    return AGESA_SUCCESS;
  }
  ASSERT(FALSE); // Device register list error
  return AGESA_FATAL;
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function that set PllLockTime to default state.
 *
 *     @param[in]   AccessWidth - Access width of the register.
 *     @param[in]   Address - address in PCI_ADDR format.
 *     @param[in, out]  *Value - Pointer to the value to be written.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
STATIC
MemNS3SetDfltPllLockTimeOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN       VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  UINT16 RegValue;

  RegValue = 0x190;
  MemNS3SetBitFieldNb (AccessS3SaveWidth16, Address, &RegValue, ConfigPtr);
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function sets bit 31 [DynModeChange] of F2x9C_xB
 *
 *     @param[in]   AccessWidth - Access width of the register.
 *     @param[in]   Address - address in PCI_ADDR format.
 *     @param[in, out]  *Value - Pointer to the value to be written.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
MemNS3SetDynModeChangeOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  UINT8 Dct;
  UINT32 RegValue;
  UINT32 Temp;
  UINT32 TempValue;

  IDS_SKIP_HOOK (IDS_BEFORE_S3_SPECIAL, &Address, ConfigPtr) {
    Temp = Address.Address.Register;
    Dct = ((Temp & 0x400) == 0) ? 0 : 1;

    // Switch Dct
    Address.Address.Function = FUNC_1;
    Address.Address.Register = 0x10C;
    TempValue = Dct;
    LibAmdPciWrite (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);

    Address.Address.Function = FUNC_2;
    Address.Address.Register = Temp;
    RegValue = 0x80000000;
    MemNS3SetCSRNb (AccessS3SaveWidth32, Address, &RegValue, ConfigPtr);
  }
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function saves the heap data of MR0 and chipsel enable map before S3
 *   entry
 *
 *     @param[in]   AccessWidth - Access width of the register.
 *     @param[in]   Address - address in PCI_ADDR format.
 *     @param[in, out]  *Value - Pointer to the value to be written.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
MemNS3SaveMR0Or (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  AGESA_STATUS Status;
  LOCATE_HEAP_PTR LocateHeapStructPtr;
  MR0_DATA_ARRAY_PTR pMR0Data;
  UINT32 Node;
  UINT32 Dct;

  Node = Address.Address.Device - 0x18;
  Dct = Address.Address.Function;

  // Get original MR0 from heap
  LocateHeapStructPtr.BufferHandle = AMD_MEM_S3_MR0_DATA_HANDLE;
  LocateHeapStructPtr.BufferPtr = NULL;
  Status = HeapLocateBuffer (&LocateHeapStructPtr, ConfigPtr);
  ASSERT (Status == AGESA_SUCCESS);
  pMR0Data = (MR0_DATA_ARRAY_PTR) (LocateHeapStructPtr.BufferPtr);
  ASSERT (pMR0Data != NULL);

  IDS_HDT_CONSOLE (MEM_FLOW, "\tSave MR0 for S3 resume\n\t\tNode: %d, Dct: %d, ChipSelEnMap: %04X, MR0: %04X\n", Node, Dct, (*pMR0Data)[Node][Dct].ChipSelEnMap, (*pMR0Data)[Node][Dct].MR0Value);
  *(UINT32*) Value = (*pMR0Data)[Node][Dct].MR0Value;
  *(UINT32*) Value <<= 16;
  *(UINT32*) Value |= (*pMR0Data)[Node][Dct].ChipSelEnMap;
}

/**
 *
 *
 *   This function send an MRS command to set MR0[PPD] after exit self-refresh
 *
 *     @param[in]   AccessWidth - Access width of the register.
 *     @param[in]   Address - address in PCI_ADDR format.
 *     @param[in, out]  *Value - Pointer to the value to be written.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
MemNS3RestoreMR0SetPPDOr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  UINT32 Node;
  UINT32 Dct;
  UINT16 ChipSelEnMap;
  UINT16 MR0Value;
  UINT32 TempValue;
  UINT32 PowerDownMode;
  UINT32 PchgPDModeSel;
  UINT8 ChipSel;

  Node = Address.Address.Device - 0x18;
  Dct = Address.Address.Function;
  ChipSelEnMap = (UINT16) ((*(UINT32*) Value) & 0xFFFF);
  MR0Value = (UINT16) (((*(UINT32*) Value) >> 16) & 0xFFFF);

  Address.Address.Register = BFPowerDownMode;
  MemNS3GetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
  PowerDownMode = TempValue;

  Address.Address.Register = BFPchgPDModeSel;
  MemNS3GetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
  PchgPDModeSel = TempValue;

  // Check if Fast exit pre-charge powerdown mode is desired
  // D18F2x84[PowerDownMode] = 0
  // D18F2x94[PchgPDModeSel] = 0
  // MR0[PPD] = 1
  if (PowerDownMode == 0 && PchgPDModeSel == 0 && (MR0Value & 0x1000) == 0x1000) {
    for (ChipSel = 0; ChipSel < MAX_CS_PER_CHANNEL; ChipSel++) {
      if (((ChipSelEnMap >> ChipSel) & 1) != 0) {
        // if chip select present
        Address.Address.Register = BFMrsChipSel;
        MemNS3SetBitFieldNb (AccessS3SaveWidth32, Address, &ChipSel, ConfigPtr);
        // BA2=0,BA1=0,BA0=0
        TempValue = 0;
        Address.Address.Register = BFMrsBank;
        MemNS3SetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
        Address.Address.Register = BFMrsAddress;
        MemNS3SetBitFieldNb (AccessS3SaveWidth16, Address, &MR0Value, ConfigPtr);
        // Bit swapping is not needed here because hardware bit swapping does not occur for commands
        // sent via D18F2x7C_dct[1:0][SendMrsCmd] when D18F2x7C_dct[1:0][EndDramInit] = 0
        TempValue = 1;
        Address.Address.Register = BFSendMrsCmd;
        MemNS3SetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
        IDS_HDT_CONSOLE (MEM_FLOW, "\tIssue MRS Command after ESR\n\t\tNode: %d, Dct: %d, CS: %d, MR0: %08X\n", Node, Dct, ChipSel, MR0Value);
        Address.Address.Register = BFSendMrsCmd;
        MemNS3GetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
        while (TempValue != 0) {
          MemNS3GetBitFieldNb (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
        }
        WaitMicroseconds (500, ConfigPtr);
      }
    }
  }
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function read the value of CSR register.
 *
 *     @param[in]   AccessWidth - Access width of the register
 *     @param[in]   Address - address of the CSR register in PCI_ADDR format.
 *     @param[in]  *Value - Pointer to the value be read.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
STATIC
MemNS3GetCSROr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN       VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  UINT32 ExtendOffset;
  UINT32 ValueRead;
  UINT32 TempFunc;
  UINT32 TempValue;

  ValueRead = 0;
  ExtendOffset = Address.Address.Register;
  TempFunc = Address.Address.Function;

  // Switch Dct
  Address.Address.Function = FUNC_1;
  Address.Address.Register = 0x10C;
  TempValue = 0;
  if (ExtendOffset & 0x400) {
    TempValue = 1;
  }
  LibAmdPciWrite (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);
  Address.Address.Function = TempFunc;

  Address.Address.Register = 0x98;
  ExtendOffset &= 0x3FF;
  LibAmdPciWrite (AccessS3SaveWidth32, Address, &ExtendOffset, ConfigPtr);
  while (((ValueRead >> 31) & 1) == 0) {
    LibAmdPciRead (AccessS3SaveWidth32, Address, &ValueRead, ConfigPtr);
  }
  Address.Address.Register = 0x9C;
  LibAmdPciRead (AccessWidth, Address, Value, ConfigPtr);
}

/* -----------------------------------------------------------------------------*/
/**
 *
 *
 *   This function write to a CSR register
 *
 *     @param[in]   AccessWidth - Access width of the register
 *     @param[in]   Address - address of the CSR register in PCI_ADDR format.
 *     @param[in, out]  *Value - Pointer to the value be read.
 *     @param[in, out]  *ConfigPtr - Pointer to Config handle.
 *     @return         none
 */
VOID
STATIC
MemNS3SetCSROr (
  IN       ACCESS_WIDTH AccessWidth,
  IN       PCI_ADDR Address,
  IN OUT   VOID *Value,
  IN OUT   VOID *ConfigPtr
  )
{
  UINT32 ExtendOffset;
  UINT32 ValueRead;
  UINT32 ValueWrite;
  UINT32 TempFunc;
  UINT32 TempValue;

  ValueRead = 0;
  ExtendOffset = Address.Address.Register;
  TempFunc = Address.Address.Function;
  // Switch Dct
  Address.Address.Function = FUNC_1;
  Address.Address.Register = 0x10C;
  TempValue = 0;
  if (ExtendOffset & 0x400) {
    TempValue = 1;
  }
  LibAmdPciWrite (AccessS3SaveWidth32, Address, &TempValue, ConfigPtr);

  Address.Address.Function = TempFunc;
  Address.Address.Register = 0x9C;

  ExtendOffset &= 0x3FF;
  ExtendOffset |= 0x40000000;
  switch (AccessWidth) {
  case AccessS3SaveWidth8:
    ValueWrite = *(UINT8 *) Value;
    break;
  case AccessS3SaveWidth16:
    ValueWrite = *(UINT16 *) Value;
    break;
  case AccessS3SaveWidth32:
    ValueWrite = *(UINT32 *) Value;
    break;
  default:
    ASSERT (FALSE);
  }
  LibAmdPciWrite (AccessS3SaveWidth32, Address, &ValueWrite, ConfigPtr);
  Address.Address.Register = 0x98;
  LibAmdPciWrite (AccessS3SaveWidth32, Address, &ExtendOffset, ConfigPtr);
  while (((ValueRead >> 31) & 1) == 0) {
    LibAmdPciRead (AccessS3SaveWidth32, Address, &ValueRead, ConfigPtr);
  }
}
