/** @file

Copyright (c) 2016, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include "FspUpd.h"


/** Fsp S Configuration
**/
struct FSP_S_CONFIG {

/** Offset 0x0020 - ActiveProcessorCores
  Number of active cores. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       ActiveProcessorCores;

/** Offset 0x0021 - Disable Core1
  Disable/Enable Core1. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       DisableCore1;

/** Offset 0x0022 - Disable Core2
  Disable/Enable Core2. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       DisableCore2;

/** Offset 0x0023 - Disable Core3
  Disable/Enable Core3. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       DisableCore3;

/** Offset 0x0024 - VMX Enable
  Enable or Disable VMX. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       VmxEnable;

/** Offset 0x0025 - Memory region allocation for Processor Trace
  Memory region allocation for Processor Trace, allowed range is from 4K (0x0) to 128MB (0xF); <b>0xFF: Disable. 0xFF:Disable(Default)
**/
  uint8_t                       ProcTraceMemSize;

/** Offset 0x0026 - Enable Processor Trace
  Enable or Disable Processor Trace feature.  0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       ProcTraceEnable;

/** Offset 0x0027 - Eist
  Enable or Disable Intel SpeedStep Technology. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       Eist;

/** Offset 0x0028 - Boot PState
  Boot PState with HFM or LFM. 0:HFM(Default), 1:LFM.
**/
  uint8_t                       BootPState;

/** Offset 0x0029 - CPU power states (C-states)
  Enable or Disable CPU power states (C-states). 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       EnableCx;

/** Offset 0x002A - Enhanced C-states
  Enable or Disable Enhanced C-states. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       C1e;

/** Offset 0x002B - Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       BiProcHot;

/** Offset 0x002C - Max Pkg Cstate
  Max Pkg Cstate. 0:PkgC0C1, 1:PkgC2, 2:PkgC3(Default), 3:PkgC6, 4:PkgC7, 5:PkgC7s, 6:PkgC8, 7:PkgC9, 8:PkgC10, 9:PkgCMax, 254:PkgCpuDefault, 255:PkgAuto.
**/
  uint8_t                       PkgCStateLimit;

/** Offset 0x002D
**/
  uint8_t                       UnusedUpdSpace0;

/** Offset 0x002E - C-State auto-demotion
  C-State Auto Demotion. 0:Disable(Default) C1 and C3 Auto-demotion, 1:Enable C3/C6/C7 Auto-demotion to C1, 2:Enable C6/C7 Auto-demotion to C3, 3:Enable C6/C7 Auto-demotion to C1 and C3.
**/
  uint8_t                       CStateAutoDemotion;

/** Offset 0x002F - C-State un-demotion
  C-State un-demotion. 0:Disable(Default) C1 and C3 Un-demotion, 1:Enable C1 Un-demotion, 2:Enable C3 Un-demotion, 3:Enable C1 and C3 Un-demotion.
**/
  uint8_t                       CStateUnDemotion;

/** Offset 0x0030 - Max Core C-State
  Max Core C-State. 0:Unlimited, 1:C1, 2:C3, 3:C6, 4:C7, 5:C8, 6:C9, 7:C10, 8:CCx(Default).
**/
  uint8_t                       MaxCoreCState;

/** Offset 0x0031 - Package C-State Demotion
  Enable or Disable Package Cstate Demotion. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PkgCStateDemotion;

/** Offset 0x0032 - Package C-State Un-demotion
  Enable or Disable Package Cstate UnDemotion. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PkgCStateUnDemotion;

/** Offset 0x0033 - Turbo Mode
  Enable or Disable long duration Turbo Mode. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       TurboMode;

/** Offset 0x0034 - SC HDA Verb Table Entry Number
  Number of Entries in Verb Table. 0(Default).
**/
  uint8_t                       HdaVerbTableEntryNum;

/** Offset 0x0035 - SC HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table. 0x00000000(Default).
**/
  uint32_t                      HdaVerbTablePtr;

/** Offset 0x0039 - Enable/Disable P2SB device hidden.
  Enable/Disable P2SB device hidden. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       HideP2sb;

/** Offset 0x003A - IPU Enable/Disable
  Enable/Disable IPU Device. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       IpuEn;

/** Offset 0x003B - IMGU ACPI mode selection
  0:Auto, 1:IGFX Child device(Default), 2:ACPI device.
  0:Disable, 1:IGFX Child device, 2:ACPI device
**/
  uint8_t                       IpuAcpiMode;

/** Offset 0x003C - GttMmAdr
  GttMmAdr structure for initialization. 0xBF000000(Default).
**/
  uint32_t                      GttMmAdr;

/** Offset 0x0040 - GmAdr
  GmAdr structure for initialization. 0xA0000000(Default).
**/
  uint32_t                      GmAdr;

/** Offset 0x0044 - Enable ForceWake
  Enable/disable ForceWake Models. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       ForceWake;

/** Offset 0x0045 - Enable PavpLock
  Enable/disable PavpLock. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PavpLock;

/** Offset 0x0046 - Enable GraphicsFreqModify
  Enable/disable GraphicsFreqModify. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       GraphicsFreqModify;

/** Offset 0x0047 - Enable GraphicsFreqReq
  Enable/disable GraphicsFreqReq. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       GraphicsFreqReq;

/** Offset 0x0048 - Enable GraphicsVideoFreq
  Enable/disable GraphicsVideoFreq. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       GraphicsVideoFreq;

/** Offset 0x0049 - Enable PmLock
  Enable/disable PmLock. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PmLock;

/** Offset 0x004A - Enable DopClockGating
  Enable/disable DopClockGating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       DopClockGating;

/** Offset 0x004B - Enable UnsolicitedAttackOverride
  Enable/disable UnsolicitedAttackOverride. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       UnsolicitedAttackOverride;

/** Offset 0x004C - Enable WOPCMSupport
  Enable/disable WOPCMSupport. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       WOPCMSupport;

/** Offset 0x004D - Enable WOPCMSize
  Enable/disable WOPCMSize. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       WOPCMSize;

/** Offset 0x004E - Enable PowerGating
  Enable/disable PowerGating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PowerGating;

/** Offset 0x004F - Enable UnitLevelClockGating
  Enable/disable UnitLevelClockGating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       UnitLevelClockGating;

/** Offset 0x0050 - Enable FastBoot
  Enable/disable FastBoot. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       FastBoot;

/** Offset 0x0051 - Enable DynSR
  Enable/disable DynSR. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       DynSR;

/** Offset 0x0052 - Enable SaIpuEnable
  Enable/disable SaIpuEnable. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       SaIpuEnable;

/** Offset 0x0053 - BMP Logo Data Size
  BMP logo data buffer size. 0x00000000(Default).
**/
  uint32_t                      LogoSize;

/** Offset 0x0057 - BMP Logo Data Pointer
  BMP logo data pointer to a BMP format buffer. 0x00000000(Default).
**/
  uint32_t                      LogoPtr;

/** Offset 0x005B - Graphics Configuration Data Pointer
  Graphics configuration data used for initialization. 0x00000000(Default).
**/
  uint32_t                      GraphicsConfigPtr;

/** Offset 0x005F - GT PM Support
  Enable/Disable GT power management support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       PmSupport;

/** Offset 0x0060 - RC6(Render Standby)
  Enable/Disable render standby support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       EnableRenderStandby;

/** Offset 0x0061 - PAVP Enable
  Enable/Disable Protected Audio Visual Path (PAVP). 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       PavpEnable;

/** Offset 0x0062 - PAVP PR3
  Enable/Disable PAVP PR3 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       PavpPr3;

/** Offset 0x0063 - CdClock Frequency selection
  0:144MHz, 1:288MHz, 2:384MHz, 3:576MHz, 4:624MHz(Default).
  0: 144 MHz, 1: 288 MHz, 2: 384 MHz, 3: 576 MHz, 4: 624 MHz
**/
  uint8_t                       CdClock;

/** Offset 0x0064 - Enable/Disable PeiGraphicsPeimInit
  Enable/Disable PeiGraphicsPeimInit 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       PeiGraphicsPeimInit;

/** Offset 0x0065 - Write Protection Support
  Enable/disable Write Protection. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       WriteProtectionEnable[5];

/** Offset 0x006A - Read Protection Support
  Enable/disable Read Protection. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       ReadProtectionEnable[5];

/** Offset 0x006F - Protected Range Limitation
  The address of the upper limit of protection, 0x0FFFh(Default).
**/
  uint16_t                      ProtectedRangeLimit[5];

/** Offset 0x0079 - Protected Range Base
  The base address of the upper limit of protection. 0x0000(Default).
**/
  uint16_t                      ProtectedRangeBase[5];

/** Offset 0x0083 - Enable SC Gaussian Mixture Models
  Enable/disable SC Gaussian Mixture Models. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       Gmm;

/** Offset 0x0084 - GMM Clock Gating - PGCB Clock Trunk
  Enable/disable PGCB Clock Trunk. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingPgcbClkTrunk;

/** Offset 0x0085 - GMM Clock Gating  - Sideband
  Enable/disable Sideband. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingSb;

/** Offset 0x0086 - GMM Clock Gating  - Sideband
  Enable/disable Sideband. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingSbClkTrunk;

/** Offset 0x0087 - GMM Clock Gating  - Sideband Clock Partition
  Enable/disable Sideband Clock Partition. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingSbClkPartition;

/** Offset 0x0088 - GMM Clock Gating  - Core
  Enable/disable Core. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingCore;

/** Offset 0x0089 - GMM Clock Gating  - DMA
  Enable/disable DMA. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingDma;

/** Offset 0x008A - GMM Clock Gating  - Register Access
  Enable/disable Register Access. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingRegAccess;

/** Offset 0x008B - GMM Clock Gating  - Host
  Enable/disable Host. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingHost;

/** Offset 0x008C - GMM Clock Gating  - Partition
  Enable/disable Partition. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingPartition;

/** Offset 0x008D - Clock Gating  - Trunk
  Enable/disable Trunk. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ClkGatingTrunk;

/** Offset 0x008E - HD Audio Support
  Enable/disable HDA Audio Feature. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       HdaEnable;

/** Offset 0x008F - HD Audio DSP Support
  Enable/disable HDA Audio DSP Feature. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       DspEnable;

/** Offset 0x0090 - Azalia wake-on-ring
  Enable/disable Azalia wake-on-ring. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       Pme;

/** Offset 0x0091 - HD-Audio I/O Buffer Ownership
  Set HD-Audio I/O Buffer Ownership. 0:Disable(Default), 1:Enable.
  0:HD-Audio link owns all the I/O buffers, 1:HD-Audio link owns 4 I/O buffers and I2S port owns 4 I/O buffers, 3:I2S port owns all the I/O buffers
**/
  uint8_t                       HdAudioIoBufferOwnership;

/** Offset 0x0092 - HD-Audio I/O Buffer Voltage
  HD-Audio I/O Buffer Voltage Mode Selectiton . 0:3.3V(Default), 1:1.8V.
  0: 3.3V, 1: 1.8V
**/
  uint8_t                       HdAudioIoBufferVoltage;

/** Offset 0x0093 - HD-Audio Virtual Channel Type
  HD-Audio Virtual Channel Type Selectiton. 0:VC0(Default), 1:VC1.
  0: VC0, 1: VC1
**/
  uint8_t                       HdAudioVcType;

/** Offset 0x0094 - HD-Audio Link Frequency
  HD-Audio Virtual Channel Type Selectiton. 0:6MHz(Default), 1:12MHz, 2:24MHz, 3:48MHz, 4:96MHz, 5:Invalid.
  0: 6MHz, 1: 12MHz, 2: 24MHz, 3: 48MHz, 4: 96MHz, 5: Invalid
**/
  uint8_t                       HdAudioLinkFrequency;

/** Offset 0x0095 - HD-Audio iDisp-Link Frequency
  HD-Audio iDisp-Link Frequency Selectiton. 0:6MHz(Default), 1:12MHz, 2:24MHz, 3:48MHz, 4:96MHz, 5:Invalid.
  0: 6MHz, 1: 12MHz, 2: 24MHz, 3: 48MHz, 4: 96MHz, 5: Invalid
**/
  uint8_t                       HdAudioIDispLinkFrequency;

/** Offset 0x0096 - HD-Audio iDisp-Link T-Mode
  HD-Audio iDisp-Link T-Mode Selectiton. 0:2T(Default), 1:1T.
  0: 2T, 1: 1T
**/
  uint8_t                       HdAudioIDispLinkTmode;

/** Offset 0x0097 - HD-Audio Disp DMIC
  HD-Audio Disp DMIC Selectiton. 0:Disable, 1:2ch array(Default), 2:4ch array.
  0: Disable, 1: 2ch array, 2: 4ch array
**/
  uint8_t                       DspEndpointDmic;

/** Offset 0x0098 - HD-Audio Bluetooth
  Enable/Disable HD-Audio bluetooth. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       DspEndpointBluetooth;

/** Offset 0x0099 - HD-Audio I2S SHK
  Enable/Disable HD-Audio I2S SHK. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       DspEndpointI2sSkp;

/** Offset 0x009A - HD-Audio I2S HP
  Enable/Disable HD-Audio I2S HP. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       DspEndpointI2sHp;

/** Offset 0x009B - HD-Audio Controller Power Gating
  Enable/Disable HD-Audio Controller Power Gating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       AudioCtlPwrGate;

/** Offset 0x009C - HD-Audio ADSP Power Gating
  Enable/Disable HD-Audio ADSP Power Gating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       AudioDspPwrGate;

/** Offset 0x009D - HD-Audio CSME Memory Transfers
  Enable/Disable HD-Audio CSME Memory Transfers. 0:VC0(Default), 1:VC2.
  0: VC0, 1: VC2
**/
  uint8_t                       Mmt;

/** Offset 0x009E - HD-Audio Host Memory Transfers
  Enable/Disable HD-Audio Host Memory Transfers. 0:VC0(Default), 1:VC2.
  0: VC0, 1: VC2
**/
  uint8_t                       Hmt;

/** Offset 0x009F - HD-Audio BIOS Configuration Lock Down
  Enable/Disable HD-Audio BIOS Configuration Lock Down. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       BiosCfgLockDown;

/** Offset 0x00A0 - HD-Audio Power Gating
  Enable/Disable HD-Audio BIOS Configuration Lock Down. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       HDAudioPwrGate;

/** Offset 0x00A1 - HD-Audio Clock Gatingn
  Enable/Disable HD-Audio Clock Gating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       HDAudioClkGate;

/** Offset 0x00A2 - Bitmask of DSP Feature
  Set Bitmask of HD-Audio DSP Feature. 0x00000000(Default).
  [BIT0] - WoV, [BIT1] - BT Sideband, [BIT2] - Codec VAD, [BIT5] - BT Intel HFP, [BIT6] - BT Intel A2DP, [BIT7] - DSP based speech pre-processing disabled, [BIT8] - 0: Intel WoV, 1: Windows Voice Activation
**/
  uint32_t                      DspFeatureMask;

/** Offset 0x00A6 - Bitmask of supported DSP Post-Processing Modules
  Set HD-Audio Bitmask of supported DSP Post-Processing Modules. 0x00000000(Default).
  [BIT0] - WoV, [BIT1] - BT Sideband, [BIT2] - Codec VAD, [BIT5] - BT Intel HFP, [BIT6] - BT Intel A2DP, [BIT7] - DSP based speech pre-processing disabled, [BIT8] - 0: Intel WoV, 1: Windows Voice Activation
**/
  uint32_t                      DspPpModuleMask;

/** Offset 0x00AA - Enable High Precision Timer
  Enable/Disable Hpet. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       Hpet;

/** Offset 0x00AB - Hpet Valid BDF Value
  Enable/Disable Hpet Valid BDF Value. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       HpetBdfValid;

/** Offset 0x00AC - Bus Number of Hpet
  Completer ID of Bus Number of Hpet. Default = 0xFA(Default).
**/
  uint8_t                       HpetBusNumber;

/** Offset 0x00AD - Device Number of Hpet
  Completer ID of Device Number of Hpet. 0x1F(Default).
**/
  uint8_t                       HpetDeviceNumber;

/** Offset 0x00AE - Function Number of Hpet
  Completer ID of Function Number of Hpet. 0x00(Default).
**/
  uint8_t                       HpetFunctionNumber;

/** Offset 0x00AF - Hpet Base Address
  Hpet Base Address. 0xFED00000(Default).
**/
  uint32_t                      HpetBase;

/** Offset 0x00B3 - IoApic Valid BDF Value
  Enable/Disable IoApic Valid BDF Value. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       IoApicBdfValid;

/** Offset 0x00B4 - Bus Number of IoApic
  Completer ID of Bus Number of IoApic. 0xFA(Default).
**/
  uint8_t                       IoApicBusNumber;

/** Offset 0x00B5 - Device Number of IoApic
  Completer ID of Device Number of IoApic. 0x0F(Default).
**/
  uint8_t                       IoApicDeviceNumber;

/** Offset 0x00B6 - Function Number of IoApic
  Completer ID of Function Number of IoApic. 0x00(Default).
**/
  uint8_t                       IoApicFunctionNumber;

/** Offset 0x00B7 - IOAPIC Entry 24-119
  Enable/Disable IOAPIC Entry 24-119. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       IoApicEntry24_119;

/** Offset 0x00B8 - IO APIC ID
  This member determines IOAPIC ID. 0x01(Default).
**/
  uint8_t                       IoApicId;

/** Offset 0x00B9 - IoApic Range
  Define address bits 19:12 for the IOxAPIC range. 0x00(Default).
**/
  uint8_t                       IoApicRangeSelect;

/** Offset 0x00BA - ISH Controller
  Enable/Disable ISH Controller. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       IshEnable;

/** Offset 0x00BB - ISH Controller
  Enable/Disable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       BiosInterface;

/** Offset 0x00BC - Bios LockDown Enable
  Enable the BIOS Lock Enable (BLE) feature and set EISS bit. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       BiosLock;

/** Offset 0x00BD - SPI EISS Status
  Enable/Disable InSMM.STS (EISS) in SPI. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SpiEiss;

/** Offset 0x00BE - BiosLock SWSMI Number
  This member describes the SwSmi value for Bios Lock. 0xA9(Default).
**/
  uint8_t                       BiosLockSwSmiNumber;

/** Offset 0x00BF - LPSS IOSF PMCTL S0ix Enable
  Enable/Disable LPSS IOSF Bridge PMCTL Register S0ix Bits. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       S0ixEnable;

/** Offset 0x00C0 - LPSS I2C Clock Gating Configuration
  Enable/Disable LPSS I2C Clock Gating. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       I2cClkGateCfg[8];

/** Offset 0x00C8 - PSS HSUART Clock Gating Configuration
  Enable/Disable LPSS HSUART Clock Gating. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       HsuartClkGateCfg[4];

/** Offset 0x00CC - LPSS SPI Clock Gating Configuration
  Enable/Disable LPSS SPI Clock Gating. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       SpiClkGateCfg[3];

/** Offset 0x00CF - I2C Device 0
  Enable/Disable I2C Device 0. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c0Enable;

/** Offset 0x00D0 - I2C Device 1
  Enable/Disable I2C Device 1. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c1Enable;

/** Offset 0x00D1 - I2C Device 2
  Enable/Disable I2C Device 2. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c2Enable;

/** Offset 0x00D2 - I2C Device 3
  Enable/Disable I2C Device 3. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c3Enable;

/** Offset 0x00D3 - I2C Device 4
  Enable/Disable I2C Device 4. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c4Enable;

/** Offset 0x00D4 - I2C Device 5
  Enable/Disable I2C Device 5. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c5Enable;

/** Offset 0x00D5 - I2C Device 6
  Enable/Disable I2C Device 6. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c6Enable;

/** Offset 0x00D6 - I2C Device 7
  Enable/Disable I2C Device 7. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       I2c7Enable;

/** Offset 0x00D7 - UART Device 0
  Enable/Disable UART Device 0. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Hsuart0Enable;

/** Offset 0x00D8 - UART Device 1
  Enable/Disable UART Device 1. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Hsuart1Enable;

/** Offset 0x00D9 - UART Device 2
  Enable/Disable UART Device 2. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Hsuart2Enable;

/** Offset 0x00DA - UART Device 3
  Enable/Disable UART Device 3. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Hsuart3Enable;

/** Offset 0x00DB - SPI UART Device 0
  Enable/Disable SPI Device 0. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Spi0Enable;

/** Offset 0x00DC - SPI UART Device 1
  Enable/Disable SPI Device 1. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Spi1Enable;

/** Offset 0x00DD - SPI UART Device 2
  Enable/Disable SPI Device 2. 0:Disabled, 1:PCI Mode(Default), 2:ACPI Mode.
  0: Disabled, 1: PCI Mode, 2: ACPI Mode
**/
  uint8_t                       Spi2Enable;

/** Offset 0x00DE - UART Debug Bass Address
  UART Debug Bass Address. 0x00000000(Default).
**/
  uint32_t                      Uart2KernelDebugBaseAddress;

/** Offset 0x00E2 - OS Debug Feature
  Enable/Disable OS Debug Feature. 0:Disable(Default), 1: Enable.
  $EN_DIS
**/
  uint8_t                       OsDbgEnable;

/** Offset 0x00E3 - Exi Feature
  Enable/Disable Exi Feature. 0:Disable(Default), 1: Enable.
  $EN_DIS
**/
  uint8_t                       ExiEnable;

/** Offset 0x00E4 - Enable PCIE Clock Gating
  Enable/disable PCIE Clock Gating. 0:Enable, 1:Disable(Default).
  $EN_DIS
**/
  uint8_t                       PcieClockGatingDisabled;

/** Offset 0x00E5 - Enable PCIE Root Port 8xh Decode
  Enable/disable PCIE Root Port 8xh Decode. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       PcieRootPort8xhDecode;

/** Offset 0x00E6 - PCIE 8xh Decode Port Index
  PCIE 8xh Decode Port Index. 0x00(Default).
**/
  uint8_t                       Pcie8xhDecodePortIndex;

/** Offset 0x00E7 - Enable PCIE Root Port Peer Memory Write
  Enable/disable PCIE root port peer memory write. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PcieRootPortPeerMemoryWriteEnable;

/** Offset 0x00E8 - PCIE SWSMI Nubmer
  This member describes the SwSmi value for override PCIe ASPM table. 0xAA(Default).
**/
  uint8_t                       PcieAspmSwSmiNumber;

/** Offset 0x00E9 - PCI Express Root Port
  Control the PCI Express Root Port . 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRootPortEn[6];

/** Offset 0x00EF - Hide PCIE Root Port Configuration Space
  Enable/disable Hide PCIE Root Port Configuration Space. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       PcieRpHide[6];

/** Offset 0x00F5 - PCIE Root Port Slot Implement
  Enable/disable PCIE Root Port Slot Implement. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpSlotImplemented[6];

/** Offset 0x00FB - Hot Plug
  PCI Express Hot Plug Enable/Disable. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpHotPlug[6];

/** Offset 0x0101 - PCIE PM SCI
  Enable/Disable PCI Express PME SCI. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       PcieRpPmSci[6];

/** Offset 0x0107 - PCIE Root Port Extended Sync
  Enable/Disable PCIE Root Port Extended Sync. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpExtSync[6];

/** Offset 0x010D - Transmitter Half Swing
  Transmitter Half Swing Enable/Disable. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpTransmitterHalfSwing[6];

/** Offset 0x0113 - ACS
  Enable/Disable Access Control Services Extended Capability. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpAcsEnabled[6];

/** Offset 0x0119 - Clock Request Support
  Enable/Disable CLKREQ# Support. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpClkReqSupported[6];

/** Offset 0x011F - Configure CLKREQ Number
  Configure Root Port CLKREQ Number if CLKREQ is supported. Default=0x04, 0x05, 0x00, 0x01, 0x02, 0x03.
**/
  uint8_t                       PcieRpClkReqNumber[6];

/** Offset 0x0125 - CLKREQ# Detection
  Enable/Disable CLKREQ# Detection Probe. 0: Disable(Default), 1: Enable.
**/
  uint8_t                       PcieRpClkReqDetect[6];

/** Offset 0x012B - Advanced Error Reporting
  Enable/Disable Advanced Error Reporting. 0: Disable(Default), 1: Enable.
**/
  uint8_t                       AdvancedErrorReporting[6];

/** Offset 0x0131 - PME Interrupt
  Enable/Disable PME Interrupt. 0: Disable(Default), 1: Enable.
**/
  uint8_t                       PmeInterrupt[6];

/** Offset 0x0137 -   URR
  PCI Express Unsupported Request Reporting Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       UnsupportedRequestReport[6];

/** Offset 0x013D -   FER
  PCI Express Device Fatal Error Reporting Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       FatalErrorReport[6];

/** Offset 0x0143 -   NFER
  PCI Express Device Non-Fatal Error Reporting Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       NoFatalErrorReport[6];

/** Offset 0x0149 -   CER
  PCI Express Device Correctable Error Reporting Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       CorrectableErrorReport[6];

/** Offset 0x014F -   SEFE
  Root PCI Express System Error on Fatal Error Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SystemErrorOnFatalError[6];

/** Offset 0x0155 -   SENFE
  Root PCI Express System Error on Non-Fatal Error Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SystemErrorOnNonFatalError[6];

/** Offset 0x015B -   SECE
  Root PCI Express System Error on Correctable Error Enable/Disable. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SystemErrorOnCorrectableError[6];

/** Offset 0x0161 - PCIe Speed
  Configure PCIe Speed. 0:Auto(Default), 1:Gen1, 2:Gen2, 3:Gen3.
**/
  uint8_t                       PcieRpSpeed[6];

/** Offset 0x0167 - Physical Slot Number
  Physical Slot Number for PCIE Root Port. Default=0x00, 0x01, 0x02, 0x03, 0x04, 0x05.
**/
  uint8_t                       PhysicalSlotNumber[6];

/** Offset 0x016D - CTO
  Enable/Disable PCI Express Completion Timer TO . 0:Disable(Default), 1:Enable.
**/
  uint8_t                       PcieRpCompletionTimeout[6];

/** Offset 0x0173 - PTM Support
  Enable/Diable PTM Support. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       PtmEnable[6];

/** Offset 0x0179 - ASPM
  PCI Express Active State Power Management settings. 0:Disable, 1:L0s, 2:L1, 3:L0sL1, 4:Auto(Default).
**/
  uint8_t                       PcieRpAspm[6];

/** Offset 0x017F - L1 Substates
  PCI Express L1 Substates settings. 0:Disable, 1:L1.1, 2:L1.2, 3:L1.1 & L1.2(Default).
**/
  uint8_t                       PcieRpL1Substates[6];

/** Offset 0x0185 - PCH PCIe LTR
  PCH PCIE Latency Reporting Enable/Disable. 0:Disable, 1:Enable(Default).
**/
  uint8_t                       PcieRpLtrEnable[6];

/** Offset 0x018B - PCIE LTR Lock
  PCIE LTR Configuration Lock. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       PcieRpLtrConfigLock[6];

/** Offset 0x0191 - PME_B0_S5 Diable bit
  PME_B0_S5_DIS bit in the General PM Configuration B (GEN_PMCON_B) register. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PmeB0S5Dis;

/** Offset 0x0192 - PCI Clock Run
  This member describes whether or not the PCI ClockRun feature of SC should be enabled. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       PciClockRun;

/** Offset 0x0193 - Enable/Disable Timer 8254 Clock Setting
  Enable/Disable Timer 8254 Clock. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       Timer8254ClkSetting;

/** Offset 0x0194 - Chipset SATA
  Enables or Disables the Chipset SATA Controller. The Chipset SATA controller supports the 2 black internal SATA ports (up to 3Gb/s supported per port). 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       EnableSata;

/** Offset 0x0195 - SATA Mode Selection
  Determines how SATA controller(s) operate. 0:AHCI(Default), 1:RAID.
  0:AHCI, 1:RAID
**/
  uint8_t                       SataMode;

/** Offset 0x0196 - Aggressive LPM Support
  Enable PCH to aggressively enter link power state.  0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SataSalpSupport;

/** Offset 0x0197 - SATA Power Optimization
  Enable SATA Power Optimizer on SC side.  0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       SataPwrOptEnable;

/** Offset 0x0198 - eSATA Speed Limit
  Enable/Disable eSATA Speed Limit.  0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       eSATASpeedLimit;

/** Offset 0x0199 - SATA Speed Limit
  SATA Speed Limit. 0h:ScSataSpeed(Default), 1h:1.5Gb/s(Gen 1), 2h:3Gb/s(Gen 2), 3h:6Gb/s(Gen 3).
  0:Default, 1: 1.5 Gb/s (Gen 1), 2: 3 Gb/s(Gen 2), 3: 6 Gb/s (Gen 1)
**/
  uint8_t                       SpeedLimit;

/** Offset 0x019A - SATA Port
  Enable or Disable SATA Port.  0:Disable, 1:Enable(Default).
**/
  uint8_t                       SataPortsEnable[2];

/** Offset 0x019C - SATA Port DevSlp
  Enable/Disable SATA Port  DevSlp. Board rework for LP needed before enable.  0:Disable(Default), 1:Enable.
**/
  uint8_t                       SataPortsDevSlp[2];

/** Offset 0x019E - SATA Port HotPlug
  Enable/Disable SATA Port Hotplug . 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SataPortsHotPlug[2];

/** Offset 0x01A0 - Mechanical Presence Switch
  Controls reporting if this port has an Mechanical Presence Switch.\nNote:Requires hardware support.  0:Disable, 1:Enable(Default).
**/
  uint8_t                       SataPortsInterlockSw[2];

/** Offset 0x01A2 - External SATA Ports
  Enable/Disable External SATA Ports. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SataPortsExternal[2];

/** Offset 0x01A4 - Spin Up Device
  Enable/Disable device spin up at boot on selected Sata Ports. 0:Disable(Default), 1:Enable.
**/
  uint8_t                       SataPortsSpinUp[2];

/** Offset 0x01A6 - SATA Solid State
  Identify the SATA port is connected to Solid State Drive or Hard Disk Drive.  0:Hard Disk Drive(Default), 1:Solid State Drive.
**/
  uint8_t                       SataPortsSolidStateDrive[2];

/** Offset 0x01A8 -   DITO Configuration
  Enable/Disable DITO Configuration.  0:Disable(Default), 1:Enable.
**/
  uint8_t                       SataPortsEnableDitoConfig[2];

/** Offset 0x01AA - DM Value
  DM Value.  0:Minimum, 0x0F:Maximum(Default).
**/
  uint8_t                       SataPortsDmVal[2];

/** Offset 0x01AC - DITO Value
  DEVSLP Idle Timeout Value. 0:Minimum, 0x03FF:Maximum, 0x0271(Default).
**/
  uint16_t                      SataPortsDitoVal[2];

/** Offset 0x01B0 - Subsystem Vendor ID
  Subsystem Vendor ID. 0x8086(Default).
**/
  uint16_t                      SubSystemVendorId;

/** Offset 0x01B2 - Subsystem ID
  Subsystem ID. 0x7270(Default).
**/
  uint16_t                      SubSystemId;

/** Offset 0x01B4 - PM Base Address
  PM Base Address. 0x400(Default).
**/
  uint16_t                      AcpiBase;

/** Offset 0x01B6 - PMC Base Address
  PMC Base Address. 0xD10010000(Default).
**/
  uint32_t                      PmcBase;

/** Offset 0x01BA - P2SB Base Address
  P2SB Base Address. 0xD0000000(Default).
**/
  uint32_t                      P2sbBase;

/** Offset 0x01BE - CRIDSettings
  PMC CRID setting. 0:Disable(Default), 1:CRID_1, 2:CRID_2, 3:CRID_3.
**/
  uint8_t                       CRIDSettings;

/** Offset 0x01BF - ResetSelect
  ResetSelect. 0x6:warm reset(Default), 0xE:cold reset.
**/
  uint8_t                       ResetSelect;

/** Offset 0x01C0 - SD Card Support (D27:F0)
  Enable/Disable SD Card Support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SdcardEnabled;

/** Offset 0x01C1 - SeMMC Support (D28:F0)
  Enable/Disable eMMC Support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       eMMCEnabled;

/** Offset 0x01C2 - eMMC Max Speed
  Select the eMMC max Speed allowed. 0:HS400(Default), 1:HS200, 2:DDR50.
  0:HS400, 1: HS200, 2:DDR50
**/
  uint8_t                       eMMCHostMaxSpeed;

/** Offset 0x01C3 - UFS Support (D29:F0)
  Enable/Disable SDIO Support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       UfsEnabled;

/** Offset 0x01C4 - SDIO Support (D30:F0)
  Enable/Disable SDIO Support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SdioEnabled;

/** Offset 0x01C5 - GPP Lock Feature
  Enable/Disable GPP lock. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       GppLock;

/** Offset 0x01C6 - Serial IRQ
  Enable/Disable Serial IRQ. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SirqEnable;

/** Offset 0x01C7 - Serial IRQ Mode
  Serial IRQ Mode Selection. 0:Quiet mode(Default), 1:Continuous mode.
  $EN_DIS
**/
  uint8_t                       SirqMode;

/** Offset 0x01C8 - Start Frame Pulse Width
  Start Frame Pulse Width Value. 0:ScSfpw4Clk(Default), 1: ScSfpw6Clk, 2:ScSfpw8Clk.
  $EN_DIS
**/
  uint8_t                       StartFramePulse;

/** Offset 0x01C9 - Enable SMBus
  Enable/disable SMBus controller. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       SmbusEnable;

/** Offset 0x01CA - SMBus ARP Support
  Enable/disable SMBus ARP Support. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       ArpEnable;

/** Offset 0x01CB - SMBus Base Address (IO space)
  SMBUS Base Address (IO space). 0xEFA0(Default).
**/
  uint16_t                      SmbusIoBase;

/** Offset 0x01CD - SMBus Table Elements
  The number of elements in the Reserved SMBus Address Table. 0x0080(Default).
**/
  uint16_t                      NumRsvdSmbusAddresses;

/** Offset 0x01CF - Reserved SMBus Address Table
  Array of addresses reserved for non-ARP-capable SMBus devices. 0x00(Default).
**/
  uint8_t                       RsvdSmbusAddressTable[128];

/** Offset 0x024F - XHCI Disable Compliance Mode
  Options to disable XHCI Link Compliance Mode. Default is FALSE to not disable Compliance Mode. Set TRUE to disable Compliance Mode. 0:FALSE(Default), 1:True.
  $EN_DIS
**/
  uint8_t                       DisableComplianceMode;

/** Offset 0x0250 - USB Per-Port Control
  Control each of the USB ports (0~3) enable/disable. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       UsbPerPortCtl;

/** Offset 0x0251 - xHCI Mode
  Mode of operation of xHCI controller. 0:Disable, 1:Enable, 2:Auto(Default), 3:SmartAuto.
  $EN_DIS
**/
  uint8_t                       Usb30Mode;

/** Offset 0x0252 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for port1, and so on. 0x01(Default).
**/
  uint8_t                       PortUsb20Enable[8];

/** Offset 0x025A - USB20 Over Current Pin
  Over Current Pin number of USB 2.0 Port. 0x00(Default).
**/
  uint8_t                       PortUs20bOverCurrentPin[8];

/** Offset 0x0262 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for port1, and so on. 0x01(Default).
**/
  uint8_t                       PortUsb30Enable[6];

/** Offset 0x0268 - USB20 Over Current Pin
  Over Current Pin number of USB 3.0 Port. 0x01(Default).
**/
  uint8_t                       PortUs30bOverCurrentPin[6];

/** Offset 0x026E - XDCI Support
  Enable/Disable XDCI. 0:Disable, 1:PCI_Mode(Default), 2:ACPI_mode.
  $EN_DIS
**/
  uint8_t                       UsbOtg;

/** Offset 0x026F - Enable XHCI HSIC Support
  Enable/Disable USB HSIC1. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       HsicSupportEnable;

/** Offset 0x0270 - Enable XHCI SSIC Support
  Enable/disable XHCI SSIC ports. One byte for each port, byte0 for port0, byte1 for port1. 0x00(Default).
**/
  uint8_t                       SsicPortEnable[2];

/** Offset 0x0272 - SSIC Dlane PowerGating
  Enable/Disable SSIC Data lane Power Gating. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint16_t                      DlanePwrGating;

/** Offset 0x0274 - VT-d
  Enable/Disable VT-d. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       VtdEnable;

/** Offset 0x0275 - HDAudio Delay Timer
  The delay timer after Azalia reset. 0x012C(Default).
**/
  uint16_t                      ResetWaitTimer;

/** Offset 0x0277 - SMI Lock bit
  Enable/Disable SMI_LOCK bit to prevent writes to the Global SMI Enable bit. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       LockDownGlobalSmi;

/** Offset 0x0278 - RTC Lock Bits
  Enable/Disable RTC Lock Bits. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  uint8_t                       RtcLock;

/** Offset 0x0279 - XHCI SSIC RATE
  Set XHCI SSIC1 Rate to A Series or B Series. 1:A Series(Default), 2:B Series.
**/
  uint8_t                       SsicRate[2];

/** Offset 0x027B - SATA Test Mode Selection
  Enable/Disable SATA Test Mode. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint8_t                       SataTestMode;

/** Offset 0x027C - SMBus Dynamic Power Gating
  Enable/Disable SMBus dynamic power gating. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  uint16_t                      DynamicPowerGating;

/** Offset 0x027E - Max Snoop Latency
  Latency Tolerance Reporting Max Snoop Latency. 0x0000(Default).
**/
  uint16_t                      PcieRpLtrMaxSnoopLatency[6];

/** Offset 0x028A -   Snoop Latency Override
  Snoop Latency Override for PCH PCIE. \nDisabled:Disable override.\nManual:Manually enter override values.\nAuto:Maintain default BIOS flow. 0:Disable, 1:Enable, 2:Auto(Default).
**/
  uint8_t                       PcieRpSnoopLatencyOverrideMode[6];

/** Offset 0x0290 -   Snoop Latency Value
  LTR Snoop Latency value of PCH PCIE. 0:Minimum, 0x03FF:Maximum, 0x003C(Default).
**/
  uint16_t                      PcieRpSnoopLatencyOverrideValue[6];

/** Offset 0x029C -   Snoop Latency Multiplier
  LTR Snoop Latency Multiplier of PCH PCIE. 0:1ns, 1:32ns, 2:1024ns(Default), 3:32768ns, 4:1048576ns, 5:33554432ns.
**/
  uint8_t                       PcieRpSnoopLatencyOverrideMultiplier[6];

/** Offset 0x02A2 - Max Non-Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency. 0x0000(Default).
**/
  uint16_t                      PcieRpLtrMaxNonSnoopLatency[6];

/** Offset 0x02AE -   Non Snoop Latency Override
  Non Snoop Latency Override for PCH PCIE. \nDisabled:Disable override.\nManual:Manually enter override values.\nAuto: Maintain default BIOS flow. 0:Disable, 1:Enable, 2:Auto(Default).
**/
  uint8_t                       PcieRpNonSnoopLatencyOverrideMode[6];

/** Offset 0x02B4 -   Non Snoop Latency Value
  LTR Non Snoop Latency value of PCH PCIE. 0:Minimum, 0x03FF:Maximum, 0x003C(Default).
**/
  uint16_t                      PcieRpNonSnoopLatencyOverrideValue[6];

/** Offset 0x02C0 -   Non Snoop Latency Multiplier
  LTR Non Snoop Latency Multiplier of PCH PCIE. 0:1ns, 1:32ns, 2:1024ns(Default), 3:32768ns, 4:1048576ns, 5:33554432ns.
**/
  uint8_t                       PcieRpNonSnoopLatencyOverrideMultiplier[6];

/** Offset 0x02C6 - PCIE Root Port Slot Power Limit Scale
  Specifies scale used for slot power limit value. 0x00(Default).
**/
  uint8_t                       PcieRpSlotPowerLimitScale[6];

/** Offset 0x02CC - PCIE Root Port Slot Power Limit Value
  Specifies upper limit on power supplie by slot. 0x00(Default).
**/
  uint8_t                       PcieRpSlotPowerLimitValue[6];

/** Offset 0x02D2 - Skip Multi-Processor Initialization
  When this is skipped, boot loader must initialize processors before SilicionInit API. 0: Initialize(Default), <b>1: Skip
  $EN_DIS
**/
  uint8_t                       SkipMpInit;

/** Offset 0x02D3
**/
  uint8_t                       ReservedFspsUpd[45];
} __attribute__((packed));

/** Fsp S Test Configuration
**/
struct FSP_S_TEST_CONFIG {

/** Offset 0x0300
**/
  uint32_t                      Signature;

/** Offset 0x0304
**/
  uint8_t                       ReservedFspsTestUpd[12];
} __attribute__((packed));

/** Fsp S Restricted Configuration
**/
struct FSP_S_RESTRICTED_CONFIG {

/** Offset 0x0310
**/
  uint32_t                      Signature;

/** Offset 0x0314
**/
  uint8_t                       ReservedFspsRestrictedUpd[12];
} __attribute__((packed));

#define FSPS_UPD_SIGNATURE               0x4450555F53505346        /* 'FSPS_UPD' */

/** Fsp S UPD Configuration
**/
struct FSPS_UPD {

/** Offset 0x0000
**/
  struct FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  struct FSP_S_CONFIG                FspsConfig;

/** Offset 0x0300
**/
  struct FSP_S_TEST_CONFIG           FspsTestConfig;

/** Offset 0x0310
**/
  struct FSP_S_RESTRICTED_CONFIG     FspsRestrictedConfig;

/** Offset 0x0320
**/
  uint16_t                      UpdTerminator;
} __attribute__((packed));

#endif
