/*
 * This file is part of the coreboot project.
 *
 * Copyright 2015 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef SOC_MEDIATEK_MT8173_PINMUX_H
#define SOC_MEDIATEK_MT8173_PINMUX_H

#define PINMUX_CONSTANTS(index, name, func1, func2, func3, func4, func5, func6, func7) \
	PAD_##name = index, \
	PAD_##name##_FUNC_##func1 = 1, \
	PAD_##name##_FUNC_##func2 = 2, \
	PAD_##name##_FUNC_##func3 = 3, \
	PAD_##name##_FUNC_##func4 = 4, \
	PAD_##name##_FUNC_##func5 = 5, \
	PAD_##name##_FUNC_##func6 = 6, \
	PAD_##name##_FUNC_##func7 = 7

enum {
	PINMUX_CONSTANTS(0, EINT0, IRDA_PDN, I2S1_WS, AUD_SPDIF, UTXD0, RES5, RES6, DBG_MON_A_20),
	PINMUX_CONSTANTS(1, EINT1, IRDA_RXD, I2S1_BCK, SDA5, URXD0, RES5, RES6, DBG_MON_A_21),
	PINMUX_CONSTANTS(2, EINT2, IRDA_TXD, I2S1_MCK, SCL5, UTXD3, RES5, RES6, DBG_MON_A_22),
	PINMUX_CONSTANTS(3, EINT3, DSI1_TE, I2S1_DO_1, SDA3, URXD3, RES5, RES6, DBG_MON_A_23),
	PINMUX_CONSTANTS(4, EINT4, DISP_PWM1, I2S1_DO_2, SCL3, UCTS3, RES5, SFWP_B, RES7),
	PINMUX_CONSTANTS(5, EINT5, PCM1_CLK, I2S2_WS, SPI_CK_3, URTS3, AP_MD32_JTAG_TMS, SFOUT, RES7),
	PINMUX_CONSTANTS(6, EINT6, PCM1_SYNC, I2S2_BCK, SPI_MI_3, RES4, AP_MD32_JTAG_TCK, SFCS0, RES7),
	PINMUX_CONSTANTS(7, EINT7, PCM1_DI, I2S2_DI_1, SPI_MO_3, RES4, AP_MD32_JTAG_TDI, SFHOLD, RES7),
	PINMUX_CONSTANTS(8, EINT8, PCM1_DO, I2S2_DI_2, SPI_CS_3, AUD_SPDIF, AP_MD32_JTAG_TDO, SFIN, RES7),
	PINMUX_CONSTANTS(9, EINT9, USB_DRVVBUS_P0, I2S2_MCK, RES3, USB_DRVVBUS_P1, AP_MD32_JTAG_TRST, SFCK, RES7),
	PINMUX_CONSTANTS(10, EINT10, CLKM0, DSI1_TE, DISP_PWM1, PWM4, IRDA_RXD, RES6, RES7),
	PINMUX_CONSTANTS(11, EINT11, CLKM1, I2S3_WS, USB_DRVVBUS_P0, PWM5, IRDA_TXD, USB_DRVVBUS_P1, DBG_MON_B_30),
	PINMUX_CONSTANTS(12, EINT12, CLKM2, I2S3_BCK, SRCLKENA0, RES4, I2S2_WS, RES6, DBG_MON_B_32),
	PINMUX_CONSTANTS(13, EINT13, CLKM3, I2S3_MCK, SRCLKENA0, RES4, I2S2_BCK, RES6, DBG_MON_A_32),
	PINMUX_CONSTANTS(14, EINT14, CMDAT0, CMCSD0, RES3, CLKM2, RES5, RES6, DBG_MON_B_6),
	PINMUX_CONSTANTS(15, EINT15, CMDAT1, CMCSD1, CMFLASH, CLKM3, RES5, RES6, DBG_MON_B_29),
	PINMUX_CONSTANTS(16, IDDIG, IDDIG, CMFLASH, RES3, PWM5, RES5, RES6, RES7),
	PINMUX_CONSTANTS(17, WATCHDOG, WATCHDOG_AO, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(18, CEC, CEC, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(19, HDMISCK, HDMISCK, HDCP_SCL, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(20, HDMISD, HDMISD, HDCP_SDA, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(21, HTPLG, HTPLG, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(22, MSDC3_DAT0, MSDC3_DAT0, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(23, MSDC3_DAT1, MSDC3_DAT1, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(24, MSDC3_DAT2, MSDC3_DAT2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(25, MSDC3_DAT3, MSDC3_DAT3, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(26, MSDC3_CLK, MSDC3_CLK, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(27, MSDC3_CMD, MSDC3_CMD, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(28, MSDC3_DSL, MSDC3_DSL, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(29, UCTS2, UCTS2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(30, URTS2, URTS2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(31, URXD2, URXD2, UTXD2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(32, UTXD2, UTXD2, URXD2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(33, DAICLK, MRG_CLK, PCM0_CLK, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(34, DAIPCMIN, MRG_DI, PCM0_DI, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(35, DAIPCMOUT, MRG_DO, PCM0_DO, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(36, DAISYNC, MRG_SYNC, PCM0_SYNC, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(37, EINT16, USB_DRVVBUS_P0, USB_DRVVBUS_P1, PWM0, PWM1, PWM2, CLKM0, RES7),
	PINMUX_CONSTANTS(38, CONN_RST, USB_DRVVBUS_P0, USB_DRVVBUS_P1, RES3, RES4, RES5, CLKM1, RES7),
	PINMUX_CONSTANTS(39, CM2MCLK, CM2MCLK, CMCSD0, RES3, RES4, RES5, RES6, DBG_MON_A_17),
	PINMUX_CONSTANTS(40, CMPCLK, CMPCLK, CMCSK, CMCSD2, RES4, RES5, RES6, DBG_MON_A_18),
	PINMUX_CONSTANTS(41, CMMCLK, CMMCLK, RES2, RES3, RES4, RES5, RES6, DBG_MON_A_19),
	PINMUX_CONSTANTS(42, DSI_TE, DSI_TE, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(43, SDA2, SDA2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(44, SCL2, SCL2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(45, SDA0, SDA0, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(46, SCL0, SCL0, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(47, RDN0_A, CMDAT2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(48, RDP0_A, CMDAT3, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(49, RDN1_A, CMDAT4, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(50, RDP1_A, CMDAT5, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(51, RCN_A, CMDAT6, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(52, RCP_A, CMDAT7, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(53, RDN2_A, CMDAT8, CMCSD3, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(54, RDP2_A, CMDAT9, CMCSD2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(55, RDN3_A, CMHSYNC, CMCSD1, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(56, RDP3_A, CMVSYNC, CMCSD0, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(57, MSDC0_DAT0, MSDC0_DAT0, I2S1_WS, RES3, RES4, RES5, RES6, DBG_MON_B_7),
	PINMUX_CONSTANTS(58, MSDC0_DAT1, MSDC0_DAT1, I2S1_BCK, RES3, RES4, RES5, RES6, DBG_MON_B_8),
	PINMUX_CONSTANTS(59, MSDC0_DAT2, MSDC0_DAT2, I2S1_MCK, RES3, RES4, RES5, RES6, DBG_MON_B_9),
	PINMUX_CONSTANTS(60, MSDC0_DAT3, MSDC0_DAT3, I2S1_DO_1, RES3, RES4, RES5, RES6, DBG_MON_B_10),
	PINMUX_CONSTANTS(61, MSDC0_DAT4, MSDC0_DAT4, I2S1_DO_2, RES3, RES4, RES5, RES6, DBG_MON_B_11),
	PINMUX_CONSTANTS(62, MSDC0_DAT5, MSDC0_DAT5, I2S2_WS, RES3, RES4, RES5, RES6, DBG_MON_B_12),
	PINMUX_CONSTANTS(63, MSDC0_DAT6, MSDC0_DAT6, I2S2_BCK, RES3, RES4, RES5, RES6, DBG_MON_B_13),
	PINMUX_CONSTANTS(64, MSDC0_DAT7, MSDC0_DAT7, I2S2_DI_1, RES3, RES4, RES5, RES6, DBG_MON_B_14),
	PINMUX_CONSTANTS(65, MSDC0_CLK, MSDC0_CLK, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_16),
	PINMUX_CONSTANTS(66, MSDC0_CMD, MSDC0_CMD, I2S2_DI_2, RES3, RES4, RES5, RES6, DBG_MON_B_15),
	PINMUX_CONSTANTS(67, MSDC0_DSL, MSDC0_DSL, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_17),
	PINMUX_CONSTANTS(68, MSDC0_RST, MSDC0_RSTB, I2S2_MCK, RES3, RES4, RES5, RES6, DBG_MON_B_18),
	PINMUX_CONSTANTS(69, SPI_CK, SPI_CK_0, I2S3_DO_1, PWM0, PWM5, I2S2_MCK, RES6, DBG_MON_B_19),
	PINMUX_CONSTANTS(70, SPI_MI, SPI_MI_0, I2S3_DO_2, PWM1, SPI_MO_0, I2S2_DI_1, DSI1_TE, DBG_MON_B_20),
	PINMUX_CONSTANTS(71, SPI_MO, SPI_MO_0, I2S3_DO_3, PWM2, SPI_MI_0, I2S2_DI_2, RES6, DBG_MON_B_21),
	PINMUX_CONSTANTS(72, SPI_CS, SPI_CS_0, I2S3_DO_4, PWM3, PWM6, DISP_PWM1, RES6, DBG_MON_B_22),
	PINMUX_CONSTANTS(73, MSDC1_DAT0, MSDC1_DAT0, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_24),
	PINMUX_CONSTANTS(74, MSDC1_DAT1, MSDC1_DAT1, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_25),
	PINMUX_CONSTANTS(75, MSDC1_DAT2, MSDC1_DAT2, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_26),
	PINMUX_CONSTANTS(76, MSDC1_DAT3, MSDC1_DAT3, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_27),
	PINMUX_CONSTANTS(77, MSDC1_CLK, MSDC1_CLK, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_28),
	PINMUX_CONSTANTS(78, MSDC1_CMD, MSDC1_CMD, RES2, RES3, RES4, RES5, RES6, DBG_MON_B_23),
	PINMUX_CONSTANTS(79, PWRAP_SPI0_MI, PWRAP_SPIMI, PWRAP_SPIMO, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(80, PWRAP_SPI0_MO, PWRAP_SPIMO, PWRAP_SPIMI, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(81, PWRAP_SPI0_CK, PWRAP_SPICK, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(82, PWRAP_SPI0_CSN, PWRAP_SPICS, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(83, AUD_CLK_MOSI, AUD_CLK_MOSI, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(84, AUD_DAT_MISO, AUD_DAT_MISO, AUD_DAT_MOSI, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(85, AUD_DAT_MOSI, AUD_DAT_MOSI, AUD_DAT_MISO, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(86, RTC32K_CK, RTC32K_CK, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(87, DISP_PWM0, DISP_PWM0, DISP_PWM1, RES3, RES4, RES5, RES6, DBG_MON_B_31),
	PINMUX_CONSTANTS(88, SRCLKENAI, SRCLKENAI, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(89, SRCLKENAI2, SRCLKENAI2, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(90, SRCLKENA0, SRCLKENA0, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(91, SRCLKENA1, SRCLKENA1, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(92, PCM_CLK, PCM1_CLK, I2S0_BCK, RES3, RES4, RES5, RES6, DBG_MON_A_24),
	PINMUX_CONSTANTS(93, PCM_SYNC, PCM1_SYNC, I2S0_WS, RES3, RES4, RES5, RES6, DBG_MON_A_25),
	PINMUX_CONSTANTS(94, PCM_RX, PCM1_DI, I2S0_DI, RES3, RES4, RES5, RES6, DBG_MON_A_26),
	PINMUX_CONSTANTS(95, PCM_TX, PCM1_DO, I2S0_DO, RES3, RES4, RES5, RES6, DBG_MON_A_27),
	PINMUX_CONSTANTS(96, URXD1, URXD1, UTXD1, RES3, RES4, RES5, RES6, DBG_MON_A_28),
	PINMUX_CONSTANTS(97, UTXD1, UTXD1, URXD1, RES3, RES4, RES5, RES6, DBG_MON_A_29),
	PINMUX_CONSTANTS(98, URTS1, URTS1, UCTS1, RES3, RES4, RES5, RES6, DBG_MON_A_30),
	PINMUX_CONSTANTS(99, UCTS1, UCTS1, URTS1, RES3, RES4, RES5, RES6, DBG_MON_A_31),
	PINMUX_CONSTANTS(100, MSDC2_DAT0, MSDC2_DAT0, RES2, USB_DRVVBUS_P0, SDA5, USB_DRVVBUS_P1, RES6, DBG_MON_B_0),
	PINMUX_CONSTANTS(101, MSDC2_DAT1, MSDC2_DAT1, RES2, AUD_SPDIF, SCL5, RES5, RES6, DBG_MON_B_1),
	PINMUX_CONSTANTS(102, MSDC2_DAT2, MSDC2_DAT2, RES2, UTXD0, RES4, PWM0, SPI_CK_1, DBG_MON_B_2),
	PINMUX_CONSTANTS(103, MSDC2_DAT3, MSDC2_DAT3, RES2, URXD0, RES4, PWM1, SPI_MI_1, DBG_MON_B_3),
	PINMUX_CONSTANTS(104, MSDC2_CLK, MSDC2_CLK, RES2, UTXD3, SDA3, PWM2, SPI_MO_1, DBG_MON_B_4),
	PINMUX_CONSTANTS(105, MSDC2_CMD, MSDC2_CMD, RES2, URXD3, SCL3, PWM3, SPI_CS_1, DBG_MON_B_5),
	PINMUX_CONSTANTS(106, SDA3, SDA3, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(107, SCL3, SCL3, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(108, JTMS, JTMS, MFG_JTAG_TMS, RES3, RES4, AP_MD32_JTAG_TMS, DFD_TMS, RES7),
	PINMUX_CONSTANTS(109, JTCK, JTCK, MFG_JTAG_TCK, RES3, RES4, AP_MD32_JTAG_TCK, DFD_TCK, RES7),
	PINMUX_CONSTANTS(110, JTDI, JTDI, MFG_JTAG_TDI, RES3, RES4, AP_MD32_JTAG_TDI, DFD_TDI, RES7),
	PINMUX_CONSTANTS(111, JTDO, JTDO, MFG_JTAG_TDO, RES3, RES4, AP_MD32_JTAG_TDO, DFD_TDO, RES7),
	PINMUX_CONSTANTS(112, JTRST_B, JTRST_B, MFG_JTAG_TRSTN, RES3, RES4, AP_MD32_JTAG_TRST, DFD_NTRST, RES7),
	PINMUX_CONSTANTS(113, URXD0, URXD0, UTXD0, RES3, RES4, RES5, I2S2_WS, DBG_MON_A_0),
	PINMUX_CONSTANTS(114, UTXD0, UTXD0, URXD0, RES3, RES4, RES5, I2S2_BCK, DBG_MON_A_1),
	PINMUX_CONSTANTS(115, URTS0, URTS0, UCTS0, RES3, RES4, RES5, I2S2_MCK, DBG_MON_A_2),
	PINMUX_CONSTANTS(116, UCTS0, UCTS0, URTS0, RES3, RES4, RES5, I2S2_DI_1, DBG_MON_A_3),
	PINMUX_CONSTANTS(117, URXD3, URXD3, UTXD3, RES3, RES4, RES5, RES6, DBG_MON_A_9),
	PINMUX_CONSTANTS(118, UTXD3, UTXD3, URXD3, RES3, RES4, RES5, RES6, DBG_MON_A_10),
	PINMUX_CONSTANTS(119, KPROW0, KROW0, RES2, RES3, RES4, RES5, RES6, DBG_MON_A_11),
	PINMUX_CONSTANTS(120, KPROW1, KROW1, RES2, PWM6, RES4, RES5, RES6, DBG_MON_A_12),
	PINMUX_CONSTANTS(121, KPROW2, KROW2, IRDA_PDN, USB_DRVVBUS_P0, PWM4, USB_DRVVBUS_P1, RES6, DBG_MON_A_13),
	PINMUX_CONSTANTS(122, KPCOL0, KCOL0, RES2, RES3, RES4, RES5, RES6, DBG_MON_A_14),
	PINMUX_CONSTANTS(123, KPCOL1, KCOL1, IRDA_RXD, PWM5, RES4, RES5, RES6, DBG_MON_A_15),
	PINMUX_CONSTANTS(124, KPCOL2, KCOL2, IRDA_TXD, USB_DRVVBUS_P0, PWM3, USB_DRVVBUS_P1, RES6, DBG_MON_A_16),
	PINMUX_CONSTANTS(125, SDA1, SDA1, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(126, SCL1, SCL1, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(127, LCM_RST, LCM_RST, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(128, I2S0_LRCK, I2S0_WS, I2S1_WS, I2S2_WS, RES4, SPI_CK_2, RES6, DBG_MON_A_4),
	PINMUX_CONSTANTS(129, I2S0_BCK, I2S0_BCK, I2S1_BCK, I2S2_BCK, RES4, SPI_MI_2, RES6, DBG_MON_A_5),
	PINMUX_CONSTANTS(130, I2S0_MCK, I2S0_MCK, I2S1_MCK, I2S2_MCK, RES4, SPI_MO_2, RES6, DBG_MON_A_6),
	PINMUX_CONSTANTS(131, I2S0_DATA0, I2S0_DO, I2S1_DO_1, I2S2_DI_1, RES4, SPI_CS_2, RES6, DBG_MON_A_7),
	PINMUX_CONSTANTS(132, I2S0_DATA1, I2S0_DI, I2S1_DO_2, I2S2_DI_2, RES4, RES5, RES6, DBG_MON_A_8),
	PINMUX_CONSTANTS(133, SDA4, SDA4, RES2, RES3, RES4, RES5, RES6, RES7),
	PINMUX_CONSTANTS(134, SCL4, SCL4, RES2, RES3, RES4, RES5, RES6, RES7),
};

#endif /* SOC_MEDIATEK_MT8173_PINMUX_H */
