/**
 * @file
 *
 * Install microcode build options for a Dragon platform solution
 *
 * This file generates the defaults tables for the "Dragon" platform solution
 * set of processors. The documented build options are imported from a user
 * controlled file for processing.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Core
 * @e \$Revision: 44323 $   @e \$Date: 2010-12-22 01:24:58 -0700 (Wed, 22 Dec 2010) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2011, Advanced Micro Devices, Inc.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of 
 *       its contributors may be used to endorse or promote products derived 
 *       from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *
 ***************************************************************************/

#ifndef _OPTION_DRAGON_MICROCODE_INSTALL_H_
#define _OPTION_DRAGON_MICROCODE_INSTALL_H_

extern  CONST MICROCODE_PATCHES ROMDATA CpuF10MicrocodePatch01000086;
extern  CONST MICROCODE_PATCHES ROMDATA CpuF10MicrocodePatch01000085;
extern  CONST MICROCODE_PATCHES ROMDATA CpuF10MicrocodePatch010000b6;

// 'NULL' must be put at the end of MicroCodePatchArray[]
CONST MICROCODE_PATCHES ROMDATA *CpuF10BlMicroCodePatchArray[] =
{
  &CpuF10MicrocodePatch010000b6,
  NULL
};

CONST MICROCODE_PATCHES ROMDATA *CpuF10DaMicroCodePatchArray[] =
{
  &CpuF10MicrocodePatch010000b6,
  NULL
};

CONST MICROCODE_PATCHES ROMDATA *CpuF10RbMicroCodePatchArray[] =
{
  &CpuF10MicrocodePatch01000086,
  &CpuF10MicrocodePatch01000085,
  &CpuF10MicrocodePatch010000b6,
  NULL
};

#endif
