#
# This file is part of the coreboot project.
#
# Copyright (C) 2012 Advanced Micro Devices, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#

ramstage-y += chip_name.c
ramstage-y += model_15_init.c

AGESA_ROOT = ../../../../vendorcode/amd/agesa/f15tn

agesa_lib_src =
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/Dispatcher.c
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/agesaCallouts.c
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/hobTransfer.c
agesa_lib_src += $(AGESA_ROOT)/Lib/amdlib.c
agesa_lib_src += $(AGESA_ROOT)/Lib/helper.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnC6State.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnCpb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnEquivalenceTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnInitEarlyTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnIoCstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnLogicalIdTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnMicrocodePatch0600110F_Enc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnMicrocodePatchTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnMsrTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnPciTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnPowerMgmtSystemTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnPowerPlane.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnSharedMsrTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/F15TnUtilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnCacheFlushOnHalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnCoreAfterReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnDmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnHtc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnNbAfterReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnPowerCheck.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnPsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/TN/cpuF15TnPstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuCommonF15Utilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15BrandId.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15CacheDefaults.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15Dmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15MmioMap.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15MsrTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15PciTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15PowerCheck.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15Utilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x15/cpuF15WheaInitDataTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/PreserveMailbox.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuC6State.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCacheFlushOnHalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCacheInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCoreLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCpb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuDmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuFeatureLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuFeatures.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuHtc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuHwC1e.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuIoCstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateGather.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuSlit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuSrat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuWhea.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/S3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Table.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cahalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cahaltasm.S
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuApicUtilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuBist.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuBrandId.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuEarlyInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuEventLog.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuFamilyTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuGeneralServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuInitEarlyTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuLateInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuMicrocodePatch.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPostInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPowerMgmt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPowerMgmtMultiSocket.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPowerMgmtSingleSocket.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuWarmReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/heapManager.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitEarly.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitResume.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdLateRunApTask.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdS3LateRestore.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdS3Save.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CommonInits.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CommonReturns.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CreateStruct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/S3RestoreState.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/S3SaveState.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Common/GnbLibFeatures.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtEarly.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtS3Save.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Library/GnbTimerLibWrap0/GnbTimerLibWrap0.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibCpuAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibHeap.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibIoAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibMemAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibPci.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibPciAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbFamTranslation/GnbPcieTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbFamTranslation/GnbTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GfxCardInfo.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GfxEnumConnectors.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GfxPowerPlayTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GnbGfxInitLibV1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxEnvInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxGmcInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxIntegratedInfoTableTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxLibTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxMidInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxPostInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GfxTablesTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbBapmCoeffCalcTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbEarlyInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbEnvInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbFuseTableTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbIommuIvrsTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbMidInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbPostInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbRegisterAccTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/GnbTablesTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieAlibTNFM2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieAlibTNFS1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieComplexDataTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieConfigTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieEarlyInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieEnvInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieLibTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieMidInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PciePostInitTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PciePowerGateTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN/PcieTablesTN.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbIommuIvrs/GnbIommuIvrs.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbIvrsLib/GnbIvrsLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbMSocketLib/GnbMSocketLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV1/GnbNbInitLibV1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV4/GnbNbInitLibV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieAlibV1/PcieAlib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieAspm/PcieAspm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieClkPm/PcieClkPm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/GnbHandleLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieConfigData.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieConfigLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieInputParser.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieMapTopology.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieAspmBlackList.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieAspmExitLatency.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePhyServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePifServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePortRegAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePortServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePowerMgmt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieSiliconServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieTimer.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieTopologyServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieUtilityLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieWrapperRegAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PcieMaxPayloadV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PciePortServicesV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PciePowerMgmtV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PcieWrapperServicesV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieTrainingV1/PcieTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieTrainingV1/PcieWorkarounds.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSbIommuLib/GnbSbIommuLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSbLib/GnbSbLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSbLib/GnbSbPcie.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSview/GnbSview.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbTable/GnbTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/Fam15Mod1x/htNbFam15Mod1x.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/Fam15Mod1x/htNbUtilitiesFam15Mod1x.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htFeat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterface.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceCoherent.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceGeneral.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceNonCoherent.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htMain.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htNb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htNotify.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDebug.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDebugPrint.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDpSerial.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Family/0x15/TN/IdsF15TnAllService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Library/IdsLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ardk/ma.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/CHINTLV/mfchi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/CSINTLV/mfcsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/DMI/mfDMI.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ECC/mfecc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ECC/mfemp.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/EXCLUDIMM/mfdimmexclud.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/IDENDIMM/mfidendimm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/INTLVRN/mfintlvrn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/LVDDR3/mflvddr3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/MEMCLR/mfmemclr.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ODTHERMAL/mfodthermal.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/PARTRN/mfParallelTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/PARTRN/mfStandardTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/S3/mfs3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/TABLE/mftds.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/TN/mmflowtn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mdef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/merrhdl.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/minit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmConditionalPso.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmEcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmExcludeDimm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmLvDdr3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmMemClr.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmMemRestore.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmNodeInterleave.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmOnlineSpare.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmParallelTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmStandardTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmUmaAlloc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmflow.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mu.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/muc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mndcttn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnflowtn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnidendimmtn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnmcttn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnottn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnphytn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mnregtn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mns3tn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/TN/mntn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnS3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mndct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnfeat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnflow.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnmct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnphy.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnreg.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mntrain3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/FM2/mpUtnfm2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/FP2/mpStnfp2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/FS1/mpStnfs1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/mpStn3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/mpUtn3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/TN/mptn3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mp.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpmaxfreq.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpmr0.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpodtpat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mprtt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpsao.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mt3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtot3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtrci3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtsdi3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtspd3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mttecc3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mttwl3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mthdi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttEdgeDetect.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttdimbt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttecc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mtthrc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mtthrcSeedTrain.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttml.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttoptsrc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttsrc.c

agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/AcpiLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchCommon.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchPeLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/MemLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/PciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/Family/Hudson2/Hudson2GecEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/Family/Hudson2/Hudson2GecService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/GecEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/GecLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/GecMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Gec/GecReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Hudson2/Hudson2SSService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/HwmEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/HwmLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/HwmMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/HwmReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/Family/Hudson2/Hudson2ImcService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/Family/Hudson2/EnvDefHudson2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/Family/Hudson2/ResetDefHudson2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitS3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchTaskLauncher.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/InitEnvDef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/InitResetDef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ir/IrEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ir/IrLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ir/IrMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcib/PcibEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcib/PcibLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcib/PcibMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcib/PcibReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2AbEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2AbResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2AbService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2GppResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2GppService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2PcieEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Hudson2/Hudson2PcieService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppHp.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppPortInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/GppReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Hudson2/Hudson2SataEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Hudson2/Hudson2SataResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Hudson2/Hudson2SataService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataEnvLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Hudson2/Hudson2SdEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Hudson2/Hudson2SdResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Hudson2/Hudson2SdService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/Family/Hudson2/Hudson2LpcEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/Family/Hudson2/Hudson2LpcResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2EhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2EhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2EhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2OhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2OhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2OhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2XhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2XhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2XhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Hudson2/Hudson2XhciResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciReset.c


romstage-y += $(agesa_lib_src)
ramstage-y += $(agesa_lib_src)

subdirs-y += ../../mtrr
subdirs-y += ../../../x86/tsc
subdirs-y += ../../../x86/lapic
subdirs-y += ../../../x86/cache
subdirs-y += ../../../x86/mtrr
subdirs-y += ../../../x86/pae
subdirs-y += ../../../x86/smm
