#include "plugin_spellcheck.h"
#include "notepad_part.h" // this plugin applies to a notepad part
#include <qmultilineedit.h>
#include <kaction.h>
#include <klocale.h>
#include <kdebug.h>
#include <kinstance.h>

PluginSpellCheck::PluginSpellCheck( QObject* parent, const char* name )
    : Plugin( parent, name )
{
    (void) new KAction( i18n( "&Select current line (plugin)" ), 0, this,
                SLOT(slotSpellCheck()), actionCollection(), "spellcheck" );
}

void PluginSpellCheck::slotSpellCheck()
{
    // Check that the parent is a NotepadPart
    if ( !parent()->inherits("NotepadPart") )
       kdFatal() << "Spell-check plugin for wrong part (not NotepadPart)" << endl;
    else
    {
         NotepadPart * part = (NotepadPart *) parent();
         QMultiLineEdit * widget = (QMultiLineEdit *) part->widget();
         widget->selectAll(); //selects current line !
    }
}


KPluginFactory::KPluginFactory( QObject* parent, const char* name )
  : KLibFactory( parent, name )
{
  s_instance = new KInstance("KPluginFactory");
}

QObject* KPluginFactory::create( QObject* parent, const char* name, const char*,
 const QStringList & )
{
    return new PluginSpellCheck( parent, name );
}

extern "C"
{
  void* init_libspellcheck()
  {
    return new KPluginFactory;
  }

}

KInstance* KPluginFactory::s_instance = 0L;

#include "plugin_spellcheck.moc"

