#include <qpixmap.h>
#include <qfile.h>

#include <kglobal.h>
#include <kstddirs.h>
#include <klocale.h>


#include "kresourcedemo.h"

KResourceDemo::KResourceDemo (QWidget *parent) : 
  QLabel (parent)
{
  KStandardDirs *dirs = KGlobal::dirs();

  //Load picture and set as background.
  QString picturepath;
  picturepath = dirs->findResource ("wallpaper", "Paper01.jpg");

  QPixmap qpixmap;
  qpixmap.load (picturepath);
  printf ("%d x %d\n",qpixmap.width(), qpixmap.height());
  setBackgroundPixmap (qpixmap);


  //Draw some text from a resource file.
  QFont qfont = font();
  qfont.setBold(true);
  setFont (qfont);
  
  QString textpath;
  textpath = dirs->findResource ("appdata", "text.txt");
  
  char * buffer = new char [1024];
  QFile qfile (textpath);
  qfile.open (IO_ReadOnly);
  int nbytesread = qfile.readBlock (buffer, 1023);
  buffer[nbytesread]='\0';

  QString datatext (buffer);
  delete buffer;
  
  datatext.prepend (i18n("Here is some text:\n"));
  setText (datatext);
}
