// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with the package.



#ifndef KROT_KROT_H
#define KROT_KROT_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <kdebug.h>

#include <qtextstream.h>

#include <sys/types.h>


/**
 * global enums
 */
enum Unit { UNIT_MHZ, UNIT_CM };

/**
 * some global parameter
 */
extern const int KROT_DIALOGMARGIN;

/**
 * KConfig sections
 */
extern const char * const KROT_CONFIG_CALCULATION;
extern const char * const KROT_CONFIG_GENERAL;
extern const char * const KROT_CONFIG_IMPORT;


/**
 * Some constants for use with the kdebug macros.
 */
extern const unsigned short KDEBUG_KROT_ASSERT;
extern const unsigned short KDEBUG_KROT_FILE;
extern const unsigned short KDEBUG_KROT_GENERAL;
extern const unsigned short KDEBUG_KROT_GUI;
extern const unsigned short KDEBUG_KROT_LAUNCH;
extern const unsigned short KDEBUG_KROT_LAUNCH_OFTEN;
extern const unsigned short KDEBUG_KROT_DEBUG;
extern const unsigned short KDEBUG_KROT_DEBUG_VERBOSE;


/**
 * Our own KDEBUG macros
 */
#define KROT_ASSERT( Cond, String )                      KASSERT( (Cond), KDEBUG_FATAL, KDEBUG_KROT_ASSERT, (String) )
#define KROT_DEBUG( String )                             KDEBUG( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String) )
#define KROT_DEBUG1( String, Par1 )                      KDEBUG1( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1) )
#define KROT_DEBUG2( String, Par1, Par2 )                KDEBUG2( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2) )
#define KROT_DEBUG3( String, Par1, Par2, Par3 )          KDEBUG3( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3) )
#define KROT_DEBUG4( String, Par1, Par2, Par3, Par4 ) \
        KDEBUG4( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4) )
#define KROT_DEBUG5( String, Par1, Par2, Par3, Par4, Par5 ) \
        KDEBUG5( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4), (Par5) )
#define KROT_DEBUG6( String, Par1, Par2, Par3, Par4, Par5, Par6 ) \
        KDEBUG6( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6) )
#define KROT_DEBUG7( String, Par1, Par2, Par3, Par4, Par5, Par6, Par7 ) \
        KDEBUG7( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6), (Par7) )
#define KROT_DEBUG8( String, Par1, Par2, Par3, Par4, Par5, Par6, Par7, Par8 ) \
        KDEBUG8( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6), (Par7), (Par8) )

#define KROT_LAUNCH( String )                            KDEBUG( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String) )
#define KROT_LAUNCH1( String, Par1 )                     KDEBUG1( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1) )
#define KROT_LAUNCH2( String, Par1, Par2 )               KDEBUG2( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2) )
#define KROT_LAUNCH3( String, Par1, Par2, Par3)          KDEBUG3( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2), (Par3) )
#define KROT_LAUNCH4( String, Par1, Par2, Par3, Par4) \
        KDEBUG4( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2), (Par3), (Par4) )
#define KROT_LAUNCH5( String, Par1, Par2, Par3, Par4, Par5) \
        KDEBUG5( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2), (Par3), (Par4), (Par5) )
#define KROT_LAUNCH6( String, Par1, Par2, Par3, Par4, Par5, Par6) \
        KDEBUG6( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6) )
#define KROT_LAUNCH7( String, Par1, Par2, Par3, Par4, Par5, Par6, Par7) \
        KDEBUG7( KDEBUG_INFO, KDEBUG_KROT_LAUNCH, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6), (Par7) )

#define KROT_ERROR( Area, String )                       KDEBUG( KDEBUG_ERROR, (Area), (String) )
#define KROT_ERROR1( Area, String, Par1 )                KDEBUG1( KDEBUG_ERROR, (Area), (String), (Par1) )
#define KROT_ERROR2( Area, String, Par1, Par2 )          KDEBUG2( KDEBUG_ERROR, (Area), (String), (Par1), (Par2) )
#define KROT_ERROR3( Area, String, Par1, Par2, Par3 )    KDEBUG3( KDEBUG_ERROR, (Area), (String), (Par1), (Par2), (Par3) )

#define KROT_FATAL( Area, String )                       KDEBUG( KDEBUG_FATAL, (Area), (String) )
#define KROT_FATAL1( Area, String, Par1 )                KDEBUG1( KDEBUG_FATAL, (Area), (String), (Par1) )
#define KROT_FATAL2( Area, String, Par1, Par2 )          KDEBUG2( KDEBUG_FATAL, (Area), (String), (Par1), (Par2) )
#define KROT_FATAL3( Area, String, Par1, Par2, Par3 )    KDEBUG3( KDEBUG_FATAL, (Area), (String), (Par1), (Par2), (Par3) )

#define KROT_INFO( Area, String )                        KDEBUG( KDEBUG_INFO, (Area), (String) )
#define KROT_INFO1( Area, String, Par1 )                 KDEBUG1( KDEBUG_INFO, (Area), (String), (Par1) )
#define KROT_INFO2( Area, String, Par1, Par2 )           KDEBUG2( KDEBUG_INFO, (Area), (String), (Par1), (Par2) )
#define KROT_INFO3( Area, String, Par1, Par2, Par3 )     KDEBUG3( KDEBUG_INFO, (Area), (String), (Par1), (Par2), (Par3) )

#define KROT_WARN( Area, String )                        KDEBUG( KDEBUG_WARN, (Area), (String) )
#define KROT_WARN1( Area, String, Par1 )                 KDEBUG1( KDEBUG_WARN, (Area), (String), (Par1) )
#define KROT_WARN2( Area, String, Par1, Par2 )           KDEBUG2( KDEBUG_WARN, (Area), (String), (Par1), (Par2) )
#define KROT_WARN3( Area, String, Par1, Par2, Par3 )     KDEBUG3( KDEBUG_WARN, (Area), (String), (Par1), (Par2), (Par3) )

#ifdef VERBOSE
#  define KROT_DEBUG_VERBOSE( String )                   KDEBUG( KDEBUG_INFO, KDEBUG_KROT_DEBUG_VERBOSE, (String) )
#  define KROT_DEBUG1_VERBOSE( String, Par1 )            KDEBUG1( KDEBUG_INFO, KDEBUG_KROT_DEBUG_VERBOSE, (String), (Par1) )
#  define KROT_DEBUG2_VERBOSE( String, Par1, Par2 )      KDEBUG2( KDEBUG_INFO, KDEBUG_KROT_DEBUG_VERBOSE, (String), (Par1), (Par2) )
#  define KROT_DEBUG3_VERBOSE( String, Par1, Par2, Par3 ) \
          KDEBUG3( KDEBUG_INFO, KDEBUG_KROT_DEBUG_VERBOSE, (String), (Par1), (Par2), (Par3) )
#  define KROT_DEBUG8_VERBOSE( String, Par1, Par2, Par3, Par4, Par5, Par6, Par7, Par8 ) \
          KDEBUG8( KDEBUG_INFO, KDEBUG_KROT_DEBUG, (String), (Par1), (Par2), (Par3), (Par4), (Par5), (Par6), (Par7), (Par8) )
#  define KROT_LAUNCH_VERBOSE( String )                  KDEBUG( KDEBUG_INFO, KDEBUG_KROT_LAUNCH_OFTEN, (String) )
#else
#  define KROT_DEBUG_VERBOSE( String )
#  define KROT_DEBUG1_VERBOSE( String, Par1 )
#  define KROT_DEBUG2_VERBOSE( String, Par1, Par2 )
#  define KROT_DEBUG3_VERBOSE( String, Par1, Par2, Par3 )
#  define KROT_DEBUG8_VERBOSE( String, Par1, Par2, Par3, Par4, Par5, Par6, Par7, Par8 )
#  define KROT_LAUNCH_VERBOSE( String )
#endif


/**
 * Content of About.. dialogs.
 */
extern QString aboutKRot;


/**
 * This is an dirty workaround for a missing function of Qt.
 */
inline bool operator<( const QString& s1, const QString& s2 )
{
    return s1 < s2.data();
}



#if SIZEOF_LONG < 8


/**
 * QTextStream output of int64_t.
 *
 * This is only implemented when sizeof( long ) < 8
 *
 * @param stream QtextStream to write to.
 * @param x      Value to write.
 * @return QTextStream.
 */
inline QTextStream& operator<<( QTextStream& stream, int64_t x )
{
    stream << static_cast< int32_t >( x / 0xffff )
	   << static_cast< u_int32_t >( x % 0xffff );
    return stream;
}



/**
 * QTextStream output of u_int64_t.
 *
 * This is only implemented when sizeof( long ) < 8
 *
 * @param stream QtextStream to write to.
 * @param x      Value to write.
 * @return QTextStream.
 */
inline QTextStream& operator<<( QTextStream& stream, u_int64_t x )
{
    stream << static_cast< u_int32_t >( x / 0xffff )
	   << static_cast< u_int32_t >( x % 0xffff );
    return stream;
}


#endif // SIZEOF_LONG



/**
 * Convert float to char[]
 */
inline const char *ftoa( const double f )
{
    static char str[256];
    sprintf( str, "%.25g", f );
    return str;
}



#endif
