/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> TRS_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"

/*BLOCK SIZE OF 1024 LEADS TO A STRANGE ERROR ON DOS SIDE*/
#define BLOCK		512
#define QN_NO		6


short TrsConvert( char *out_flnm ) ;
short CAlloc1Dim( char **ptpt, long sz ) ;
void CFree1Dim( char **ptpt ) ;
short SAlloc1Dim( short **ptpt, long sz ) ;
void SFree1Dim( short **ptpt ) ;
short LAlloc1Dim( long **ptpt, long sz ) ;
void LFree1Dim( long **ptpt ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;
short DIndexx( long n, double *arrin, long *indx ) ;
short Csi6sfdrSort( long n, long *idx, char *cs, short *ss, long *is, short *s6s, float *fs, double *ds ) ;
short GenLnSet( long prm_no, double *prm ) ;







/*CONVERT SIMULATED LINE INTENSITIES, FREQ, QUANTUM NUMBERS AND EXPER FREQ TO BINARY FILE FORMAT FOR INPUT TO JB*/
short TrsConvert( char *out_flnm )
   {
   char fib_flnm[ FLNM_LEN ], q_flnm[ FLNM_LEN ], m_flnm[ FLNM_LEN ] ;
   int fib_fd, q_fd, m_fd, re_fd ;
   short *ts_ary, ts_ele ;
   long *idx_ary, tl_ele ;
   float *tf_ary ;
   double *td_ary, td_ele ;
   char *tc_ary ;
   short ln_ct, ln_ctold ;
   long cnt, mk_ct, mk_ctnew ;


/*LOG PHASE AND LINESET INFO*/
   fprintf( Log_fp, "\n----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> PHASE III " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "LINESET %s\n", out_flnm ) ;
   fprintf( Log_fp, "NUMBER OF CALCULATED LINES        = %ld\n", Trs_nolvs / Amp_no ) ;
   fprintf( Log_fp, "NUMBER OF ASSIGNED LINES MARKED   = %ld\n", Acp_nolvs ) ;
   fprintf( Log_fp, "NUMBER OF REJECTED LINES UNMARKED = %ld\n", Rej_nolvs ) ;



/*CREATE JB FILENAME CONTAINING SIM ENERGIES, EXP ENERGIES, SIM INTENSITY AND BAND TYPES*/
   strcpy( fib_flnm, out_flnm ) ;
   strcat( fib_flnm, ".f" ) ;


/*CREATE FREQUENCY, INTENSITY AND BAND TYPE FILENAME*/
   if( (fib_fd = open( fib_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T CREATE '%s' FILE !\n", fib_flnm ) ;
      return( E_RT_UNK ) ;
      }



/*ALLOCATE SPACE TO SORT TRANSITION ENERGIES INTO SINGLE ARRAY*/
   idx_ary = NULL ;
   if( LAlloc1Dim( &idx_ary, Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT (IDX_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*ALLOCATE SPACE FOR ALL BAND SIMULATED TRANSITION ENERGIES*/
   td_ary = NULL ;
   if( DAlloc1Dim( &td_ary, Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT (TI_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }



/*OPEN SIMULATED ENERGY FILE FOR READING*/
   if( (Se_fd = open( "IAR.se", O_RDONLY | O_BINARY )) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T OPEN 'IAR.se' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*READ ALL SIMULATED FREQUENCIES*/
   read( Se_fd, (char *)td_ary, Trs_nolvs * sizeof( double ) ) ;

/*CLOSE FILE*/
   close( Se_fd ) ;


/*SORT ACCORDING TO SIMULATED ENERGIES IN DECENDING ORDER -> UNIT OFFSET ARRAYS NEEDED*/
   DIndexx( Trs_nolvs, td_ary - 1, idx_ary - 1 ) ;
   if( Csi6sfdrSort( Trs_nolvs, idx_ary - 1, (char *)NULL, (short *)NULL, (long *)NULL, (short *)NULL, (float *)NULL, td_ary - 1 ) == -1 )
      return( E_RT_UNK ) ;


/*FOR COMPATIBILITY WITH OLD FORMAT OF JB - CONVERT SIM FREQUENCIES TO LONG INTEGERS BEFORE WRITING TO FILE*/
   if( JB_stat )
      {
      for( cnt = 0; cnt < Trs_nolvs; cnt++ )
         {
         tl_ele = (long)(*(td_ary + cnt) * JB_ERGMULT_2_LONG + 0.5) ;
         write( fib_fd, (char *)(&tl_ele), sizeof( long ) ) ;
         }
      }

/*WRITE ORDERED SIMULATED ENERGIES*/
   else
      write( fib_fd, (char *)td_ary, Trs_nolvs * sizeof( double ) ) ;





/*WRITE MARKER POSITION FOR QUICK SEEK IN SIM ARRAYS AND FILES -> MAKE MARKER FILENAME*/
   strcpy( m_flnm, out_flnm ) ;
   strcat( m_flnm, ".m" ) ;

/*CREATE MARKER FILE*/
   if( (m_fd = open( m_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T CREATE '%s' FILE !\n", m_flnm ) ;
      return( E_RT_UNK ) ;
      }


/*WRITE FIRST MARKER AS ZERO FOR BEGINNING OF FILE*/
   mk_ct = 0 ;
   write( m_fd, (char *)&mk_ct, sizeof( short ) ) ;


/*LOOP THROUGH ALL SIMULATED LINE FREQUENCIES - REVERSE ORDERED*/
   for( td_ele = td_ary[ 0 ], ln_ctold = 0, ln_ct = 0; ln_ct < Trs_nolvs; ln_ct++ )
      {


   /*STORE QUICK REFERENCE GIVEN FREQUENCY TO SEEK TO CORRECT LINE IN SIMULATION FILE*/
      if( (mk_ctnew = (long)((td_ele - *(td_ary + ln_ct)) / JB_fsr)) > mk_ct )
         {
         mk_ct++ ;

      /*FILL IN ALL EMPTY MARKER INDEXED ELEMENTS WITH PREVIOUS LINE NUMBER*/
         while( mk_ct < mk_ctnew )
            {
            write( m_fd, (char *)&ln_ctold, sizeof( short ) ) ;
            mk_ct++ ;
            }

      /*WRITE NEW LINE COUNT*/
         write( m_fd, (char *)&ln_ct, sizeof( short ) ) ;
         ln_ctold = ln_ct ;
         }
      }


/*AT END OF FILE, WRITE TOTAL # OF LINES*/
   write( m_fd, (char *)&ln_ct, sizeof( short ) ) ;

/*WRITE TOTAL # OF MARKERS -> INCLUDE ZEROITH ELEMENT*/
   mk_ct++ ;
   write( m_fd, (char *)&mk_ct, sizeof( long ) ) ;


/*CLOSE MARKER FILE*/
   close( m_fd ) ;





/*ZERO EXPERIMENTAL ENERGY ARRAY*/
   for( cnt = 0; cnt < Trs_nolvs; cnt++ )
      *(td_ary + cnt) = 0.0 ;


/*READ EXPERIMENTAL FREQUENCIES, SORT AND WRITE TO FILE*/
   if( Acp_nolvs > 0 )
      {

   /*OPEN EXPERIMENTAL FILE FOR READING*/
      if( (Ee_fd = open( "IAR.ee", O_RDONLY | O_BINARY )) == -1 )
         {
         fprintf( Log_fp, "\nTRSCONVERT -> CAN'T OPEN 'IAR.ee' FILE !\n" ) ;
         return( E_RT_UNK ) ;
         }

   /*READ INDEX AND EXPERIMENTAL FREQUENCY AND PLACE IN ARRAY AT INDEXED POSITION*/
      while( read( Ee_fd, (char *)&cnt, sizeof( long ) ) != 0 )
         read( Ee_fd, (char *)(td_ary + cnt), sizeof( double ) ) ;

   /*CLOSE FILE*/
      close( Ee_fd ) ;


   /*SORT ACCORDING TO SIMULATED ENERGIES IN DECENDING ORDER -> UNIT OFFSET ARRAYS NEEDED*/
      if( Csi6sfdrSort( Trs_nolvs, idx_ary - 1, (char *)NULL, (short *)NULL, (long *)NULL, (short *)NULL, (float *)NULL, td_ary - 1 ) == -1 )
         return( E_RT_UNK ) ;
      }


/*FOR COMPATIBILITY WITH OLD FORMAT OF JB - CONVERT EXP FREQUENCIES TO LONG INTEGERS BEFORE WRITING TO FILE*/
   if( JB_stat )
      {
      for( cnt = 0; cnt < Trs_nolvs; cnt++ )
         {
         tl_ele = (long)(*(td_ary + cnt) * JB_ERGMULT_2_LONG + 0.5) ;
         write( fib_fd, (char *)(&tl_ele), sizeof( long ) ) ;
         }
      }

/*WRITE ORDERED EXPERIMENTAL ENERGIES*/
   else
      write( fib_fd, (char *)td_ary, Trs_nolvs * sizeof( double ) ) ;

/*FREE LOCAL SPACE*/
   DFree1Dim( &td_ary ) ;




/*ALLOCATE SPACE FOR ALL SIMULATED TRANSITION INTENSITIES*/
   tf_ary = NULL ;
   if( FAlloc1Dim( &tf_ary, Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT (INT_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*OPEN SIMULATED INTENSITY FILE FOR READING*/
   if( (Si_fd = open( "IAR.si", O_RDONLY | O_BINARY )) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T OPEN 'IAR.si' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*READ ALL SIMULATED INTENSITIES*/
   read( Si_fd, (char *)tf_ary, Trs_nolvs * sizeof( float ) ) ;

/*CLOSE FILE AND REMOVE IT*/
   close( Si_fd ) ;



/*SORT ACCORDING TO SIMULATED INTENSITIES IN DECENDING ORDER -> UNIT OFFSET ARRAYS NEEDED*/
   if( Csi6sfdrSort( Trs_nolvs, idx_ary - 1, (char *)NULL, (short *)NULL, (long *)NULL, (short *)NULL, tf_ary - 1, (double *)NULL ) == -1 )
      return( E_RT_UNK ) ;


/*FOR COMPATIBILITY WITH OLD FORMAT OF JB - CONVERT LINE INTENSITIES TO SHORT INTEGERS BEFORE WRITING TO FILE*/
   if( JB_stat )
      {
      for( cnt = 0; cnt < Trs_nolvs; cnt++ )
         {
         ts_ele = (short)(*(tf_ary + cnt) * JB_ITNMULT_2_SHORT + 0.5) ;
         write( fib_fd, (char *)(&ts_ele), sizeof( short ) ) ;
         }
      }

/*WRITE ORDERED SIMULATED INTENSITIES*/
   else
      write( fib_fd, (char *)tf_ary, Trs_nolvs * sizeof( float ) ) ;

/*FREE LOCAL SPACE*/
   FFree1Dim( &tf_ary ) ;






/*ALLOCATE SPACE FOR ALL BAND TYPE LABELS*/
   tc_ary = NULL ;
   if( CAlloc1Dim( &tc_ary, Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT (BT_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }


/*OPEN SIMULATED BAND TYPE LABEL FILE FOR READING*/
   if( (Bt_fd = open( "IAR.bt", O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T OPEN 'IAR.bt' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*READ ALL BAND TYPE LABELS*/
   read( Bt_fd, (char *)tc_ary, Trs_nolvs * sizeof( char ) ) ;

/*CLOSE FILE AND REMOVE IT*/
   close( Bt_fd ) ;



/*OPEN REJECTED LINE FILE FOR READING*/
   if( (re_fd = open( "IAR.re", O_RDONLY | O_BINARY ) ) != -1 )
      {

   /*LABEL ALL REJECTED LINES WITH R -> READ INDEX AND PLACE IN ARRAY AT INDEXED POSITION*/
      while( read( re_fd, (char *)&cnt, sizeof( long ) ) != 0 )
         *(tc_ary + cnt) = (char)'R' ;

   /*CLOSE FILE AND REMOVE IT*/
      close( re_fd ) ;
      }


/*SORT ACCORDING TO SIMULATED ENERGIES IN DECENDING ORDER -> UNIT OFFSET ARRAYS NEEDED*/
   if( Csi6sfdrSort( Trs_nolvs, idx_ary - 1, tc_ary - 1, (short *)NULL, (long *)NULL, (short *)NULL, (float *)NULL, (double *)NULL ) == -1 )
      return( E_RT_UNK ) ;


/*WRITE ORDERED BAND TYPES*/
   write( fib_fd, (char *)tc_ary, Trs_nolvs * sizeof( char ) ) ;


/*FREE SPACE*/
   CFree1Dim( &tc_ary ) ;

/*CLOSE FREQUENCY INTENSITY AND BAND TYPE FILENAME*/
   close( fib_fd ) ;







/*ALLOCATE SPACE FOR ALL QUANTUM #'S FOR ALL SIMULATED LINES*/
   ts_ary = NULL ;
   if( SAlloc1Dim( &ts_ary, QN_NO * Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT (TS_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }


/*CREATE QUANTUM # FILENAME*/
   strcpy( q_flnm, out_flnm ) ;
   strcat( q_flnm, ".q" ) ;

/*CREATE QUANTUM # FILE*/
   if( (q_fd = open( q_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T CREATE '%s' FILE !\n", q_flnm ) ;
      return( E_RT_UNK ) ;
      }


/*OPEN SIMULATED ENERGY FILE FOR READING*/
   if( (Jk_fd = open( "IAR.jk", O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nTRSCONVERT -> CAN'T OPEN 'IAR.jk' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*READ ALL BAND TYPES*/
    read( Jk_fd, (char *)ts_ary, QN_NO * Trs_nolvs * sizeof( short ) ) ;

/*CLOSE FILE AND REMOVE IT*/
   close( Jk_fd ) ;


/*SORT ACCORDING TO SIMULATED ENERGIES IN DECENDING ORDER -> UNIT OFFSET ARRAYS NEEDED*/
   if( Csi6sfdrSort( Trs_nolvs, idx_ary - 1, (char *)NULL, (short *)NULL, (long *)NULL, ts_ary - QN_NO, (float *)NULL, (double *)NULL ) == -1 )
      return( E_RT_UNK ) ;

/*WRITE ORDERED SIMULATED QUANTUM #'S*/
   write( q_fd, (char *)ts_ary, QN_NO * Trs_nolvs * sizeof( short ) ) ;



/*FREE SPACE*/
   SFree1Dim( &ts_ary ) ;

/*CLOSE MARKER FILE*/
   close( q_fd ) ;


/*FREE LOCAL SPACE*/
   LFree1Dim( &idx_ary ) ;

/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
   }









/*GENERATE NEW LINE SET BASED ON NEW PARAMETERS AND OLD DERIVATIVES*/
short GenLnSet( long prm_no, double *prm )
   {
   long cnt, cts, row_ofs, ln_no, erg_ct ;
   long dvs_no, dvs_sz ;
   double *erg_vec ;
   double erg, *dvs_mat ;



/*GENERATE NEW LINE SET -> CALCULATE SPACE NEEDED FOR DERIVATIVE BLOCK*/
   dvs_no = St_nodv[ GND ] + St_nodv[ EXE ] ;

/*MICROWAVE - HALF THE NUMBER OF DERIVATIVES*/
   if( !Rc[ EXE ][ ORI ] )
      dvs_no = St_nodv[ GND ] ;

/*DETERMIN SIZE OF BLOCK ARRAY*/
   dvs_sz = BLOCK * dvs_no ;

/*ALLOCATE SPACE FOR OLD DERIVATIVE INFORMATION*/
   dvs_mat = NULL ;
   if( DAlloc1Dim( &dvs_mat, dvs_sz ) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS (DVS_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*ALLOCATE SPACE FOR OBSERVED ENERGY VECTOR*/
   erg_vec = NULL ;
   if( DAlloc1Dim( &erg_vec, BLOCK * Amp_no ) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS (ERG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*OPEN DERIVATIVE FILE*/
   if( (Dv_fd = open( "IAR.dv", O_RDONLY | O_BINARY )) == -1 )
      {
      printf( "\nLSFTRS -> CAN'T OPEN 'IAR.dv' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*CREATE NEW ENERGY FILE*/
   if( (Se_fd = open( "IAR.se", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS -> CAN'T CREATE 'IAR.se' FILE !\n" ) ;
      return( E_RT_UNK ) ;
      }



/*READ OLD DERIVATIVES IN BLOCK FORM*/
   while( (ln_no = read( Dv_fd, (char *)dvs_mat, dvs_sz * sizeof( double ) ) /
         (dvs_no * sizeof( double ) )) != 0 )
      {

   /*LOOP THROUGH EACH BLOCK OF DERIVATIVES*/
      for( erg_ct = 0, cnt = 0; cnt < ln_no; cnt++, erg_ct += Amp_no )
         {

      /*LOOP THROUGH ALL DERIVATIVES -> UNIT OFFSET PARAMETER ARRAY*/
         for( erg = 0.0, row_ofs = cnt * dvs_no - 1, cts = 1; cts < prm_no; cts++ )
            erg += *(prm + cts) * *(dvs_mat + row_ofs + cts) ;

      /*ADD ORIGIN*/
         *(erg_vec + erg_ct) = erg + prm[ cts ] ;

      /*REPEAT TRANSITION ERG WHEN AMPLITUDES ARE ALSO WANTED*/
         if( Amp_no > 1 )
            *(erg_vec + erg_ct + 1) = *(erg_vec + erg_ct) + 1.0 ;
         if( Amp_no > 2 )
            *(erg_vec + erg_ct + 2) = *(erg_vec + erg_ct) + 1.0 ;
         if( Amp_no > 3 )
            *(erg_vec + erg_ct + 3) = *(erg_vec + erg_ct) + 1.0 ;
         }


   /*WRITE NEW ENERGIES OUT TO FILE*/
      write( Se_fd, (char *)erg_vec, Amp_no * ln_no * sizeof( double ) ) ;
      }



/*FREE SPACE*/
   DFree1Dim( &erg_vec ) ;
   DFree1Dim( &dvs_mat ) ;

/*CLOSE FILES*/
   close( Dv_fd ) ;
   close( Se_fd ) ;


/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
   }








/*
for( cnt = 0; cnt < Trs_nolvs; cnt++ )
   printf( "SIM %ld\n", *(ti_ary + cnt) ) ;
fflush( stdout ) ;
*/
/*
for( cnt = 0; cnt < Trs_nolvs; cnt++ )
   printf( "SIM %ld\n", *(ti_ary + cnt) ) ;
fflush( stdout ) ;
*/
/*
for( cnt = 0; cnt < Trs_nolvs; cnt++ )
   printf( "EXP %ld\n", *(ti_ary + cnt) ) ;
fflush( stdout ) ;
*/
/*
for( cnt = 0; cnt < Trs_nolvs; cnt++ )
   printf( "INT %ld\n", *(ts_ary + cnt) ) ;
fflush( stdout ) ;
*/
/*
for( cnt = 0; cnt < Trs_nolvs; cnt++ )
   printf( "BT %c\n", *(tc_ary + cnt) ) ;
fflush( stdout ) ;
*/
/*
for( cnt = 0; cnt < QN_NO * Trs_nolvs; cnt += QN_NO )
   printf( "%ld %ld %ld %ld %ld %ld\n", *(ts_ary + cnt), *(ts_ary + cnt + 1), *(ts_ary + cnt + 2), *(ts_ary + cnt + 3), *(ts_ary + cnt + 4), *(ts_ary + cnt + 5) ) ;
fflush( stdout ) ;
*/

