c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997,1998 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.


c     size of calculations/arrays
#define ARNIROT_JMAX      (100)
#define ARNIROT_MAXNLI  (60000)
#define ARNIROT_NPAR       (11)


c     file descriptors
#define ARNIROT_STDIN   ( 5 )
#define ARNIROT_STDOUT  ( 6 )
#define ARNIROT_STDERR  ( 6 )


c     debug macros
#ifdef LAUNCH
#  define ARNIROT_LAUNCH( msg ) write(ARNIROT_STDERR,*) msg
#else
#  define ARNIROT_LAUNCH( msg )
#endif

#ifdef DEBUG
#  define ARNIROT_DEBUG( msg ) write(ARNIROT_STDERR,*) msg
#  define ARNIROT_DEBUG1( msg1, msg2 ) write(ARNIROT_STDERR,*) msg1, msg2
#  define ARNIROT_DEBUG2( msg1, msg2, msg3 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3
#  define ARNIROT_DEBUG3( msg1, msg2, msg3, msg4 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3, msg4
#else
#  define ARNIROT_DEBUG( msg )
#  define ARNIROT_DEBUG1( msg1, msg2 )
#  define ARNIROT_DEBUG2( msg1, msg2, msg3 )
#  define ARNIROT_DEBUG3( msg1, msg2, msg3, msg4 )
#endif

#ifdef DEBUG_VERBOSE
#  define ARNIROT_DEBUG_VERBOSE( msg ) write(ARNIROT_STDERR,*) msg
#  define ARNIROT_DEBUG_VERBOSE1( msg1, msg2 ) write(ARNIROT_STDERR,*) msg1, msg2
#  define ARNIROT_DEBUG_VERBOSE2( msg1, msg2, msg3 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3
#  define ARNIROT_DEBUG_VERBOSE3( msg1, msg2, msg3, msg4 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3, msg4
#else
#  define ARNIROT_DEBUG_VERBOSE( msg )
#  define ARNIROT_DEBUG_VERBOSE1( msg1, msg2 )
#  define ARNIROT_DEBUG_VERBOSE2( msg1, msg2, msg3 )
#  define ARNIROT_DEBUG_VERBOSE3( msg1, msg2, msg3, msg4 )
#endif

#ifdef DEBUG_FIT_OUTPUT
#  define ARNIROT_DEBUG_FIT( msg ) write(ARNIROT_STDERR,*) msg
#  define ARNIROT_DEBUG_FIT1( msg1, msg2 ) write(ARNIROT_STDERR,*) msg1, msg2
#  define ARNIROT_DEBUG_FIT2( msg1, msg2, msg3 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3
#  define ARNIROT_DEBUG_FIT3( msg1, msg2, msg3, msg4 ) write(ARNIROT_STDERR,*) msg1, msg2, msg3, msg4
#else
#  define ARNIROT_DEBUG_FIT( msg )
#  define ARNIROT_DEBUG_FIT1( msg1, msg2 )
#  define ARNIROT_DEBUG_FIT2( msg1, msg2, msg3 )
#  define ARNIROT_DEBUG_FIT3( msg1, msg2, msg3, msg4 )
#endif
