//
// Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "StarDetails.h"

extern "C"
{
#include "Stars.h"
}

StarDetails::StarDetails(QWidget* w, const char* name)
	: QFrame(w,name)
{

	setGeometry(10,40,320,300);
	setFrameStyle(Panel|Raised);

	lA = new QLabel(this);
	lA->setGeometry(10,10,110,16);
	lA->setAlignment(AlignRight|AlignVCenter);
	lA->setText(klocale->translate("BS Catalog :"));

	lB = new QLabel(this);
	lB->setGeometry(10,30,110,16);
	lB->setAlignment(AlignRight|AlignVCenter);
	lB->setText(klocale->translate("Name : "));

	lC = new QLabel(this);
	lC->setGeometry(10,50,110,16);
	lC->setAlignment(AlignRight|AlignVCenter);
	lC->setText(klocale->translate("Constellation : "));

	lD = new QLabel(this);
	lD->setGeometry(10,70,110,16);
	lD->setAlignment(AlignRight|AlignVCenter);
	lD->setText(klocale->translate("HD Catalog : "));

	lE = new QLabel(this);
	lE->setGeometry(10,90,110,16);
	lE->setAlignment(AlignRight|AlignVCenter);
	lE->setText(klocale->translate("ADS Catalog : "));

	lF = new QLabel(this);
	lF->setGeometry(10,110,110,16);
	lF->setAlignment(AlignRight|AlignVCenter);
	lF->setText(klocale->translate("Variable ID : "));

	lG = new QLabel(this);
	lG->setGeometry(10,130,110,16);
	lG->setAlignment(AlignRight|AlignVCenter);
	lG->setText(klocale->translate("Right Ascension : "));

	lH = new QLabel(this);
	lH->setGeometry(10,150,110,16);
	lH->setAlignment(AlignRight|AlignVCenter);
	lH->setText(klocale->translate("Declination : "));

	lI = new QLabel(this);
	lI->setGeometry(10,170,110,16);
	lI->setAlignment(AlignRight|AlignVCenter);
	lI->setText(klocale->translate("Magnitude : "));

	lJ = new QLabel(this);
	lJ->setGeometry(10,190,110,16);
	lJ->setAlignment(AlignRight|AlignVCenter);
	lJ->setText(klocale->translate("BV Magnitude : "));

	lK = new QLabel(this);
	lK->setGeometry(10,210,110,16);
	lK->setAlignment(AlignRight|AlignVCenter);
	lK->setText(klocale->translate("Spectrum : "));

	bs = new QLabel(this);
	bs->setGeometry(130,10,100,16);
	bs->setAlignment(AlignLeft|AlignVCenter);

	na = new QLabel(this);
	na->setGeometry(130,30,180,16);
	na->setAlignment(AlignLeft|AlignVCenter);
	
	co = new QLabel(this);
	co->setGeometry(130,50,180,16);
	co->setAlignment(AlignLeft|AlignVCenter);
	
	hd = new QLabel(this);
	hd->setGeometry(130,70,180,16);
	hd->setAlignment(AlignLeft|AlignVCenter);
	
	ac = new QLabel(this);
	ac->setGeometry(130,90,180,16);
	ac->setAlignment(AlignLeft|AlignVCenter);
	
	va = new QLabel(this);
	va->setGeometry(130,110,180,16);
	va->setAlignment(AlignLeft|AlignVCenter);
	
	ra = new QLabel(this);
	ra->setGeometry(130,130,180,16);
	ra->setAlignment(AlignLeft|AlignVCenter);
	
	de = new QLabel(this);
	de->setGeometry(130,150,180,16);
	de->setAlignment(AlignLeft|AlignVCenter);
	
	vm = new QLabel(this);
	vm->setGeometry(130,170,180,16);
	vm->setAlignment(AlignLeft|AlignVCenter);
	
	bv = new QLabel(this);
	bv->setGeometry(130,190,180,16);
	bv->setAlignment(AlignLeft|AlignVCenter);
	
	sc = new QLabel(this);
	sc->setGeometry(130,210,180,30);
	sc->setAlignment(AlignLeft|AlignVCenter);
	
	okay = new QPushButton(klocale->translate("Hide"),this);
	okay->setGeometry(260,10,50,20);
	connect(okay,SIGNAL(clicked()),SLOT(exit()));
}

StarDetails::~StarDetails()
{
}

void
StarDetails::exit()
{
	emit quit();
}

void
StarDetails::view(long bscat)
{
QString txt(26);

	txt.sprintf("%d",bscat);
	bs->setText(txt);

	na->setText(::getName());

	co->setText(::getConstellation(::getShortConst()));

	txt.sprintf("%d",::getHDCatalog());
	hd->setText(txt);

	txt.sprintf("%d",::getADSCatalog());
	ac->setText(txt);

	va->setText(::getVarID());

	txt.sprintf("%dh %dm %.2fs",::getRAhour(),::getRAminute(),::getRAsecond());
	ra->setText(txt);

	txt.sprintf("%dd %dm %.2fs",::getDECdegree(),::getDECminute(),::getDECsecond());
	de->setText(txt);

	txt.sprintf("%.2f",::getVMagnitude());
	vm->setText(txt);

	txt.sprintf("%.2f",::getBVMagnitude());
	bv->setText(txt);

	sc->setText(::getSpectrum());
}
