/***************************************************************************
                          bintpar.cpp  -  description
                             -------------------
    begin                : Sun Jan 2 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/



// include files for QT

#include <qbttngrp.h>
#include <qpushbt.h>
// include files for KDE
#include <ktabctl.h>

#include "bhebinp.h"
#include "bibview.h"

// application specific includes

#include "bintpar.h"
#include "resource.h"


BIntPar::BIntPar(QWidget *parent, const char *name ) : QWidget(parent,name) {

// Hebfont setzten
   	extern BitanaApp *bitana;
		QFont hebfont(bitana->getHebFont1());

// Gruppe Intervallwort

  QButtonGroup* intw;
  intw = new QButtonGroup( this, "intw" );
  intw->setGeometry( 0, 5, 260, 90 );
  intw->setFrameStyle( 49 );
  intw->setTitle( i18n("searchword:" ));
	
  QPushButton *but;
	
	but  = new QPushButton(this, "w");
	but->setGeometry( 5, 25, 40, 30 );
	but->setText( "W>" );
	intw->insert(but);
	
  iwort = new QLabel(this, "iw");
  iwort->setGeometry( 50, 25, 200, 30 );
	iwort->setFont( hebfont );
	iwort->setFrameStyle( 49 );
	iwort->setText("");

 	connect(intw, SIGNAL(clicked(int)), this, SLOT(slotPressW(int)));

	ana = new QCheckBox(i18n("with analysis"), this, "ana");
  ana->setGeometry(10, 60, 200, 30);

	// Gruppe Richtung
  QButtonGroup* grrich;
  grrich = new QButtonGroup( this, "grrich" );
  grrich->setGeometry( 0, 100, 120, 80 );
  grrich->setFrameStyle( 49 );
  grrich->setTitle( i18n("direction"));

	vor = new QCheckBox(i18n("foreward"), this, "vor");
  vor->setGeometry(10, 118, 80, 30);
  grrich->insert(vor);

  ru = new QCheckBox(i18n("backward"), this, "rue");
  ru->setGeometry(10, 143, 80, 30);
  grrich->insert(ru);

	vor->setChecked(true);


  // Gruppe Sortierung

  QButtonGroup* grsort;
  grsort = new QButtonGroup( this, "grsort" );
  grsort->setGeometry( 140, 100, 120, 80 );
  grsort->setFrameStyle( 49 );
  grsort->setTitle( i18n("sort") );

  inte = new QRadioButton(i18n("sequense"), this, "inter");
  inte->setGeometry(145, 118, 80, 30);
  grsort->insert(inte);

  posi = new QRadioButton(i18n("position"), this, "posi");
  posi->setGeometry(145, 143, 80, 30);
  grsort->insert(posi);

  inte->setChecked(true);

	QButtonGroup* griber;
  griber = new QButtonGroup( this, "bgroup" );
  griber->setGeometry( 0, 185, 260, 50 );
  griber->setFrameStyle( 49 );
  griber->setTitle( i18n("sequencerange") );

	QLabel *bv = new QLabel(this);
  bv->setText(i18n("from:"));
  bv->setGeometry(10, 205, 50, 20);


  ivon = new QSpinBox(1, 9999, 1, this, "ivon");
  ivon->setGeometry( 50, 205, 50, 20);

  QLabel *bb = new QLabel(this);
  bb->setText(i18n("to:"));
  bb->setGeometry(130, 205, 50, 20);

  ibis = new QSpinBox(2, 9999, 1, this, "ibis");
  ibis->setGeometry( 170, 205, 60, 20);
  ibis->setValue(200);


}

/** Wort Button gedrckt */
void BIntPar::slotPressW(int x){

  KTabCtl* tab = (KTabCtl*)parentWidget();
	BibView* v   = (BibView*)tab->parentWidget();
	BHebInp* i = v->inp;
	iwort->setText( (i->readInput()).rightJustify(16, ' '));

}

BIntPar::~BIntPar(){
}


QString BIntPar::liesIntWort() {

	QString t;
	t = iwort->text();
	return( t.stripWhiteSpace());	
}

bool BIntPar::liesAnalyse() {
	return(ana->isChecked());
}

int BIntPar::liesRichtung() {
	if ((vor->isChecked()) && !(ru->isChecked())) return (1);
  if (!(vor->isChecked()) && (ru->isChecked())) return (2);
	return (0);
}

bool BIntPar::liesSortierung() {
	return (posi->isChecked());
}

int BIntPar::liesIntwVon(){
  QString tmp;
	tmp = ivon->text();
	return (tmp.toInt());
}

int BIntPar::liesIntwBis(){
  QString tmp;
	tmp = ibis->text();
	return (tmp.toInt());
}


void BIntPar::setIntWort(QString wo){
	iwort->setText(wo.rightJustify(16, ' '));	
}

void BIntPar::setAnalyse(bool analyse){
	if (analyse) ana->setChecked(true);
		else ana->setChecked(false);
}

void BIntPar::setRichtung(int ri){
	vor->setChecked(true);
	ru->setChecked(true);
	if (ri==1) ru->setChecked(false);
	if (ri==2) vor->setChecked(false);	
}

void BIntPar::setSortierung(bool po){
	posi->setChecked(po);
	inte->setChecked(!po);
}

void BIntPar::setIntwVon(int von){
	ivon->setValue(von);
}

void BIntPar::setIntwBis(int bis){
ibis->setValue(bis);
}

















