/***************************************************************************
                          bhebidx.cpp  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "bhebidx.h"
#include "iostream.h"
#include "bitana.h"

#define LNGTXT 400

BHebIdx::BHebIdx()
{

}

BHebIdx::~BHebIdx()
{
 f1.close();
 f2.close();
}

int BHebIdx::lesVers(QString buch, int pos)
{
 unsigned int i;
 int j,k,bu=0;
 char txt[LNGTXT];
 QString verz;

 extern BitanaApp *bitana;

 if(strcmp(name,buch) && f2.isOpen()) f2.close();
 bool ok=openBuch(buch);               // Opened the indexfile
 if(!ok || pos>int(datlng)) return(-1);
 k=posKap(buch, pos);                  // Read idxhead to position
 if(k>0)
 {
  if(!f2.isOpen())                     // Opened the codefilr
  {
   verz=bitana->getBookDir();
/*
   do
   {
    verz=verz.left(verz.length()-1);
   } while(verz.at(verz.length()-1)!='/');
   verz.append("he/");
*/
   QDir d=QDir::root();
   if (d.cd(verz))
   {
    f2.setName(d.filePath(name+".cod"));
    if (!f2.open(IO_ReadOnly))
        QMessageBox::warning(0,i18n("Cannot find the file"),
                             f2.name());
   }
   else
   {
    QMessageBox::warning(0,i18n("Error"),
                           i18n("Cannot find the book directory")+verz);
   }
  }
  f2.at(idx.idxkop.bpos);              // Set file pointer
  for(i=0;i<300;i++) txt[i]=' ';
  i=j=0;
  while(int(wrtbu[i])!=-1 && i<sizeof(wrtbu))  // Text create
  {
   if(wrtbu[i]<0)
   {
    wrtbu[i]=wrtbu[i]+128;             // Modification number letter
//    txt[j]='-';                        // To make bind the words
    txt[j]=' ';
   }
   else txt[j]=' ';
   j++;
   for(k=0;k<int(wrtbu[i]);k++)        // Word make
   {
    bu=f2.getch();                     // Read letter
    txt[j+k]=bu;
   }
   j=j+k;
   i++;
  }

// Modify and move the text
  txt[j]=':';                         // The end of verse
  txt[j+1]='\0';                      // The end of string
  text.operator=(txt);                // Make a QString
  text.remove(0,2);
  return(idx.idxkop.epos);
 }
 else return(-1);                     // No idx record
}

int BHebIdx::nextIdxSatz()
{
 unsigned int i;
 int bu=0;

 if(f1.isOpen() && !f1.atEnd())
 {
  f1.readBlock(idx.idxstr,(uint)sizeof(IDXKOP)); // Read idxhead
  for(i=0;i<sizeof(wrtbu);i++) wrtbu[i]=0;
  i=0;
  do                                   // Read quanti words at a vers
  {
   wrtbu[i]=bu;                        // Entry quanti letter of word
   i++;
  } while(i<sizeof(wrtbu) && (bu=f1.getch())!=0xff);
  wrtbu[i]=bu;
  if(bu==0xff) return(idx.idxkop.epos);
  else
  {
   QMessageBox::warning(0,i18n("File is corrupt"),
                          f1.name());
   return(0);
  }
 }
 else return(0);                       // Not file or file is eof
}


int BHebIdx::endBuch(QString buch)
{
 bool ok=openBuch(buch);
 if(!ok) return(-1);
 int lng=posKap(buch, datlng);
 return(lng);
}

void BHebIdx::transStr()
{

 char feld[8];
 unsigned int i;

// Transfer to public structure versdat
 versdat.kap=int(idx.idxkop.kap);
 versdat.vers=int(idx.idxkop.vers);
 versdat.bpos=idx.idxkop.bpos;
 versdat.epos=idx.idxkop.epos;

// Create string of chapter and verse
 for(i=0;i<sizeof(versdat.kapvers);i++) versdat.kapvers[i]=' ';
 sprintf(feld,"% d",versdat.kap);
 for(i=1;i<strlen(feld);i++) versdat.kapvers[3-strlen(feld)+i]=feld[i];
 sprintf(feld,"% d",versdat.vers);
 for(i=1;i<strlen(feld);i++) versdat.kapvers[6-strlen(feld)+i]=feld[i];
// versdat.kapvers[7]=idx.idxkop.soze;   // Additional character (Sonderzeichen)
 versdat.kapvers[3]=':';               // Chapter verse seperator
 versdat.kapvers[8]='\0';
}

int BHebIdx::posKap(QString buch, int pos)
{
 bool ok=openBuch(buch);
 if(!ok || pos>int(datlng)) return(-1);
 int k=idx.idxkop.epos;
 if(idx.idxkop.bpos>pos)
 {
  f1.at(0);                            // Pointer to begin of file
  k=nextIdxSatz();
 }
 while(k && pos>idx.idxkop.epos) k=nextIdxSatz();
 transStr();                           // Transmission of public srtucture
 return(idx.idxkop.epos);
}

int BHebIdx::kapPos(QString buch, int kap, int vers)
{
 int k=1;
 bool ok=openBuch(buch);
 if(!ok) return(-1);
 if(int(idx.idxkop.kap)>kap ||
   (int(idx.idxkop.kap)==kap && int(idx.idxkop.vers)>=vers))
 {
  f1.at(0);
  k=nextIdxSatz();                   // Read first record
 }
// Search the idx record
 while(k && kap>int(idx.idxkop.kap)) k=nextIdxSatz();
 while(k && kap==int(idx.idxkop.kap) && vers>int(idx.idxkop.vers))
{
 k=nextIdxSatz();
}
 if(kap!=int(idx.idxkop.kap) || vers!=int(idx.idxkop.vers))
 {
  f1.at(0);
  k=nextIdxSatz();                  // Read first record
  return(-1);
 }
 transStr();                         // Transmission of the public srtucture
 return(k);
}

bool BHebIdx::openBuch(QString buch)
{
 extern BitanaApp *bitana;
 int ok=0;
 QString verz;

 if(strcmp(name,buch))
 {
  if(f1.isOpen()) f1.close();
  name=" ";

  verz=bitana->getBookDir();
/*
  do
  {
   verz=verz.left(verz.length()-1);
  } while(verz.at(verz.length()-1)!='/');
  verz.append("he/");
*/
  QDir d=QDir::root();
  if (d.cd(verz))
  {
   f1.setName( d.filePath(buch+".idx"));
   if (f1.open(IO_ReadOnly)) ok=nextIdxSatz(); // Read first record idxfile
   else
   {
    QMessageBox::warning(0,i18n("Cannot find the file"),
                               f1.name());
    return false;
   }
  }
  else
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot find the book directory")+verz);
   return false;
  }
  name=buch;
  if(f2.isOpen()) f2.close();

   verz=bitana->getBookDir();
/*
  do
  {
   verz=verz.left(verz.length()-1);
  } while(verz.at(verz.length()-1)!='/');
  verz.append("he/");
*/
  QDir e=QDir::root();
  if (e.cd(verz))
  {
   f2.setName(e.filePath(name+".cod"));
   if (!f2.open(IO_ReadOnly))
   {
     QMessageBox::warning(0,i18n("Cannot find the file"),
                          f2.name());
    return false;
   }
  }
  else
  {
   QMessageBox::warning(0,i18n("Cannot find the book directory"),
                          bitana->getBookDir());
   return false;
  }
  datlng=f2.size()-1;
  f2.close();
 }
 return true;
}
