/***************************************************************************
                          bgrafiksatz.h  -  description
                             -------------------
    begin                : Mon Dec 27 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BGRAFIKSATZ_H
#define BGRAFIKSATZ_H

/**
  *@author Heinz Schumann
  *The class 'BGrafiksatz' is a help support to create and write on file for
  *application interne grafic-files structure. This worked sum with the class 'BGrafik'
*/

#include <qobject.h>
#include <qfile.h>
#include <qtextstream.h>

class BGrafikSatz : public QObject
{
 Q_OBJECT

 public:
	BGrafikSatz();
	~BGrafikSatz();

/**
 *Initial the members for windows with x and y pixels
*/
  void setzFenster(int, int);

/**
 *Calculate the scale for picture-presentation
 *The parameters is:
 *1. min x value
 *2. max x value
 *3. min y value
 *4. max y value
*/
  void setzMassstab(int, int, int, int);

/**
 *Create and opened the file with name of QString
*/
  bool openDatei(QString);
  void closeDatei();

/**
 *Set color picture
 *Parameters is code digit of color
 *0 = white
 *1 = black
 *2 = gray
 *3 = red
 *4 = green
 *5 = blue
 *6 = yellow
 *7 = cyan
 *8 = magneta
*/
  void setzFarbe(int);
  void schreibText(QString);
  void grafikText(int, int, int, QString);
  void malePunkt(int, int, int);
  void maleLinie(int, int, int, int, int);
  void maleBalken(int, int, int, int, int);
  void zeichneSkala(char, int, QString);

 private:
  void schreibSatz();

  int kz,pen;
  int x1,x2,y1,y2;
  QString zeile;


  float mx, my;
  int kx,ky;
  int sx1,sx2,sy1,sy2;
  int vx,bx,vy,by;
  int dlx, dly;
  int fx, fy;
  QFile f1;
  QTextStream pic;
};

#endif















