/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include <kapplication.h>
#include <kimageio.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kiconloader.h>

#include "kgrabadaptor.h"
#include "kgrab.h"

#define KGRABVERSION "0.1.1"

static const char description[] = I18N_NOOP("KDE Screen Grabbing Utility");

int main(int argc, char **argv)
{
  KAboutData aboutData( "kgrab", 0, ki18n("KGrab"),
    KGRABVERSION, ki18n(description), KAboutData::License_GPL,
    ki18n("(c) 2006 Marcus Hufgard \n(c) 1997-2004, Richard J. Moore,\n(c) 2000, Matthias Ettrich,\n(c) 2002-2003 Aaron J. Seigo"));
  aboutData.addAuthor( ki18n("Marcus Hufgard"), ki18n("Maintainer"), "marcus.hufgard@hufgard.de" );
  aboutData.addAuthor( ki18n("Richard J. Moore"),ki18n("KSnapshot"), "rich@kde.org" );
  aboutData.addAuthor( ki18n("Matthias Ettrich"),ki18n("KSnapshot"), "ettrich@kde.org" );
  aboutData.addAuthor( ki18n("Aaron J. Seigo"), ki18n("KSnaphsot"), "aseigo@kde.org" );
  aboutData.addCredit( ki18n("Nadeem Hasan"), ki18n("On KSnapshot\nRegion Grabbing, Reworked GUI"), "nhasan@kde.org" );
  KCmdLineArgs::init( argc, argv, &aboutData );

  KCmdLineOptions options;
  options.add("c");
  options.add("current", ki18n("Captures the window under the mouse on startup (instead of the desktop)"));
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  KApplication app;

  // Create top level window
  KGrab *toplevel;

  if ( args->isSet( "current" ) )
     toplevel = new KGrab( 0, true );
  else
     toplevel = new KGrab();

  new KgrabAdaptor(toplevel);
  QDBusConnection::sessionBus().registerObject("/KGrab", toplevel);
  toplevel->show();
  return app.exec();
}
