#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# File name          :
# Author             :
# Date created       :
# Date last modified :
# Python Version     : 3.*

import binascii
import unittest
from dsinternals.common.data.DNWithBinary import DNWithBinary
from dsinternals.common.data.DNWithBinary import InvalidNumberOfPartsInRawDNWithBinary, InvalidBinaryDataLength, EmptyRawDNWithBinary


class TestCaseDNWithBinary(unittest.TestCase):

    def test_parse_good_data(self):
        data = b"B:828:00020000200001293CDE5195FE34E2D6D7E385AE8E36EC0883CE457613458D679726E3DD8864C92000024042781613BB48B19CBEB46CD2EDB49C9FBADB5A6185DB01D1CCBBD32CF8EE591B0103525341310008000003000000000100000000000000000000010001CB56D3816B78DC0DB5BA3A766FFDA0E35902A8BD92EE38BCCA85A29838D4ADDB00BA2138D3BB89091CAC112D3DAE845E8A4DC4209DAA1357812996A2252C29B419DEC0C9EA38376F97AC1AB337868D42A534B135322045CAE9C5239E092FCA893173C64EAC11D470D0D88699D37CEE0D37C5B808328F9CB9DF432D9CCEAFABA97D276096522E17A60AEDEA41844D2AF6AF73E89326298F7A87F877856297500B97B1432F7A05BAA534734673B7B53F682D7E6C08D45BACE97BDB0392E44AA1BBD04DB646C53835A9C9BC5D9DE1A7EB5856079573B57E2E8CE652254765D8FD2ED9FD419D45529C00D81B7EDDD4BD5B8FAF2EA202ED8D9058591C016BB4F3E1E501000401010005001000064BA1D5AD9EE59242864067D70B9E9DC70200070100080008D5AF88AE717ED701080009D5AF88AE717ED701:CN=user2,CN=Users,DC=domain,DC=local"
        dnb = DNWithBinary.fromRawDNWithBinary(data)
        self.assertEqual(dnb.DistinguishedName, b"CN=user2,CN=Users,DC=domain,DC=local")
        self.assertEqual(dnb.BinaryData, binascii.unhexlify("00020000200001293CDE5195FE34E2D6D7E385AE8E36EC0883CE457613458D679726E3DD8864C92000024042781613BB48B19CBEB46CD2EDB49C9FBADB5A6185DB01D1CCBBD32CF8EE591B0103525341310008000003000000000100000000000000000000010001CB56D3816B78DC0DB5BA3A766FFDA0E35902A8BD92EE38BCCA85A29838D4ADDB00BA2138D3BB89091CAC112D3DAE845E8A4DC4209DAA1357812996A2252C29B419DEC0C9EA38376F97AC1AB337868D42A534B135322045CAE9C5239E092FCA893173C64EAC11D470D0D88699D37CEE0D37C5B808328F9CB9DF432D9CCEAFABA97D276096522E17A60AEDEA41844D2AF6AF73E89326298F7A87F877856297500B97B1432F7A05BAA534734673B7B53F682D7E6C08D45BACE97BDB0392E44AA1BBD04DB646C53835A9C9BC5D9DE1A7EB5856079573B57E2E8CE652254765D8FD2ED9FD419D45529C00D81B7EDDD4BD5B8FAF2EA202ED8D9058591C016BB4F3E1E501000401010005001000064BA1D5AD9EE59242864067D70B9E9DC70200070100080008D5AF88AE717ED701080009D5AF88AE717ED701"))

    def test_error_parse_empty_data(self):
        data = b""
        self.assertRaises(EmptyRawDNWithBinary, DNWithBinary.fromRawDNWithBinary, data)

    def test_error_parse_not_4_parts_of_data(self):
        data = b"B:1234:Wow"
        self.assertRaises(InvalidNumberOfPartsInRawDNWithBinary, DNWithBinary.fromRawDNWithBinary, data)

    def test_error_parse_invalid_data_length(self):
        data = b"B:827:00020000200001293CDE5195FE34E2D6D7E385AE8E36EC0883CE457613458D679726E3DD8864C92000024042781613BB48B19CBEB46CD2EDB49C9FBADB5A6185DB01D1CCBBD32CF8EE591B0103525341310008000003000000000100000000000000000000010001CB56D3816B78DC0DB5BA3A766FFDA0E35902A8BD92EE38BCCA85A29838D4ADDB00BA2138D3BB89091CAC112D3DAE845E8A4DC4209DAA1357812996A2252C29B419DEC0C9EA38376F97AC1AB337868D42A534B135322045CAE9C5239E092FCA893173C64EAC11D470D0D88699D37CEE0D37C5B808328F9CB9DF432D9CCEAFABA97D276096522E17A60AEDEA41844D2AF6AF73E89326298F7A87F877856297500B97B1432F7A05BAA534734673B7B53F682D7E6C08D45BACE97BDB0392E44AA1BBD04DB646C53835A9C9BC5D9DE1A7EB5856079573B57E2E8CE652254765D8FD2ED9FD419D45529C00D81B7EDDD4BD5B8FAF2EA202ED8D9058591C016BB4F3E1E501000401010005001000064BA1D5AD9EE59242864067D70B9E9DC70200070100080008D5AF88AE717ED701080009D5AF88AE717ED701:CN=user2,CN=Users,DC=domain,DC=local"
        self.assertRaises(InvalidBinaryDataLength, DNWithBinary.fromRawDNWithBinary, data)

if __name__ == '__main__':
    unittest.main()
