/*
 * xfont - Entry of XFONT Program
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_PM
#include <os2.h>

#include "xfont.h"

UCHAR   XfdProgName[] = "xfont"     ;
UCHAR   XfdInitPath[MAXNAM] = { 0 } ;

LISTPTR XfdFontList = NULL  ;
SWP     XfdSwpInit = { 0 }  ;

/*
 * Path to Profile
 */

static  void    profilePath(PUCHAR me)
{
    PUCHAR  p ;
    APIRET  stat ;
    BOOL    lkup = TRUE ;
    UCHAR   exename[MAXNAM] ;
    
    for (p = me ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            lkup = FALSE ;
	}
    }
    if (lkup == FALSE) {
        strcpy(XfdInitPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, XfdInitPath, MAXNAM) != 0) {
        XfdInitPath[0] = '\0' ;
	return ;
    }
    if ((p = strrchr(XfdInitPath, '.')) == NULL) {
        strcat(XfdInitPath, ".ini") ;
    } else {
        strcpy(p, ".ini") ;
    }
}

/*
 * Save/Restore Window Position
 */

static  UCHAR   XfdInitPos[] = "xfont.pos" ;

void    positionRestore(HAB hab)
{
    HINI    hini ;
    SWP     swp  ;
    LONG    len  ;
    
    if (XfdInitPath[0] == '\0') {
        return ;
    }
    if ((hini = PrfOpenProfile(hab, XfdInitPath)) == NULLHANDLE) {
        return ;
    }
    
    memset(&swp, 0, (len = sizeof(swp))) ;
    PrfQueryProfileData(hini, XfdProgName, XfdInitPos, (PVOID) &swp, &len) ;
    
    if (swp.cx != 0 || swp.cy != 0 || swp.x != 0 || swp.y != 0) {
        XfdSwpInit.cx = swp.cx    ;
	XfdSwpInit.cy = swp.cy    ;
	XfdSwpInit.fl |= SWP_SIZE ;
        XfdSwpInit.x = swp.x      ;
	XfdSwpInit.y = swp.y      ;
	XfdSwpInit.fl |= SWP_MOVE ;
    }
    PrfCloseProfile(hini) ;
}

void    positionSave(HWND hwnd)
{
    HINI    hini ;
    SWP     swp  ;
    HAB     hab = WinQueryAnchorBlock(hwnd) ;
    LONG    len = sizeof(swp) ;
    
    if (XfdInitPath[0] == '\0') {
        return ;
    }
    if ((hini = PrfOpenProfile(hab, XfdInitPath)) == NULLHANDLE) {
        return ;
    }
    WinQueryWindowPos(hwnd, &swp) ;
    PrfWriteProfileData(hini, XfdProgName, XfdInitPos, (PVOID) &swp, len) ;
    PrfCloseProfile(hini) ;
}

/*
 * m a i n  -  Program Start Here
 */
 
int     main(int ac, char *av[])
{
    int     i    ;
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;
    HWND    hwndViewer ;
    
    hab = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0) ;

    memset(&XfdSwpInit, 0, sizeof(XfdSwpInit)) ;

    profilePath(av[0])   ;
    positionRestore(hab) ;
    
    /*
     * Expand Argument & Initialize Font List
     */

    if ((XfdFontList = initFontList()) == NULL) {
        printf("cannot create font list\n") ; fflush(stdout) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab)       ;
        return 1 ;
    }
    
    _wildcard(&ac, &av) ;
    
    for (i = 1 ; i < ac ; i++) {
        if (stricmp(av[i], "-w") == 0) {
	    if ((i + 1) < ac) {
	        XfdSwpInit.cx = atoi(av[i+=1]) ;
		XfdSwpInit.fl |= SWP_SIZE ;
            }
        } else if (stricmp(av[i], "-h") == 0) {
	    if ((i + 1) < ac) {
	        XfdSwpInit.cy = atoi(av[i+=1]) ;
		XfdSwpInit.fl |= SWP_SIZE ;
            }
        } else if (stricmp(av[i], "-x") == 0) {
	    if ((i + 1) < ac) {
	        XfdSwpInit.x = atoi(av[i+=1]) ;
		XfdSwpInit.fl |= SWP_MOVE ;
            }
        } else if (stricmp(av[i], "-y") == 0) {
	    if ((i + 1) < ac) {
	        XfdSwpInit.y = atoi(av[i+=1]) ;
		XfdSwpInit.fl |= SWP_MOVE ;
            }
        } else if (stricmp(av[i], "-r") == 0) {
            XfdSwpInit.fl = 0 ;
        } else {	
            putFontFile(XfdFontList, av[i]) ;
        }
    }

    /*
     * Start Window
     */
     
    if ((hwndViewer = initViewer(hab)) == NULLHANDLE) {
        printf("cannot create window\n") ; fflush(stdout) ;
        WinDestroyMsgQueue(hmq)   ;
        WinTerminate(hab)         ;
        freeFontList(XfdFontList) ;
        return 2 ;
    }
    
    while (WinGetMsg(hab, &qmsg, 0L, 0, 0)) {
        WinDispatchMsg(hab, &qmsg) ;
    }

    termViewer(hwndViewer)    ;
    WinDestroyMsgQueue(hmq)   ;
    WinTerminate(hab)         ;
    freeFontList(XfdFontList) ;
    
    return 0 ;
}
