



Jan 31, 1988                                               FIZ(1)



NAME
     fiz - analyze damaged zoo archive for data revovery

SYNOPSIS
     fiz archive[.zoo]

DESCRIPTION
     Fiz is used to analyze damaged zoo archives and locate
     directory entries and file data in them.  The current ver-
     sion of fiz is 2.0 and it is meant to be used in conjunction
     with zoo version 2.0.  Fiz makes no assumptions about
     archive structure.  Instead, it simply searches the entire
     subject archive for tag values that mark the locations of
     directory entries and file data.  In a zoo archive, a direc-
     tory entry contains information about a stored file such as
     its name, whether compressed or not, and its timestamp.  The
     file data are the actual data for the archived file, and may
     be either the original data, or the result of compressing
     the file.

     For each directory entry found, fiz prints where in the
     archive it is located, the directory path and filename(s)
     found in it, whether the directory entry appears to be cor-
     rupted (indicated by [*CRC Error*]), and the value of the
     pointer to the file data that is found in the directory
     entry.  For each block of file data found in the archive,
     fiz prints where in the archive the block begins.  In the
     case of an undamaged archive, the pointer to file data found
     in a directory entry will correspond to where fiz actually
     locates the data.  Here is some sample output from fiz:

     ****************
         2526: DIR  [changes] ==>   95
         2587: DATA
     ****************
         3909: DIR  [copyrite] ==> 1478
         3970: DATA
         4769: DATA
     ****************

     In such output, DIR indicates where fiz found a directory
     entry in the archive, and DATA indicates where fiz found
     file data in the archive.  Filenames located by fiz are
     enclosed in square brackets, and the notation "==>   95"
     indicates that the directory entry found by fiz at position
     2526 has a file data pointer to position 95.  In actuality,
     fiz found file data at positions 2587, 3970, and 4769.
     Since fiz found only two directory entries, and each direc-
     tory entry corresponds to one file, one of the file data
     positions is an artifact.

     Once the locations of directory entries and file data are
     found, the @ modifier to zoo's archive list and extract com-
     mands can be used and the archive contents selectively
     listed or extracted, skipping the damaged portion.  This is
     further described in the documentation for zoo(1).


     In the above case, commands to try giving to zoo might be
     x@2526,2587 (extract beginning at position 2526, and get
     file data from position 2587), x@3090,3970 (extract at 3090,
     get data from 3970) and x@3909,4769 (extract at 3909, get
     data from 4769).  Once a correctly-matched directory
     entry/file data pair is found, zoo will in most cases syn-
     chronize with and correctly extract all files subsequently
     found in the archive.  Trial and error should allow all
     undamaged files to be extracted.  Also note that self-
     extracting archives created using sez (the Self-Extracting
     Zoo utility for MS-DOS), which are normally executed on an
     MS-DOS system for extraction, can be extracted on non-MSDOS
     systems in a similar way.

SEE ALSO
     zoo(1)

BUGS
     Random byte patterns can occasionally be incorrectly recog-
     nized as tag values.  This occurs very rarely, however, and
     trial and error will usually permit all undamaged data to be
     extracted.

DIAGNOSTICS
     Fiz always exits with a status code of 0.

FUTURE DIRECTIONS
     Automation of data recovery from a damaged archive is poten-
     tially achievable.  However, since damaged archives occur
     only rarely, fiz as it currently stands is unlikely to
     change much in the near future.

AUTHOR
     Rahul Dhesi
