/* @(#) msc.c 1.2 91/07/14 16:08:54 */

#include <stdio.h>		/* to get fileno() */
#include <io.h>
#include <stdlib.h>
#include <signal.h>

#ifdef OS2
#define INCL_BASE
#include <os2.h>
#else
#include <dos.h>
#endif

void dosname PARMS((char *, char *));

/****************
function zootrunc() truncates a file at the current seek position.
*/

int zootrunc (f)
FILE *f;
{
	int handle = fileno(f);
	long pos = tell(handle);
	if (pos == -1) 
	  return -1;
	if (chsize(handle, pos) == -1)
	  return -1;
	return fseek(f, pos, SEEK_SET);
}

/****************
Function fixfname() converts the supplied filename to a syntax
legal for the host system.  It is used during extraction.
*/

char *fixfname(fname)
char *fname;
{
	char tmpname[PATHSIZE];
        if ( IsFileNameValid(fname) )
	  return(fname);
	dosname (nameptr(fname), tmpname);
	strcpy(fname,tmpname);
	return(fname);
}

void zooexit (int status)
{
	exit (status);
}

void spec_init(void)
{
	signal (SIGINT, zooexit);		/* install our own Control-C handler */
	signal (SIGBREAK, zooexit);		/* install our own Control-Break handler */
}
