/********************************************************/
/* zippy.cmd                                           */
/* Created in 1997                                      */
/* Author: Daniel Szmulewicz                            */
/* Purpose: Zip up whole directory trees, useful as a   */ 
/*          general purpose back-up tool.               */
/********************************************************/
signal on halt
begin = setlocal()
env = "OS2ENVIRONMENT"
if Rxfuncquery('SysLoadFuncs') \= 0 then
   rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
call SysLoadFuncs
Parse Source . . ThisProc
ThisDrive = filespec('D',ThisProc)
ThisDir  = filespec('P',ThisProc)
ThisProc = filespec('N',ThisProc)

/***general stuff***/
LowerCase = xrange('a','z')
UpperCase = xrange('A','Z')

/***color****/
'@ansi on 1>nul 2>&1'
redonblue = '1B'x || '[37;44m'
othergreen = '1B'x || '[46;43m'
whiteongreen = '1B'x || '[37;46m'
normal = '1B'x || '[0m'
bright = '1B'x || '[1m'

/*********Check that paths on the command line are valid, and gather info*************/

arg target source 

i = words(source)
source.0 = i 
if source = '' | target = '' | pos('\', source) = 0 | pos('\', target) = 0 | pos(':', target) = 0 | pos(':', source) = 0 then call help
do i = 1 to source.0
  source.i = strip(word(source, i))
  if length(source.i) > 3 & substr(source.i, length(source.i), 1) = '\' then source.i = left(source.i, length(source.i) -1)
  else if length(source.i) < 3 then call help  
    else nop 
  if pos('*', source.i) > 0 then do
      source.i.wildcard = substr(source.i, lastpos('\', source.i) + 1)
      source.i = left(source.i, lastpos('\', source.i) -1 )
    end
  else source.i.wildcard = 'X'
  rc = sysfiletree(source.i, file, DO)
  if file.0 = 0 then do 
    say 'can''t find 'source.i
    exit
  end
end

drop file.
target = strip(target)


rc = sysfiletree(target, file, DO)
if file.0 = 0 then do 
    say 'can''t find 'target
    exit
  end

targetdrive = filespec('D', target)
targetpath = right(target, length(target) - (pos(':', target) + 1))
targetroot = right(target, length(target) - lastpos("\", target)) 

do p= 1 to source.0
  if length(source.p) > 3 then do 
    sourcedrive.p = filespec('D', source)
    sourcepath.p = right(source.p, length(source.p) - (pos(':', source.p) + 1))
    sourceroot.p = right(source.p, length(source.p) - lastpos("\", source.p))  
  end
  else sourceroot.p = left(source.p, 1) || '__'
end

do i= 1 to source.0
  say 'source: 'source.i
end

say 'target: 'target
cur = directory()


if length(target) > 3 & substr(target, length(target), 1) <> '\' then target = target || '\' /*left(target, length(target) -1)*/
if stream(target || 'zippy.log', 'c', 'query exists') <> '' then rc = SysFileDelete(target || 'zippy.log')

logfile = target || 'zippy.log' 

do i = 1 to source.0
  if length(source.i) = 3 then source.i = left(source.i, 2)
  if source.i.wildcard = 'X' then do
        rc = Sysfiletree(source.i || '\*.*', source.i_files_in_root, 'F')
        rc = Sysfiletree(source.i || '\*.*', source.i_dir_in_root, 'D')
        say source.i_files_in_root.0' files in root of' source.i'.'  
        say source.i_dir_in_root.0' directories beneath' source.i'.'  
      end
  else do
        rc = Sysfiletree(source.i || '\' || source.i.wildcard, source.i.matchedfiles_in_root, 'F')
        rc = Sysfiletree(source.i || '\' || source.i.wildcard, source.i.matcheddirs_in_root, 'D')
        say source.i.matchedfiles_in_root.0' files in root of' source.i ' match the wildcard.'  
        say source.i.matcheddirs_in_root.0' directories beneath' source.i ' match the wildcard.'  
      end
  say
  if length(source.i) = 2 then source.i = source.i || '\'
end

/***search zip in current directory***/

/*    rc = Sysfiletree(cur || '\zip.exe', zipfile, 'F') 
      rc = Sysfiletree(cur || '\unzip.exe', unzipfile, 'F') 
      rc = Sysfiletree(cur || '\unzipsfx.exe', stubfile, 'F') 
      if zipfile.0 >= 1 & unzipfile.0 >= 1 & unzipsfx.0 >= 1 then 
        do
          say 'ok, zip executables located!'
          say
        end 
      else
*/

/*****search zip executables in path, otherwise exit***********/

zipflag = 0
stubflag = 0
unzipflag = 0
path = value('PATH',,env) 
if right(path,1) <> ';' then path = insert(';', path, length(path))
do while path <> ''
  pathone = left(path, pos(';',path) -1) 
  path = right(path, length(path) - pos(';',path))
  rc = Sysfiletree(pathone||'\zip.exe',zipfile,'F')
  rc = Sysfiletree(pathone||'\unzipsfx.exe',stubfile,'F')
  rc = Sysfiletree(pathone||'\unzip.exe',unzipfile,'F')
  if zipfile.0 > 0 then 
    do; call charout, 'locating zip.exe...' 
       zipflag = zipflag + 1 
    end
  if stubfile.0 > 0 then 
    do;  call charout, 'unzipsfx.exe...' 
        stubflag = stubflag + 1
    end 
  if unzipfile.0 > 0 then 
    do; call charout, 'unzip.exe...' 
        unzipflag = unzipflag + 1
    end 
  if stubflag >= 1 & zipflag >= 1 & unzipflag >= 1 then 
    do
      say 'ok, zip executables found!'
      say
      leave
    end
end

  if \(stubflag >= 1) | \(zipflag >= 1) | \(unzipflag >= 1) then 
    do
      say '...zip executables missing!'
      if \(zipflag >= 1) then say 'zip.exe is not in your path'
      if \(unzipflag >= 1) then say 'unzip.exe is not in your path'
      if \(stubflag >= 1) then say 'unzipsfx.exe is not in your path'
      exit
    end

/**********Main program***********/

do n = 1 to source.0
  new = directory(source.n)
  Select 
    when source.n.wildcard = 'X' then do
        call Ziponefile
      end
    Otherwise do
        if source.n.matcheddirs_in_root.0 <> 0 then call Zipmanyfiles
        if source.n.matchedfiles_in_root.0 <> 0 then call ZipRoot
     end
  End
end

say
say bright||'...all done'||normal
exit


Ziponefile:  
if length(source.n) = 3 then zipfile = 'drive' || left(source.n, 1)
else do
    zipfile = Reverse(source.n)
    parse var zipfile zipfile '\' .
    zipfile = translate(zipfile, lowercase, uppercase)
    zipfile = Reverse(zipfile)
    zipfile = stripblanks(zipfile)
    zipfile = stripdots(zipfile)
    if length(zipfile) > 8 then do
        zipfile = left(zipfile, 8)
      end  
end
call zippy zipfile, 'one'
return 

Zipmanyfiles:
flagthis = 0
if source.n.wildcard = 'X' then rc = sysfiletree(source.n'\*.*',
     'directories', 'DO')
else if length(source.n) > 3 then rc = sysfiletree(source.n || '\' || source.n.wildcard, 'directories', 'DO')
        else rc = sysfiletree(source.n || source.n.wildcard, 'directories', 'DO')
do p=1 to directories.0
  zipfile.p = directories.p
  zipfile.p = Reverse(zipfile.p)
  parse var zipfile.p zipfile.p '\' .
  zipfile = translate(zipfile, lowercase, uppercase)
  zipfile.p = Reverse(zipfile.p)
  zipfile.p = stripblanks(zipfile.p)
  zipfile.p = stripdots(zipfile.p)
  if length(zipfile.p) > 8 then
        do
          zipfiletemp = zipfile.p
          flagthis = flagthis + 1 
          do b=1 to (p-1)
             if left(zipfiletemp, 8) = left(zipfile.p, 8) then 
                zipfile.p = left(zipfiletemp, 6)  || flagthis
             else 
               zipfile.p = left(zipfiletemp, 8)
          end
       end
  call zippy zipfile.p, 'many'
end
return

ZipRoot:
parse value left(sourceroot.n, 3) with root
root = translate(root, lowercase, uppercase)
if souceroot.n > 3 then root = root || '_' || 'root'
else root = 'root'
if source.n.wildcard = 'X' then wildcard = '*.*'
else wildcards = source.n.wildcard
call zippy root, 'root', wildcards
return

zippy:
zipfile = arg(1)
flag = arg(2)
wildcards = arg(3)
say 'zipping' zipfile || '.zip on' left(target, length(target) - 1)
if flag = 'one' then '@ZIP -r -q 'target || zipfile ||'.zip *.*'     
if flag = 'many' then '@ZIP -r -q 'target || zipfile ||'.zip' '"' || right(directories.p, length(directories.p) - lastpos("\", directories.p)) || '"'     
if flag = 'root' then '@Zip -q -j 'target || zipfile || '.zip' wildcards     
if rc <> 0 & rc <> 18 then call error
else do
    say 'appending self-executable stub to' zipfile || '.zip'
    '@copy /b 'pathone || '\UNZIPSFX.EXE + 'target || zipfile||'.zip' target || zipfile||'.exe 1>nul'
    say 'adjusting headers for' zipfile || '.exe'
    '@ZIP -A 'target || zipfile||'.exe 1>nul 2>&1'
    if rc <> 0 then call error
    say 'testing integrity of 'zipfile || '.exe'
    '@ZIP -T 'target || zipfile||'.exe >>'target || 'zippy.log 2>&1'
    if rc <> 0 then call error
  end
if rc <> 12 then rc = Sysfiledelete(target || zipfile||'.zip')
if rc <> 0 then say 'error: could not delete 'zipfile
say
return

Stripblanks:
zipfile = arg(1)
do forever 
  if pos(" ", zipfile) > 0 then 
    do
      zipfile = overlay('_', zipfile, pos(" ", zipfile))
      call Stripblanks(zipfile)
    end
  else leave
end
return zipfile

Stripdots:
zipfile = arg(1)
do forever 
  if pos(".", zipfile) > 0 then 
    do
      zipfile = overlay('_', zipfile, pos(".", zipfile))
      call Stripblanks(zipfile)
    end
  else leave
end
return zipfile

help:
say whiteongreen'     Usage:'normal
say ''
say '     zippy <target> <src1> <src2> <src3> ... '
say ''
say whiteongreen'     Where:'normal
say '       '
say '     <src(n)> and <target> are expressed in absolute paths.'
say '     '
say '     'bright||'Note:'||normal' zip files are automatically converted to self-extractable (*.exe).' 
say
say whiteongreen'     Example:'normal
say ''
say '         zippy d:\archives c:\os2 d:\programs\* e:\data\misc\t*.r* '
say '           '
say whiteongreen'     Meaning:'normal
say '       Create the following files on d:\archives:'
say '         -os2.exe: complete directory tree beneath c:\os2'
say '         -subdirectories of d:\programs as separate zipfiles'
say '         -subdirectories of e:\data\misc that match' 
say '          the wildcard ''t*.r*'', as separate zipfiles'
exit

/*Installcmd:
if stream(zipplace'install.cmd', C, query exists) <> '' then
        do
        say 'Replace existing install.cmd?'
        pull answer
        if abbrev(answer, 'Y') then
           call sysfiledelete zipplace'install.cmd'
        else return
        end
file = zipplace'install.cmd'
do j=1 to file.0
        call lineout file, rname.j' -o'
end /* do */
call lineout file
return
*/
error:
Select 
  when rc = 9 then do
    say "interrupted by user... zippy terminated..."
    call lineout logfile,  "interrupted by user... zippy terminated..."
    exit
  end
  when rc = 12 then do
      call lineout logfile, zipfile 'deleted'
      return   
    end
  otherwise do 
    say 'zip error, rc =' rc
    say 'zippy got error from zip.exe, archives won''t be complete...'
    call lineout logfile,  rc 'rc error: check archive'
    return
  end
end

halt:
say 'interrupted by user... exiting'
exit
