{ Old-style EXE header
}
  TExeHeader = record
    Signature: Word;
    LastCount: Word;
    PageCount: Word;
    ReloCount: Word;
    eHdrSize:   Word;
    eMinAbove:  Word;
    eMaxAbove:  Word;
    eInitSS:    Word;
    eInitSP:    Word;
    eCheckSum:  Word;
    eInitPC:    Word;
    eInitCS:    Word;
    eRelocOfs:  Word;
    eOvlyNum:   Word;
    eRelocTab:  Word;
    eSpace:     array[1..30] of Byte;
    eNewHeader: Word;
  end;

{ New-Style EXE header
}
  TWinHeader = record
    Signature: Word;
    LinkerVer: Word;
    EntryOffs: Word;
    EntrySize: Word;
    ReservedA: array[0..3] of Byte;
    LinkerFlags: Word;
    nDataSeg: Word;
    LocalHeapSize: Word;
    StackSize: Word;
    CSIP: pointer;
    SSSP: pointer;
    nSegEntries: Word;
    nModRefEntries: Word;
    nNonResNameBytes: Word;
    SegTbl: Word;			{ offsets from Win header }
    ResourceTbl: Word;
    ResNameTbl: Word;
    ModRefTbl: Word;
    ImpNameTbl: Word;
    NonResNameTbl: LongInt;		{ offset from top }
    nMovableEntryPoints: Word;
    ShiftCount: Word;
    nResourceSegs: Word;
    OS: Byte;
    Extra: Byte;
    ReservedB: array[0..7] of Byte;
  End;

Format of EXEC parameter block for AL=00h,01h,04h:
Offset  Size    Description     (Table 0897)
 00h    WORD    segment of environment to copy for child process (copy caller's
                  environment if 0000h)
 02h    DWORD   pointer to command tail to be copied into child's PSP
 06h    DWORD   pointer to first FCB to be copied into child's PSP
 0Ah    DWORD   pointer to second FCB to be copied into child's PSP
 0Eh    DWORD   (AL=01h) will hold subprogram's initial SS:SP on return
 12h    DWORD   (AL=01h) will hold entry point (CS:IP) on return
SeeAlso: #0898,#0899

Format of EXEC parameter block for AL=03h:
Offset  Size    Description     (Table 0898)
 00h    WORD    segment at which to load overlay
 02h    WORD    relocation factor to apply to overlay if in .EXE format
SeeAlso: #0897,#0899

Format of EXEC parameter block for FlashTek X-32:
Offset  Size    Description     (Table 0899)
 00h    PWORD   48-bit far pointer to environment string
 06h    PWORD   48-bit far pointer to command tail string
SeeAlso: #0897,#0898

(Table 0900)
Values for the executable types understood by various environments:
 MZ     old-style DOS executable (see #0901)
 NE     Windows or OS/2 1.x segmented ("new") executable (see #0903)
 LE     Windows virtual device driver (VxD) linear executable (see #0916)
 LX     variant of LE used in OS/2 2.x (see #0916)
 W3     Windows WIN386.EXE file; a collection of LE files
 PE     Win32 (Windows NT and Win32s) portable executable based on Unix COFF
 DL     HP 100LX/200LX system manager compliant executable (.EXM)
 MP     old PharLap .EXP (see #0926)
 P2     PharLap 286 .EXP (see #0927)
 P3     PharLap 386 .EXP (see #0927)

Format of .EXE file header:
Offset  Size    Description     (Table 0901)
 00h  2 BYTEs   .EXE signature, either "MZ" or "ZM" (5A4Dh or 4D5Ah)
                  (see also #0900)
 02h    WORD    number of bytes in last 512-byte page of executable
 04h    WORD    total number of 512-byte pages in executable (includes any
                partial last page)
 06h    WORD    number of relocation entries
 08h    WORD    header size in paragraphs
 0Ah    WORD    minimum paragraphs of memory required to allocate in addition
                  to executable's size
 0Ch    WORD    maximum paragraphs to allocate in addition to executable's size
 0Eh    WORD    initial SS relative to start of executable
 10h    WORD    initial SP
 12h    WORD    checksum (one's complement of sum of all words in executable)
 14h    DWORD   initial CS:IP relative to start of executable
 18h    WORD    offset within header of relocation table
                40h or greater for new-format (NE,LE,LX,W3,PE,etc.) executable
 1Ah    WORD    overlay number (normally 0000h = main program)
---new executable---
 1Ch  4 BYTEs   ???
 20h    WORD    behavior bits
 22h 26 BYTEs   reserved for additional behavior info
 3Ch    DWORD   offset of new executable (NE,LE,etc) header within disk file,
                or 00000000h if plain MZ executable
---Borland TLINK---
 1Ch  2 BYTEs   ??? (apparently always 01h 00h)
 1Eh    BYTE    signature FBh
 1Fh    BYTE    TLINK version (major in high nybble, minor in low nybble)
 20h  2 BYTEs   ??? (v2.0 apparently always 72h 6Ah, v3.0+ seems always 6Ah 72h)
---ARJ self-extracting archive---
 1Ch  4 BYTEs   signature "RJSX" (older versions, new signature is "aRJsfX" in
                the first 1000 bytes of the file)
---LZEXE 0.90 compressed executable---
 1Ch  4 BYTEs   signature "LZ09"
---LZEXE 0.91 compressed executable---
 1Ch  4 BYTEs   signature "LZ91"
---PKLITE compressed executable---
 1Ch    BYTE    minor version number
 1Dh    BYTE    bits 0-3: major version
                bit 4: extra compression
                bit 5: huge (multi-segment) file
 1Eh  6 BYTEs   signature "PKLITE" (followed by copyright message)
---LHarc 1.x self-extracting archive---
 1Ch  4 BYTEs   unused???
 20h  3 BYTEs   jump to start of extraction code
 23h  2 BYTEs   ???
 25h 12 BYTEs   signature "LHarc's SFX "
---LHA 2.x self-extracting archive---
 1Ch  8 BYTEs   ???
 24h 10 BYTEs   signature "LHa's SFX " (v2.10) or "LHA's SFX " (v2.13)
---TopSpeed C 3.0 CRUNCH compressed file---
 1Ch    DWORD   018A0001h
 20h    WORD    1565h
---PKARCK 3.5 self-extracting archive---
 1Ch    DWORD   00020001h
 20h    WORD    0700h
---BSA (Soviet archiver) self-extracting archive---
 1Ch    WORD    000Fh
 1Eh    BYTE    A7h
---LARC self-extracting archive---
 1Ch  4 BYTEs   ???
 20h 11 BYTEs   "SFX by LARC "
---LH self-extracting archive---
 1Ch  8 BYTEs   ???
 24h  8 BYTEs   "LH's SFX "
---other linkers---
 1Ch    var     optional information
---
  N   N DWORDs  relocation items
Notes:  if word at offset 02h is 4, it should be treated as 00h, since pre-1.10
          versions of the MS linker set it that way
        if both minimum and maximum allocation (offset 0Ah/0Ch) are zero, the
          program is loaded as high in memory as possible (DOS only checks
          the maximum allocation, however)
        the maximum allocation is set to FFFFh by default
        additional data may be contained in the file beyond the end of the
          load image described by the .EXE header; this data may be overlays,
          the actual executable for newer-format executables, or debugging
          information (see #0907,#0931)
SeeAlso: #0903

Format of ROM Module Header:
Offset  Size    Description     (Table 0902)
 00h  2 BYTEs   ROM signature 55h, AAh
 02h    BYTE    size of ROM in 512-byte blocks
 03h  3 BYTEs   POST initialization entry point (near JMP instruction)
 06h    ROM Program Name List [array]
        Offset  Size    Description
         00h    BYTE    length of ROM program's name (00h if end of name list)
         01h  N BYTEs   program name
         N+1  3 BYTEs   program entry point (near JMP instruction)

Format of new executable header:
Offset  Size    Description     (Table 0903)
 00h  2 BYTEs   "NE" (4Eh 45h) signature
 02h  2 BYTEs   linker version (major, then minor)
 04h    WORD    offset from start of this header to entry table (see #0910)
 06h    WORD    length of entry table in bytes
 08h    DWORD   file load CRC (0 in Borland's TPW)
 0Ch    BYTE    program flags (see #0904)
 0Dh    BYTE    application flags (see #0905)
 0Eh    WORD    auto data segment index
 10h    WORD    initial local heap size
 12h    WORD    initial stack size (added to data seg, 0000h if SS <> DS)
 14h    DWORD   program entry point (CS:IP), "CS" is index into segment table
 18h    DWORD   initial stack pointer (SS:SP), "SS" is segment index
                if SS=automatic data segment and SP=0000h, the stack pointer is
                  set to the top of the automatic data segment, just below the
                  local heap
 1Ch    WORD    segment count
 1Eh    WORD    module reference count
 20h    WORD    length of nonresident names table in bytes
 22h    WORD    offset from start of this header to segment table (see #0908)
 24h    WORD    offset from start of this header to resource table
 26h    WORD    offset from start of this header to resident names table
 28h    WORD    offset from start of this header to module reference table
 2Ah    WORD    offset from start of this header to imported names table
                (array of counted strings, terminated with a string of length
                  00h)
 2Ch    DWORD   offset from start of file to nonresident names table
 30h    WORD    count of moveable entry point listed in entry table
 32h    WORD    file alignment size shift count
                0 is equivalent to 9 (default 512-byte pages)
 34h    WORD    number of resource table entries
 36h    BYTE    target operating system
                00h unknown
                01h OS/2
                02h Windows
                03h European MS-DOS 4.x
                04h Windows 386
                05h BOSS (Borland Operating System Services)
                81h PharLap 286|DOS-Extender, OS/2
                82h PharLap 286|DOS-Extender, Windows
 37h    BYTE    other EXE flags (see #0906)
 38h    WORD    offset to return thunks or start of gangload area
 3Ah    WORD    offset to segment reference thunks or length of gangload area
 3Ch    WORD    minimum code swap area size
 3Eh  2 BYTEs   expected Windows version (minor version first)
Note:   this header is documented in detail in the Windows 3.1 SDK Programmer's
          Reference, Vol 4.
SeeAlso: #0901

Bitfields for new executable program flags:
Bit(s)  Description     (Table 0904)
 0-1    DGROUP type
          0 = none
          1 = single shared
          2 = multiple (unshared)
          3 = (null)
 2      global initialization
 3      protected mode only
 4      8086 instructions
 5      80286 instructions
 6      80386 instructions
 7      80x87 instructions

Bitfields for new executable application flags:
Bit(s)  Description     (Table 0905)
 0-2    application type
        001 full screen (not aware of Windows/P.M. API)
        010 compatible with Windows/P.M. API
        011 uses Windows/P.M. API
 3      is a Family Application (OS/2)
 5      0=executable, 1=errors in image
 6      non-conforming program (valid stack is not maintained)
 7      DLL or driver rather than application
        (SS:SP info invalid, CS:IP points at FAR init routine called with
          AX=module handle which returns AX=0000h on failure, AX nonzero on
          successful initialization)

Bitfields for other new .EXE flags:
Bit(s)  Description     (Table 0906)
 0      supports long filenames
 1      2.X protected mode
 2      2.X proportional font
 3      gangload area

Format of Codeview trailer (at end of executable):
Offset  Size    Description     (Table 0907)
 00h    WORD    signature 4E42h ('NB')
 02h    WORD    Microsoft debug info version number
 04h    DWORD   Codeview header offset
SeeAlso: #0931

Format of new executable segment table record:
Offset  Size    Description     (Table 0908)
 00h    WORD    offset in file (shift left by alignment shift to get byte offs)
 02h    WORD    length of image in file (0000h = 64K)
 04h    WORD    segment attributes (see #0909)
 06h    WORD    number of bytes to allocate for segment (0000h = 64K)
Note:   the first segment table entry is entry number 1
SeeAlso: #0911

Bitfields for segment attributes:
Bit(s)  Description     (Table 0909)
 0      data segment rather than code segment
 1      unused???
 2      real mode
 3      iterated
 4      movable
 5      sharable
 6      preloaded rather than demand-loaded
 7      execute-only (code) or read-only (data)
 8      relocations (directly following code for this segment)
 9      debug info present
 10,11  80286 DPL bits
 12     discardable
 13-15  discard priority

Format of new executable entry table item (list):
Offset  Size    Description     (Table 0910)
 00h    BYTE    number of entry points (00h if end of entry table list)
 01h    BYTE    segment number (00h if end of entry table list)
 02h 3N BYTEs   entry records
                Offset  Size    Description
                 00h    BYTE    flags
                                bit 0: exported
                                bit 1: single data
                                bits 2-7: unused???
                 01h    WORD    offset within segment

Format of new executable relocation data (immediately follows segment image):
Offset  Size    Description     (Table 0911)
 00h    WORD    number of relocation items
 02h 8N BYTEs   relocation items
                Offset  Size    Description
                 00h    BYTE    relocation type
                                00h LOBYTE
                                02h BASE
                                03h PTR
                                05h OFFS
                                0Bh PTR48
                                0Dh OFFS32
                 01h    BYTE    flags
                                bit 2: additive
                 02h    WORD    offset within segment
                 04h    WORD    target address segment
                 06h    WORD    target address offset
SeeAlso: #0908,#0912

Format of new executable resource data:
Offset  Size    Description     (Table 0912)
 00h    WORD    alignment shift count for resource data
 02h  N RECORDs resources
        Format of resource record:
        Offset  Size    Description
         00h    WORD    type ID
                        0000h if end of resource records
                        >= 8000h if integer type
                        else offset from start of resource table to type string
         02h    WORD    number of resources of this type
         04h    DWORD   reserved for runtime use
         08h  N Resources (see #0913)
Note:   resource type and name strings are stored immediately following the
          resource table, and are not null-terminated
SeeAlso: #0913

Format of new executable resource entry:
Offset  Size    Description     (Table 0913)
 00h    WORD    offset in alignment units from start of file to contents of
                the resource data
 02h    WORD    length of resource image in bytes
 04h    WORD    flags
                bit 4: moveable
                bit 5: shareable
                bit 6: preloaded
 06h    WORD    resource ID
                >= 8000h if integer resource
                else offset from start of resource table to resource string
 08h    DWORD   reserved for runtime use
Notes:  resource type and name strings are stored immediately following the
          resource table, and are not null-terminated
        strings are counted strings, with a string of length 0 indicating the
          end of the resource table
SeeAlso: #0912,#0914

Format of new executable module reference table [one bundle of entries]:
Offset  Size    Description     (Table 0914)
 00h    BYTE    number of records in this bundle (00h if end of table)
 01h    BYTE    segment indicator
                00h unused
                FFh movable segment, segment number is in entry
                else segment number of fixed segment
 02h  N RECORDs
        Format of segment record
        Offset  Size    Description
         00h    BYTE    flags
                        bit 0: entry is exported
                        bit 1: entry uses global (shared) data
                        bits 7-3: number of parameter words
        ---fixed segment---
         01h    WORD    offset
        ---moveable segment---
         01h  2 BYTEs   INT 3F instruction (CDh 3Fh)
         03h    BYTE    segment number
         05h    WORD    offset
Note:   table entries are numbered starting from 1
SeeAlso: #0915

Format of new executable resident/nonresident name table entry:
Offset  Size    Description     (Table 0915)
 00h    BYTE    length of string (00h if end of table)
 01h  N BYTEs   ASCII text of string
 N+1    WORD    ordinal number (index into entry table)
Notes:  the first string in the resident name table is the module name; the
          first entry in the nonresident name table is the module description
        the strings are case-sensitive; if the executable was linked with
          /IGNORECASE, all strings are in uppercase
SeeAlso: #0914

Format of Linear Executable (enhanced mode executable) header:
Offset  Size    Description     (Table 0916)
 00h  2 BYTEs   "LE" (4Ch 45h) signature (Windows)
                "LX" (4Ch 58h) signature (OS/2)
 02h    BYTE    byte order (00h = little-endian, nonzero = big-endian)
 03h    BYTE    word order (00h = little-endian, nonzero = big-endian)
 04h    DWORD   executable format level
 08h    WORD    CPU type (see also INT 15/AH=C9h)
                01h Intel 80286 or upwardly compatible
                02h Intel 80386 or upwardly compatible
                03h Intel 80486 or upwardly compatible
                04h Intel Pentium (80586) or upwardly compatible
                20h Intel i860 (N10) or compatible
                21h Intel "N11" or compatible
                40h MIPS Mark I (R2000, R3000) or compatible
                41h MIPS Mark II (R6000) or compatible
                42h MIPS Mark III (R4000) or compatible
 0Ah    WORD    target operating system
                01h OS/2
                02h Windows
                03h European DOS 4.0
                04h Windows 386
 0Ch    DWORD   module version
 10h    DWORD   module type (see #0917)
 14h    DWORD   number of memory pages
 18h    Initial CS:EIP
        DWORD   object number
        DWORD   offset
 20h    Initial SS:ESP
        DWORD   object number
        DWORD   offset
 28h    DWORD   memory page size
 2Ch    DWORD   (Windows LE) bytes on last page
                (OS/2 LX) page offset shift count
 30h    DWORD   fixup section size
 34h    DWORD   fixup section checksum
 38h    DWORD   loader section size
 3Ch    DWORD   loader section checksum
 40h    DWORD   offset of object table (see #0918)
 44h    DWORD   object table entries
 48h    DWORD   object page map table offset (see #0920)
 4Ch    DWORD   object iterate data map offset
 50h    DWORD   resource table offset
 54h    DWORD   resource table entries
 58h    DWORD   resident names table offset (see #0921)
 5Ch    DWORD   entry table offset (see #0922,#0923)
 60h    DWORD   module directives table offset
 64h    DWORD   Module Directives entries
 68h    DWORD   Fixup page table offset
 6Ch    DWORD   Fixup record table offset (see #0925)
 70h    DWORD   imported modules name table offset
 74h    DWORD   imported modules count
 78h    DWORD   imported procedures name table offset
 7Ch    DWORD   per-page checksum table offset
 80h    DWORD   data pages offset
 84h    DWORD   preload page count
 88h    DWORD   non-resident names table offset
 8Ch    DWORD   non-resident names table length
 90h    DWORD   non-resident names checksum
 94h    DWORD   automatic data object
 98h    DWORD   debug information offset
 9Ch    DWORD   debug information length
 A0h    DWORD   preload instance pages number
 A4h    DWORD   demand instance pages number
 A8h    DWORD   extra heap allocation
 ACh 12 BYTEs   reserved
 B8h    DWORD   offset of VERSIONINFO resource (MS-Windows VxD only)
 BCh    DWORD   pointer to ??? (dynamically-loadable VxDs only???)
 C0h    WORD    device ID (MS-Windows VxD only)
 C2h    WORD    DDK version (MS-Windows VxD only)
Note:   used by EMM386.EXE, QEMM, and Windows 3.0 Enhanced Mode drivers

Bitfields for Linear Executable module type:
Bit(s)  Description     (Table 0917)
 2      initialization (only for DLLs) 0 = global, 1 = per-process
 4      no internal fixups in executable image
 5      no external fixups in executable image
 8-10   API compatibility
        0 = unknown
        1 = incompatible with PM windowing \
        2 = compatible with PM windowing    > (only for
        3 = uses PM windowing API          /    programs)
 13     module not loadable (only for programs)
 15-17  module type
        000 program
        001 library (DLL)
        011 protected memory library module
        100 physical device driver
        110 virtual device driver
 30     per-process library termination
        (requires valid CS:EIP, can't be set for .EXE)

Format of object table entry:
Offset  Size    Description     (Table 0918)
 00h    DWORD   virtual size in bytes
 04h    DWORD   relocation base address
 08h    DWORD   object flags (see #0919)
 0Ch    DWORD   page map index
 10h    DWORD   page map entries (see #0920)
 14h  4 BYTEs   reserved??? (apparently always zeros)

Bitfields for object flags:
Bit(s)  Description     (Table 0919)
 0      readable
 1      writable
 2      executable
 3      resource
 4      discardable
 5      shared
 6      preloaded
 7      invalid
 8-9    type
        00 normal
        01 zero-filled
        10 resident
        11 resident and contiguous
 10     resident and long-lockable
 11     reserved
 12     16:16 alias required
 13     "BIG" (Huge: 32-bit)
 14     conforming
 15     "OBJECT_I/O_PRIVILEGE_LEVEL"
 16-31  reserved

Format of object page map table entry:
Offset  Size    Description     (Table 0920)
 00h    BYTE    ??? (usually 00h)
 01h    WORD    (big-endian) index to fixup table
                0000h if no relocation info
 03h    BYTE    type (00h hard copy in file, 03h some relocation needed)

Format of resident names table entry:
Offset  Size    Description     (Table 0921)
 00h    BYTE    length of name
 01h  N BYTEs   name
 N+1  3 BYTEs   ???

Format of LE linear executable entry table:
Offset  Size    Description     (Table 0922)
 00h    BYTE    number of entries in table
 01h 10 BYTEs per entry
                Offset  Size    Description
                 00h    BYTE    bit flags
                                bit 0: non-empty bundle
                                bit 1: 32-bit entry
                 01h    WORD    object number
                 03h    BYTE    entry type flags
                                bit 0: exported
                                bit 1: uses single data rather than instance
                                bit 2: reserved
                                bits 3-7: number of stack parameters
                 04h    DWORD   offset of entry point
                 08h  2 BYTEs   ???
Note:   empty bundles (bit flags at 00h = 00h) are used to skip unused indices,
          and do not contain the remaining nine bytes

Format of LX linear executable entry table [array]:
Offset  Size    Description     (Table 0923)
 00h    BYTE    number of bundles following (00h = end of entry table)
 01h    BYTE    bundle type
                00h empty
                01h 16-bit entry
                02h 286 callgate entry
                03h 32-bit entry
                04h forwarder entry
                bit 7 set if additional parameter typing information is present
---bundle type 00h---
 no additional fields
---bundle type 01h---
 02h    WORD    object number
 04h    BYTE    entry flags
                bit 0: exported
                bits 7-3: number of stack parameters
 05h    WORD    offset of entry point in object (shifted by page size shift)
---bundle type 02h---
 02h    WORD    object number
 04h    BYTE    entry flags
                bit 0: exported
                bits 7-3: number of stack parameters
 05h    WORD    offset of entry point in object
 07h    WORD    reserved for callgate selector (used by loader)
---bundle type 03h---
 02h    WORD    object number
 04h    BYTE    entry flags
                bit 0: exported
                bits 7-3: number of stack parameters
 05h    DWORD   offset of entry point in object
---bundle type 04h---
 02h    WORD    reserved
 04h    BYTE    forwarder flags
                bit 0: import by ordinal
                bits 7-1 reserved
 05h    WORD    module ordinal
                (forwarder's index into Import Module Name table)
 07h    DWORD   procedure name offset or import ordinal number
Note:   all fields after the first two bytes are repeated N times

Bitfields for linear executable fixup type:
Bit(s)  Description     (Table 0924)
 7      ordinal is BYTE rather than WORD
 6      16-rather than 8-object number/module ordinal
 5      addition with DWORD rather than WORD
 4      relocation info has size with new two bytes at end
 3      reserved (0)
 2      set if add to destination, clear to replace destination
 1-0    type
        00 internal fixup
        01 external fixup, imported by ordinal
        10 external fixup, imported by name
        11 internal fixup via entry table

Format of linear executable fixup record:
Offset  Size    Description     (Table 0925)
 00h    BYTE    type
                bits 7-4: modifier (0001 single, 0011 multiple)
                bits 3-0: type
                        0000 byte offset
                        0010 word segment
                        0011 16-bit far pointer (DWORD)
                        0101 16-bit offset
                        0110 32-bit far pointer (PWORD)
                        0111 32-bit offset
                        1000 near call or jump, WORD/DWORD based on seg attrib
 01h    BYTE    linear executable fixup type (see #0924)
---if single type---
 02h    WORD    offset within page
 04h    relocation information
        ---internal fixup---
        BYTE    object number
        ---external,ordinal---
        BYTE    one-based module number in Import Module table
        BYTE/WORD ordinal number
        WORD/DWORD value to add (only present if modifier bit 4 set)
        ---external,name---
        BYTE    one-based module number in Import Module table
        WORD    offset in Import Procedure names
        WORD/DWORD value to add (only present if modifier bit 4 set)
---if multiple type---
 02h    BYTE    number of items
 03h    var     relocation info as for "single" type (see above)
      N WORDs   offsets of items to relocate

Format of old Phar Lap .EXP file header:
Offset  Size    Description     (Table 0926)
 00h  2 BYTEs   "MP" (4Dh 50h) signature
 02h    WORD    remainder of image size / page size (page size = 512h)
 04h    WORD    size of image in pages
 06h    WORD    number of relocation items
 08h    WORD    header size in paragraphs
 0Ah    WORD    minimum number of extra 4K pages to be allocated at the end
                  of program, when it is loaded
 0Ch    WORD    maximum number of extra 4K pages to be allocated at the end
                  of program, when it is loaded
 0Eh    DWORD   initial ESP
 12h    WORD    word checksum of file
 14h    DWORD   initial EIP
 18h    WORD    offset of first relocation item
 1Ah    WORD    overlay number
 1Ch    WORD    ??? (wants to be 1)
SeeAlso: #0927

Format of new Phar Lap .EXP file header:
Offset  Size    Description     (Table 0927)
 00h  2 BYTEs   signature ("P2" for 286 .EXP executable, "P3" for 386 .EXP)
 02h    WORD    level (01h flat-model file, 02h multisegmented file)
 04h    WORD    header size
 06h    DWORD   file size in bytes
 0Ah    WORD    checksum
 0Ch    DWORD   offset of run-time parameters within file (see #0929)
 10h    DWORD   size of run-time parameters in bytes
 14h    DWORD   offset of relocation table within file
 18h    DWORD   size of relocation table in bytes
 1Ch    DWORD   offset of segment information table within file (see #0928)
 20h    DWORD   size of segment information table in bytes
 24h    WORD    size of segment information table entry in bytes
 26h    DWORD   offset of load image within file
 2Ah    DWORD   size of load image on disk
 2Eh    DWORD   offset of symbol table within file or 00000000h
 32h    DWORD   size of symbol table in bytes
 36h    DWORD   offset of GDT within load image
 3Ah    DWORD   size of GDT in bytes
 3Eh    DWORD   offset of LDT within load image
 42h    DWORD   size of LDT in bytes
 46h    DWORD   offset of IDT within load image
 4Ah    DWORD   size of IDT in bytes
 4Eh    DWORD   offset of TSS within load image
 52h    DWORD   size of TSS in bytes
 56h    DWORD   minimum number of extra bytes to be allocated at end of program
                (level 1 executables only)
 5Ah    DWORD   maximum number of extra bytes to be allocated at end of program
                (level 1 executables only)
 5Eh    DWORD   base load offset (level 1 executables only)
 62h    DWORD   initial ESP
 66h    WORD    initial SS
 68h    DWORD   initial EIP
 6Ch    WORD    initial CS
 6Eh    WORD    initial LDT
 70h    WORD    initial TSS
 72h    WORD    flags
                bit 0: load image is packed
                bit 1: 32-bit checksum is present
                bits 4-2: type of relocation table
 74h    DWORD   memory requirements for load image
 78h    DWORD   32-bit checksum (optional)
 7Ch    DWORD   size of stack segment in bytes
 80h 256 BYTEs  reserved (0)
SeeAlso: #0926,#0930

Format of Phar Lap segment information table entry:
Offset  Size    Description     (Table 0928)
 00h    WORD    selector number
 02h    WORD    flags
 04h    DWORD   base offset of selector
 08h    DWORD   minimum number of extra bytes to be allocated to the segment

Format of 386|DOS-Extender run-time parameters:
Offset  Size    Description     (Table 0929)
 00h  2 BYTEs   signature "DX" (44h 58h)
 02h    WORD    minimum number of real-mode params to leave free at run time
 04h    WORD    maximum number of real-mode params to leave free at run time
 06h    WORD    minimum interrupt buffer size in KB
 08h    WORD    maximum interrupt buffer size in KB
 0Ah    WORD    number of interrupt stacks
 0Ch    WORD    size in KB of each interrupt stack
 0Eh    DWORD   offset of byte past end of real-mode code and data
 12h    WORD    size in KB of call buffers
 14h    WORD    flags
                bit 0: file is virtual memory manager
                bit 1: file is a debugger
 16h    WORD    unprivileged flag (if nonzero, executes at ring 1, 2, or 3)
 18h 104 BYTEs  reserved (0)

Format of Phar Lap repeat block header:
Offset  Size    Description     (Table 0930)
 00h    WORD    byte count
 02h    BYTE    repeat string length

Format of Borland debugging information header (following load image):
Offset  Size    Description     (Table 0931)
 00h    WORD    signature 52FBh
 02h    WORD    version ID
 04h    DWORD   size of name pool in bytes
 08h    WORD    number of names in name pool
 0Ah    WORD    number of type entries
 0Ch    WORD    number of structure members
 0Eh    WORD    number of symbols
 10h    WORD    number of global symbols
 12h    WORD    number of modules
 14h    WORD    number of locals (optional)
 16h    WORD    number of scopes in table
 18h    WORD    number of line-number entries
 1Ah    WORD    number of include files
 1Ch    WORD    number of segment records
 1Eh    WORD    number of segment/file correlations
 20h    DWORD   size of load image after removing uninitialized data and debug
                  information
 24h    DWORD   debugger hook; pointer into debugged program whose meaning
                  depends on program flags
 28h    BYTE    program flags
                bit 0: case-sensitive link
                bit 1: pascal overlay program
 29h    WORD    no longer used
 2Bh    WORD    size of data pool in bytes
 2Dh    BYTE    padding
 2Eh    WORD    size of following header extension (currently 00h, 10h, or 20h)
 30h    WORD    number of classes
 32h    WORD    number of parents
 34h    WORD    number of global classes (currently unused)
 36h    WORD    number of overloads (currently unused)
 38h    WORD    number of scope classes
 3Ah    WORD    number of module classes
 3Ch    WORD    number of coverage offsets
 3Eh    DWORD   offset relative to symbol base of name pool
 42h    WORD    number of browser information records
 44h    WORD    number of optimized symbol records
 46h    WORD    debugging flags
 48h  8 BYTEs   padding
Note:   additional information on the Borland debugging info may be found in
          Borland's Open Architecture Handbook
SeeAlso: #0907

                            \\\\\//
                           @ 0   0 @
<-------------------oOOO------(_)--------OOOo--------------------->
                       dBsee Product Manager
                           Matteo Baccan
                      mailto:baccan@isanet.it
                       mailto:guru@dbsee.com
                      http://matteo.isanet.it

        Get a free copy of dBsee from http://www.dbsee.com

     Current releases : dBsee 4.5, dBsee ++ 5.04, dBsee400 4.5

	       Current betas : dBsee ++ 6, dBsee400 ++
<------------------------oooO----------Oooo----------------------->
