/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.flamingo.bcb.BreadcrumbPathEvent;
import org.jvnet.flamingo.bcb.BreadcrumbPathListener;
import org.jvnet.flamingo.bcb.core.BreadcrumbFileSelector;
import org.jvnet.flamingo.common.StringValuePair;
import org.jvnet.flamingo.slider.FlexiRangeModel;
import org.jvnet.flamingo.slider.JFlexiSlider;
import test.common.ExplorerFileViewPanel;

public class FileExplorer
extends JFrame {
    private ExplorerFileViewPanel<File> filePanel;
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();

    public FileExplorer() {
        super("File explorer");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.filePanel = new ExplorerFileViewPanel<File>(this.bar, 32, null);
        JScrollPane fileListScrollPane = new JScrollPane(this.filePanel);
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        final List newPath = FileExplorer.this.bar.getModel().getItems();
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() throws Exception {
                                    return FileExplorer.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        FileExplorer.this.filePanel.setFolder((List)this.get());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        final FlexiRangeModel.Range rangeSmallMedium = new FlexiRangeModel.Range("Small Icons -> Medium Icons", true, 0.0);
        final FlexiRangeModel.Range rangeMediumLarge = new FlexiRangeModel.Range("Medium Icons -> Large Icons", false, 1.0);
        final FlexiRangeModel.Range rangeLargeVeryLarge = new FlexiRangeModel.Range("Large Icons -> Giant Icons", false, 2.0);
        ImageIcon iconSmallIcons = new ImageIcon(FileExplorer.class.getClassLoader().getResource("test/resource/small-icons.png"));
        ImageIcon iconMediumIcons = new ImageIcon(FileExplorer.class.getClassLoader().getResource("test/resource/medium-icons.png"));
        ImageIcon iconLargeIcons = new ImageIcon(FileExplorer.class.getClassLoader().getResource("test/resource/large-icons.png"));
        ImageIcon iconVeryLargeIcons = new ImageIcon(FileExplorer.class.getClassLoader().getResource("test/resource/very-large-icons.png"));
        FlexiRangeModel.Range[] ranges = new FlexiRangeModel.Range[]{rangeSmallMedium, rangeMediumLarge, rangeLargeVeryLarge};
        Icon[] icons = new Icon[]{iconSmallIcons, iconMediumIcons, iconLargeIcons, iconVeryLargeIcons};
        String[] texts = new String[]{"Small Icons", "Medium Icons", "Large Icons", "Very Large Icons"};
        final JFlexiSlider sizeSlider = new JFlexiSlider(ranges, icons, texts);
        sizeSlider.setValue(new FlexiRangeModel.Value(rangeSmallMedium, 0.0));
        sizeSlider.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (sizeSlider.getModel().getValueIsAdjusting()) {
                    return;
                }
                FlexiRangeModel.Value value = sizeSlider.getValue();
                FlexiRangeModel.Range range = value.range;
                double fraction = value.rangeFraction;
                int iconSize = 0;
                if (range == rangeSmallMedium) {
                    iconSize = fraction == 0.0 ? 32 : 64;
                }
                if (range == rangeMediumLarge) {
                    iconSize = (int)(64.0 + 64.0 * fraction);
                }
                if (range == rangeLargeVeryLarge) {
                    iconSize = (int)(128.0 + 128.0 * fraction);
                }
                FileExplorer.this.filePanel.cancelMainWorker();
                FileExplorer.this.filePanel.setIconDimension(iconSize);
            }
        });
        this.add((Component)sizeSlider, "West");
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileExplorer test = new FileExplorer();
                test.setSize(500, 400);
                test.setLocationRelativeTo(null);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }
}

