/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.popup.PopupPanelManager;
import org.jvnet.flamingo.common.ui.ScrollablePanel;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbon;
import org.jvnet.flamingo.ribbon.JRibbonFrame;
import org.jvnet.flamingo.ribbon.RibbonContextualTaskGroup;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizeSequencingPolicy;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JRibbonTaskToggleButton;
import org.jvnet.flamingo.ribbon.ui.RibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.RibbonUI;
import org.jvnet.flamingo.ribbon.ui.appmenu.JRibbonApplicationMenuButton;
import org.jvnet.flamingo.utils.DoubleArrowResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;
import org.jvnet.flamingo.utils.KeyTipManager;
import org.jvnet.flamingo.utils.RenderingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRibbonUI
extends RibbonUI {
    public static final String IS_USING_TITLE_PANE = "ribbon.internal.isUsingTitlePane";
    protected JRibbon ribbon;
    protected JPanel taskBarPanel;
    protected ScrollablePanel<BandHostPanel> bandScrollablePanel;
    protected ScrollablePanel<TaskToggleButtonsHostPanel> taskToggleButtonsScrollablePanel;
    protected JRibbonApplicationMenuButton applicationMenuButton;
    protected JCommandButton helpButton;
    protected Map<RibbonTask, JRibbonTaskToggleButton> taskToggleButtons = new HashMap<RibbonTask, JRibbonTaskToggleButton>();
    protected ButtonGroup taskToggleButtonGroup = new ButtonGroup();
    protected ChangeListener ribbonChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ContainerListener ribbonContainerListener;
    protected ComponentListener ribbonComponentListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.ribbon = (JRibbon)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbon = null;
    }

    protected void installListeners() {
        this.ribbonChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BasicRibbonUI.this.syncRibbonState();
            }
        };
        this.ribbon.addChangeListener(this.ribbonChangeListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedTask".equals(evt.getPropertyName())) {
                    RibbonTask old = (RibbonTask)evt.getOldValue();
                    RibbonTask curr = (RibbonTask)evt.getNewValue();
                    if (old != null && BasicRibbonUI.this.taskToggleButtons.get(old) != null) {
                        BasicRibbonUI.this.taskToggleButtons.get(old).setSelected(false);
                    }
                    if (curr != null && BasicRibbonUI.this.taskToggleButtons.get(curr) != null) {
                        BasicRibbonUI.this.taskToggleButtons.get(curr).setSelected(true);
                    }
                    if (BasicRibbonUI.this.isShowingScrollsForTaskToggleButtons() && curr != null) {
                        JRibbonTaskToggleButton toggleButton = BasicRibbonUI.this.taskToggleButtons.get(curr);
                        BasicRibbonUI.this.scrollAndRevealTaskToggleButton(toggleButton);
                    }
                }
                if ("applicationMenuRichTooltip".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenuKeyTip".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenu".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.ribbon.revalidate();
                    BasicRibbonUI.this.ribbon.doLayout();
                    BasicRibbonUI.this.ribbon.repaint();
                }
                if ("minimized".equals(evt.getPropertyName())) {
                    PopupPanelManager.defaultManager().hidePopups(null);
                    BasicRibbonUI.this.ribbon.revalidate();
                    BasicRibbonUI.this.ribbon.doLayout();
                    BasicRibbonUI.this.ribbon.repaint();
                }
            }
        };
        this.ribbon.addPropertyChangeListener(this.propertyChangeListener);
        this.ribbonContainerListener = new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                if (BasicRibbonUI.this.isUsingTitlePane()) {
                    return;
                }
                Component added = e.getComponent();
                if (added != BasicRibbonUI.this.applicationMenuButton) {
                    BasicRibbonUI.this.ribbon.setComponentZOrder(BasicRibbonUI.this.applicationMenuButton, BasicRibbonUI.this.ribbon.getComponentCount() - 1);
                }
            }
        };
        this.ribbon.addContainerListener(this.ribbonContainerListener);
        this.ribbonComponentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                KeyTipManager.defaultManager().hideAllKeyTips();
            }
        };
        this.ribbon.addComponentListener(this.ribbonComponentListener);
    }

    protected void uninstallListeners() {
        this.ribbon.removeChangeListener(this.ribbonChangeListener);
        this.ribbonChangeListener = null;
        this.ribbon.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbon.removeContainerListener(this.ribbonContainerListener);
        this.ribbonContainerListener = null;
        this.ribbon.removeComponentListener(this.ribbonComponentListener);
        this.ribbonComponentListener = null;
    }

    protected void installDefaults() {
        Border b = this.ribbon.getBorder();
        if (b == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("Ribbon.border");
            if (toSet == null) {
                toSet = new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2);
            }
            this.ribbon.setBorder(toSet);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.taskBarPanel = new TaskbarPanel();
        this.taskBarPanel.setName("JRibbon Task Bar");
        this.taskBarPanel.setLayout(this.createTaskbarLayoutManager());
        this.ribbon.add(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.createBandHostPanel();
        bandHostPanel.setLayout(this.createBandHostPanelLayoutManager());
        this.bandScrollablePanel = new ScrollablePanel<BandHostPanel>(bandHostPanel, bandHostPanel);
        this.bandScrollablePanel.setScrollOnRollover(false);
        this.ribbon.add(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.createTaskToggleButtonsHostPanel();
        taskToggleButtonsHostPanel.setLayout(this.createTaskToggleButtonsHostPanelLayoutManager());
        this.taskToggleButtonsScrollablePanel = new ScrollablePanel<TaskToggleButtonsHostPanel>(taskToggleButtonsHostPanel, taskToggleButtonsHostPanel);
        this.taskToggleButtonsScrollablePanel.setScrollOnRollover(false);
        this.taskToggleButtonsScrollablePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BasicRibbonUI.this.ribbon.repaint();
            }
        });
        this.ribbon.add(this.taskToggleButtonsScrollablePanel);
        this.ribbon.setLayout(this.createLayoutManager());
        this.syncRibbonState();
        this.applicationMenuButton = new JRibbonApplicationMenuButton();
        this.syncApplicationMenuTips();
        this.ribbon.add(this.applicationMenuButton);
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.ribbon);
        if (windowAncestor instanceof JRibbonFrame) {
            FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)windowAncestor);
        }
    }

    protected LayoutManager createTaskToggleButtonsHostPanelLayoutManager() {
        return new TaskToggleButtonsHostPanelLayout();
    }

    protected TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new TaskToggleButtonsHostPanel();
    }

    protected BandHostPanel createBandHostPanel() {
        return new BandHostPanel();
    }

    protected LayoutManager createBandHostPanelLayoutManager() {
        return new BandHostPanelLayout();
    }

    protected void uninstallComponents() {
        this.taskBarPanel.removeAll();
        this.taskBarPanel.setLayout(null);
        this.ribbon.remove(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        bandHostPanel.setLayout(null);
        this.ribbon.remove(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        taskToggleButtonsHostPanel.setLayout(null);
        this.ribbon.remove(this.taskToggleButtonsScrollablePanel);
        this.ribbon.remove(this.applicationMenuButton);
        if (this.helpButton != null) {
            this.ribbon.remove(this.helpButton);
        }
        this.ribbon.setLayout(null);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        super.update(g2d, c);
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g);
        if (!this.ribbon.isMinimized()) {
            Insets ins = c.getInsets();
            int extraHeight = this.getTaskToggleButtonHeight();
            if (!this.isUsingTitlePane()) {
                extraHeight += this.getTaskbarHeight();
            }
            this.paintTaskArea(g, 0, ins.top + extraHeight, c.getWidth(), c.getHeight() - extraHeight - ins.top - ins.bottom);
        } else {
            this.paintMinimizedRibbonSeparator(g);
        }
    }

    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Color borderColor = FlamingoUtilities.getBorderColor();
        g.setColor(borderColor);
        Insets ins = this.ribbon.getInsets();
        g.drawLine(0, this.ribbon.getHeight() - ins.bottom, this.ribbon.getWidth(), this.ribbon.getHeight() - ins.bottom);
    }

    protected void paintBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(FlamingoUtilities.getColor(Color.lightGray, "Panel.background"));
        g2d.fillRect(0, 0, this.ribbon.getWidth(), this.ribbon.getHeight());
        g2d.dispose();
    }

    protected void paintTaskArea(Graphics g, int x, int y, int width, int height) {
        if (this.ribbon.getTaskCount() == 0) {
            return;
        }
        JRibbonTaskToggleButton selectedTaskButton = this.taskToggleButtons.get(this.ribbon.getSelectedTask());
        Rectangle selectedTaskButtonBounds = selectedTaskButton.getBounds();
        Point converted = SwingUtilities.convertPoint(selectedTaskButton.getParent(), selectedTaskButtonBounds.getLocation(), this.ribbon);
        Rectangle taskToggleButtonsViewportBounds = this.taskToggleButtonsScrollablePanel.getViewport().getBounds();
        taskToggleButtonsViewportBounds.setLocation(SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel.getViewport().getParent(), taskToggleButtonsViewportBounds.getLocation(), this.ribbon));
        int startSelectedX = Math.max(converted.x + 1, (int)taskToggleButtonsViewportBounds.getMinX());
        startSelectedX = Math.min(startSelectedX, (int)taskToggleButtonsViewportBounds.getMaxX());
        int endSelectedX = Math.min(converted.x + selectedTaskButtonBounds.width - 1, (int)taskToggleButtonsViewportBounds.getMaxX());
        endSelectedX = Math.max(endSelectedX, (int)taskToggleButtonsViewportBounds.getMinX());
        GeneralPath outerContour = FlamingoUtilities.getRibbonBorderOutline(x + 1, x + width - 3, startSelectedX, endSelectedX, converted.y, y, y + height, 2.0f);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(FlamingoUtilities.getBorderColor());
        g2d.draw(outerContour);
        RibbonTask selected = this.ribbon.getSelectedTask();
        RibbonContextualTaskGroup contextualGroup = selected.getContextualGroup();
        if (contextualGroup != null) {
            Insets ins = this.ribbon.getInsets();
            int topY = ins.top + this.getTaskbarHeight();
            int bottomY = topY + 5;
            Color hueColor = contextualGroup.getHueColor();
            GradientPaint paint = new GradientPaint(0.0f, topY, FlamingoUtilities.getAlphaColor(hueColor, 63), 0.0f, bottomY, FlamingoUtilities.getAlphaColor(hueColor, 0));
            g2d.setPaint(paint);
            g2d.clip(outerContour);
            g2d.fillRect(0, topY, width, bottomY - topY + 1);
        }
        g2d.dispose();
    }

    @Override
    public Rectangle getContextualTaskGroupBounds(RibbonContextualTaskGroup group) {
        Rectangle rect = null;
        for (int j = 0; j < group.getTaskCount(); ++j) {
            JRibbonTaskToggleButton button = this.taskToggleButtons.get(group.getTask(j));
            rect = rect == null ? button.getBounds() : rect.union(button.getBounds());
        }
        int buttonGap = this.getTabButtonGap();
        Point location = SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel.getView(), rect.getLocation(), this.ribbon);
        return new Rectangle(location.x - buttonGap / 3, location.y - 1, rect.width + buttonGap * 2 / 3 - 1, rect.height + 1);
    }

    protected int getBandGap() {
        return 2;
    }

    protected int getTabButtonGap() {
        return 6;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    protected LayoutManager createTaskbarLayoutManager() {
        return new TaskbarLayout();
    }

    public int getTaskbarHeight() {
        return 24;
    }

    public int getTaskToggleButtonHeight() {
        return 22;
    }

    protected void syncRibbonState() {
        int i;
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        if (this.helpButton != null) {
            this.ribbon.remove(this.helpButton);
            this.helpButton = null;
        }
        List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        RibbonTask selectedTask = this.ribbon.getSelectedTask();
        for (final RibbonTask task : visibleTasks) {
            final JRibbonTaskToggleButton taskToggleButton = new JRibbonTaskToggleButton(task.getTitle());
            taskToggleButton.setKeyTip(task.getKeyTip());
            taskToggleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicRibbonUI.this.scrollAndRevealTaskToggleButton(taskToggleButton);
                            BasicRibbonUI.this.ribbon.setSelectedTask(task);
                            if (BasicRibbonUI.this.ribbon.isMinimized()) {
                                int ph;
                                AbstractRibbonBand<?> band;
                                PopupPanelManager.PopupInfo lastPopup;
                                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                                if (popups.size() > 0 && (lastPopup = popups.get(popups.size() - 1)).getPopupOriginator() == taskToggleButton) {
                                    PopupPanelManager.defaultManager().hidePopups(null);
                                    return;
                                }
                                PopupPanelManager.defaultManager().hidePopups(null);
                                BasicRibbonUI.this.ribbon.remove(BasicRibbonUI.this.bandScrollablePanel);
                                int prefHeight = BasicRibbonUI.this.bandScrollablePanel.getView().getPreferredSize().height;
                                Insets ins = BasicRibbonUI.this.ribbon.getInsets();
                                prefHeight += ins.top + ins.bottom;
                                AbstractRibbonBand<?> abstractRibbonBand = band = BasicRibbonUI.this.ribbon.getSelectedTask().getBandCount() > 0 ? BasicRibbonUI.this.ribbon.getSelectedTask().getBand(0) : null;
                                if (band != null) {
                                    Insets bandIns = band.getInsets();
                                    prefHeight += bandIns.top + bandIns.bottom;
                                }
                                BandHostPopupPanel popupPanel = new BandHostPopupPanel(BasicRibbonUI.this.bandScrollablePanel, new Dimension(BasicRibbonUI.this.ribbon.getWidth(), prefHeight));
                                int x = BasicRibbonUI.this.ribbon.getLocationOnScreen().x;
                                int y = BasicRibbonUI.this.ribbon.getLocationOnScreen().y + BasicRibbonUI.this.ribbon.getHeight();
                                Rectangle scrBounds = BasicRibbonUI.this.ribbon.getGraphicsConfiguration().getBounds();
                                int pw = popupPanel.getPreferredSize().width;
                                if (x + pw > scrBounds.x + scrBounds.width) {
                                    x = scrBounds.x + scrBounds.width - pw;
                                }
                                if (y + (ph = popupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                                    y = scrBounds.y + scrBounds.height - ph;
                                }
                                popupPanel.setPreferredSize(new Dimension(BasicRibbonUI.this.ribbon.getWidth(), prefHeight));
                                Popup popup = PopupFactory.getSharedInstance().getPopup(taskToggleButton, popupPanel, x, y);
                                PopupPanelManager.PopupListener tracker = new PopupPanelManager.PopupListener(){

                                    public void popupShown(PopupPanelManager.PopupEvent event) {
                                        JComponent originator = event.getPopupOriginator();
                                        if (originator instanceof JRibbonTaskToggleButton) {
                                            int minViewWidth = BasicRibbonUI.this.bandScrollablePanel.getView().getMinimumSize().width;
                                            BasicRibbonUI.this.bandScrollablePanel.validateScrolling(minViewWidth, null);
                                            BasicRibbonUI.this.bandScrollablePanel.doLayout();
                                            BasicRibbonUI.this.bandScrollablePanel.repaint();
                                        }
                                    }

                                    public void popupHidden(PopupPanelManager.PopupEvent event) {
                                        JComponent originator = event.getPopupOriginator();
                                        if (originator instanceof JRibbonTaskToggleButton) {
                                            BasicRibbonUI.this.ribbon.add(BasicRibbonUI.this.bandScrollablePanel);
                                            PopupPanelManager.defaultManager().removePopupListener(this);
                                            BasicRibbonUI.this.ribbon.revalidate();
                                            BasicRibbonUI.this.ribbon.doLayout();
                                            BasicRibbonUI.this.ribbon.repaint();
                                        }
                                    }
                                };
                                PopupPanelManager.defaultManager().addPopupListener(tracker);
                                PopupPanelManager.defaultManager().addPopup(taskToggleButton, popup, popupPanel);
                            }
                        }
                    });
                }
            });
            taskToggleButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (BasicRibbonUI.this.ribbon.getSelectedTask() == task && e.getClickCount() == 2) {
                        BasicRibbonUI.this.ribbon.setMinimized(!BasicRibbonUI.this.ribbon.isMinimized());
                    }
                }
            });
            if (task.getContextualGroup() != null) {
                taskToggleButton.setContextualGroupHueColor(task.getContextualGroup().getHueColor());
            }
            this.taskToggleButtonGroup.add(taskToggleButton);
            taskToggleButtonsHostPanel.add(taskToggleButton);
            this.taskToggleButtons.put(task, taskToggleButton);
        }
        JRibbonTaskToggleButton toSelect = this.taskToggleButtons.get(selectedTask);
        if (toSelect != null) {
            toSelect.setSelected(true);
        }
        for (i = 0; i < this.ribbon.getTaskCount(); ++i) {
            RibbonTask task = this.ribbon.getTask(i);
            for (AbstractRibbonBand<?> band : task.getBands()) {
                bandHostPanel.add(band);
                band.setVisible(selectedTask == task);
            }
        }
        for (i = 0; i < this.ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup taskGroup = this.ribbon.getContextualTaskGroup(i);
            for (int j = 0; j < taskGroup.getTaskCount(); ++j) {
                RibbonTask task = taskGroup.getTask(j);
                for (AbstractRibbonBand<?> band : task.getBands()) {
                    bandHostPanel.add(band);
                    band.setVisible(selectedTask == task);
                }
            }
        }
        ActionListener helpListener = this.ribbon.getHelpActionListener();
        if (helpListener != null) {
            this.helpButton = new JCommandButton("", this.ribbon.getHelpIcon());
            this.helpButton.setDisplayState(CommandButtonDisplayState.SMALL);
            this.helpButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            this.helpButton.getActionModel().addActionListener(helpListener);
            this.ribbon.add(this.helpButton);
        }
        this.ribbon.revalidate();
        this.ribbon.repaint();
    }

    protected List<RibbonTask> getCurrentlyShownRibbonTasks() {
        int i;
        ArrayList<RibbonTask> result = new ArrayList<RibbonTask>();
        for (i = 0; i < this.ribbon.getTaskCount(); ++i) {
            RibbonTask task = this.ribbon.getTask(i);
            result.add(task);
        }
        for (i = 0; i < this.ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = this.ribbon.getContextualTaskGroup(i);
            if (!this.ribbon.isVisible(group)) continue;
            for (int j = 0; j < group.getTaskCount(); ++j) {
                RibbonTask task = group.getTask(j);
                result.add(task);
            }
        }
        return result;
    }

    protected boolean isUsingTitlePane() {
        return Boolean.TRUE.equals(this.ribbon.getClientProperty(IS_USING_TITLE_PANE));
    }

    protected void syncApplicationMenuTips() {
        this.applicationMenuButton.setPopupRichTooltip(this.ribbon.getApplicationMenuRichTooltip());
        this.applicationMenuButton.setPopupKeyTip(this.ribbon.getApplicationMenuKeyTip());
    }

    @Override
    public boolean isShowingScrollsForTaskToggleButtons() {
        return this.taskToggleButtonsScrollablePanel.isShowingScrollButtons();
    }

    @Override
    public boolean isShowingScrollsForBands() {
        return this.bandScrollablePanel.isShowingScrollButtons();
    }

    public Map<RibbonTask, JRibbonTaskToggleButton> getTaskToggleButtons() {
        return Collections.unmodifiableMap(this.taskToggleButtons);
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent e) {
        if (this.ribbon.isMinimized()) {
            return;
        }
        final List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        if (visibleTasks.size() == 0) {
            return;
        }
        int delta = e.getWheelRotation();
        if (delta == 0) {
            return;
        }
        int currSelectedTaskIndex = visibleTasks.indexOf(this.ribbon.getSelectedTask());
        int newSelectedTaskIndex = currSelectedTaskIndex + (delta > 0 ? 1 : -1);
        if (newSelectedTaskIndex < 0) {
            return;
        }
        if (newSelectedTaskIndex >= visibleTasks.size()) {
            return;
        }
        final int indexToSet = newSelectedTaskIndex;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(3));
                BasicRibbonUI.this.ribbon.setSelectedTask((RibbonTask)visibleTasks.get(indexToSet));
                BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    protected void scrollAndRevealTaskToggleButton(JRibbonTaskToggleButton taskToggleButton) {
        Point loc = SwingUtilities.convertPoint(taskToggleButton.getParent(), taskToggleButton.getLocation(), this.taskToggleButtonsScrollablePanel.getView());
        this.taskToggleButtonsScrollablePanel.getView().scrollRectToVisible(new Rectangle(loc.x, loc.y, taskToggleButton.getWidth(), taskToggleButton.getHeight()));
    }

    protected static class BandHostPopupPanel
    extends JPopupPanel {
        public BandHostPopupPanel(Component component, Dimension originalSize) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(originalSize);
            this.setSize(originalSize);
        }
    }

    private class TaskToggleButtonsHostPanelLayout
    implements LayoutManager {
        private TaskToggleButtonsHostPanelLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalTaskButtonsWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getPreferredSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        public Dimension minimumLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalTaskButtonsWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getMinimumSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        public void layoutContainer(Container c) {
            int pw;
            JRibbonTaskToggleButton tabButton;
            int x = 0;
            int y = 0;
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalPrefWidth = 0;
            int totalMinWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            HashMap<JRibbonTaskToggleButton, Integer> diffMap = new HashMap<JRibbonTaskToggleButton, Integer>();
            int totalDiff = 0;
            for (RibbonTask task : visibleTasks) {
                tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                pw = tabButton.getPreferredSize().width;
                int mw = tabButton.getMinimumSize().width;
                diffMap.put(tabButton, pw - mw);
                totalDiff += pw - mw;
                totalPrefWidth += pw;
                totalMinWidth += mw;
            }
            totalMinWidth += tabButtonGap * visibleTasks.size();
            if ((totalPrefWidth += tabButtonGap * visibleTasks.size()) <= c.getWidth()) {
                for (RibbonTask task : visibleTasks) {
                    tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                    pw = tabButton.getPreferredSize().width;
                    tabButton.setBounds(x, y + 1, pw, taskToggleButtonHeight - 1);
                    x += pw + tabButtonGap;
                    tabButton.setToolTipText(null);
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", null);
            } else {
                if (totalMinWidth > c.getWidth()) {
                    throw new IllegalStateException("Available width not enough to host minimized task tab buttons");
                }
                int toDistribute = totalPrefWidth - c.getWidth() + 2;
                for (RibbonTask task : visibleTasks) {
                    JRibbonTaskToggleButton tabButton2 = BasicRibbonUI.this.taskToggleButtons.get(task);
                    int pw2 = tabButton2.getPreferredSize().width;
                    int delta = toDistribute * (Integer)diffMap.get(tabButton2) / totalDiff;
                    int finalWidth = pw2 - delta;
                    tabButton2.setBounds(x, y + 1, finalWidth, taskToggleButtonHeight - 1);
                    x += finalWidth + tabButtonGap;
                    tabButton2.setToolTipText(task.getTitle());
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", Boolean.TRUE);
            }
        }
    }

    protected class TaskToggleButtonsHostPanel
    extends JPanel
    implements ScrollablePanel.ScrollableSupport {
        public static final String IS_SQUISHED = "flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished";

        protected TaskToggleButtonsHostPanel() {
        }

        public JCommandButton createLeftScroller() {
            JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 7));
            b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            b.setFocusable(false);
            b.setCursor(Cursor.getPredefinedCursor(12));
            b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
            b.setName("Ribbon.taskToggleButtonsHostPanel.leftScroller");
            b.setFlat(false);
            return b;
        }

        public JCommandButton createRightScroller() {
            JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 3));
            b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            b.setFocusable(false);
            b.setCursor(Cursor.getPredefinedCursor(12));
            b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
            b.setName("Ribbon.taskToggleButtonsHostPanel.rightScroller");
            b.setFlat(false);
            return b;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintContextualTaskGroupsOutlines(g);
            if (Boolean.TRUE.equals(this.getClientProperty(IS_SQUISHED))) {
                this.paintTaskOutlines(g);
            }
        }

        protected void paintTaskOutlines(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, this.getHeight(), color);
            g2d.setPaint(paint);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            for (i = 0; i < BasicRibbonUI.this.ribbon.getTaskCount() - 1; ++i) {
                RibbonTask task = BasicRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
            }
            for (i = 0; i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!BasicRibbonUI.this.ribbon.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount() - 1; ++j) {
                    RibbonTask task = group.getTask(j);
                    tasksWithTrailingSeparators.add(task);
                }
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JRibbonTaskToggleButton taskToggleButton = BasicRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + BasicRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.drawLine(x, 0, x, this.getHeight());
            }
            g2d.dispose();
        }

        protected void paintContextualTaskGroupsOutlines(Graphics g) {
            for (int i = 0; i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!BasicRibbonUI.this.ribbon.isVisible(group)) continue;
                Rectangle rect = BasicRibbonUI.this.getContextualTaskGroupBounds(group);
                rect.setLocation(SwingUtilities.convertPoint(BasicRibbonUI.this.ribbon, rect.getLocation(), BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView()));
                this.paintContextualTaskGroupOutlines(g, group, rect);
            }
        }

        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint paint = new GradientPaint(0.0f, groupBounds.y, color, 0.0f, groupBounds.y + groupBounds.height, FlamingoUtilities.getAlphaColor(color, 0));
            g2d.setPaint(paint);
            int x = groupBounds.x;
            g2d.drawLine(x, groupBounds.y, x, groupBounds.y + groupBounds.height);
            x = groupBounds.x + groupBounds.width;
            g2d.drawLine(x, groupBounds.y, x, groupBounds.y + groupBounds.height);
            g2d.dispose();
        }
    }

    private class BandHostPanelLayout
    implements LayoutManager {
        private BandHostPanelLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int maxPrefBandHeight = 0;
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            return new Dimension(c.getWidth(), maxPrefBandHeight);
        }

        public Dimension minimumLayoutSize(Container c) {
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                int bandPrefHeight = ribbonBand.getMinimumSize().height;
                Insets bandInsets = ribbonBand.getInsets();
                RibbonBandUI bandUI = ribbonBand.getUI();
                int preferredCollapsedWidth = bandUI.getPreferredCollapsedWidth() + bandInsets.left + bandInsets.right;
                width += preferredCollapsedWidth;
                maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight);
            }
            return new Dimension(width += gap * (selectedTask.getBandCount() + 1), maxMinBandHeight);
        }

        public void layoutContainer(Container c) {
            int bandGap = BasicRibbonUI.this.getBandGap();
            int x = 0;
            int y = 0;
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            if (selectedTask == null) {
                return;
            }
            for (AbstractRibbonBand<?> band : selectedTask.getBands()) {
                List<RibbonBandResizePolicy> policies = band.getResizePolicies();
                RibbonBandResizePolicy last = policies.get(0);
                band.setCurrentResizePolicy(last);
            }
            int availableBandHeight = c.getHeight() - 1;
            int availableWidth = c.getWidth() - 1;
            if (selectedTask.getBandCount() > 0) {
                RibbonBandResizeSequencingPolicy resizeSequencingPolicy = selectedTask.getResizeSequencingPolicy();
                resizeSequencingPolicy.reset();
                AbstractRibbonBand currToTakeFrom = resizeSequencingPolicy.next();
                while (true) {
                    boolean noMore = true;
                    for (AbstractRibbonBand<?> band : selectedTask.getBands()) {
                        List<RibbonBandResizePolicy> resizePolicies;
                        RibbonBandResizePolicy currentResizePolicy = band.getCurrentResizePolicy();
                        if (currentResizePolicy == (resizePolicies = band.getResizePolicies()).get(resizePolicies.size() - 1)) continue;
                        noMore = false;
                        break;
                    }
                    if (noMore) break;
                    int totalWidth = 0;
                    for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                        RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
                        Insets ribbonBandInsets = ribbonBand.getInsets();
                        Object controlPanel = ribbonBand.getControlPanel();
                        if (controlPanel == null) {
                            controlPanel = ribbonBand.getPopupRibbonBand().getControlPanel();
                        }
                        Insets controlPanelInsets = ((JComponent)controlPanel).getInsets();
                        int controlPanelGap = ((AbstractBandControlPanel)controlPanel).getUI().getLayoutGap();
                        int ribbonBandHeight = availableBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom;
                        int availableHeight = ribbonBandHeight - ribbonBand.getUI().getBandTitleHeight();
                        if (controlPanel != null) {
                            availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                        }
                        int preferredWidth = currentResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                        totalWidth += preferredWidth + bandGap;
                    }
                    if (totalWidth < availableWidth) break;
                    List<RibbonBandResizePolicy> policies = currToTakeFrom.getResizePolicies();
                    int currPolicyIndex = policies.indexOf(currToTakeFrom.getCurrentResizePolicy());
                    if (currPolicyIndex != policies.size() - 1) {
                        currToTakeFrom.setCurrentResizePolicy(policies.get(currPolicyIndex + 1));
                    }
                    currToTakeFrom = resizeSequencingPolicy.next();
                }
            }
            x = 1;
            for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                Insets ribbonBandInsets = ribbonBand.getInsets();
                RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
                Object controlPanel = ribbonBand.getControlPanel();
                if (controlPanel == null) {
                    controlPanel = ribbonBand.getPopupRibbonBand().getControlPanel();
                }
                Insets controlPanelInsets = ((JComponent)controlPanel).getInsets();
                int controlPanelGap = ((AbstractBandControlPanel)controlPanel).getUI().getLayoutGap();
                int ribbonBandHeight = availableBandHeight;
                int availableHeight = ribbonBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom - ribbonBand.getUI().getBandTitleHeight();
                if (controlPanelInsets != null) {
                    availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                }
                int requiredBandWidth = currentResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                ribbonBand.setBounds(x, y, requiredBandWidth, ribbonBandHeight);
                ribbonBand.doLayout();
                x += requiredBandWidth + bandGap;
            }
        }
    }

    protected static class BandHostPanel
    extends JPanel
    implements ScrollablePanel.ScrollableSupport {
        protected BandHostPanel() {
        }

        public JCommandButton createLeftScroller() {
            JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 7));
            b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            b.setFocusable(false);
            b.setCursor(Cursor.getPredefinedCursor(12));
            b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
            b.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
            b.setFlat(false);
            return b;
        }

        public JCommandButton createRightScroller() {
            JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), 3));
            b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            b.setFocusable(false);
            b.setCursor(Cursor.getPredefinedCursor(12));
            b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
            b.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
            b.setFlat(false);
            return b;
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(1, 0, 1, 0));
        }

        protected void paintComponent(Graphics g) {
            int contourMaxX;
            Shape contour = this.getOutline(this);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RenderingUtils.installDesktopHints(g2d);
            if (contour != null) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.6f));
                g2d.setColor(FlamingoUtilities.getColor(Color.lightGray.brighter(), "Panel.background"));
                g2d.fill(contour);
                g2d.setColor(FlamingoUtilities.getBorderColor().darker());
                g2d.draw(contour);
            }
            int maxX = 0;
            if (this.getComponentCount() == 0) {
                maxX = 1;
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    maxX += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
                }
            } else {
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Component taskBarComp = this.getComponent(i);
                    maxX = Math.max(maxX, taskBarComp.getX() + taskBarComp.getWidth());
                }
            }
            int height = this.getHeight();
            g2d.drawLine(maxX, height - 1, this.getWidth(), height - 1);
            int n = contourMaxX = contour != null ? (int)contour.getBounds2D().getMaxX() + 6 : 6;
            if (!BasicRibbonUI.this.isShowingScrollsForTaskToggleButtons()) {
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.translate(-this.getBounds().x, 0);
                for (int i = 0; i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                    RibbonContextualTaskGroup taskGroup = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                    if (!BasicRibbonUI.this.ribbon.isVisible(taskGroup)) continue;
                    Rectangle taskGroupBounds = BasicRibbonUI.this.getContextualTaskGroupBounds(taskGroup);
                    Color hueColor = taskGroup.getHueColor();
                    GradientPaint paint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(hueColor, 0), 0.0f, height, FlamingoUtilities.getAlphaColor(hueColor, 63));
                    g2d.setPaint(paint);
                    int startX = Math.max(contourMaxX, taskGroupBounds.x);
                    int width = taskGroupBounds.x + taskGroupBounds.width - startX;
                    if (width <= 0) continue;
                    g2d.fillRect(startX, 0, width, height);
                    g2d.setColor(hueColor);
                    g2d.drawLine(startX + 1, height - 1, startX + width, height - 1);
                    g2d.setColor(FlamingoUtilities.getColor(Color.black, "Button.foreground"));
                    FontMetrics fm = this.getFontMetrics(BasicRibbonUI.this.ribbon.getFont());
                    int yOffset = (height + fm.getHeight()) / 2 - fm.getDescent();
                    int availableTextWidth = width - 10;
                    String titleToShow = taskGroup.getTitle();
                    if (fm.stringWidth(titleToShow) > availableTextWidth) {
                        while (titleToShow.length() != 0 && fm.stringWidth(titleToShow + "...") > availableTextWidth) {
                            titleToShow = titleToShow.substring(0, titleToShow.length() - 1);
                        }
                        titleToShow = titleToShow + "...";
                    }
                    BasicGraphicsUtils.drawString(g2d, titleToShow, -1, startX + 5, yOffset);
                    Color color = FlamingoUtilities.getBorderColor();
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, height, color));
                    g2d.drawLine(startX, 0, startX, height);
                    g2d.drawLine(startX + width, 0, startX + width, height);
                }
            }
            g2d.dispose();
        }

        protected Shape getOutline(TaskbarPanel taskbarPanel) {
            double height = this.getHeight() - 1;
            if (this.getComponentCount() == 0) {
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    int x = 1;
                    if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                        x += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
                    }
                    return new Arc2D.Double((double)(x - 1) - 2.0 * height, 0.0, 2.0 * height, 2.0 * height, 0.0, 90.0, 0);
                }
                return null;
            }
            int minX = this.getWidth();
            int maxX = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component taskBarComp = this.getComponent(i);
                minX = Math.min(minX, taskBarComp.getX());
                maxX = Math.max(maxX, taskBarComp.getX() + taskBarComp.getWidth());
            }
            float radius = (float)height / 2.0f;
            GeneralPath outline = new GeneralPath();
            if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                outline.moveTo((float)(minX + 5) - 2.0f * radius, 0.0f);
            } else {
                outline.moveTo(minX - 1, 0.0f);
            }
            outline.lineTo(maxX, 0.0f);
            outline.append(new Arc2D.Double((float)maxX - radius, 0.0, height, height, 90.0, -180.0, 0), true);
            outline.lineTo((double)(minX - 1), height);
            if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                outline.append(new Arc2D.Double((double)(minX - 1) - 2.0 * height, 0.0, 2.0 * height, 2.0 * height, 0.0, 90.0, 0), true);
            } else {
                outline.lineTo(minX - 1, 0.0f);
            }
            return outline;
        }

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(result.width + result.height / 2, result.height);
        }
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, BasicRibbonUI.this.getTaskbarHeight() + ins.top + ins.bottom);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = BasicRibbonUI.this.getBandGap();
            int x = ins.left + 1;
            if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                x += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
            }
            for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                int pw = regComp.getPreferredSize().width;
                regComp.setBounds(x, ins.top + 1, pw, c.getHeight() - ins.top - ins.bottom - 2);
                x += pw + gap;
            }
        }
    }

    private class RibbonLayout
    implements LayoutManager {
        private RibbonLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int maxPrefBandHeight = 0;
            boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
            if (!isRibbonMinimized && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            int extraHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            if (!BasicRibbonUI.this.isUsingTitlePane()) {
                extraHeight += BasicRibbonUI.this.getTaskbarHeight();
            }
            return new Dimension(c.getWidth(), maxPrefBandHeight + extraHeight + ins.top + ins.bottom);
        }

        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            int extraHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            if (!BasicRibbonUI.this.isUsingTitlePane()) {
                extraHeight += BasicRibbonUI.this.getTaskbarHeight();
            }
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getMinimumSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    RibbonBandUI bandUI = ribbonBand.getUI();
                    width += bandUI.getPreferredCollapsedWidth();
                    if (isRibbonMinimized) continue;
                    maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
                width += gap * (selectedTask.getBandCount() - 1);
            } else {
                width = 50;
            }
            return new Dimension(width, maxMinBandHeight + extraHeight + ins.top + ins.bottom);
        }

        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int x = ins.left;
            int taskbarHeight = BasicRibbonUI.this.getTaskbarHeight();
            int y = ins.top;
            boolean isUsingTitlePane = BasicRibbonUI.this.isUsingTitlePane();
            if (!isUsingTitlePane) {
                BasicRibbonUI.this.taskBarPanel.removeAll();
                for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                    BasicRibbonUI.this.taskBarPanel.add(regComp);
                }
                BasicRibbonUI.this.taskBarPanel.setBounds(x, ins.top, c.getWidth() - ins.left - ins.right, taskbarHeight);
                y += taskbarHeight;
            }
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            x = ins.left;
            int appMenuButtonSize = taskbarHeight + taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                BasicRibbonUI.this.applicationMenuButton.setVisible(BasicRibbonUI.this.ribbon.getApplicationMenu() != null);
                if (BasicRibbonUI.this.ribbon.getApplicationMenu() != null) {
                    BasicRibbonUI.this.applicationMenuButton.setBounds(ins.left, ins.top, appMenuButtonSize, appMenuButtonSize);
                }
            } else {
                BasicRibbonUI.this.applicationMenuButton.setVisible(false);
            }
            x = ins.left + 2;
            if (FlamingoUtilities.getApplicationMenuButton(SwingUtilities.getWindowAncestor(BasicRibbonUI.this.ribbon)) != null) {
                x += appMenuButtonSize;
            }
            if (BasicRibbonUI.this.helpButton != null) {
                Dimension preferred = BasicRibbonUI.this.helpButton.getPreferredSize();
                BasicRibbonUI.this.helpButton.setBounds(c.getWidth() - ins.right - preferred.width, y, preferred.width, preferred.height);
            }
            int taskButtonsWidth = BasicRibbonUI.this.ribbon.getHelpActionListener() != null ? BasicRibbonUI.this.helpButton.getX() - tabButtonGap - x : c.getWidth() - ins.right - x;
            BasicRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x, y, taskButtonsWidth, taskToggleButtonHeight);
            TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            int taskToggleButtonsHostPanelMinWidth = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(taskToggleButtonsHostPanelMinWidth, BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getBounds().height));
            BasicRibbonUI.this.taskToggleButtonsScrollablePanel.validateScrolling(taskToggleButtonsHostPanelMinWidth, null);
            BasicRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            y += taskToggleButtonHeight;
            int extraHeight = taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                extraHeight += taskbarHeight;
            }
            if (BasicRibbonUI.this.bandScrollablePanel.getParent() == BasicRibbonUI.this.ribbon) {
                if (!BasicRibbonUI.this.ribbon.isMinimized() && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets bandInsets = BasicRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : BasicRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(1 + ins.left, y + bandInsets.top, c.getWidth() - 2 * ins.left - 2 * ins.right - 1, c.getHeight() - extraHeight - ins.top - ins.bottom - bandInsets.top - bandInsets.bottom);
                    BandHostPanel bandHostPanel = BasicRibbonUI.this.bandScrollablePanel.getView();
                    int bandHostPanelMinWidth = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(bandHostPanelMinWidth, BasicRibbonUI.this.bandScrollablePanel.getBounds().height));
                    BasicRibbonUI.this.bandScrollablePanel.validateScrolling(bandHostPanelMinWidth, null);
                    BasicRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }
}

