/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.JCommandButtonStrip;
import org.jvnet.flamingo.common.JCommandToggleButton;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.common.popup.JCommandPopupMenu;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.popup.PopupPanelManager;
import org.jvnet.flamingo.ribbon.ui.JRibbonGallery;
import org.jvnet.flamingo.ribbon.ui.RibbonGalleryUI;
import org.jvnet.flamingo.utils.ArrowResizableIcon;
import org.jvnet.flamingo.utils.DoubleArrowResizableIcon;
import org.jvnet.flamingo.utils.FlamingoUtilities;
import org.jvnet.flamingo.utils.KeyTipManager;

public class BasicRibbonGalleryUI
extends RibbonGalleryUI {
    protected JRibbonGallery ribbonGallery;
    protected int firstVisibleButtonIndex;
    protected int lastVisibleButtonIndex;
    protected int visibleButtonsCount;
    protected JCommandButton scrollDownButton;
    protected JCommandButton scrollUpButton;
    protected ExpandCommandButton expandActionButton;
    protected JCommandButtonStrip buttonStrip;
    protected ActionListener scrollDownListener;
    protected ActionListener scrollUpListener;
    protected ActionListener expandListener;
    protected PopupPanelManager.PopupListener popupListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Insets margin;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonGalleryUI();
    }

    public void installUI(JComponent c) {
        this.ribbonGallery = (JRibbonGallery)c;
        this.firstVisibleButtonIndex = 0;
        this.visibleButtonsCount = 0;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    protected void installComponents() {
        this.buttonStrip = new JButtonStripUIResource(JCommandButtonStrip.StripOrientation.VERTICAL);
        this.buttonStrip.setDisplayState(CommandButtonDisplayState.FIT_TO_ICON);
        this.ribbonGallery.add(this.buttonStrip);
        this.scrollUpButton = this.createScrollUpButton();
        this.scrollDownButton = this.createScrollDownButton();
        this.expandActionButton = this.createExpandButton();
        this.syncExpandKeyTip();
        this.buttonStrip.add(this.scrollUpButton);
        this.buttonStrip.add(this.scrollDownButton);
        this.buttonStrip.add(this.expandActionButton);
    }

    protected JCommandButton createScrollDownButton() {
        JCommandButton result = new JCommandButton(null, new ArrowResizableIcon(9, 5));
        result.setFocusable(false);
        result.setName("RibbonGallery.scrollDownButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        result.setAutoRepeatAction(true);
        return result;
    }

    protected JCommandButton createScrollUpButton() {
        JCommandButton result = new JCommandButton(null, new ArrowResizableIcon(9, 1));
        result.setFocusable(false);
        result.setName("RibbonGallery.scrollUpButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        result.setAutoRepeatAction(true);
        return result;
    }

    protected ExpandCommandButton createExpandButton() {
        ExpandCommandButton result = new ExpandCommandButton(null, new DoubleArrowResizableIcon(9, 5));
        result.getActionModel().setFireActionOnPress(true);
        result.setFocusable(false);
        result.setName("RibbonGallery.expandButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        return result;
    }

    protected void uninstallComponents() {
        this.buttonStrip.remove(this.scrollUpButton);
        this.buttonStrip.remove(this.scrollDownButton);
        this.buttonStrip.remove(this.expandActionButton);
        this.ribbonGallery.remove(this.buttonStrip);
    }

    protected void installDefaults() {
        Border b;
        this.margin = UIManager.getInsets("RibbonGallery.margin");
        if (this.margin == null) {
            this.margin = new Insets(3, 3, 3, 3);
        }
        if ((b = this.ribbonGallery.getBorder()) == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("RibbonGallery.border");
            if (toSet == null) {
                toSet = new BorderUIResource.EmptyBorderUIResource(2, 2, 2, 2);
            }
            this.ribbonGallery.setBorder(toSet);
        }
        this.ribbonGallery.setOpaque(false);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.scrollDownListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicRibbonGalleryUI.this.scrollOneRowDown();
                BasicRibbonGalleryUI.this.ribbonGallery.revalidate();
            }
        };
        this.scrollDownButton.addActionListener(this.scrollDownListener);
        this.scrollUpListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicRibbonGalleryUI.this.scrollOneRowUp();
                BasicRibbonGalleryUI.this.ribbonGallery.revalidate();
            }
        };
        this.scrollUpButton.addActionListener(this.scrollUpListener);
        this.expandListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupPanelManager.defaultManager().hidePopups(BasicRibbonGalleryUI.this.ribbonGallery);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PopupFactory popupFactory = PopupFactory.getSharedInstance();
                        JCommandButtonPanel popupButtonPanel = BasicRibbonGalleryUI.this.ribbonGallery.getPopupButtonPanel();
                        final Point loc = BasicRibbonGalleryUI.this.ribbonGallery.getLocationOnScreen();
                        final JCommandPopupMenu popupMenu = new JCommandPopupMenu(popupButtonPanel, BasicRibbonGalleryUI.this.ribbonGallery.getPreferredPopupMaxButtonColumns(), BasicRibbonGalleryUI.this.ribbonGallery.getPreferredPopupMaxVisibleButtonRows());
                        if (BasicRibbonGalleryUI.this.ribbonGallery.getPopupCallback() != null) {
                            BasicRibbonGalleryUI.this.ribbonGallery.getPopupCallback().popupToBeShown(popupMenu);
                        }
                        popupMenu.setCustomizer(new JPopupPanel.PopupPanelCustomizer(){

                            public Rectangle getScreenBounds() {
                                Rectangle scrBounds = BasicRibbonGalleryUI.this.ribbonGallery.getGraphicsConfiguration().getBounds();
                                int x = loc.x;
                                int y = loc.y;
                                Dimension pref = popupMenu.getPreferredSize();
                                int width = Math.max(pref.width, BasicRibbonGalleryUI.this.ribbonGallery.getWidth());
                                int height = pref.height;
                                if (x + width > scrBounds.x + scrBounds.width) {
                                    x = scrBounds.x + scrBounds.width - width;
                                }
                                if (y + height > scrBounds.y + scrBounds.height) {
                                    y = scrBounds.y + scrBounds.height - height;
                                }
                                return new Rectangle(x, y, width, height);
                            }
                        });
                        BasicRibbonGalleryUI.this.ribbonGallery.setShowingPopupPanel(true);
                        Popup popup = popupFactory.getPopup(BasicRibbonGalleryUI.this.ribbonGallery, popupMenu, loc.x, loc.y);
                        BasicRibbonGalleryUI.this.ribbonGallery.repaint();
                        PopupPanelManager.defaultManager().addPopup(BasicRibbonGalleryUI.this.ribbonGallery, popup, popupMenu);
                        if (popupButtonPanel.getSelectedButton() != null) {
                            Rectangle selectionButtonBounds = popupButtonPanel.getSelectedButton().getBounds();
                            popupButtonPanel.scrollRectToVisible(selectionButtonBounds);
                        }
                    }
                });
            }
        };
        this.expandActionButton.addActionListener(this.expandListener);
        this.popupListener = new PopupPanelManager.PopupListener(){

            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getPopupOriginator() == BasicRibbonGalleryUI.this.ribbonGallery) {
                    for (int i = 0; i < BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount(); ++i) {
                        BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).getActionModel().setRollover(false);
                    }
                    BasicRibbonGalleryUI.this.ribbonGallery.setShowingPopupPanel(false);
                }
            }

            public void popupShown(PopupPanelManager.PopupEvent event) {
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedButton".equals(evt.getPropertyName())) {
                    BasicRibbonGalleryUI.this.scrollToSelected();
                    BasicRibbonGalleryUI.this.ribbonGallery.revalidate();
                }
                if ("expandKeyTip".equals(evt.getPropertyName())) {
                    BasicRibbonGalleryUI.this.syncExpandKeyTip();
                }
            }
        };
        this.ribbonGallery.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.scrollDownButton.removeActionListener(this.scrollDownListener);
        this.scrollDownListener = null;
        this.scrollUpButton.removeActionListener(this.scrollUpListener);
        this.scrollUpListener = null;
        this.expandActionButton.removeActionListener(this.expandListener);
        this.expandListener = null;
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        this.ribbonGallery.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.ribbonGallery = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonGalleryLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintRibbonGalleryBorder(graphics);
        graphics.dispose();
    }

    protected void paintRibbonGalleryBorder(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setColor(FlamingoUtilities.getBorderColor());
        GeneralPath outerContour = FlamingoUtilities.getRibbonGalleryOutline(this.margin.left, this.ribbonGallery.getWidth() - this.margin.right, this.margin.top, this.ribbonGallery.getHeight() - this.margin.bottom, 2.0f);
        g2d.clipRect(0, 0, this.ribbonGallery.getWidth() - this.margin.right - this.buttonStrip.getWidth() / 2, this.ribbonGallery.getHeight());
        g2d.draw(outerContour);
        g2d.dispose();
    }

    protected int getLayoutGap() {
        return 4;
    }

    public int getPreferredWidth(int buttonCount, int availableHeight) {
        Insets borderInsets = this.ribbonGallery.getInsets();
        int galleryHeight = availableHeight - this.margin.top - this.margin.bottom;
        int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
        int result = this.margin.left;
        result += buttonCount * buttonHeight * 5 / 4;
        result += (buttonCount + 1) * this.getLayoutGap();
        result += 15;
        return result += this.margin.right;
    }

    protected void scrollOneRowDown() {
        int buttonCount;
        this.firstVisibleButtonIndex += this.visibleButtonsCount;
        if (this.visibleButtonsCount > 1) {
            --this.firstVisibleButtonIndex;
        }
        if (this.firstVisibleButtonIndex >= (buttonCount = this.ribbonGallery.getButtonCount())) {
            this.firstVisibleButtonIndex = buttonCount - 1;
        }
        this.lastVisibleButtonIndex = this.firstVisibleButtonIndex + this.visibleButtonsCount - 1;
        if (this.lastVisibleButtonIndex >= buttonCount) {
            this.lastVisibleButtonIndex = buttonCount - 1;
        }
    }

    protected void scrollOneRowUp() {
        this.lastVisibleButtonIndex = this.firstVisibleButtonIndex;
        if (this.visibleButtonsCount == 1) {
            --this.lastVisibleButtonIndex;
        }
        this.firstVisibleButtonIndex = this.lastVisibleButtonIndex - this.visibleButtonsCount + 1;
        if (this.firstVisibleButtonIndex < 0) {
            this.firstVisibleButtonIndex = 0;
        }
    }

    protected void scrollToSelected() {
        JCommandToggleButton selected = this.ribbonGallery.getSelectedButton();
        if (selected == null) {
            return;
        }
        int selIndex = -1;
        for (int i = 0; i < this.ribbonGallery.getButtonCount(); ++i) {
            if (this.ribbonGallery.getButtonAt(i) != selected) continue;
            selIndex = i;
            break;
        }
        if (selIndex < 0) {
            return;
        }
        if (selIndex >= this.firstVisibleButtonIndex && selIndex <= this.lastVisibleButtonIndex) {
            return;
        }
        if (this.visibleButtonsCount <= 0) {
            return;
        }
        do {
            if (selIndex < this.firstVisibleButtonIndex) {
                this.scrollOneRowUp();
                continue;
            }
            this.scrollOneRowDown();
        } while (selIndex < this.firstVisibleButtonIndex || selIndex > this.lastVisibleButtonIndex);
    }

    protected void syncExpandKeyTip() {
        this.expandActionButton.setActionKeyTip(this.ribbonGallery.getExpandKeyTip());
    }

    @KeyTipManager.HasNextKeyTipChain
    protected static class ExpandCommandButton
    extends JCommandButton {
        public ExpandCommandButton(String title, ResizableIcon icon) {
            super(title, icon);
        }
    }

    private class RibbonGalleryLayout
    implements LayoutManager {
        private RibbonGalleryLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicRibbonGalleryUI.this.ribbonGallery.getPreferredWidth(BasicRibbonGalleryUI.this.ribbonGallery.getDisplayPriority(), c.getHeight()), c.getHeight());
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            Insets borderInsets = BasicRibbonGalleryUI.this.ribbonGallery.getInsets();
            int galleryHeight = height - BasicRibbonGalleryUI.this.margin.top - BasicRibbonGalleryUI.this.margin.bottom;
            int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
            int scrollerButtonHeight = galleryHeight / 3;
            int buttonWidth = 15;
            int buttonX = width - buttonWidth - BasicRibbonGalleryUI.this.margin.right;
            BasicRibbonGalleryUI.this.scrollDownButton.setPreferredSize(new Dimension(buttonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.scrollUpButton.setPreferredSize(new Dimension(buttonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.expandActionButton.setPreferredSize(new Dimension(buttonWidth, galleryHeight - 2 * scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.setBounds(buttonX, BasicRibbonGalleryUI.this.margin.top, buttonWidth, galleryHeight);
            BasicRibbonGalleryUI.this.buttonStrip.doLayout();
            if (!BasicRibbonGalleryUI.this.ribbonGallery.isShowingPopupPanel()) {
                int neededSpace;
                int maxButtonWidth = buttonHeight * 5 / 4;
                for (int i = 0; i < BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount(); ++i) {
                    JCommandToggleButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                    currButton.setVisible(false);
                }
                int gap = BasicRibbonGalleryUI.this.getLayoutGap();
                BasicRibbonGalleryUI.this.visibleButtonsCount = 0;
                while (true) {
                    if ((neededSpace = BasicRibbonGalleryUI.this.visibleButtonsCount * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsCount + 1) * gap) > buttonX - BasicRibbonGalleryUI.this.margin.right) {
                        --BasicRibbonGalleryUI.this.visibleButtonsCount;
                        break;
                    }
                    ++BasicRibbonGalleryUI.this.visibleButtonsCount;
                }
                neededSpace = BasicRibbonGalleryUI.this.visibleButtonsCount * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsCount + 1) * gap;
                int startX = BasicRibbonGalleryUI.this.margin.left + gap;
                int availableWidth = buttonX - BasicRibbonGalleryUI.this.margin.left;
                int toAddToButtonWidth = (availableWidth - neededSpace) / BasicRibbonGalleryUI.this.visibleButtonsCount;
                BasicRibbonGalleryUI.this.lastVisibleButtonIndex = BasicRibbonGalleryUI.this.firstVisibleButtonIndex + BasicRibbonGalleryUI.this.visibleButtonsCount - 1;
                if (BasicRibbonGalleryUI.this.lastVisibleButtonIndex >= BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount()) {
                    BasicRibbonGalleryUI.this.lastVisibleButtonIndex = BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount() - 1;
                }
                for (int i = BasicRibbonGalleryUI.this.firstVisibleButtonIndex; i <= BasicRibbonGalleryUI.this.lastVisibleButtonIndex; ++i) {
                    JCommandToggleButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                    currButton.setVisible(true);
                    currButton.setBounds(startX, BasicRibbonGalleryUI.this.margin.top + borderInsets.top, maxButtonWidth + toAddToButtonWidth, buttonHeight);
                    startX += maxButtonWidth + toAddToButtonWidth + gap;
                }
                if (BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount() == 0) {
                    BasicRibbonGalleryUI.this.scrollDownButton.setEnabled(false);
                    BasicRibbonGalleryUI.this.scrollUpButton.setEnabled(false);
                    BasicRibbonGalleryUI.this.expandActionButton.setEnabled(false);
                } else {
                    BasicRibbonGalleryUI.this.scrollDownButton.setEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(BasicRibbonGalleryUI.this.ribbonGallery.getButtonCount() - 1).isVisible());
                    BasicRibbonGalleryUI.this.scrollUpButton.setEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(0).isVisible());
                    BasicRibbonGalleryUI.this.expandActionButton.setEnabled(true);
                }
            }
        }
    }

    protected static class JButtonStripUIResource
    extends JCommandButtonStrip
    implements UIResource {
        public JButtonStripUIResource() {
        }

        public JButtonStripUIResource(JCommandButtonStrip.StripOrientation orientation) {
            super(orientation);
        }
    }
}

