/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.popup.PopupPanelManager;
import org.jvnet.flamingo.ribbon.JRibbon;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JRibbonRootPane;
import org.jvnet.flamingo.utils.FlamingoUtilities;
import org.jvnet.flamingo.utils.KeyTipManager;
import org.jvnet.flamingo.utils.KeyTipRenderingUtilities;
import org.jvnet.flamingo.utils.RenderingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRibbonFrame
extends JFrame {
    private JRibbon ribbon;

    public boolean isRibbonMinimised() {
        return this.ribbon.isMinimized();
    }

    public int getRibbonHeight() {
        return this.ribbon.getHeight();
    }

    public JRibbonFrame() throws HeadlessException {
        this.initRibbon();
    }

    public JRibbonFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initRibbon();
    }

    public JRibbonFrame(String title) throws HeadlessException {
        super(title);
        this.initRibbon();
    }

    public JRibbonFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initRibbon();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        LayoutManager currManager;
        if (manager.getClass() != RibbonFrameLayout.class && (currManager = this.getLayout()) != null) {
            throw new IllegalArgumentException("Can't set a custom layout manager on JRibbonFrame");
        }
        super.setLayout(manager);
    }

    @Override
    public void setJMenuBar(JMenuBar menubar) {
        throw new IllegalArgumentException("Can't set a menu bar on JRibbonFrame");
    }

    @Override
    public void setContentPane(Container contentPane) {
        throw new IllegalArgumentException("Can't set the content pane on JRibbonFrame");
    }

    private void initRibbon() {
        this.setLayout(new RibbonFrameLayout());
        this.ribbon = new JRibbon(this);
        this.add((Component)this.ribbon, "North");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                Component c;
                Object src = event.getSource();
                if (src instanceof Component && SwingUtilities.getWindowAncestor(c = (Component)src) == JRibbonFrame.this) {
                    if (event instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)event;
                        switch (keyEvent.getID()) {
                            case 401: {
                                break;
                            }
                            case 402: {
                                char keyChar = keyEvent.getKeyChar();
                                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                                    KeyTipManager.defaultManager().handleKeyPress(keyChar);
                                }
                                if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 121) {
                                    boolean hadPopups = !PopupPanelManager.defaultManager().getShownPath().isEmpty();
                                    PopupPanelManager.defaultManager().hidePopups(null);
                                    if (hadPopups || KeyTipManager.defaultManager().isShowingKeyTips()) {
                                        KeyTipManager.defaultManager().hideAllKeyTips();
                                    } else {
                                        KeyTipManager.defaultManager().showRootKeyTipChain(JRibbonFrame.this);
                                    }
                                }
                                if (keyEvent.getKeyCode() != 27) break;
                                KeyTipManager.defaultManager().showPreviousChain();
                            }
                        }
                    }
                    if (event instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)event;
                        switch (mouseEvent.getID()) {
                            case 500: 
                            case 501: 
                            case 502: 
                            case 506: {
                                KeyTipManager.defaultManager().hideAllKeyTips();
                            }
                        }
                    }
                }
            }
        }, 24L);
        final KeyTipLayer keyTipLayer = new KeyTipLayer();
        JRootPane rootPane = this.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        final LayoutManager currLM = rootPane.getLayout();
        rootPane.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
                currLM.addLayoutComponent(name, comp);
            }

            public void layoutContainer(Container parent) {
                currLM.layoutContainer(parent);
                JRibbonFrame ribbonFrame = JRibbonFrame.this;
                if (ribbonFrame.getRootPane().getWindowDecorationStyle() != 0) {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getBounds());
                } else {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getContentPane().getBounds());
                }
            }

            public Dimension minimumLayoutSize(Container parent) {
                return currLM.minimumLayoutSize(parent);
            }

            public Dimension preferredLayoutSize(Container parent) {
                return currLM.preferredLayoutSize(parent);
            }

            public void removeLayoutComponent(Component comp) {
                currLM.removeLayoutComponent(comp);
            }
        });
        layeredPane.add((Component)keyTipLayer, (Object)(JLayeredPane.DEFAULT_LAYER + 60));
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent e) {
                KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                if (keyTipManager.isShowingKeyTips()) {
                    keyTipManager.hideAllKeyTips();
                }
            }
        });
        KeyTipManager.defaultManager().addKeyTipListener(new KeyTipManager.KeyTipListener(){

            public void keyTipsHidden(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(false);
                }
            }

            public void keyTipsShown(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(true);
                }
            }
        });
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    @Override
    protected JRootPane createRootPane() {
        JRibbonRootPane rp = new JRibbonRootPane();
        rp.setOpaque(true);
        return rp;
    }

    @Override
    public synchronized void setIconImages(List<? extends Image> icons) {
        super.setIconImages(icons);
        FlamingoUtilities.updateRibbonFrameIconImages(this);
    }

    public boolean isShowingKeyTips() {
        return KeyTipManager.defaultManager().isShowingKeyTips();
    }

    private class KeyTipLayer
    extends JComponent {
        public KeyTipLayer() {
            this.setOpaque(false);
        }

        public synchronized void addMouseListener(MouseListener l) {
        }

        public synchronized void addMouseMotionListener(MouseMotionListener l) {
        }

        public synchronized void addMouseWheelListener(MouseWheelListener l) {
        }

        public synchronized void addKeyListener(KeyListener l) {
        }

        protected void paintComponent(Graphics g) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(this);
            if (!ribbonFrame.isShowingKeyTips()) {
                return;
            }
            if (!ribbonFrame.isActive()) {
                return;
            }
            Collection<KeyTipManager.KeyTipLink> keyTips = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
            if (keyTips != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                RenderingUtils.installDesktopHints(g2d);
                for (KeyTipManager.KeyTipLink keyTip : keyTips) {
                    if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, keyTip.comp) != null) continue;
                    Rectangle compBounds = keyTip.comp.getBounds();
                    if (!keyTip.comp.isShowing() || compBounds.getWidth() == 0.0 || compBounds.getHeight() == 0.0) continue;
                    Dimension pref = KeyTipRenderingUtilities.getPrefSize(g2d.getFontMetrics(), keyTip.keyTipString);
                    Point prefCenter = keyTip.prefAnchorPoint;
                    Point loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, this);
                    Container bandControlPanel = SwingUtilities.getAncestorOfClass(AbstractBandControlPanel.class, keyTip.comp);
                    if (bandControlPanel != null) {
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.topRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = 0;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.midRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight() / 2;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.bottomRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight();
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                    }
                    KeyTipRenderingUtilities.renderKeyTip(g2d, this, new Rectangle(loc.x - pref.width / 2, loc.y - pref.height / 2, pref.width, pref.height), keyTip.keyTipString, keyTip.enabled);
                }
                g2d.dispose();
            }
        }

        private boolean hasClientPropertySetToTrue(Component c, String clientPropName) {
            while (c != null) {
                JComponent jc;
                if (c instanceof JComponent && Boolean.TRUE.equals((jc = (JComponent)c).getClientProperty(clientPropName))) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        public boolean contains(int x, int y) {
            return false;
        }
    }

    private class RibbonFrameLayout
    extends BorderLayout {
        private RibbonFrameLayout() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints != null && constraints.equals("North")) {
                if (this.getLayoutComponent("North") != null) {
                    throw new IllegalArgumentException("Already has a NORTH JRibbon component");
                }
                if (!(comp instanceof JRibbon)) {
                    throw new IllegalArgumentException("Can't add non-JRibbon component to NORTH location");
                }
            }
            super.addLayoutComponent(comp, constraints);
        }

        public void removeLayoutComponent(Component comp) {
            if (comp instanceof JRibbon) {
                throw new IllegalArgumentException("Can't remove JRibbon component");
            }
            super.removeLayoutComponent(comp);
        }
    }
}

