/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JSeparator;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerBig;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class CommandButtonLayoutManagerCustom
extends CommandButtonLayoutManagerBig {
    public CommandButtonLayoutManagerCustom(AbstractCommandButton commandButton) {
        super(commandButton);
    }

    public int getPreferredIconSize() {
        return -1;
    }

    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        JSeparator jsep = new JSeparator(0);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        int title1Width = fm.stringWidth(this.titlePart1);
        int title2Width = fm.stringWidth(this.titlePart2);
        int width = Math.max(commandButton.getIcon().getIconWidth(), Math.max(title1Width, title2Width + 4 * layoutHGap + jsep.getPreferredSize().width + (FlamingoUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 : 0)));
        int height = by + commandButton.getIcon().getIconHeight() + layoutVGap + jsep.getPreferredSize().height;
        if (commandButton.getText() != null && commandButton.getText().length() > 0) {
            height += 2 * fm.getAscent() + fm.getDescent();
        }
        return new Dimension(bx + width, height);
    }
}

