/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.util.List;
import javax.swing.Icon;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.common.StringValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BreadcrumbItemChoices<T> {
    private BreadcrumbItem<T>[] choices;
    private BreadcrumbItem ancestor;
    private int index = 0;

    public BreadcrumbItemChoices(BreadcrumbItem ancestor, List<StringValuePair<T>> entries) {
        this.ancestor = ancestor;
        this.choices = new BreadcrumbItem[entries.size()];
        int index = 0;
        for (StringValuePair<T> pair : entries) {
            this.choices[index] = new BreadcrumbItem((String)pair.getKey(), pair.getValue());
            this.choices[index].setIcon((Icon)pair.get("icon"));
            ++index;
        }
    }

    public int getPosition(String s) {
        assert (s != null && s.length() > 0);
        for (int i = 0; i < this.choices.length; ++i) {
            BreadcrumbItem<T> it = this.choices[i];
            if (!s.equals(it.getKey())) continue;
            return i;
        }
        return -1;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public BreadcrumbItem[] getChoices() {
        return this.choices;
    }

    public BreadcrumbItem getAncestor() {
        return this.ancestor;
    }
}

