/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbBarExceptionHandler;
import org.jvnet.flamingo.bcb.BreadcrumbBarModel;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.ui.BasicBreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBreadcrumbBar<T>
extends JComponent {
    private static final long serialVersionUID = 3258407339731400502L;
    protected BreadcrumbBarModel<T> model = new BreadcrumbBarModel();
    protected BreadcrumbBarCallBack<T> callback;
    protected List<BreadcrumbBarExceptionHandler> exceptionHandlers;
    public static final String uiClassID = "BreadcrumbBarUI";

    public JBreadcrumbBar(BreadcrumbBarCallBack<T> callback) {
        this.callback = callback;
        if (this.callback != null) {
            this.callback.setup();
        }
        this.exceptionHandlers = new ArrayList<BreadcrumbBarExceptionHandler>();
        this.updateUI();
    }

    public void setPath(List<BreadcrumbItem<T>> newPath) {
        this.getModel().replace(newPath);
    }

    public BreadcrumbBarCallBack<T> getCallback() {
        return this.callback;
    }

    public void setUI(BreadcrumbBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BreadcrumbBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbBarUI());
        }
    }

    @Override
    public BreadcrumbBarUI getUI() {
        return (BreadcrumbBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addExceptionHandler(BreadcrumbBarExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    public void removeExceptionHandler(BreadcrumbBarExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    public List<BreadcrumbBarExceptionHandler> getExceptionHandlers() {
        return Collections.unmodifiableList(this.exceptionHandlers);
    }

    public void setThrowsExceptions(boolean throwsExceptions) {
        if (this.callback != null) {
            this.callback.setThrowsExceptions(throwsExceptions);
        }
    }

    public BreadcrumbBarModel<T> getModel() {
        return this.model;
    }

    public static interface BreadcrumbBarElement {
        public String getText();

        public int getIndex();
    }
}

