/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.PanelNotPassedException;
import gamemaker.GameMap;
import gamemaker.VariableChangeInput;
import gamemaker.XMLSimplify;
import gamemaker.events.GameEvent;
import gamemaker.events.VariableOperation;
import gamemaker.events.VariableOperations;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class VariableChangeEvent
extends GameEvent {
    private GameMap gameMap;
    private VariableChangeInput vci;
    private VariableOperations variableOperations;

    public VariableChangeEvent(GameMap gameMap) {
        super(gameMap.getEventPanel(), "variablechange");
        this.gameMap = gameMap;
        this.variableOperations = new VariableOperations();
    }

    public boolean eventAction() {
        if (this.isEventActionAbleToRun()) {
            if (this.variableOperations.isMessageEnabled()) {
                try {
                    String[] parts = this.variableOperations.getMessage().split("[{|}]");
                    String newMessage = "";
                    int index = 0;
                    boolean changeTheMessage = false;
                    for (int i = 0; i < parts.length; ++i) {
                        if (i % 2 == 1) {
                            try {
                                index = Integer.parseInt(parts[i]);
                                newMessage = newMessage + this.gameMap.getSpritePanel().getSprite().getSpriteVar(index %= 10);
                                changeTheMessage = true;
                            }
                            catch (NumberFormatException nfe) {}
                            continue;
                        }
                        newMessage = newMessage + parts[i];
                    }
                    if (changeTheMessage) {
                        this.eventPanel.getDialoguePanel().setMessage(newMessage);
                    } else {
                        this.eventPanel.getDialoguePanel().setMessage(this.variableOperations.getMessage());
                    }
                    this.gameMap.toggleDialogue();
                }
                catch (PanelNotPassedException pnpe) {
                    System.err.println(pnpe);
                    pnpe.printStackTrace();
                }
            }
            for (int i = 0; i < this.variableOperations.getArrayList().size(); ++i) {
                this.gameMap.getSpritePanel().getSprite().setVariable(this.variableOperations.getArrayList().get(i));
            }
            return true;
        }
        return false;
    }

    public void configureEvent(boolean requireCondition) {
        if (this.createCondition(requireCondition)) {
            this.vci = new VariableChangeInput();
            this.variableOperations = this.vci.getInput();
            if (this.variableOperations.getArrayList().size() <= 0) {
                this.deleteMyself();
            }
        } else {
            this.deleteMyself();
        }
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        super.fromXML(rootElement);
        String messageEnabled = rootElement.getAttributeValue("messageenabled");
        boolean boolmessageEnabled = false;
        if (messageEnabled.toLowerCase().equals("true")) {
            boolmessageEnabled = true;
        } else if (messageEnabled.toLowerCase().equals("false")) {
            boolmessageEnabled = false;
        } else {
            boolmessageEnabled = false;
            throw new GameXmlIncorrectException("Incorrect message enabled attribute.");
        }
        this.variableOperations.setArrayList(new ArrayList<VariableOperation>(10));
        Element element = XMLSimplify.getStrictlySingleElement(rootElement, "operations");
        List elements = element.getChildren("variable");
        for (int i = 0; i < elements.size(); ++i) {
            int index = XMLSimplify.getXMLInt((Element)elements.get(i), "index");
            int value = XMLSimplify.getXMLInt((Element)elements.get(i), "value");
            String operation = ((Element)elements.get(i)).getAttributeValue("operation");
            this.variableOperations.getArrayList().add(new VariableOperation(index, value, operation));
        }
        if (boolmessageEnabled) {
            this.variableOperations.setMessageEnabled(true);
            this.variableOperations.setMessage(rootElement.getText().trim());
        } else {
            this.variableOperations.setMessageEnabled(false);
            this.variableOperations.setMessage("");
        }
    }

    public String toXML() {
        String opening = "<event type=\"" + this.getEventFuntion() + "\" " + "trigger=\"" + this.eventTriggerToString() + "\" messageenabled=\"" + this.variableOperations.isMessageEnabledText() + "\">";
        String closing = "</event>";
        return this.toXML(opening, closing);
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + this.alwaysToXML();
        xml = xml + "<operations>";
        for (int i = 0; i < this.variableOperations.getArrayList().size(); ++i) {
            xml = xml + this.variableOperations.getArrayList().get(i).toXML();
        }
        xml = xml + "</operations>";
        xml = xml + this.variableOperations.getMessage();
        xml = xml + closeTag + "\n";
        return xml;
    }
}

