/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.events;

import gamemaker.Area;
import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.IllegalReferenceValueException;
import gamemaker.Panels.EventPanel;
import gamemaker.Panels.XMLable;
import gamemaker.VariableConditionInput;
import gamemaker.XMLSimplify;
import gamemaker.events.EventCondition;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jdom.Element;

public abstract class GameEvent
implements XMLable {
    public final int TRIGGER_WALKOVER = 0;
    public final int TRIGGER_ACTIONBUTTON = 1;
    public final int TRIGGER_ENTERMAP = 2;
    public final int TYPE_AREA = 1;
    public final int TYPE_SQUARE = 2;
    public final int TYPE_CIRCLE = 3;
    public final int TYPE_NOAREA = 4;
    private int eventTrigger = 1;
    private int eventType = 1;
    private Coordinate initialPoint = new Coordinate(0, 0);
    private GradientPaint fillGradient = new GradientPaint(0.0f, 3.0f, new Color(0, 0, 100), 3.0f, 0.0f, new Color(100, 0, 0), true);
    private Shape theShape;
    private Area eventArea;
    private String eventFunction = "undefined";
    private EventCondition eventCondition = new EventCondition();
    protected EventPanel eventPanel;

    public GameEvent(EventPanel eventPanel, String eventFunction) {
        this.eventFunction = eventFunction;
        this.eventPanel = eventPanel;
    }

    public boolean isEventActionAbleToRun() {
        return this.eventCondition.isConditionSatisfied(this.eventPanel.getGameMaps().getSprite());
    }

    public void setEventArea(Area a) {
        this.eventArea = a;
        this.eventType = 1;
    }

    public void setEventShape(Coordinate position, int width, int shapeType) {
        this.setEventShape(position, width, width, shapeType);
    }

    public void setEventShape(Coordinate position, int width, int height, int shapeType) {
        this.getClass();
        if (shapeType == 2) {
            this.theShape = new Rectangle2D.Double(position.getX(), position.getY(), width, height);
            this.getClass();
            this.eventType = 2;
        } else if (shapeType == this.TYPE_CIRCLE) {
            this.theShape = new Ellipse2D.Double(position.getX(), position.getY(), width, height);
            this.eventType = this.TYPE_CIRCLE;
        } else {
            System.out.println("Error in shape definition");
        }
    }

    public Area getEventArea() {
        return this.eventArea;
    }

    public String getEventAreaShapeXML() {
        String trigger = "action";
        String xml = "";
        this.getClass();
        if (this.eventTrigger == 1) {
            trigger = "action";
        } else {
            this.getClass();
            if (this.eventTrigger == 2) {
                trigger = "entermap";
            } else if (this.eventTrigger == this.TRIGGER_WALKOVER) {
                trigger = "walkover";
            }
        }
        if (this.eventType == 1 && this.eventArea != null) {
            xml = xml + this.eventArea.toXML("<eventshape shape=\"area\">", "</eventshape>");
        } else if (this.theShape != null) {
            xml = this.eventType == 2 ? xml + "<eventshape shape=\"square\">" : xml + "<eventshape shape=\"circle\">";
            xml = xml + "\n<position width=\"" + this.theShape.getBounds().getWidth() + "\" height=\"" + this.theShape.getBounds().getHeight() + "\" xaxis=\"" + this.theShape.getBounds().getMinX() + "\" yaxis=\"" + this.theShape.getBounds().getMinY() + "\" />";
            xml = xml + "\n</eventshape>\n";
        } else {
            xml = xml + "<error />";
        }
        return xml;
    }

    public String getEventFuntion() {
        return this.eventFunction;
    }

    public void deleteMyself() {
        this.eventPanel.removeCurrentEvent();
    }

    public void defineEventCondition() {
    }

    protected boolean createCondition(boolean requireCondition) {
        if (requireCondition) {
            VariableConditionInput vcm = new VariableConditionInput();
            try {
                this.eventCondition = vcm.getInput();
            }
            catch (IllegalReferenceValueException irve) {
                System.err.println(irve);
                irve.printStackTrace();
            }
            if (!this.eventCondition.isConditionEnabled()) {
                return false;
            }
        }
        return true;
    }

    public void configureEvent(boolean requireCondition) {
        this.createCondition(requireCondition);
    }

    public boolean isPointWithin(double x, double y) {
        this.getClass();
        if (this.eventType == 1) {
            this.eventArea.isPointWithin((int)x, (int)y);
        }
        if (this.theShape != null) {
            return this.theShape.contains(x, y);
        }
        return false;
    }

    public int getTriggerMode() {
        return this.eventTrigger;
    }

    public void setShapeDiameter(Coordinate c) {
        this.getClass();
        if (this.eventType != 1) {
            int x1 = this.initialPoint.getX();
            int y1 = this.initialPoint.getY();
            int width = Math.abs(x1 - c.getX());
            int height = Math.abs(y1 - c.getY());
            if (x1 - c.getX() > 0) {
                x1 -= width;
            }
            if (y1 - c.getY() > 0) {
                y1 -= height;
            }
            this.getClass();
            if (this.eventType == 2) {
                this.theShape = new Rectangle2D.Double(x1, y1, width, height);
            } else if (this.eventType == this.TYPE_CIRCLE) {
                this.theShape = new Ellipse2D.Double(x1, y1, width, height);
            }
        }
    }

    public void setDrawShape(Coordinate startPoint, int type) {
        this.eventType = type;
        this.initialPoint = startPoint;
        this.getClass();
        if (this.eventType == 2) {
            this.theShape = new Rectangle2D.Double(startPoint.getX(), startPoint.getY(), 0.0, 0.0);
        } else if (this.eventType == this.TYPE_CIRCLE) {
            this.theShape = new Ellipse2D.Double(startPoint.getX(), startPoint.getY(), 0.0, 0.0);
        }
    }

    public void setDrawMode(int mode) {
        this.eventType = mode;
    }

    public int getDrawMode() {
        return this.eventType;
    }

    public void setTriggerMode(int trigger) {
        if (trigger <= 2 && trigger >= 0) {
            this.eventTrigger = trigger;
        }
    }

    public boolean isComplete() {
        this.getClass();
        if (this.eventType == 1) {
            return this.eventArea.isComplete();
        }
        return true;
    }

    public void setComplete() {
        if (this.eventArea != null) {
            this.eventArea.setComplete();
        }
    }

    public void addPoint(Coordinate c) {
        if (this.eventArea == null || this.eventArea.isComplete()) {
            this.initialPoint.setX(c.getX());
            this.initialPoint.setY(c.getY());
            this.eventArea = new Area(this.eventPanel);
            this.eventArea.setFillGradient(Color.red, Color.BLUE);
            this.getClass();
            this.eventType = 1;
            this.eventArea.addPoint(c);
        } else {
            this.eventArea.addPoint(c);
        }
    }

    public boolean isShapeInProgress() {
        this.getClass();
        if (this.eventType == 1) {
            return this.eventArea.isComplete();
        }
        return false;
    }

    public boolean isPointWithin(Coordinate c) {
        this.getClass();
        if (this.eventType == 1) {
            return this.eventArea.isPointWithin(c.getX(), c.getY());
        }
        if (this.eventType == this.TYPE_NOAREA) {
            return false;
        }
        return this.theShape.contains(new Point(c.getX(), c.getY()));
    }

    public void drawEvent(Graphics2D g2) {
        this.getClass();
        if (this.eventType == 1 && this.eventArea != null) {
            this.eventArea.setFillGradient(this.fillGradient);
            this.eventArea.drawArea(g2);
        } else if (this.theShape != null) {
            g2.setPaint(this.fillGradient);
            float alpha = 0.5f;
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            g2.fill(this.theShape);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(2.0f, 1, 2));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.draw(this.theShape);
        }
    }

    public boolean eventAction() {
        return false;
    }

    public boolean isPlaced() {
        boolean eventPlaced = true;
        this.getClass();
        if (this.eventType == 1) {
            this.theShape = this.eventArea.getFinalShape();
        }
        if (this.theShape != null && this.eventTrigger != 2) {
            eventPlaced = false;
        }
        return eventPlaced;
    }

    public String eventTriggerToString() {
        return this.eventTriggerToString(this.eventTrigger);
    }

    public void setEventTrigger(String trigger) {
        if (trigger.equals("action")) {
            this.getClass();
            this.setTriggerMode(1);
        } else if (trigger.equals("walkover")) {
            this.setTriggerMode(this.TRIGGER_WALKOVER);
        } else if (trigger.equals("entermap")) {
            this.getClass();
            this.setTriggerMode(2);
        } else {
            System.out.println("ERROR. Trigger not specified correctly.");
        }
    }

    public String eventTriggerToString(int trigger) {
        this.getClass();
        if (trigger == 1) {
            return "action";
        }
        if (trigger == this.TRIGGER_WALKOVER) {
            return "walkover";
        }
        this.getClass();
        if (trigger == 2) {
            return "entermap";
        }
        return "ERROR. Trigger not specified correctly.";
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        this.eventCondition = new EventCondition(rootElement);
        String shapeType = (rootElement = XMLSimplify.getStrictlySingleElement(rootElement, "eventshape")).getAttributeValue("shape");
        if (shapeType.equals("area")) {
            this.getClass();
            this.eventType = 1;
            List points = rootElement.getChildren("point");
            Area area = new Area(this.eventPanel);
            for (int j = 0; j < points.size(); ++j) {
                int xaxis = XMLSimplify.getXMLInt((Element)points.get(j), "xaxis");
                int yaxis = XMLSimplify.getXMLInt((Element)points.get(j), "yaxis");
                area.addPoint(new Coordinate(xaxis, yaxis));
                if (j != points.size() - 1) continue;
                area.setComplete();
            }
            if (points.size() > 0) {
                this.eventArea = area;
            }
        } else if (shapeType.equals("circle") || shapeType.equals("square")) {
            Element position = XMLSimplify.getStrictlySingleElement(rootElement, "position");
            int type = this.TYPE_CIRCLE;
            if (shapeType.equals("circle")) {
                type = this.TYPE_CIRCLE;
            } else if (shapeType.equals("square")) {
                this.getClass();
                type = 2;
            }
            double xaxis = XMLSimplify.getXMLDouble(position, "xaxis");
            double yaxis = XMLSimplify.getXMLDouble(position, "yaxis");
            double width = XMLSimplify.getXMLDouble(position, "width");
            double height = XMLSimplify.getXMLDouble(position, "height");
            this.setEventShape(new Coordinate(xaxis, yaxis), (int)Math.round(width), (int)Math.round(height), type);
        }
    }

    public String alwaysToXML() {
        String xml = "";
        xml = xml + this.getEventAreaShapeXML();
        xml = xml + this.eventCondition.toXML();
        return xml;
    }

    public String toXML() {
        return this.toXML("", "");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        xml = xml + closeTag + "\n";
        return xml;
    }
}

