/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Area;
import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Panels.GamePanel;
import gamemaker.Panels.XMLable;
import gamemaker.XMLSimplify;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class WalkableAreaPanel
extends GamePanel
implements XMLable {
    ArrayList<Area> areas;

    public WalkableAreaPanel() {
        this.setOpaque(false);
        this.areas = new ArrayList(20);
    }

    public void newWalkableArea() {
        this.areas.add(new Area(this));
    }

    public void addPoint(Coordinate c) {
        if (this.areas.size() <= 0) {
            this.newWalkableArea();
        }
        if (this.areas.get(this.areas.size() - 1).isComplete()) {
            this.newWalkableArea();
            this.areas.get(this.areas.size() - 1).addPoint(c);
        } else {
            this.areas.get(this.areas.size() - 1).addPoint(c);
        }
    }

    public void deleteShapeAtPoint(Coordinate c) {
        int i = this.areas.size() - 1;
        boolean within = false;
        while (i >= 0 && !within) {
            if (this.areas.get(i).isPointWithin(c.getX(), c.getY())) {
                within = true;
            }
            if (within) continue;
            --i;
        }
        if (within) {
            this.areas.remove(i);
        }
    }

    public boolean isShapeInProgress() {
        if (this.areas.size() <= 0) {
            return true;
        }
        return this.areas.get(this.areas.size() - 1).isComplete();
    }

    public void setCurrentComplete() {
        if (this.areas.size() > 0) {
            this.areas.get(this.areas.size() - 1).setComplete();
        }
    }

    public boolean isPointWithin(Point p) {
        return this.isPointWithin(new Coordinate(p.getX(), p.getY()));
    }

    public boolean isPointWithin(Coordinate c) {
        boolean within = false;
        for (int i = 0; i < this.areas.size() && !within; ++i) {
            if (!this.areas.get(i).isPointWithin(c.getX(), c.getY())) continue;
            within = true;
        }
        return within;
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        List areas = rootElement.getChildren("area");
        for (int i = 0; i < areas.size(); ++i) {
            List points = ((Element)areas.get(i)).getChildren("point");
            Area area = new Area(this);
            for (int j = 0; j < points.size(); ++j) {
                int xaxis = XMLSimplify.getXMLInt((Element)points.get(j), "xaxis");
                int yaxis = XMLSimplify.getXMLInt((Element)points.get(j), "yaxis");
                area.addPoint(new Coordinate(xaxis, yaxis));
                if (j != points.size() - 1) continue;
                area.setComplete();
            }
            if (points.size() <= 0) continue;
            this.areas.add(area);
        }
    }

    public String toXML() {
        return this.toXML("<walkover>", "</walkover>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        for (int i = 0; i < this.areas.size(); ++i) {
            xml = xml + this.areas.get(i).toXML() + "\n";
        }
        xml = xml + closeTag + "\n";
        return xml;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        for (int i = 0; i < this.areas.size(); ++i) {
            this.areas.get(i).drawArea(g2);
        }
    }
}

