/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.GameMaps;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public class PaintPanel
extends JComponent {
    Image image = this.createVolatileImage(100, 100);
    GameMaps m;
    private int paintWidth = 800;
    private int paintHeight = 600;

    public PaintPanel(GameMaps m) {
        this.setOpaque(true);
        this.m = m;
        this.setBackground(Color.black);
        this.setVisible(true);
        this.repaint();
        this.setAutoscrolls(true);
    }

    public void setPaintSize(int width, int height) {
        this.paintWidth = width;
        this.paintHeight = height;
        this.setSize(width, height);
    }

    public int getPaintWidth() {
        return this.paintWidth;
    }

    public int getPaintHeight() {
        return this.paintHeight;
    }

    public void updateImage() {
        this.updateUI();
        this.setSize(this.m.getCurrentMap().getBackgroundPanel().getSize());
        this.image = this.createVolatileImage((int)this.m.getCurrentMap().getBackgroundPanel().getSize().getWidth(), (int)this.m.getCurrentMap().getBackgroundPanel().getSize().getSize().getHeight());
        Dimension d = new Dimension(this.m.getMapsContainer().getWidth(), this.m.getMapsContainer().getHeight());
        this.m.getMapsContainer().setVisible(true);
    }

    public int getTopY() {
        this.paintHeight = (int)Math.ceil(this.getVisibleRect().getHeight());
        this.paintWidth = (int)Math.ceil(this.getVisibleRect().getWidth());
        int coy = (int)Math.ceil((double)this.m.getSprite().getSpritePositionCoord().getY() - (double)this.paintHeight / 2.0);
        if ((double)this.m.getCurrentMap().getBackgroundPanel().getHeight() < this.getVisibleRect().getHeight()) {
            int diff = (int)Math.ceil(this.getVisibleRect().getHeight() - (double)this.m.getCurrentMap().getBackgroundPanel().getHeight());
            coy = -(diff / 2);
        } else if (coy + this.paintHeight >= this.image.getHeight(this)) {
            coy = this.image.getHeight(this) - this.paintHeight;
        } else if (coy <= 0) {
            coy = 0;
        }
        return coy;
    }

    public int getTopX() {
        this.paintHeight = (int)Math.ceil(this.getVisibleRect().getHeight());
        this.paintWidth = (int)Math.ceil(this.getVisibleRect().getWidth());
        int cox = (int)Math.ceil((double)this.m.getSprite().getSpritePositionCoord().getX() - (double)this.paintWidth / 2.0);
        if ((double)this.m.getCurrentMap().getBackgroundPanel().getWidth() < this.getVisibleRect().getWidth()) {
            int diff = (int)Math.ceil(this.getVisibleRect().getWidth() - (double)this.m.getCurrentMap().getBackgroundPanel().getWidth());
            cox = -(diff / 2);
        } else if (cox + this.paintWidth >= this.image.getWidth(this)) {
            cox = this.image.getWidth(this) - this.paintWidth;
        } else if (cox <= 0) {
            cox = 0;
        }
        return cox;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.m != null) {
            g2.setClip(this.getVisibleRect());
            if (this.image == null) {
                this.m.getCurrentMap().getBackgroundPanel().paintComponent(g2);
                this.m.getCurrentMap().getSpritePanel().paintComponent(g2);
                this.m.getCurrentMap().getForegroundPanel().paintComponentTwo(g2);
                this.m.getCurrentMap().getDialoguePanel().paintComponents(g2);
                this.updateImage();
            } else {
                this.m.getCurrentMap().getBackgroundPanel().paintComponent(this.image.getGraphics());
                this.m.getCurrentMap().getSpritePanel().paintComponent(this.image.getGraphics());
                this.m.getCurrentMap().getForegroundPanel().paintComponentTwo(this.image.getGraphics());
                this.m.getCurrentMap().getDialoguePanel().paintComponent(this.image.getGraphics());
                int coy = this.getTopY();
                int cox = this.getTopX();
                g2.setColor(Color.BLACK);
                g2.fillRect((int)this.getVisibleRect().getMinX(), (int)this.getVisibleRect().getMinY(), (int)this.getVisibleRect().getWidth(), (int)this.getVisibleRect().getHeight());
                g2.drawImage(this.image, -cox, -coy, this);
            }
        } else {
            g2.setColor(Color.red);
            g2.fill3DRect(0, 0, 100, 100, true);
        }
    }
}

