/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;

public final class JavaAdapter
implements IdFunctionCall {
    private static final Object FTAG = new Object();
    private static final int Id_JavaAdapter = 1;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        JavaAdapter javaAdapter = new JavaAdapter();
        IdFunctionObject idFunctionObject = new IdFunctionObject(javaAdapter, FTAG, 1, "JavaAdapter", 1, scriptable);
        idFunctionObject.markAsConstructor(null);
        if (bl) {
            idFunctionObject.sealObject();
        }
        idFunctionObject.exportAsScopeProperty();
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1) {
            return JavaAdapter.js_createAdpter(context, scriptable, objectArray);
        }
        throw idFunctionObject.unknown();
    }

    public static Object convertResult(Object object, Class clazz) {
        if (object == Undefined.instance && clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.StringClass) {
            return null;
        }
        return Context.jsToJava(object, clazz);
    }

    public static Scriptable createAdapterWrapper(Scriptable scriptable, Object object) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        NativeJavaObject nativeJavaObject = new NativeJavaObject(scriptable2, object, null);
        nativeJavaObject.setPrototype(scriptable);
        return nativeJavaObject;
    }

    public static Object getAdapterSelf(Class clazz, Object object) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField("self");
        return field.get(object);
    }

    static Object js_createAdpter(Context context, Scriptable scriptable, Object[] objectArray) {
        Class clazz;
        Object object;
        int n = objectArray.length;
        if (n == 0) {
            throw ScriptRuntime.typeError0("msg.adapter.zero.args");
        }
        Class clazz2 = null;
        Class[] classArray = new Class[n - 1];
        int n2 = 0;
        for (int i = 0; i != n - 1; ++i) {
            object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(i), ScriptRuntime.toString(object));
            }
            clazz = ((NativeJavaClass)object).getClassObject();
            if (!clazz.isInterface()) {
                if (clazz2 != null) {
                    throw ScriptRuntime.typeError2("msg.only.one.super", clazz2.getName(), clazz.getName());
                }
                clazz2 = clazz;
                continue;
            }
            classArray[n2++] = clazz;
        }
        if (clazz2 == null) {
            clazz2 = ScriptRuntime.ObjectClass;
        }
        Class[] classArray2 = new Class[n2];
        System.arraycopy(classArray, 0, classArray2, 0, n2);
        object = ScriptRuntime.toObject(context, scriptable, objectArray[n - 1]);
        clazz = JavaAdapter.getAdapterClass(scriptable, clazz2, classArray2, (Scriptable)object);
        Class[] classArray3 = new Class[]{ScriptRuntime.ContextFactoryClass, ScriptRuntime.ScriptableClass};
        Object[] objectArray2 = new Object[]{context.getFactory(), object};
        try {
            Object t = clazz.getConstructor(classArray3).newInstance(objectArray2);
            return JavaAdapter.getAdapterSelf(clazz, t);
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    public static void writeAdapterObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        Class<?> clazz = object.getClass();
        objectOutputStream.writeObject(clazz.getSuperclass().getName());
        Class<?>[] classArray = clazz.getInterfaces();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        objectOutputStream.writeObject(stringArray);
        try {
            Object object2 = clazz.getField("delegee").get(object);
            objectOutputStream.writeObject(object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new IOException();
    }

    public static Object readAdapterObject(Scriptable scriptable, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Context context = Context.getCurrentContext();
        ContextFactory contextFactory = context != null ? context.getFactory() : null;
        Class<?> clazz = Class.forName((String)objectInputStream.readObject());
        String[] stringArray = (String[])objectInputStream.readObject();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i]);
        }
        Scriptable scriptable2 = (Scriptable)objectInputStream.readObject();
        Class clazz2 = JavaAdapter.getAdapterClass(scriptable, clazz, classArray, scriptable2);
        Class[] classArray2 = new Class[]{ScriptRuntime.ContextFactoryClass, ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] objectArray = new Object[]{contextFactory, scriptable2, scriptable};
        try {
            return clazz2.getConstructor(classArray2).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable scriptable) {
        Object[] objectArray = ScriptableObject.getPropertyIds(scriptable);
        ObjToIntMap objToIntMap = new ObjToIntMap(objectArray.length);
        for (int i = 0; i != objectArray.length; ++i) {
            String string;
            Object object;
            if (!(objectArray[i] instanceof String) || !((object = ScriptableObject.getProperty(scriptable, string = (String)objectArray[i])) instanceof Function)) continue;
            Function function = (Function)object;
            int n = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)function, "length"));
            if (n < 0) {
                n = 0;
            }
            objToIntMap.put(string, n);
        }
        return objToIntMap;
    }

    private static Class getAdapterClass(Scriptable scriptable, Class clazz, Class[] classArray, Scriptable scriptable2) {
        ClassCache classCache = ClassCache.get(scriptable);
        Hashtable hashtable = classCache.javaAdapterGeneratedClasses;
        ObjToIntMap objToIntMap = JavaAdapter.getObjectFunctionNames(scriptable2);
        JavaAdapterSignature javaAdapterSignature = new JavaAdapterSignature(clazz, classArray, objToIntMap);
        Class clazz2 = (Class)hashtable.get(javaAdapterSignature);
        if (clazz2 == null) {
            String string = "adapter" + classCache.newClassSerialNumber();
            byte[] byArray = JavaAdapter.createAdapterCode(objToIntMap, string, clazz, classArray, null);
            clazz2 = JavaAdapter.loadAdapterClass(string, byArray);
            if (classCache.isCachingEnabled()) {
                hashtable.put(javaAdapterSignature, clazz2);
            }
        }
        return clazz2;
    }

    public static byte[] createAdapterCode(ObjToIntMap objToIntMap, String string, Class clazz, Class[] classArray, String string2) {
        String string3;
        String string4;
        Class[] classArray2;
        String string5;
        int n;
        ClassFileWriter classFileWriter = new ClassFileWriter(string, clazz.getName(), "<adapter>");
        classFileWriter.addField("factory", "Lorg/mozilla/javascript/ContextFactory;", (short)17);
        classFileWriter.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        classFileWriter.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int n2 = classArray == null ? 0 : classArray.length;
        for (int i = 0; i < n2; ++i) {
            if (classArray[i] == null) continue;
            classFileWriter.addInterface(classArray[i].getName());
        }
        String string6 = clazz.getName().replace('.', '/');
        JavaAdapter.generateCtor(classFileWriter, string, string6);
        JavaAdapter.generateSerialCtor(classFileWriter, string, string6);
        if (string2 != null) {
            JavaAdapter.generateEmptyCtor(classFileWriter, string, string6, string2);
        }
        ObjToIntMap objToIntMap2 = new ObjToIntMap();
        ObjToIntMap objToIntMap3 = new ObjToIntMap();
        for (int i = 0; i < n2; ++i) {
            Method[] methodArray = classArray[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                n = method.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isFinal(n)) continue;
                string5 = method.getName();
                classArray2 = method.getParameterTypes();
                if (!objToIntMap.has(string5)) {
                    try {
                        clazz.getMethod(string5, classArray2);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                string4 = JavaAdapter.getMethodSignature(method, classArray2);
                string3 = string5 + string4;
                if (objToIntMap2.has(string3)) continue;
                JavaAdapter.generateMethod(classFileWriter, string, string5, classArray2, method.getReturnType());
                objToIntMap2.put(string3, 0);
                objToIntMap3.put(string5, 0);
            }
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n3 = method.getModifiers();
            if (Modifier.isStatic(n3) || Modifier.isFinal(n3)) continue;
            n = Modifier.isAbstract(n3) ? 1 : 0;
            string5 = method.getName();
            if (n == 0 && !objToIntMap.has(string5)) continue;
            classArray2 = method.getParameterTypes();
            string4 = JavaAdapter.getMethodSignature(method, classArray2);
            string3 = string5 + string4;
            if (!objToIntMap2.has(string3)) {
                JavaAdapter.generateMethod(classFileWriter, string, string5, classArray2, method.getReturnType());
                objToIntMap2.put(string3, 0);
                objToIntMap3.put(string5, 0);
            }
            if (n != 0) continue;
            JavaAdapter.generateSuper(classFileWriter, string, string6, string5, string4, classArray2, method.getReturnType());
        }
        ObjToIntMap.Iterator iterator = new ObjToIntMap.Iterator(objToIntMap);
        iterator.start();
        while (!iterator.done()) {
            String string7 = (String)iterator.getKey();
            if (!objToIntMap3.has(string7)) {
                int n4 = iterator.getValue();
                Class[] classArray3 = new Class[n4];
                for (int i = 0; i < n4; ++i) {
                    classArray3[i] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(classFileWriter, string, string7, classArray3, ScriptRuntime.ObjectClass);
            }
            iterator.next();
        }
        return classFileWriter.toByteArray();
    }

    static Class loadAdapterClass(String string, byte[] byArray) {
        GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(null, null);
        Class clazz = generatedClassLoader.defineClass(string, byArray);
        generatedClassLoader.linkClass(clazz);
        return clazz;
    }

    public static Function getFunction(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object, string);
        }
        return (Function)object;
    }

    public static Object callMethod(ContextFactory contextFactory, final Scriptable scriptable, final Function function, final Object[] objectArray, final long l) {
        if (function == null) {
            return Undefined.instance;
        }
        if (contextFactory == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        final Scriptable scriptable2 = function.getParentScope();
        if (l == 0L) {
            return Context.call(contextFactory, function, scriptable2, scriptable, objectArray);
        }
        Context context = Context.getCurrentContext();
        if (context != null) {
            return JavaAdapter.doCall(context, scriptable2, scriptable, function, objectArray, l);
        }
        return contextFactory.call(new ContextAction(){

            public Object run(Context context) {
                return JavaAdapter.doCall(context, scriptable2, scriptable, function, objectArray, l);
            }
        });
    }

    private static Object doCall(Context context, Scriptable scriptable, Scriptable scriptable2, Function function, Object[] objectArray, long l) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object;
            if (0L == (l & (long)(1 << i)) || (object = objectArray[i]) instanceof Scriptable) continue;
            objectArray[i] = context.getWrapFactory().wrap(context, scriptable, object, null);
        }
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    public static Scriptable runScript(final Script script) {
        return (Scriptable)Context.call(new ContextAction(){

            public Object run(Context context) {
                ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
                script.exec(context, scriptableObject);
                return scriptableObject;
            }
        });
    }

    private static void generateCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string2, "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(44);
        classFileWriter.add(181, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(44);
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(181, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)3);
    }

    private static void generateSerialCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string2, "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(44);
        classFileWriter.add(181, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(45);
        classFileWriter.add(181, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)4);
    }

    private static void generateEmptyCtor(ClassFileWriter classFileWriter, String string, String string2, String string3) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string2, "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.add(1);
        classFileWriter.add(181, string, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(187, string3);
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, string3, "<init>", "()V");
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(76);
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(181, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    static void generatePushWrappedArgs(ClassFileWriter classFileWriter, Class[] classArray, int n) {
        classFileWriter.addPush(n);
        classFileWriter.add(189, "java/lang/Object");
        int n2 = 1;
        for (int i = 0; i != classArray.length; ++i) {
            classFileWriter.add(89);
            classFileWriter.addPush(i);
            n2 += JavaAdapter.generateWrapArg(classFileWriter, n2, classArray[i]);
            classFileWriter.add(83);
        }
    }

    private static int generateWrapArg(ClassFileWriter classFileWriter, int n, Class clazz) {
        int n2 = 1;
        if (!clazz.isPrimitive()) {
            classFileWriter.add(25, n);
        } else if (clazz == Boolean.TYPE) {
            classFileWriter.add(187, "java/lang/Boolean");
            classFileWriter.add(89);
            classFileWriter.add(21, n);
            classFileWriter.addInvoke(183, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (clazz == Character.TYPE) {
            classFileWriter.add(21, n);
            classFileWriter.addInvoke(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            classFileWriter.add(187, "java/lang/Double");
            classFileWriter.add(89);
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add(21, n);
                    classFileWriter.add(135);
                    break;
                }
                case 'l': {
                    classFileWriter.add(22, n);
                    classFileWriter.add(138);
                    n2 = 2;
                    break;
                }
                case 'f': {
                    classFileWriter.add(23, n);
                    classFileWriter.add(141);
                    break;
                }
                case 'd': {
                    classFileWriter.add(24, n);
                    n2 = 2;
                }
            }
            classFileWriter.addInvoke(183, "java/lang/Double", "<init>", "(D)V");
        }
        return n2;
    }

    static void generateReturnResult(ClassFileWriter classFileWriter, Class clazz, boolean bl) {
        if (clazz == Void.TYPE) {
            classFileWriter.add(87);
            classFileWriter.add(177);
        } else if (clazz == Boolean.TYPE) {
            classFileWriter.addInvoke(184, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            classFileWriter.add(172);
        } else if (clazz == Character.TYPE) {
            classFileWriter.addInvoke(184, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            classFileWriter.add(3);
            classFileWriter.addInvoke(182, "java/lang/String", "charAt", "(I)C");
            classFileWriter.add(172);
        } else if (clazz.isPrimitive()) {
            classFileWriter.addInvoke(184, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add(142);
                    classFileWriter.add(172);
                    break;
                }
                case 'l': {
                    classFileWriter.add(143);
                    classFileWriter.add(173);
                    break;
                }
                case 'f': {
                    classFileWriter.add(144);
                    classFileWriter.add(174);
                    break;
                }
                case 'd': {
                    classFileWriter.add(175);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + clazz.toString());
                }
            }
        } else {
            String string = clazz.getName();
            if (bl) {
                classFileWriter.addLoadConstant(string);
                classFileWriter.addInvoke(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            classFileWriter.add(192, string);
            classFileWriter.add(176);
        }
    }

    private static void generateMethod(ClassFileWriter classFileWriter, String string, String string2, Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = JavaAdapter.appendMethodSignature(classArray, clazz, stringBuffer);
        String string3 = stringBuffer.toString();
        classFileWriter.startMethod(string2, string3, (short)1);
        classFileWriter.add(42);
        classFileWriter.add(180, string, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(180, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(180, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addPush(string2);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        JavaAdapter.generatePushWrappedArgs(classFileWriter, classArray, classArray.length);
        if (classArray.length > 64) {
            throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
        }
        long l = 0L;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            l |= (long)(1 << i);
        }
        classFileWriter.addPush(l);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(classFileWriter, clazz, true);
        classFileWriter.stopMethod((short)n);
    }

    private static int generatePushParam(ClassFileWriter classFileWriter, int n, Class clazz) {
        if (!clazz.isPrimitive()) {
            classFileWriter.addALoad(n);
            return 1;
        }
        String string = clazz.getName();
        switch (string.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                classFileWriter.addILoad(n);
                return 1;
            }
            case 'l': {
                classFileWriter.addLLoad(n);
                return 2;
            }
            case 'f': {
                classFileWriter.addFLoad(n);
                return 1;
            }
            case 'd': {
                classFileWriter.addDLoad(n);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter classFileWriter, Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    classFileWriter.add(172);
                    break;
                }
                case 'l': {
                    classFileWriter.add(173);
                    break;
                }
                case 'f': {
                    classFileWriter.add(174);
                    break;
                }
                case 'd': {
                    classFileWriter.add(175);
                }
            }
        } else {
            classFileWriter.add(176);
        }
    }

    private static void generateSuper(ClassFileWriter classFileWriter, String string, String string2, String string3, String string4, Class[] classArray, Class clazz) {
        classFileWriter.startMethod("super$" + string3, string4, (short)1);
        classFileWriter.add(25, 0);
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            n += JavaAdapter.generatePushParam(classFileWriter, n, classArray[i]);
        }
        classFileWriter.addInvoke(183, string2, string3, string4);
        Class clazz2 = clazz;
        if (!clazz2.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(classFileWriter, clazz2);
        } else {
            classFileWriter.add(177);
        }
        classFileWriter.stopMethod((short)(n + 1));
    }

    private static String getMethodSignature(Method method, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        JavaAdapter.appendMethodSignature(classArray, method.getReturnType(), stringBuffer);
        return stringBuffer.toString();
    }

    static int appendMethodSignature(Class[] classArray, Class clazz, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n = 1 + classArray.length;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            JavaAdapter.appendTypeString(stringBuffer, clazz2);
            if (clazz2 != Long.TYPE && clazz2 != Double.TYPE) continue;
            ++n;
        }
        stringBuffer.append(')');
        JavaAdapter.appendTypeString(stringBuffer, clazz);
        return n;
    }

    private static StringBuffer appendTypeString(StringBuffer stringBuffer, Class clazz) {
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            char c;
            if (clazz == Boolean.TYPE) {
                c = 'Z';
            } else if (clazz == Long.TYPE) {
                c = 'J';
            } else {
                String string = clazz.getName();
                c = Character.toUpperCase(string.charAt(0));
            }
            stringBuffer.append(c);
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer;
    }

    static int[] getArgsToConvert(Class[] classArray) {
        int n = 0;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i != classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    static class JavaAdapterSignature {
        Class superClass;
        Class[] interfaces;
        ObjToIntMap names;

        JavaAdapterSignature(Class clazz, Class[] classArray, ObjToIntMap objToIntMap) {
            this.superClass = clazz;
            this.interfaces = classArray;
            this.names = objToIntMap;
        }

        public boolean equals(Object object) {
            if (!(object instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature javaAdapterSignature = (JavaAdapterSignature)object;
            if (this.superClass != javaAdapterSignature.superClass) {
                return false;
            }
            if (this.interfaces != javaAdapterSignature.interfaces) {
                if (this.interfaces.length != javaAdapterSignature.interfaces.length) {
                    return false;
                }
                for (int i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i] == javaAdapterSignature.interfaces[i]) continue;
                    return false;
                }
            }
            if (this.names.size() != javaAdapterSignature.names.size()) {
                return false;
            }
            ObjToIntMap.Iterator iterator = new ObjToIntMap.Iterator(this.names);
            iterator.start();
            while (!iterator.done()) {
                String string = (String)iterator.getKey();
                int n = iterator.getValue();
                if (n != this.names.get(string, n + 1)) {
                    return false;
                }
                iterator.next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() | -1640531527 * (this.names.size() | this.interfaces.length << 16);
        }
    }
}

