/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class Version {
    private static String PROPERTIES_PATH = "/svnkit.build.properties";
    private static final String VERSION_STRING_PROPERTY = "svnkit.version.string";
    private static final String VERSION_MAJOR_PROPERTY = "svnkit.version.major";
    private static final String VERSION_MINOR_PROPERTY = "svnkit.version.minor";
    private static final String VERSION_MICRO_PROPERTY = "svnkit.version.micro";
    private static final String VERSION_REVISION_PROPERTY = "svnkit.version.revision";
    private static final String VERSION_STRING_DEFAULT = "SVNKit (http://svnkit.com/) rSNAPSHOT";
    private static final String VERSION_MAJOR_DEFAULT = "0";
    private static final String VERSION_MINOR_DEFAULT = "0";
    private static final String VERSION_MICRO_DEFAULT = "0";
    private static final String VERSION_REVISION_DEFAULT = "SNAPSHOT";
    private static String ourUserAgent = System.getProperty("svnkit.http.userAgent");
    private static Properties ourProperties;
    static /* synthetic */ Class class$org$tmatesoft$svn$util$Version;

    public static String getVersionString() {
        Version.loadProperties();
        return ourProperties.getProperty(VERSION_STRING_PROPERTY, VERSION_STRING_DEFAULT);
    }

    public static void setUserAgent(String userAgent) {
        ourUserAgent = userAgent;
    }

    public static String getUserAgent() {
        if (ourUserAgent != null) {
            return ourUserAgent;
        }
        return Version.getVersionString();
    }

    public static int getMajorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MAJOR_PROPERTY, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getMinorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MINOR_PROPERTY, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getMicroVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MICRO_PROPERTY, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static long getRevisionNumber() {
        Version.loadProperties();
        try {
            return Long.parseLong(ourProperties.getProperty(VERSION_REVISION_PROPERTY, VERSION_REVISION_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        if (ourProperties != null) {
            return;
        }
        InputStream is = (class$org$tmatesoft$svn$util$Version == null ? (class$org$tmatesoft$svn$util$Version = Version.class$("org.tmatesoft.svn.util.Version")) : class$org$tmatesoft$svn$util$Version).getResourceAsStream(PROPERTIES_PATH);
        ourProperties = new Properties();
        if (is == null) {
            return;
        }
        try {
            ourProperties.load(is);
        }
        catch (IOException iOException) {
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

