/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.JavaHLPropertyData;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.Status;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class JavaHLObjectFactory {
    private static final Map STATUS_CONVERSION_MAP = new HashMap();
    private static final Map REVISION_KIND_CONVERSION_MAP = new HashMap();
    private static final Map ACTION_CONVERSION_MAP = new HashMap();
    private static final Map LOCK_CONVERSION_MAP = new HashMap();

    public static Status createStatus(String path, SVNStatus status) {
        String url;
        if (status == null) {
            return null;
        }
        String string = url = status.getURL() != null ? status.getURL().toString() : null;
        if (url == null && status.getEntryProperties() != null) {
            url = (String)status.getEntryProperties().get("svn:entry:url");
        }
        if (url == null && status.getRemoteURL() != null) {
            url = status.getRemoteURL().toString();
        }
        int nodeKind = JavaHLObjectFactory.getNodeKind(status.getKind());
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED) {
            nodeKind = 3;
        }
        long revision = status.getRevision().getNumber();
        long lastChangedRevision = -1L;
        if (status.getCommittedRevision() != null) {
            lastChangedRevision = status.getCommittedRevision().getNumber();
        }
        Date d = status.getCommittedDate();
        long lastChangedDate = -1L;
        if (d != null) {
            lastChangedDate = d.getTime() * 1000L;
        }
        String lastCommitAuthor = status.getAuthor();
        int textStatus = JavaHLObjectFactory.getStatusValue(status.getContentsStatus());
        int propStatus = JavaHLObjectFactory.getStatusValue(status.getPropertiesStatus());
        int repositoryTextStatus = JavaHLObjectFactory.getStatusValue(status.getRemoteContentsStatus());
        int repositoryPropStatus = JavaHLObjectFactory.getStatusValue(status.getRemotePropertiesStatus());
        boolean locked = status.isLocked();
        boolean copied = status.isCopied();
        boolean switched = status.isSwitched();
        String conflictOld = "";
        if (status.getConflictOldFile() != null) {
            conflictOld = status.getConflictOldFile().getName();
        }
        String conflictNew = "";
        if (status.getConflictNewFile() != null) {
            conflictNew = status.getConflictNewFile().getName();
        }
        String conflictWorking = "";
        if (status.getConflictWrkFile() != null) {
            conflictWorking = status.getConflictWrkFile().getName();
        }
        String urlCopiedFrom = status.getCopyFromURL();
        long revisionCopiedFrom = status.getCopyFromRevision().getNumber();
        String lockToken = null;
        String lockOwner = null;
        String lockComment = null;
        long lockCreationDate = 0L;
        if (status.getLocalLock() != null) {
            lockToken = status.getLocalLock().getID();
            lockOwner = status.getLocalLock().getOwner();
            lockComment = status.getLocalLock().getComment();
            lockCreationDate = status.getLocalLock().getCreationDate().getTime() * 1000L;
        }
        Lock reposLock = JavaHLObjectFactory.createLock(status.getRemoteLock());
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        long reposRev = status.getRemoteRevision() != null ? status.getRemoteRevision().getNumber() : -1L;
        long reposDate = status.getRemoteDate() != null ? status.getRemoteDate().getTime() * 1000L : -1L;
        String reposAuthor = status.getRemoteAuthor();
        int reposKind = JavaHLObjectFactory.getNodeKind(status.getRemoteKind());
        Status st = new Status(path, url, nodeKind, revision, lastChangedRevision, lastChangedDate, lastCommitAuthor, textStatus, propStatus, repositoryTextStatus, repositoryPropStatus, locked, copied, conflictOld, conflictNew, conflictWorking, urlCopiedFrom, revisionCopiedFrom, switched, lockToken, lockOwner, lockComment, lockCreationDate, reposLock, reposRev, reposDate, reposKind, reposAuthor);
        return st;
    }

    public static SVNRevision getSVNRevision(Revision r) {
        if (r == null) {
            return SVNRevision.UNDEFINED;
        }
        if (r.getKind() == 1) {
            return SVNRevision.create(((Revision.Number)r).getNumber());
        }
        if (r.getKind() == 2) {
            return SVNRevision.create(((Revision.DateSpec)r).getDate());
        }
        if (r == Revision.START) {
            return SVNRevision.create(0L);
        }
        return (SVNRevision)REVISION_KIND_CONVERSION_MAP.get(new Integer(r.getKind()));
    }

    public static int getNodeKind(SVNNodeKind svnKind) {
        if (svnKind == SVNNodeKind.DIR) {
            return 2;
        }
        if (svnKind == SVNNodeKind.NONE) {
            return 0;
        }
        if (svnKind == SVNNodeKind.FILE) {
            return 1;
        }
        return 3;
    }

    public static int getStatusValue(SVNStatusType svnStatusType) {
        Object status = STATUS_CONVERSION_MAP.get(svnStatusType);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static int getLockStatusValue(SVNStatusType svnStatusType) {
        Object status = LOCK_CONVERSION_MAP.get(svnStatusType);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static int getNotifyActionValue(SVNEventAction action) {
        Object status = ACTION_CONVERSION_MAP.get(action);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static DirEntry createDirEntry(SVNDirEntry dirEntry) {
        if (dirEntry == null) {
            return null;
        }
        return new DirEntry(dirEntry.getRelativePath(), JavaHLObjectFactory.getNodeKind(dirEntry.getKind()), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), dirEntry.getDate() != null ? dirEntry.getDate().getTime() * 1000L : 0L, dirEntry.getAuthor());
    }

    public static LogMessage createLogMessage(SVNLogEntry logEntry) {
        if (logEntry == null) {
            return null;
        }
        Map cpaths = logEntry.getChangedPaths();
        ChangePath[] cp = null;
        if (cpaths == null) {
            cp = new ChangePath[]{};
        } else {
            ArrayList<ChangePath> clientChangePaths = new ArrayList<ChangePath>();
            Iterator iter = cpaths.keySet().iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                SVNLogEntryPath entryPath = (SVNLogEntryPath)cpaths.get(path);
                if (entryPath == null) continue;
                clientChangePaths.add(new ChangePath(path, entryPath.getCopyRevision(), entryPath.getCopyPath(), entryPath.getType()));
            }
            cp = clientChangePaths.toArray(new ChangePath[clientChangePaths.size()]);
        }
        return new LogMessage(logEntry.getMessage(), logEntry.getDate(), logEntry.getRevision(), logEntry.getAuthor(), cp);
    }

    public static CommitItem[] getCommitItems(SVNCommitItem[] commitables) {
        if (commitables == null) {
            return null;
        }
        CommitItem[] items = new CommitItem[commitables.length];
        for (int i = 0; i < items.length; ++i) {
            SVNCommitItem sc = commitables[i];
            if (sc == null) {
                items[i] = null;
                continue;
            }
            int stateFlag = 0;
            if (sc.isDeleted()) {
                stateFlag += 2;
            } else if (sc.isAdded()) {
                ++stateFlag;
            } else if (sc.isContentsModified()) {
                stateFlag += 4;
            }
            if (sc.isPropertiesModified()) {
                stateFlag += 8;
            }
            if (sc.isCopied()) {
                stateFlag += 16;
            }
            items[i] = new CommitItem(sc.getPath(), JavaHLObjectFactory.getNodeKind(sc.getKind()), stateFlag, sc.getURL() != null ? sc.getURL().toString() : null, sc.getCopyFromURL() != null ? sc.getCopyFromURL().toString() : null, sc.getRevision().getNumber());
        }
        return items;
    }

    public static Lock createLock(SVNLock svnLock) {
        if (svnLock == null) {
            return null;
        }
        return new Lock(svnLock.getOwner(), svnLock.getPath(), svnLock.getID(), svnLock.getComment(), svnLock.getCreationDate() != null ? svnLock.getCreationDate().getTime() * 1000L : 0L, svnLock.getExpirationDate() != null ? svnLock.getExpirationDate().getTime() * 1000L : 0L);
    }

    public static Info createInfo(SVNInfo info) {
        String path;
        if (info == null) {
            return null;
        }
        int schedule = 0;
        if ("add".equals(info.getSchedule())) {
            schedule = 1;
        } else if ("delete".equals(info.getSchedule())) {
            schedule = 2;
        }
        File file = info.getFile();
        boolean deleted = file != null && !file.exists() && schedule == 2;
        boolean absent = file != null && !deleted && !file.exists();
        boolean incomplete = false;
        long copyRev = info.getCopyFromRevision() != null ? info.getCopyFromRevision().getNumber() : -1L;
        String copyUrl = info.getCopyFromURL() != null ? info.getCopyFromURL().toString() : null;
        String string = path = info.getFile() != null ? info.getFile().getName() : SVNPathUtil.tail(info.getPath());
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        return new Info(path, info.getURL() != null ? info.getURL().toString() : null, info.getRepositoryUUID(), info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null, schedule, JavaHLObjectFactory.getNodeKind(info.getKind()), info.getAuthor(), info.getRevision() != null ? info.getRevision().getNumber() : -1L, info.getCommittedRevision() != null ? info.getCommittedRevision().getNumber() : -1L, info.getCommittedDate(), info.getTextTime(), info.getPropTime(), info.getCopyFromRevision() != null || info.getCopyFromURL() != null, deleted, absent, incomplete, copyRev, copyUrl);
    }

    public static Info2 createInfo2(SVNInfo info) {
        String path;
        if (info == null) {
            return null;
        }
        int schedule = 0;
        if ("add".equals(info.getSchedule())) {
            schedule = 1;
        } else if ("delete".equals(info.getSchedule())) {
            schedule = 2;
        }
        long copyRev = info.getCopyFromRevision() != null ? info.getCopyFromRevision().getNumber() : -1L;
        String copyUrl = info.getCopyFromURL() != null ? info.getCopyFromURL().toString() : null;
        String string = path = info.getFile() != null ? info.getFile().getAbsolutePath() : info.getPath();
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        return new Info2(path, info.getURL() != null ? info.getURL().toString() : null, info.getRevision() != null ? info.getRevision().getNumber() : -1L, JavaHLObjectFactory.getNodeKind(info.getKind()), info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null, info.getRepositoryUUID(), info.getCommittedRevision() != null ? info.getCommittedRevision().getNumber() : -1L, info.getCommittedDate() != null ? info.getCommittedDate().getTime() * 1000L : 0L, info.getAuthor(), JavaHLObjectFactory.createLock(info.getLock()), !info.isRemote(), schedule, copyUrl, copyRev, info.getTextTime() != null ? info.getTextTime().getTime() * 1000L : 0L, info.getPropTime() != null ? info.getPropTime().getTime() * 1000L : 0L, info.getChecksum(), info.getConflictOldFile() != null ? info.getConflictOldFile().getName() : null, info.getConflictNewFile() != null ? info.getConflictNewFile().getName() : null, info.getConflictWrkFile() != null ? info.getConflictWrkFile().getName() : null, info.getPropConflictFile() != null ? info.getPropConflictFile().getName() : null);
    }

    public static PropertyData createPropertyData(Object client, String path, String name, String value, byte[] data) {
        if (client instanceof SVNClientImpl) {
            return new JavaHLPropertyData((SVNClientImpl)client, null, path, name, value, data);
        }
        return new PropertyData((SVNClient)client, path, name, value, data);
    }

    public static NotifyInformation createNotifyInformation(SVNEvent event, String path) {
        String errMsg = null;
        if (event.getErrorMessage() != null) {
            errMsg = event.getErrorMessage().getFullMessage();
        }
        return new NotifyInformation(path, JavaHLObjectFactory.getNotifyActionValue(event.getAction()), JavaHLObjectFactory.getNodeKind(event.getNodeKind()), event.getMimeType(), JavaHLObjectFactory.createLock(event.getLock()), errMsg, JavaHLObjectFactory.getStatusValue(event.getContentsStatus()), JavaHLObjectFactory.getStatusValue(event.getPropertiesStatus()), JavaHLObjectFactory.getLockStatusValue(event.getLockStatus()), event.getRevision());
    }

    public static void throwException(SVNException e, SVNClientImpl svnClient) throws ClientException {
        int code = 0;
        if (e.getErrorMessage() != null) {
            code = e.getErrorMessage().getErrorCode().getCode();
        }
        ClientException ec = new ClientException(e.getMessage(), "", code);
        svnClient.getClientManager().getDebugLog().info((Throwable)ec);
        svnClient.getClientManager().getDebugLog().info(e);
        throw ec;
    }

    static {
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_ADDED, new Integer(3));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_CONFLICTED, new Integer(9));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_DELETED, new Integer(4));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_EXTERNAL, new Integer(13));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_IGNORED, new Integer(11));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_INCOMPLETE, new Integer(12));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_MISSING, new Integer(6));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_MODIFIED, new Integer(2));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_NONE, new Integer(0));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_NORMAL, new Integer(1));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_OBSTRUCTED, new Integer(10));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_REPLACED, new Integer(7));
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_UNVERSIONED, new Integer(5));
        STATUS_CONVERSION_MAP.put(SVNStatusType.CHANGED, new Integer(5));
        STATUS_CONVERSION_MAP.put(SVNStatusType.CONFLICTED, new Integer(7));
        STATUS_CONVERSION_MAP.put(SVNStatusType.INAPPLICABLE, new Integer(0));
        STATUS_CONVERSION_MAP.put(SVNStatusType.MERGED, new Integer(6));
        STATUS_CONVERSION_MAP.put(SVNStatusType.MISSING, new Integer(3));
        STATUS_CONVERSION_MAP.put(SVNStatusType.OBSTRUCTED, new Integer(4));
        STATUS_CONVERSION_MAP.put(SVNStatusType.UNCHANGED, new Integer(2));
        STATUS_CONVERSION_MAP.put(SVNStatusType.UNKNOWN, new Integer(1));
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_INAPPLICABLE, new Integer(0));
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_LOCKED, new Integer(3));
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNCHANGED, new Integer(2));
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNKNOWN, new Integer(1));
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNLOCKED, new Integer(4));
        REVISION_KIND_CONVERSION_MAP.put(new Integer(5), SVNRevision.BASE);
        REVISION_KIND_CONVERSION_MAP.put(new Integer(3), SVNRevision.COMMITTED);
        REVISION_KIND_CONVERSION_MAP.put(new Integer(7), SVNRevision.HEAD);
        REVISION_KIND_CONVERSION_MAP.put(new Integer(4), SVNRevision.PREVIOUS);
        REVISION_KIND_CONVERSION_MAP.put(new Integer(0), SVNRevision.UNDEFINED);
        REVISION_KIND_CONVERSION_MAP.put(new Integer(6), SVNRevision.WORKING);
        ACTION_CONVERSION_MAP.put(SVNEventAction.ADD, new Integer(0));
        ACTION_CONVERSION_MAP.put(SVNEventAction.ANNOTATE, new Integer(20));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_ADDED, new Integer(16));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_DELETED, new Integer(17));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_DELTA_SENT, new Integer(19));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_MODIFIED, new Integer(15));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_REPLACED, new Integer(18));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COPY, new Integer(1));
        ACTION_CONVERSION_MAP.put(SVNEventAction.DELETE, new Integer(2));
        ACTION_CONVERSION_MAP.put(SVNEventAction.FAILED_REVERT, new Integer(5));
        ACTION_CONVERSION_MAP.put(SVNEventAction.LOCK_FAILED, new Integer(23));
        ACTION_CONVERSION_MAP.put(SVNEventAction.LOCKED, new Integer(21));
        ACTION_CONVERSION_MAP.put(SVNEventAction.RESOLVED, new Integer(6));
        ACTION_CONVERSION_MAP.put(SVNEventAction.RESTORE, new Integer(3));
        ACTION_CONVERSION_MAP.put(SVNEventAction.REVERT, new Integer(4));
        ACTION_CONVERSION_MAP.put(SVNEventAction.SKIP, new Integer(7));
        ACTION_CONVERSION_MAP.put(SVNEventAction.STATUS_COMPLETED, new Integer(13));
        ACTION_CONVERSION_MAP.put(SVNEventAction.STATUS_EXTERNAL, new Integer(14));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UNLOCK_FAILED, new Integer(24));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UNLOCKED, new Integer(22));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_ADD, new Integer(9));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_COMPLETED, new Integer(11));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_DELETE, new Integer(8));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_EXTERNAL, new Integer(12));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_UPDATE, new Integer(10));
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_NONE, new Integer(10));
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_COMPLETED, new Integer(-11));
    }
}

