/*
 * Decompiled with CFR 0.152.
 */
package org.spicetrade;

import bsh.Interpreter;
import com.thoughtworks.xstream.XStream;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.spicetrade.Actions;
import org.spicetrade.Armies;
import org.spicetrade.Dialogs;
import org.spicetrade.Map;
import org.spicetrade.Market;
import org.spicetrade.Places;
import org.spicetrade.Player;
import org.spicetrade.Sounds;
import org.spicetrade.Traders;
import org.spicetrade.tools.Drawable;
import org.spicetrade.tools.Item;
import org.spicetrade.tools.LogItem;
import org.spicetrade.tools.MapEntry;
import org.spicetrade.tools.Settings;
import org.spicetrade.tools.Spicebean;
import org.spicetrade.tools.Task;
import org.spicetrade.tools.Tools;

public class Mainframe
extends Frame {
    public Interpreter bsh = new Interpreter();
    public XStream xstream = new XStream();
    public Player player;
    public Dialogs dialogs;
    public Places places;
    public Market market;
    public Sounds sounds;
    public Tools tools = new Tools();
    public Actions actions;
    public Armies armies;
    public Traders traders;
    public Task timer2;
    public Map map;
    public Hashtable images;
    public Vector objects = new Vector();
    public Vector panel = new Vector();
    public Vector glass = new Vector();
    public Font font;
    public Font fontBold;
    public boolean isModal = false;
    public int converter = 0;
    public boolean isStatus = false;
    public boolean showMapHomeCity;
    public boolean showMapGlobe = false;
    public boolean showStatus = false;
    public boolean idle = false;
    public Drawable flyover = null;
    public String dialog = "";
    public String bshimport = "import org.spicetrade.*;\nimport org.spicetrade.tools.*;\n";
    public Random random = new Random();
    public int nextInt = this.random.nextInt(100);
    public String doActionOnEntering = "";
    public static Mainframe me = null;
    public Timer timer = null;
    public Image offscreen;
    public Graphics bg;
    public static final int DEBUG = 0;

    public Mainframe() {
        this.images = new Hashtable();
        this.initialize();
    }

    public void initialize() {
        try {
            me = this;
            this.dialogs = new Dialogs();
            this.places = new Places();
            this.market = new Market();
            this.sounds = new Sounds();
            this.sounds.musicOn = false;
            this.actions = new Actions();
            this.map = new Map();
            this.player = new Player();
            this.armies = new Armies();
            this.traders = new Traders();
            this.player.journal.open("field2");
            this.bsh.setOut(System.out);
            this.bsh.set("mf", this);
            this.bsh.set("res", false);
            this.setBounds(0, 0, 1024, 768);
            this.images.put("notavailable", this.tools.loadImage(this, "/pics/notavailable.gif"));
            this.setIconImage(this.getImage("/pics/navigation/icons/icon.gif"));
            this.getImage("controls", "/pics/navigation/icons/controls.png", true);
            this.getImage("questionMark", "/pics/navigation/icons/question_mark.png", true);
            this.getImage("localMap", "/pics/navigation/icons/icon_map.png", true);
            this.getImage("globalMap", "/pics/navigation/icons/icon_globe.png", true);
            this.getImage("statusFace", this.player.statusFace, true);
            this.getImage("statusBar", "/pics/navigation/icons/statusbar.jpg", true);
            this.getImage("statusHashish", "/pics/navigation/icons/hashish_addiction.png", true);
            this.getImage("statusOpium", "/pics/navigation/icons/opium_addiction.png", true);
            this.getImage("statusPlague", "/pics/navigation/icons/health.png", true);
            this.getImage("playerIcon", "/pics/navigation/icons/abusmall.png", true);
            this.getImage("logoIntro", "/pics/navigation/icons/logos/logo_intro.png", true);
            this.getImage("logoEvil", "/pics/navigation/icons/logos/logo_bad.png", true);
            this.getImage("logoAmulet", "/pics/navigation/icons/logos/logo_fatima.png", true);
            this.getImage("logoDeath", "/pics/navigation/icons/logos/logo_dead.png", true);
            this.getImage("logoDeath2", "/pics/navigation/icons/logos/logo_invert.png", true);
            this.getImage("logoFatima", "/pics/navigation/icons/logos/logo_fatima.png", true);
            this.getImage("logoHashish", "/pics/navigation/icons/logos/logo_hashish.png", true);
            this.getImage("logoOpium", "/pics/navigation/icons/logos/logo_opium.png", true);
            this.getImage("logoPlague", "/pics/navigation/icons/logos/logo_red_crescent.png", true);
            this.getImage("abu", "/pics/navigation/characters/abu.png", true);
            this.getImage("abuSoldier", "/pics/objects/abu_fighting_150.png", true);
            this.getImage("pixel", "/pics/pixel.gif", true);
            this.loadSettings();
            this.font = new Font("Arial", 0, 14);
            this.fontBold = new Font("Arial", 1, 14);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Mainframe.this.this_mouseClicked(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    Mainframe.this.this_mouseMoved(e);
                }
            });
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    Mainframe.this.this_windowClosed(e);
                }
            });
            this.sounds.musicOn = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.offscreen == null) {
                g.setFont(this.font);
                this.offscreen = this.createImage(this.getWidth(), this.getHeight());
                this.bg = this.offscreen.getGraphics();
            }
            this.bg.setColor(Color.darkGray);
            this.bg.fillRect(0, 0, 2000, 2000);
            int i = 0;
            int j = this.objects.size();
            while (i < j) {
                ((Drawable)this.objects.elementAt(i)).draw(this.bg);
                ++i;
            }
            if (this.isModal) {
                i = 0;
                j = this.panel.size();
                while (i < j) {
                    ((Drawable)this.panel.elementAt(i)).draw(this.bg);
                    ++i;
                }
            }
            i = 0;
            j = this.glass.size();
            while (i < j) {
                ((Drawable)this.glass.elementAt(i)).draw(this.bg);
                ++i;
            }
            if (this.flyover != null) {
                this.flyover.draw(this.bg);
            }
            g.drawImage(this.offscreen, 0, 0, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void doAction(String action) {
        this.doAction(action, this.getWidth() - 300, "");
    }

    public void doAction(String action, String doAfter) {
        this.doAction(action, this.getWidth() - 300, doAfter);
    }

    public void doAction(String action, int x, String doAfter) {
        this.doAction(action, x, 20, 20, 750, 20, doAfter);
    }

    public void doAction(String action, int x, int y, int times, int delay, String doAfter) {
        this.doAction(action, x, y, times, delay, 0, doAfter);
    }

    public void doAction(String action, int x, int y, int times, int delay, int after) {
        this.doAction(action, x, y, times, delay, after, "");
    }

    public void doAction(String action, int x, int y, int times, int delay, int after, String doAfter) {
        this.doAction(action, x, y, times, delay, after, doAfter, false);
    }

    public void doAction(String action, int x, int y, int times, int delay, int after, String doAfter, boolean fade) {
        this.isModal = true;
        String timerAction = "mf.actions.perform(\"" + action + "\", !counter, " + x + ", " + y + ", !donep, " + after + ", " + fade + ");";
        this.createTask(timerAction, 1000, delay, times, doAfter);
    }

    public void gotoMap() {
        System.gc();
        this.sounds.loopMusic("/music/16_world_horizon.ogg");
        this.player.place = "map";
        this.player.nicecity = "Map of the world";
        this.isModal = false;
        this.flyover = null;
        this.panel.clear();
        this.objects.clear();
        this.glass.clear();
        this.paintMap(true);
        this.paintGlass();
        this.doLayout();
        this.repaint();
        this.player.journal.done("permit1");
        this.player.journal.open("permit5");
        if ((this.player.hasItem("10100") || this.player.hasItem("10110") || this.player.hasItem("10120") || this.player.hasItem("10130") || this.player.hasItem("10200") || this.player.hasItem("10210") || this.player.hasItem("10220") || this.player.hasItem("10230")) && !this.player.hasItem("10640")) {
            this.gotoDialog("1680");
        }
    }

    public void gotoPlace(String to) {
        if (!this.doActionOnEntering.equals("")) {
            try {
                String action = this.doActionOnEntering;
                this.doActionOnEntering = "";
                this.player.place = to;
                this.bsh.eval(String.valueOf(this.bshimport) + action);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.gotoPlace(to, false);
        }
    }

    public void gotoPlace(String to, boolean modal) {
        if (!(to.equals(this.player.place) || to.equals("menu") || to.equals("settings") || to.equals("intro") || to.equals("intro2") || to.equals("credits"))) {
            this.player.lastPlace = this.player.place;
            this.nextInt = this.random.nextInt(100);
        }
        if (this.player.fullScreen && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() == null) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this);
        }
        if (!this.player.fullScreen && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() != null) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
        }
        this.isModal = modal;
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (to.equals("map")) {
            this.player.place = to;
            this.gotoMap();
        } else {
            this.player.nicecity = this.places.getTitle(to);
            String old = this.player.place;
            this.player.place = to;
            this.flyover = null;
            this.panel.clear();
            this.objects.clear();
            this.glass.clear();
            this.paintPlace(to);
            this.paintGlass();
            this.doLayout();
            this.repaint();
            this.player.place = old;
            Vector events = this.places.getEvents(to);
            if (events != null && events.size() > 0) {
                int i = 0;
                int j = events.size();
                while (i < j) {
                    Spicebean sb = (Spicebean)events.elementAt(i);
                    sb.doAction();
                    ++i;
                }
            }
            this.player.place = to;
        }
    }

    public void gotoCity(String to, String action, int xcity, int ycity, int days) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (to.equals(this.player.city)) {
            this.player.nicecity = to;
            this.gotoPlace(to);
        } else {
            this.objects.clear();
            this.paintMap(false);
            this.player.to(xcity, ycity);
            this.createTask(action, 1000, 200, days);
        }
    }

    public void gotoDialog(String to) {
        this.gotoDialog(to, 0, 0);
    }

    public void gotoDialog(String to, int x, int y) {
        this.player.addLog("!" + to, "mf.gotoDialog(\"" + to + "\", " + x + ", " + y + ");", this.player.day + this.player.month * 30 + this.player.year * 360);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dialog = to;
        this.isModal = true;
        this.flyover = null;
        this.panel.clear();
        this.objects.clear();
        if (this.player.place.equals("map")) {
            this.paintMap(true);
        } else {
            this.paintPlace();
        }
        this.paintDialog(x, y);
        this.doLayout();
        this.repaint();
        this.nextInt = this.random.nextInt(100);
    }

    public void gotoStatus(int state, String id, int page, int from, int helpMore) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.isModal = true;
        this.flyover = null;
        this.panel.clear();
        this.objects.clear();
        if (this.player.hasItem("11500") && this.player.hasItem("11510") && this.player.hasItem("11520") && this.player.hasItem("11530")) {
            this.player.chooseFace("14");
        }
        if (this.player.place.equals("map")) {
            this.paintMap(true);
        } else {
            this.paintPlace();
        }
        this.paintStatus(state, id, page, from, helpMore);
        this.doLayout();
        this.repaint();
        String[] cities = new String[]{"!Baghdad", "!Najaf", "!Anjudan", "!Konya", "!Al-ladhiqiyah", "!Baku", "!Constantinople"};
        if (this.player.hasItem("11500") && this.player.hasItem("11510") && this.player.hasItem("11520") && this.player.hasItem("11530")) {
            int which = 0;
            if (this.rB(0, 14)) {
                which = 0;
            }
            if (this.rB(14, 28)) {
                which = 1;
            }
            if (this.rB(28, 42)) {
                which = 2;
            }
            if (this.rB(42, 56)) {
                which = 3;
            }
            if (this.rB(56, 70)) {
                which = 4;
            }
            if (this.rB(75, 90)) {
                which = 5;
            }
            if (this.rB(90, 100)) {
                which = 6;
            }
            if (!this.player.journal.isDone("grave1")) {
                this.player.journal.open("grave1", cities[which]);
            } else if (!this.player.journal.isDone("grave2")) {
                this.player.journal.open("grave2", cities[which]);
            } else if (!this.player.journal.isDone("grave3")) {
                this.player.journal.open("grave3", cities[which]);
            } else if (!this.player.journal.isDone("grave4")) {
                this.player.journal.open("grave4", cities[which]);
            } else if (!this.player.journal.isDone("grave5")) {
                this.player.journal.open("grave5", cities[which]);
            } else if (!this.player.journal.isDone("grave6")) {
                this.player.journal.open("grave6", cities[which]);
            } else if (!this.player.journal.isDone("grave7")) {
                this.player.journal.open("grave7", cities[which]);
            }
            this.player.removeItem("11500");
            this.player.removeItem("11510");
            this.player.removeItem("11520");
            this.player.removeItem("11530");
        }
    }

    public void gotoBattle(String who) {
        this.gotoBattle(who, 1, 0, this.armies.getHealth(who), "");
    }

    public void gotoBattle(String who, int round, int weapon, int enemyMight, String endTask) {
        this.sounds.loopMusic("/music/10_its_time.ogg");
        this.nextInt = this.random.nextInt(100);
        this.isModal = true;
        this.player.inBattle = true;
        this.panel.clear();
        this.player.chooseFace("16");
        this.paintBattle(who, round, weapon, enemyMight, endTask);
        this.doLayout();
        this.repaint();
    }

    public void gotoDiary() {
        this.gotoDiary(0);
    }

    public void gotoDiary(int page) {
        this.isModal = true;
        this.panel.clear();
        this.objects.clear();
        this.paintPlace();
        this.paintDiary(page);
        this.doLayout();
        this.repaint();
    }

    public void gotoShop(String who) {
        this.gotoShop(who, 0, "", "", 0, 0, 0);
    }

    public void gotoShop(String who, int state, String id, String name, int price, int pageLeft, int pageRight) {
        this.nextInt = this.random.nextInt(100);
        this.isModal = true;
        this.panel.clear();
        this.player.chooseFace("02");
        this.paintShop(who, state, id, name, price, pageLeft, pageRight);
        this.doLayout();
        this.repaint();
    }

    public void gotoDeath(String famousLastWords, int how) {
        this.player.inGameOver = true;
        this.isModal = true;
        this.player.deathType = how;
        this.player.lastWords = famousLastWords;
        this.panel.clear();
        this.objects.clear();
        if (this.player.place.equals("map")) {
            this.paintMap(true);
        } else {
            this.paintPlace();
        }
        this.player.logo = "logoDeath";
        this.paintStatus(5, "", 0, 0, 0);
        this.doLayout();
        this.repaint();
    }

    public void paintShop(String who, int state, String id, String name, int price, int pageLeft, int pageRight) {
        int j;
        String strPage;
        int x = 150;
        int y = 100;
        int width = 760;
        int height = 500;
        boolean buy = false;
        boolean sell = false;
        String transaction = "";
        int per = 9;
        Font statusFontBold = new Font("Arial", 1, 12);
        Font statusFont = new Font("Arial", 0, 10);
        this.panel.add(new Drawable(x, y, width, height, 12, this.getImage("logoIntro"), "Trading with " + this.traders.getDisplay(who)));
        this.panel.add(new Drawable(x + 10, y + 10, 0, 0, 3, this.getImage(this.traders.getString(who, "Picture"))));
        this.panel.add(new Drawable(x + width - 110, y + 10, 0, 0, 3, this.getImage("abu")));
        this.panel.add(new Drawable(745, 541, 120, 20, 2, "Money:", statusFontBold, Color.BLACK));
        this.panel.add(new Drawable(793, 548, 200, 20, 2, String.valueOf(this.player.money) + " silver dirhams", statusFont, Color.BLACK));
        Vector buyItems = this.traders.getBuyItems(who);
        Vector sellItems = this.traders.getSellItems(who);
        int p = 0;
        x = 200;
        y = 250;
        int counter = 0;
        Image image = null;
        if (buyItems.size() > per) {
            if (pageLeft > 0) {
                this.panel.add(new Drawable(160, 219, 80, 20, 2, "<< Previous", "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + (pageLeft - 1) + ", " + pageRight + ");", "Goto previous page"));
            }
            strPage = "";
            int i = 0;
            j = (buyItems.size() - 1) / per;
            while (i <= j) {
                strPage = i == j ? String.valueOf(i + 1) : String.valueOf(String.valueOf(i + 1)) + ",";
                if (pageLeft == i) {
                    this.panel.add(new Drawable(260 + i * 20, 219, 18, 20, 2, strPage, "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + String.valueOf(i) + ", " + pageRight + ");", "Goto page " + String.valueOf(i + 1), this.fontBold, Color.RED));
                } else {
                    this.panel.add(new Drawable(260 + i * 20, 219, 18, 20, 2, strPage, "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + String.valueOf(i) + ", " + pageRight + ");", "Goto page " + String.valueOf(i + 1)));
                }
                ++i;
            }
            if (pageLeft < (buyItems.size() - 1) / per) {
                this.panel.add(new Drawable(260 + i * 20, 219, 80, 20, 2, "Next >>", "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + (pageLeft + 1) + ", " + pageRight + ");", "Goto next page"));
            }
        }
        Iterator iter = buyItems.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (++counter <= pageLeft * per || counter > pageLeft * per + per || counter >= buyItems.size() + 1) continue;
            p = this.traders.getBuyPrice(who, item.id);
            image = this.getImage(item.picture);
            this.panel.add(new Drawable(x + (47 - image.getWidth(this) / 2), y + (50 - image.getHeight(this) / 2), 70, 70, 3, image, "mf.gotoShop(\"" + who + "\", 1, \"" + item.id + "\", \"" + item.name + "\",  " + p + ", " + pageLeft + ", " + pageRight + ");", "Buy " + item.name + "\u00a7" + item.description + "\u00a7" + "Price: " + p + " silver dr"));
            if ((y += 100) <= 510) continue;
            x += 94;
            y = 250;
        }
        x = 550;
        y = 250;
        counter = 0;
        if (sellItems.size() > per) {
            strPage = "";
            int i = 0;
            j = 0;
            j = (sellItems.size() - 1) / per;
            while (i <= j) {
                strPage = i == j ? String.valueOf(i + 1) : String.valueOf(String.valueOf(i + 1)) + ",";
                if (pageRight == i) {
                    this.panel.add(new Drawable(910 - (j * 20 + 80) + i * 20, 219, 18, 20, 2, strPage, "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + pageLeft + ", " + String.valueOf(i) + ");", "Goto page " + String.valueOf(i + 1), this.fontBold, Color.RED));
                } else {
                    this.panel.add(new Drawable(910 - (j * 20 + 80) + i * 20, 219, 18, 20, 2, strPage, "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + pageLeft + ", " + String.valueOf(i) + ");", "Goto page " + String.valueOf(i + 1)));
                }
                ++i;
            }
            if (pageRight > 0) {
                this.panel.add(new Drawable(910 - (j * 20 + 180), 219, 80, 20, 2, "<< Previous", "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + pageLeft + ", " + (pageRight - 1) + ");", "Goto previous page"));
            }
            if (pageRight < (sellItems.size() - 1) / per) {
                this.panel.add(new Drawable(910 - (j * 20 + 80) + i * 20, 219, 80, 20, 2, "Next >>", "mf.gotoShop(\"" + who + "\", " + state + ", \"" + id + "\", \"" + name + "\", " + price + ", " + pageLeft + ", " + (pageRight + 1) + ");", "Goto next page"));
            }
        }
        iter = sellItems.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (++counter <= pageRight * per || counter > pageRight * per + per || counter >= sellItems.size() + 1) continue;
            p = this.traders.getSellPrice(who, item.id);
            image = this.getImage(item.picture);
            this.panel.add(new Drawable(x + (47 - image.getWidth(this) / 2), y + (50 - image.getHeight(this) / 2), 70, 70, 3, image, "mf.gotoShop(\"" + who + "\", 2, \"" + item.id + "\", \"" + item.name + "\",  " + p + ", " + pageLeft + ", " + pageRight + ");", "Sell " + item.name + "\u00a7" + item.description + "\u00a7" + "Price: " + p + " silver dr"));
            if ((y += 100) <= 510) continue;
            x += 94;
            y = 250;
        }
        if (state == 1) {
            buy = true;
            transaction = this.player.hasSold(id) ? "mf.player.buyItem(\"" + id + "\", " + price + ", \"" + who + "\");mf.gotoShop(\"" + who + "\", 0, \"\", \"\", 0, " + pageLeft + ", " + pageRight + ");" : "mf.player.buyItem(\"" + id + "\", " + price + ");mf.gotoShop(\"" + who + "\", 0, \"\", \"\", 0, " + pageLeft + ", " + pageRight + ");";
            if (id.equals("10310") || id.equals("10320") || id.equals("10330") || id.equals("10340") || id.equals("10350") || id.equals("10360")) {
                transaction = "mf.player.buyItem(\"" + id.substring(0, 4) + "5\", 0);" + transaction;
            }
            if (id.equals("10000") || id.equals("10050") || id.equals("10720")) {
                transaction = "mf.player.removeItem(\"10000\");mf.player.removeItem(\"10050\");mf.player.removeItem(\"10720\");" + transaction;
            }
        } else if (state == 2) {
            sell = true;
            transaction = id.equals("10100") || id.equals("10110") || id.equals("10120") || id.equals("10130") || id.equals("10200") || id.equals("10210") || id.equals("10220") || id.equals("10230") || id.equals("10310") || id.equals("10320") || id.equals("10330") || id.equals("10340") || id.equals("10350") || id.equals("10360") ? "mf.player.sellItem(\"" + id + "\", " + price + ");mf.gotoShop(\"" + who + "\", 0, \"\", \"\", 0, " + pageLeft + ", " + pageRight + ");" : "mf.player.sellItem(\"" + id + "\", " + price + ", \"" + who + "\");mf.gotoShop(\"" + who + "\", 0, \"\", \"\", 0, " + pageLeft + ", " + pageRight + ");";
            if (id.equals("10310") || id.equals("10320") || id.equals("10330") || id.equals("10340") || id.equals("10350") || id.equals("10360")) {
                transaction = "mf.player.removeItem(\"" + id.substring(0, 4) + "5\");" + transaction;
            }
            if (id.equals("10050") || id.equals("10720")) {
                transaction = "mf.player.buyItem(\"10000\");" + transaction;
            }
        }
        Drawable d = null;
        if (buy && this.player.money >= price) {
            d = new Drawable(390, 563, 300, 20, 2, "Buy " + name + " (Price: " + price + ")", transaction);
        } else if (buy) {
            d = new Drawable(390, 563, 300, 20, 2, "You cannot afford " + name, "res=false;");
        }
        if (sell) {
            d = new Drawable(390, 563, 300, 20, 2, "Sell " + name + " (Price: " + price + ")", transaction);
        }
        if (d != null) {
            d.x = 140 + width / 2 - d.textWidth / 2;
            this.panel.add(d);
        }
        this.panel.add(new Drawable(850, 570, 80, 20, 2, "Close", "mf.player.chooseFace();mf.gotoPlace(mf.player.place);"));
    }

    public void paintBattle(String who, int turn, int weapon, int enemyMight, String endTask) {
        try {
            int x = 150;
            int y = 100;
            int width = 760;
            int height = 500;
            boolean end = false;
            String endDo = "mf.gotoPlace(mf.player.place);";
            String abuLog = "Abu's actions:\u00a7";
            String enemyLog = "Actions for " + this.armies.getName(who) + ":\u00a7";
            this.panel.add(new Drawable(x, y, width, height, 12, this.getImage("logoIntro"), "Fighting against " + this.armies.getName(who) + " starting turn: " + turn));
            this.panel.add(new Drawable(x + 10, y + 10, 0, 0, 3, this.getImage(this.armies.getString(who, "Picture"))));
            this.panel.add(new Drawable(x + width - 110, y + 10, 0, 0, 3, this.getImage("abu")));
            this.panel.add(new Drawable(x + 50, y + 150, 0, 0, 3, this.getImage(this.armies.getString(who, "Soldier"))));
            this.panel.add(new Drawable(x + width - 150, y + 150, 0, 0, 3, this.getImage("abuSoldier")));
            int abu = (int)this.player.health;
            int enemy = enemyMight;
            Item item = new Item();
            if (this.player.hasItem("13000")) {
                item = this.market.getItem("13000");
                enemy -= item.force - this.nextInt / 10;
                abuLog = String.valueOf(abuLog) + "\u00a7- Your sword swings into action";
            } else if (this.player.hasItem("13010")) {
                item = this.market.getItem("13010");
                enemy -= item.force - this.nextInt / 10;
                abuLog = String.valueOf(abuLog) + "\u00a7- You struck with the dagger";
            }
            switch (weapon) {
                case 1: {
                    item = this.market.getItem("13010");
                    enemy -= item.force - this.nextInt / 10;
                    abuLog = String.valueOf(abuLog) + "\u00a7- You struck with the dagger";
                    break;
                }
                case 2: {
                    item = this.market.getItem("13000");
                    enemy -= item.force - this.nextInt / 10;
                    abuLog = String.valueOf(abuLog) + "\u00a7- Your sword swings into action";
                    break;
                }
                case 3: {
                    enemy -= 50 - this.nextInt / 10;
                    abuLog = String.valueOf(abuLog) + "\u00a7- The djinnies appear and attack the enemy";
                }
            }
            if (this.rB(99, 100)) {
                enemy -= 20 - this.nextInt / 10;
                abuLog = String.valueOf(abuLog) + "\u00a7- You get a critical strike!";
            } else if (this.rB(1, 2)) {
                abu -= 20 - this.nextInt / 10;
                enemyLog = String.valueOf(enemyLog) + "\u00a7- The enemy forces get strike a mighty blow!";
            }
            if (this.player.addictedHashish && this.rB(0, 25)) {
                --abu;
                abuLog = String.valueOf(abuLog) + "\u00a7- You are hampered by your addiction to hashish";
            } else if (this.player.addictedOpium && this.rB(0, 50)) {
                abu -= 3;
                abuLog = String.valueOf(abuLog) + "\u00a7- Your opium addiction causes you to lose your will to fight";
            } else if (this.player.sickPlague && this.rB(0, 75)) {
                abu -= 6;
                abuLog = String.valueOf(abuLog) + "\u00a7- The plague you are carrying hinders your battle greatly";
            }
            if (this.player.moral < -75 && this.rB(0, 75)) {
                abu += 10 - this.nextInt / 10;
                enemyLog = String.valueOf(enemyLog) + "\u00a7- Your vile deeds on the battlefield cause your foes to tremble";
            } else if (this.player.moral > 75 && this.rB(0, 75)) {
                abu += 10 - this.nextInt / 10;
                enemyLog = String.valueOf(enemyLog) + "\u00a7- Your good reputation preceeds you, some of the enemies soldiers abandon their foul cause";
            }
            Random r = new Random();
            int enemyHit = this.armies.getForce(who) + r.nextInt(10);
            int abuHit = this.player.force + r.nextInt(10);
            abu -= enemyHit;
            enemy -= abuHit;
            if (abuHit < 5) {
                abuLog = String.valueOf(abuLog) + "\u00a7- You barely scratch the enemy";
            } else if (abuHit >= 5 && abuHit < 15) {
                abuLog = String.valueOf(abuLog) + "\u00a7- You feebly hit the enemy";
            } else if (abuHit >= 15 && abuHit < 25) {
                abuLog = String.valueOf(abuLog) + "\u00a7- You hit the enemy";
            } else if (abuHit >= 25 && abuHit < 50) {
                abuLog = String.valueOf(abuLog) + "\u00a7- You hit the enemy hard";
            } else if (abuHit >= 50) {
                abuLog = String.valueOf(abuLog) + "\u00a7- You score a devastating hit";
            }
            if (enemyHit < 5) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- The enemy slaps you";
            } else if (enemyHit >= 5 && enemyHit < 15) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- You are slightly wounded by the enemy";
            } else if (enemyHit >= 15 && enemyHit < 25) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- The enemy hits you";
            } else if (enemyHit >= 25 && enemyHit < 50) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- You get a bad wound from the enemy";
            } else if (enemyHit >= 50) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- The enemy strikes you with enourmous power";
            }
            this.player.health = abu;
            if (enemy < 1) {
                enemyLog = String.valueOf(enemyLog) + "\u00a7- The enemy forces have been annihilated";
                abuLog = String.valueOf(abuLog) + "\u00a7- You won!";
                end = true;
                this.player.add(String.valueOf(who) + "won");
            }
            if (abu < 1) {
                if (enemy > 0) {
                    abuLog = String.valueOf(abuLog) + "\u00a7- You were defeated!";
                    endDo = "mf.gotoDeath(\"Abu was defeated in a battle that occurred the surroundings of " + this.player.nicecity + " against the forces of " + this.armies.getName(who) + ".\", 1);";
                } else {
                    abuLog = String.valueOf(abuLog) + "\u00a7- You were defeated!";
                    endDo = "mf.gotoDeath(\"Abu died in a glorious battle on the surroundings of " + this.player.nicecity + " while destroying the remnants of the forces of " + this.armies.getName(who) + ".\", 2);";
                }
                end = true;
            }
            Font statusFont = new Font("Arial", 0, 10);
            this.panel.add(new Drawable(x + 200, y + 150, 150, 200, 2, enemyLog, statusFont, Color.BLACK));
            this.panel.add(new Drawable(x + width - 350, y + 150, 150, 200, 2, abuLog, statusFont, Color.BLACK));
            String nextTurn = "mf.player.nextDay();mf.gotoBattle(\"" + who + "\", " + (turn + 1) + ", !weapon, " + enemy + ", \"" + endTask.replaceAll("\"", "\\\\\"") + "\");";
            if (!end) {
                this.player.inBattle = false;
                this.panel.add(new Drawable(810, 570, 80, 20, 2, "Next round", nextTurn.replaceAll("!weapon", "0")));
            } else {
                this.player.inBattle = false;
                if (!endTask.equals("")) {
                    this.panel.add(new Drawable(810, 570, 80, 20, 2, "End battle", "mf.sounds.loopMusic(mf.sounds.lastMusic);mf.player.chooseFace();" + endTask));
                } else if (!endDo.equals("")) {
                    this.panel.add(new Drawable(810, 570, 80, 20, 2, "End battle", "mf.sounds.loopMusic(mf.sounds.lastMusic);mf.player.chooseFace();" + endDo));
                } else {
                    this.panel.add(new Drawable(810, 570, 80, 20, 2, "End battle", "mf.sounds.loopMusic(mf.sounds.lastMusic);mf.player.chooseFace();mf.gotoPlace(mf.player.place);"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintMap(boolean showIcon) {
        try {
            this.objects.add(new Drawable(0, 0, this.getHeight(), this.getWidth(), 3, this.getImage(this.map.getBackground())));
            MapEntry entry = new MapEntry();
            Vector entries = this.map.getEntries(this.player.city, this.player.transport, this.player.hasItem("10630") && this.player.transport != 2);
            int i = 0;
            int j = entries.size();
            while (i < j) {
                entry = (MapEntry)entries.elementAt(i);
                this.objects.add(new Drawable(entry.x - 10, entry.y - 10, entry.width, entry.height, 3, this.getImage("pixel", true), null, entry.getAction(this.player.transport), "Go to " + entry.nice, entry.getDescription(this.player.transport), 0.0f, null, null));
                ++i;
            }
            Vector items = this.player.items;
            Item item = null;
            int y = this.getHeight() - 565;
            int x = 50;
            int i2 = 0;
            int j2 = items.size();
            while (i2 < j2) {
                item = (Item)items.elementAt(i2);
                if (item.isActive()) {
                    Image image = this.getImage(item.picture);
                    if (item.name.toLowerCase().equals(MapEntry.TRANSPORTS[this.player.transport])) {
                        image = this.getImage(item.picture.replaceAll(".png", "_active.png"));
                    }
                    this.objects.add(new Drawable(x - image.getWidth(this) / 2, y + (65 - image.getHeight(this) / 2), 75, 75, 3, image, item.action, String.valueOf(item.name) + "\u00a7" + item.description));
                    y += 65;
                }
                ++i2;
            }
            if (showIcon) {
                this.objects.add(new Drawable(this.player.xHomeCountry - 14, this.player.yHomeCountry - 14, 0, 0, 3, this.getImage("playerIcon", true)));
            }
            if (this.showStatus) {
                this.objects.add(new Drawable(this.getWidth() - 40, 10, 0, 0, 3, this.getImage("controls", true)));
                this.objects.add(new Drawable(this.getWidth() - 40, 88, 100, 19, 3, this.getImage("pixel", true), "mf.exit();", "Close"));
                this.objects.add(new Drawable(this.getWidth() - 40, 65, 100, 19, 3, this.getImage("pixel", true), "mf.save();", "Save"));
                this.objects.add(new Drawable(this.getWidth() - 40, 40, 100, 19, 3, this.getImage("pixel", true), "mf.load();", "Load"));
                this.objects.add(new Drawable(this.getWidth() - 40, 15, 100, 19, 3, this.getImage("pixel", true), "mf.setExtendedState(Frame.ICONIFIED);", "Minimize"));
                this.objects.add(new Drawable(this.getWidth() - 40, 111, 24, 19, 3, this.getImage("pixel", true), "mf.showStatus=false;mf.player.lastPlace=\"" + this.player.place + "\";mf.gotoPlace(\"menu\");", "Back to menu"));
                String helpid = "9239";
                if (helpid != null && !helpid.equals("")) {
                    this.objects.add(new Drawable(this.getWidth() - 39, 136, 100, 19, 3, this.getImage("questionMark", true), "mf.gotoStatus(3, \"" + helpid + "\", 0, 0, 0);", "Help about world map"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintGlass() {
        try {
            if (this.showStatus) {
                this.getImage("statusFace", this.player.statusFace, true, true);
                this.glass.add(new Drawable(20, this.getHeight() - 169, 155, 155, 0, this.getImage("statusFace", true), this.getImage("statusBar", true), "mf.gotoStatus(0, \"\", 0, 0, 0);", "Open status", "Open status", 0.0f, null, null));
                this.glass.add(new Drawable(386, this.getHeight() - 38, 100, 19, 2, String.valueOf(this.player.age) + " years", "res=false;", "Abu's age is " + this.player.day + " days " + this.player.month + " months " + this.player.age + " years", new Font("Arial", 1, 12), new Color(255, 0, 255)));
                if (!this.player.place.equals("highwaymen") && !this.player.place.equals("pirates")) {
                    this.glass.add(new Drawable(195, this.getHeight() - 100, 65, 60, 3, this.getImage("localMap", true), "mf.gotoPlace(\"" + this.player.city + "\");", "Go to map of " + this.places.getTitle(this.player.city)));
                    if (this.showMapGlobe) {
                        this.glass.add(new Drawable(265, this.getHeight() - 100, 60, 60, 3, this.getImage("globalMap", true), null, "mf.gotoMap();", "Go to map of the world"));
                    }
                }
                int y = 698;
                if (this.player.sickGeneral) {
                    this.glass.add(new Drawable(480, y += 10, 20, 20, 3, this.getImage("statusPlague", true), "mf.gotoStatus(3, \"5430\", 0, 0, 0);", "You are poisoned"));
                    if (!this.player.sickPlague && !this.player.sickPoisoned) {
                        y -= 40;
                    }
                }
                if (this.player.sickPoisoned) {
                    if (!this.player.sickGeneral) {
                        y += 10;
                    }
                    this.glass.add(new Drawable(480, y, 20, 20, 3, this.getImage("statusPlague", true), "mf.gotoStatus(3, \"5430\", 0, 0, 0);", "You are poisoned"));
                    if (!this.player.sickPlague) {
                        y -= 40;
                    }
                }
                if (this.player.sickPlague) {
                    if (!this.player.sickGeneral && !this.player.sickPoisoned) {
                        y += 10;
                    }
                    this.glass.add(new Drawable(480, y, 20, 20, 3, this.getImage("statusPlague", true), "mf.gotoStatus(3, \"5430\", 0, 0, 0);", "You have the plague"));
                    y -= 40;
                }
                if (this.player.addictedHashish) {
                    this.glass.add(new Drawable(473, y, 27, 27, 3, this.getImage("statusHashish", true), "mf.gotoStatus(3, \"3360\", 0, 0, 0);", "You are addicted to hashish"));
                    y -= 43;
                }
                if (this.player.addictedOpium) {
                    this.glass.add(new Drawable(479, y, 27, 27, 3, this.getImage("statusOpium", true), "mf.gotoStatus(3, \"3360\", 0, 0, 0);", "You are addicted to opium"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintPlace() {
        this.paintPlace(this.player.place);
    }

    public void paintPlace(String to) {
        try {
            this.objects.add(new Drawable(0, 0, this.getHeight(), this.getWidth(), 3, this.getImage(this.places.getBackground(to))));
            Spicebean sb = new Spicebean();
            Vector pictures = this.places.getPictures(to);
            int i = 0;
            int j = pictures.size();
            while (i < j) {
                sb = (Spicebean)pictures.elementAt(i);
                if (sb.isDoable()) {
                    this.objects.add(new Drawable(sb.x, sb.y, sb.width, sb.height, 3, this.getImage(sb.picture), sb.action, sb.name));
                } else {
                    this.objects.add(new Drawable(sb.x, sb.y, 0, 0, 3, this.getImage(sb.picture)));
                }
                ++i;
            }
            Vector items = this.player.items;
            Item item = null;
            int x = 25;
            int y = 25;
            int width = 0;
            int height = 0;
            int counter = 0;
            String picture = "";
            int i2 = 0;
            int j2 = items.size();
            while (i2 < j2) {
                item = (Item)items.elementAt(i2);
                if (item.isActive()) {
                    if (item.pictureBig == null || item.pictureBig.equals("")) {
                        picture = item.picture;
                        width = 55;
                        height = 55;
                    } else {
                        picture = item.pictureBig;
                        width = 100;
                        height = 100;
                    }
                    this.objects.add(new Drawable(x, y, width, height, 3, this.getImage(picture), item.action, String.valueOf(item.name) + "\u00a7" + item.description));
                    x += 75;
                    if (counter == 11) {
                        y += 90;
                        x = 25;
                    } else if (counter == 23) {
                        y += 90;
                        x = 25;
                    } else if (counter == 35) {
                        y += 90;
                        x = 25;
                    } else if (counter == 47) {
                        y += 90;
                        x = 25;
                    }
                    ++counter;
                }
                ++i2;
            }
            x = 210;
            Vector drawables = this.places.getDrawables(to);
            int i3 = 0;
            int j3 = drawables.size();
            while (i3 < j3) {
                this.objects.add(drawables.elementAt(i3));
                ++i3;
            }
            if (this.showStatus) {
                this.objects.add(new Drawable(this.getWidth() - 40, 10, 0, 0, 3, this.getImage("controls", true)));
                this.objects.add(new Drawable(this.getWidth() - 40, 88, 100, 19, 3, this.getImage("pixel", true), "if(mf.tools.askYesNo(mf, \"You are leaving the game, you will lose all unsaved information. Do you really want to exit?\"))mf.exit();", "Close"));
                this.objects.add(new Drawable(this.getWidth() - 40, 65, 100, 19, 3, this.getImage("pixel", true), "mf.save();", "Save"));
                this.objects.add(new Drawable(this.getWidth() - 40, 40, 100, 19, 3, this.getImage("pixel", true), "mf.load();", "Load"));
                this.objects.add(new Drawable(this.getWidth() - 40, 15, 100, 19, 3, this.getImage("pixel", true), "mf.setExtendedState(Frame.ICONIFIED);", "Minimize"));
                this.objects.add(new Drawable(this.getWidth() - 40, 111, 100, 19, 3, this.getImage("pixel", true), "mf.showStatus=false;mf.player.lastPlace=\"" + this.player.place + "\";mf.gotoPlace(\"menu\");", "Back to menu"));
                String helpid = this.places.getString(to, "Help");
                if (helpid != null && !helpid.equals("")) {
                    this.objects.add(new Drawable(this.getWidth() - 39, 136, 100, 19, 3, this.getImage("questionMark", true), "mf.gotoStatus(3, \"" + helpid + "\", 0, 0, 0);", "Help about " + this.player.nicecity));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintDialog() {
        this.paintDialog(0, 0);
    }

    public void paintDialog(int x, int y) {
        try {
            Vector actions = this.dialogs.getChoices(this.dialog);
            String idialog = "/pics/navigation/characters/" + this.dialogs.getTitle(this.dialog).toLowerCase().replaceAll(" ", "_") + ".png";
            Drawable d = new Drawable(x + 200, y + 56, this.getWidth() / 2 - 160, 150, 2, this.dialogs.getText(this.dialog));
            if (d.textVector.size() > 6) {
                this.panel.add(new Drawable(x + 20, y + 18, this.getWidth() - 70, 60 + d.textVector.size() * 18, 4, this.getImage(idialog), this.dialogs.getTitle(this.dialog)));
            } else if (actions.size() > 3) {
                this.panel.add(new Drawable(x + 20, y + 18, this.getWidth() - 70, 100 + (actions.size() + 1) * 20, 4, this.getImage(idialog), this.dialogs.getTitle(this.dialog)));
            } else {
                this.panel.add(new Drawable(x + 20, y + 18, this.getWidth() - 70, 155, 4, this.getImage(idialog), this.dialogs.getTitle(this.dialog)));
            }
            this.panel.add(d);
            int _y = y + 56;
            Spicebean sb = new Spicebean();
            int _x = 0;
            int i = actions.size();
            while (_x < i) {
                sb = (Spicebean)actions.elementAt(_x);
                d = new Drawable(x + this.getWidth() / 2 + 70, y + _y, 340, 30, 2, sb.name, sb.action);
                this.panel.add(d);
                _y += 16 * d.textVector.size() - 1;
                ++_x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintDiary(int page) {
        try {
            int y = 100;
            int x = 100;
            boolean counter = false;
            this.panel.add(new Drawable(150, 100, 760, 500, 4, this.getImage("/pics/navigation/abus/abu_dead2.png"), this.getImage(this.player.logo, true), "Your diary", Color.BLACK));
            Font statusFontBold = new Font("Arial", 1, 14);
            Font statusFont = new Font("Arial", 0, 14);
            Color color = Color.WHITE;
            Vector tasks = this.player.journal.tasks;
            String task = "";
            if (page == 0) {
                Image image = null;
                x = 327;
                y = 360;
                switch (this.player.deathType) {
                    case 1: {
                        image = this.getImage("/pics/bagdad/characters/dead001.png");
                        x = 420;
                        y = 280;
                        break;
                    }
                    case 2: {
                        image = this.getImage("/pics/bagdad/characters/dead003a.png");
                        x = 528;
                        y = 177;
                        break;
                    }
                    case 3: {
                        image = this.getImage("/pics/bagdad/characters/dead004.png");
                        x = 420;
                        y = 280;
                        break;
                    }
                    case 4: {
                        image = this.getImage("/pics/bagdad/characters/dead005.png");
                        x = 400;
                        y = 280;
                        break;
                    }
                    default: {
                        image = this.getImage("/pics/bagdad/characters/dead002.png");
                        x = 400;
                        y = 280;
                    }
                }
                this.panel.add(new Drawable(x, y, 0, 0, 3, image));
                Drawable d1 = new Drawable(585, 495, 460, 20, 2, this.player.lastWords, statusFontBold, color);
                d1.x -= d1.textWidth / 2;
                this.panel.add(d1);
            } else {
                task = (String)tasks.elementAt(page - 1);
                int when = Integer.parseInt((String)this.player.journal.timestamp.get(task));
                int year = when / 360 + 17 - 500;
                String time = ", age of " + year;
                Image image = this.getImage(this.player.journal.getPicture(task));
                String taskText = this.player.journal.getString(task, "Endtext");
                String taskTasks = this.player.journal.get(task);
                this.panel.add(new Drawable(582 - image.getWidth(this) / 2, 350 - image.getHeight(this) / 2, 0, 0, 3, image));
                Drawable d1 = new Drawable(585, 515, 460, 20, 2, String.valueOf(this.player.journal.getString(task, "Display")) + time, statusFontBold, color);
                d1.x -= d1.textWidth / 2;
                this.panel.add(d1);
                Drawable d2 = new Drawable(585, 540, 460, 380, 2, taskText, statusFont, color);
                d2.x -= d2.textWidth / 2;
                this.panel.add(d2);
            }
            if (page > 0) {
                this.panel.add(new Drawable(170, 570, 120, 20, 2, "<< PREVIOUS", "mf.gotoDiary(" + (page - 1) + ");", statusFontBold, color));
            }
            this.panel.add(new Drawable(540, 570, 120, 20, 2, "END GAME", "boolean p = mf.sounds.musicOn;mf.sounds.musicOn=false;mf.player = new Player();mf.sounds.musicOn=p;mf.sounds.loopMusic(\"/music/16_world_horizon.ogg\");mf.gotoPlace(\"menu\");", statusFontBold, color));
            if (page < this.player.journal.tasksClosed.size()) {
                this.panel.add(new Drawable(840, 570, 120, 20, 2, "NEXT >>", "mf.gotoDiary(" + (page + 1) + ");", statusFontBold, color));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paintConverter(String back) {
        this.paintConverter(back, -1, 0, 0);
    }

    public void paintConverter(String back, int number, int action, int total) {
        int x = 165;
        int y = 280;
        int width = 220;
        int height = 290;
        int newTotal = total;
        Font statusFontBold = new Font("Arial", 1, 11);
        Font statusFont = new Font("Arial", 0, 10);
        if (number > -1) {
            newTotal = Integer.parseInt(String.valueOf(String.valueOf(total)) + String.valueOf(number));
        }
        if (action == 1) {
            newTotal = -newTotal;
        }
        this.panel.add(new Drawable(x, y, width, height, 4, null, null, null, "Hijra converter", null, 1.0f, null, Color.WHITE));
        this.panel.add(new Drawable(x + width - 20, y + 10, 20, 20, 2, "X", "mf.converter=0;" + back, "Close converter", statusFontBold, Color.BLACK));
        this.panel.add(new Drawable(x + 40, y + 18, 140, 20, 2, "CALENDAR CONVERTER", statusFontBold, Color.BLACK));
        this.panel.add(new Drawable(x + 43, y + 45, 120, 108, 3, this.getImage("/pics/objects/converter.png")));
        this.panel.add(new Drawable(x + width - 70, y + 190, 40, 20, 2, "CLEAR", "mf.paintConverter(\"" + back.replaceAll("\"", "\\\\\"") + "\", -1, 0, 0);", "Clear converter", statusFont, Color.BLACK));
        this.panel.add(new Drawable(x + 26, y + 183, 50, 20, 2, "+/-", "mf.paintConverter(\"" + back.replaceAll("\"", "\\\\\"") + "\", -1, 1, " + String.valueOf(newTotal) + ");", "Change year to positive/negative", statusFontBold, Color.BLACK));
        int _x = x - 25 + 85;
        int _y = y + 138;
        Color color = Color.BLACK;
        int counter = 0;
        int i = 1;
        while (i < 11) {
            color = i == number ? Color.RED : Color.BLACK;
            if (i < 10) {
                this.panel.add(new Drawable(_x += 20, _y, 13, 15, 2, String.valueOf(i), "mf.paintConverter(\"" + back.replaceAll("\"", "\\\\\"") + "\", " + String.valueOf(i) + ", 0, " + String.valueOf(newTotal) + ");", String.valueOf(i), statusFontBold, color));
            } else {
                this.panel.add(new Drawable(_x += 40, _y, 13, 15, 2, "0", "mf.paintConverter(\"" + back.replaceAll("\"", "\\\\\"") + "\", 0, 0, " + String.valueOf(newTotal) + ");", "0", statusFontBold, color));
            }
            if (counter++ > 1) {
                _x = x - 25 + 85;
                _y += 15;
                counter = 0;
            }
            ++i;
        }
        int ah = newTotal - Math.round((float)newTotal / 33.0f) + 622;
        int gre = newTotal - 622 + Math.round((float)(newTotal - 622) / 32.0f);
        String greStr = "AC";
        String ahStr = "AH";
        String greStr2 = "AC";
        String ahStr2 = "AH";
        if (gre < 0) {
            ahStr = "BH";
        }
        if (ah < 0) {
            greStr = "BC";
        }
        if (newTotal < 0) {
            ahStr2 = "BH";
        }
        if (newTotal < 0) {
            greStr2 = "BC";
        }
        this.panel.add(new Drawable(x + 40, y + 220, 300, 100, 2, "Hijra years to gregorian years", statusFont, Color.BLACK));
        this.panel.add(new Drawable(x + 70, y + 235, 300, 100, 2, String.valueOf(newTotal) + " " + ahStr2 + " = " + ah + " " + greStr, statusFont, Color.BLACK));
        this.panel.add(new Drawable(x + 40, y + 255, 300, 100, 2, "Gregorian years to Hijra years", statusFont, Color.BLACK));
        this.panel.add(new Drawable(x + 70, y + 270, 300, 100, 2, String.valueOf(newTotal) + " " + greStr2 + " = " + gre + " " + ahStr, statusFont, Color.BLACK));
        this.doLayout();
        this.repaint();
    }

    public void paintStatus(int state, String id, int page, int from, int more) {
        try {
            int _y = 0;
            String[] title = new String[]{"Status", "Inventory", "Diary", "Help", "Log", "DEATH!", "Culture"};
            this.panel.add(new Drawable(150, 100, 760, 500, 4, this.getImage("statusFace", true), this.getImage(this.player.logo, true), title[state]));
            Font statusFontBold = new Font("Arial", 1, 12);
            Font statusFont = new Font("Arial", 0, 10);
            if (state != 3) {
                this.panel.add(new Drawable(410, 210, 300, 20, 2, this.player.get("Name"), statusFontBold, Color.BLACK));
                this.panel.add(new Drawable(410, 240, 300, 20, 2, "date and place of born", statusFont, Color.BLACK));
                this.panel.add(new Drawable(594, 240, 300, 20, 2, this.player.get("dateAndPlace"), statusFont, Color.BLACK));
                Drawable wd = new Drawable(594, 255, 300, 20, 2, this.player.get("wifes"), statusFont, Color.BLACK);
                int wifes = wd.textVector.size();
                if (wifes > 1) {
                    this.panel.add(new Drawable(410, 255, 300, 20, 2, "wives", statusFont, Color.BLACK));
                } else {
                    this.panel.add(new Drawable(410, 255, 300, 20, 2, "wife", statusFont, Color.BLACK));
                }
                if (!this.player.get("wifes").equals("")) {
                    this.panel.add(wd);
                } else {
                    this.panel.add(new Drawable(594, 255, 300, 20, 2, "none", statusFont, Color.BLACK));
                }
                this.panel.add(new Drawable(410, 257 + wifes * 9, 300, 20, 2, "children", statusFont, Color.BLACK));
                if (!this.player.get("children").equals("")) {
                    this.panel.add(new Drawable(594, 257 + wifes * 9, 300, 20, 2, this.player.get("children"), statusFont, Color.BLACK));
                } else {
                    this.panel.add(new Drawable(594, 257 + wifes * 9, 300, 20, 2, "none", statusFont, Color.BLACK));
                }
                this.panel.add(new Drawable(177, 280, 200, 20, 2, "MONEY", statusFontBold, Color.BLACK));
                this.panel.add(new Drawable(177, 300, 200, 20, 2, String.valueOf(String.valueOf(this.player.money)) + " silver dirhams", statusFont, Color.BLACK));
            }
            block1 : switch (state) {
                default: {
                    break;
                }
                case 0: {
                    Image image;
                    Item item;
                    Image image2;
                    Item item2;
                    Image image3;
                    Item item3;
                    Image image4;
                    Item item4;
                    Image image5;
                    Item item5;
                    int increment = 20;
                    int y = 370;
                    boolean foundp = false;
                    this.panel.add(new Drawable(177, y - 30, 300, 20, 2, "PROPERTY", statusFontBold, Color.BLACK));
                    this.panel.add(new Drawable(177, y, 300, 20, 2, "- lands", statusFont, Color.BLACK));
                    int x = 253;
                    String[] lands = new String[]{"12050", "14000", "14005", "14010", "14015", "14020", "14025", "14030", "14035", "14040", "14045"};
                    int i = 0;
                    int j = lands.length;
                    while (i < j) {
                        if (this.player.hasItem(lands[i], 1, false)) {
                            Item item6 = this.market.getItem(lands[i]);
                            Image image6 = this.getImage(item6.pictureStatus);
                            this.panel.add(new Drawable(x, y - 5, 20, 25, 3, image6, "mf.gotoStatus(3,\"" + item6.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item6.name) + "\u00a7" + item6.description));
                            x += increment;
                        }
                        ++i;
                    }
                    String[] spices = new String[]{"10110", "10100", "10120", "10130", "10210", "10200", "10220", "10230"};
                    x = 253;
                    int i2 = 0;
                    int j2 = spices.length;
                    while (i2 < j2) {
                        if (this.player.hasItem(spices[i2], 1, false)) {
                            Item item7 = this.market.getItem(spices[i2]);
                            Image image7 = this.getImage(item7.pictureStatus);
                            this.panel.add(new Drawable(x, y + 22, 20, 25, 3, image7, "mf.gotoStatus(3,\"" + item7.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item7.name) + "\u00a7" + item7.description));
                            x += increment;
                            foundp = true;
                        }
                        ++i2;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(177, y + 30, 300, 20, 2, "- spices", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] art1 = new String[]{"10800", "10801", "10802", "10803", "10804", "10805"};
                    String[] art2 = new String[]{"10810", "10811", "10812"};
                    String[] art3 = new String[]{"10820"};
                    String[] art4 = new String[]{"10830", "10831"};
                    x = 253;
                    int i3 = 0;
                    int j3 = art1.length;
                    while (i3 < j3) {
                        if (this.player.hasItem(art1[i3], 1, false)) {
                            item5 = this.market.getItem(art1[i3]);
                            image5 = this.getImage(item5.pictureStatus);
                            this.panel.add(new Drawable(x, y + 53, 20, 25, 3, image5, "mf.gotoStatus(3,\"" + item5.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item5.name) + "\u00a7" + item5.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    j3 = art2.length;
                    while (i3 < j3) {
                        if (this.player.hasItem(art2[i3], 1, false)) {
                            item5 = this.market.getItem(art2[i3]);
                            image5 = this.getImage(item5.pictureStatus);
                            this.panel.add(new Drawable(x, y + 53, 20, 25, 3, image5, "mf.gotoStatus(3,\"" + item5.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item5.name) + "\u00a7" + item5.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    j3 = art3.length;
                    while (i3 < j3) {
                        if (this.player.hasItem(art3[i3], 1, false)) {
                            item5 = this.market.getItem(art3[i3]);
                            image5 = this.getImage(item5.pictureStatus);
                            this.panel.add(new Drawable(x, y + 53, 20, 25, 3, image5, "mf.gotoStatus(3,\"" + item5.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item5.name) + "\u00a7" + item5.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    j3 = art4.length;
                    while (i3 < j3) {
                        if (this.player.hasItem(art4[i3], 1, false)) {
                            item5 = this.market.getItem(art4[i3]);
                            image5 = this.getImage(item5.pictureStatus);
                            this.panel.add(new Drawable(x, y + 53, 20, 25, 3, image5, "mf.gotoStatus(3,\"" + item5.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item5.name) + "\u00a7" + item5.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i3;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(177, y + 60, 300, 20, 2, "- works of art", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] treasures1 = new String[]{"11600", "11601", "11602", "11603", "11604"};
                    String[] treasures2 = new String[]{"11610", "11611"};
                    String[] treasures3 = new String[]{"11620"};
                    String[] treasures4 = new String[]{"11630"};
                    String[] treasures5 = new String[]{"11640"};
                    String[] treasures6 = new String[]{"11650", "11651", "11652", "11660", "11661"};
                    String[] treasures7 = new String[]{"11670", "11671", "11672", "11673"};
                    String[] treasures8 = new String[]{"11680", "11680"};
                    x = 253;
                    int i4 = 0;
                    int j4 = treasures1.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures1[i4], 1, false)) {
                            item4 = this.market.getItem(treasures1[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures2.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures2[i4], 1, false)) {
                            item4 = this.market.getItem(treasures2[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures3.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures3[i4], 1, false)) {
                            item4 = this.market.getItem(treasures3[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures4.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures4[i4], 1, false)) {
                            item4 = this.market.getItem(treasures4[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures5.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures5[i4], 1, false)) {
                            item4 = this.market.getItem(treasures5[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures6.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures6[i4], 1, false)) {
                            item4 = this.market.getItem(treasures6[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures7.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures7[i4], 1, false)) {
                            item4 = this.market.getItem(treasures7[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    i4 = 0;
                    j4 = treasures8.length;
                    while (i4 < j4) {
                        if (this.player.hasItem(treasures8[i4], 1, false)) {
                            item4 = this.market.getItem(treasures8[i4]);
                            image4 = this.getImage(item4.pictureStatus);
                            this.panel.add(new Drawable(x, y + 82, 20, 25, 3, image4, "mf.gotoStatus(3,\"" + item4.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item4.name) + "\u00a7" + item4.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i4;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(177, y + 90, 300, 20, 2, "- treasures", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] luxury1 = new String[]{"10720"};
                    String[] luxury2 = new String[]{"10750", "10751"};
                    String[] luxury3 = new String[]{"10730", "10731", "10732", "10733"};
                    String[] luxury4 = new String[]{"10760"};
                    String[] luxury5 = new String[]{"10770"};
                    String[] luxury6 = new String[]{"10710"};
                    String[] luxury7 = new String[]{"10740", "10741", "10742", "10743", "10744", "10745"};
                    x = 253;
                    int i5 = 0;
                    int j5 = luxury1.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury1[i5], 1, false)) {
                            item3 = this.market.getItem(luxury1[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury2.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury2[i5], 1, false)) {
                            item3 = this.market.getItem(luxury2[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury3.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury3[i5], 1, false)) {
                            item3 = this.market.getItem(luxury3[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury4.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury4[i5], 1, false)) {
                            item3 = this.market.getItem(luxury4[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury5.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury5[i5], 1, false)) {
                            item3 = this.market.getItem(luxury5[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury6.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury6[i5], 1, false)) {
                            item3 = this.market.getItem(luxury6[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    i5 = 0;
                    j5 = luxury7.length;
                    while (i5 < j5) {
                        if (this.player.hasItem(luxury7[i5], 1, false)) {
                            item3 = this.market.getItem(luxury7[i5]);
                            image3 = this.getImage(item3.pictureStatus);
                            this.panel.add(new Drawable(x, y + 112, 20, 25, 3, image3, "mf.gotoStatus(3,\"" + item3.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item3.name) + "\u00a7" + item3.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i5;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(177, y + 120, 300, 20, 2, "- luxury", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] buildings1 = new String[]{"12000", "12001", "12002", "12003", "12004"};
                    String[] buildings2 = new String[]{"12060", "12061", "12062", "12063", "12064", "12065", "12066", "12067", "12068", "12069", "12070"};
                    String[] buildings3 = new String[]{"12080", "12081", "12082", "12083", "12084", "12085", "12086", "12087", "12088", "12089", "12090"};
                    String[] buildings4 = new String[]{"12030"};
                    String[] buildings5 = new String[]{"12010"};
                    String[] buildings6 = new String[]{"12020"};
                    String[] buildings7 = new String[]{"12040"};
                    x = 253;
                    int i6 = 0;
                    int j6 = buildings1.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings1[i6], 1, false)) {
                            item2 = this.market.getItem(buildings1[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings2.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings2[i6], 1, false)) {
                            item2 = this.market.getItem(buildings2[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings3.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings3[i6], 1, false)) {
                            item2 = this.market.getItem(buildings3[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings4.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings4[i6], 1, false)) {
                            item2 = this.market.getItem(buildings4[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings5.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings5[i6], 1, false)) {
                            item2 = this.market.getItem(buildings5[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings6.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings6[i6], 1, false)) {
                            item2 = this.market.getItem(buildings6[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    j6 = buildings7.length;
                    while (i6 < j6) {
                        if (this.player.hasItem(buildings7[i6], 1, false)) {
                            item2 = this.market.getItem(buildings7[i6]);
                            image2 = this.getImage(item2.pictureStatus);
                            this.panel.add(new Drawable(x, y + 143, 20, 25, 3, image2, "mf.gotoStatus(3,\"" + item2.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item2.name) + "\u00a7" + item2.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i6;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(177, y + 150, 300, 20, 2, "- buildings", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] licenses1 = new String[]{"10600", "10610"};
                    String[] licenses2 = new String[]{"10620"};
                    String[] licenses3 = new String[]{"10630"};
                    String[] licenses4 = new String[]{"10640"};
                    String[] licenses5 = new String[]{"10650", "10651", "10652", "10653", "10654", "10655", "10656", "10657", "10658", "10659", "10660"};
                    increment = 40;
                    x = 450;
                    int i7 = 0;
                    int j7 = licenses1.length;
                    while (i7 < j7) {
                        if (this.player.hasItem(licenses1[i7], 1, false)) {
                            item = this.market.getItem(licenses1[i7]);
                            image = this.getImage(item.pictureStatus);
                            this.panel.add(new Drawable(x, y - 10, 40, 40, 3, image, "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i7;
                    }
                    i7 = 0;
                    j7 = licenses2.length;
                    while (i7 < j7) {
                        if (this.player.hasItem(licenses2[i7], 1, false)) {
                            item = this.market.getItem(licenses2[i7]);
                            image = this.getImage(item.pictureStatus);
                            this.panel.add(new Drawable(x, y - 10, 40, 40, 3, image, "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i7;
                    }
                    i7 = 0;
                    j7 = licenses3.length;
                    while (i7 < j7) {
                        if (this.player.hasItem(licenses3[i7], 1, false)) {
                            item = this.market.getItem(licenses3[i7]);
                            image = this.getImage(item.pictureStatus);
                            this.panel.add(new Drawable(x, y - 10, 40, 40, 3, image, "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i7;
                    }
                    i7 = 0;
                    j7 = licenses4.length;
                    while (i7 < j7) {
                        if (this.player.hasItem(licenses4[i7], 1, false)) {
                            item = this.market.getItem(licenses4[i7]);
                            image = this.getImage(item.pictureStatus);
                            this.panel.add(new Drawable(x, y - 10, 40, 40, 3, image, "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i7;
                    }
                    i7 = 0;
                    j7 = licenses5.length;
                    while (i7 < j7) {
                        if (this.player.hasItem(licenses5[i7], 1, false)) {
                            item = this.market.getItem(licenses5[i7]);
                            image = this.getImage(item.pictureStatus);
                            this.panel.add(new Drawable(x, y - 10, 40, 40, 3, image, "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                            x += increment;
                            foundp = true;
                            break;
                        }
                        ++i7;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(460, y - 30, 300, 20, 2, "LICENSES", statusFontBold, Color.BLACK));
                    }
                    foundp = false;
                    String[] maps = new String[]{"11500", "11510", "11520", "11530"};
                    x = 450;
                    int i8 = 0;
                    int j8 = maps.length;
                    while (i8 < j8) {
                        if (this.player.hasItem(maps[i8], 1, false)) {
                            Item item8 = this.market.getItem(maps[i8]);
                            Image image8 = this.getImage(item8.pictureStatus);
                            this.panel.add(new Drawable(x, y + 60, 40, 40, 3, image8, "mf.gotoStatus(3,\"" + item8.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item8.name) + "\u00a7" + item8.description));
                            x += increment;
                            foundp = true;
                        }
                        ++i8;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(460, y + 40, 300, 20, 2, "MAPS", statusFontBold, Color.BLACK));
                    }
                    foundp = false;
                    String[] workers = new String[]{"16000", "16010", "16020", "16030"};
                    x = 450;
                    int i9 = 0;
                    int j9 = workers.length;
                    while (i9 < j9) {
                        if (this.player.hasItem(workers[i9], 1, false)) {
                            Item item9 = this.market.getItem(workers[i9]);
                            Image image9 = this.getImage(item9.pictureStatus);
                            this.panel.add(new Drawable(x, y + 130, 40, 40, 3, image9, "mf.gotoStatus(3,\"" + item9.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item9.name) + "\u00a7" + item9.description));
                            x += increment;
                            foundp = true;
                        }
                        ++i9;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(460, y + 110, 300, 20, 2, "WORKERS", statusFontBold, Color.BLACK));
                    }
                    foundp = false;
                    boolean foundsuperp = false;
                    String[] amulets = new String[]{"11000", "11001", "11002", "11003", "11004", "11005", "11010", "11011", "11012", "11013", "11014", "11015"};
                    x = 723;
                    increment = 13;
                    int i10 = 0;
                    int j10 = amulets.length;
                    while (i10 < j10) {
                        if (this.player.hasItem(amulets[i10], 1, false)) {
                            Item item10 = this.market.getItem(amulets[i10]);
                            Image image10 = this.getImage(item10.pictureStatus);
                            this.panel.add(new Drawable(x, y - 6, 10, 20, 3, image10, "mf.gotoStatus(3,\"" + item10.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item10.name) + "\u00a7" + item10.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i10;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(652, y, 300, 20, 2, "- amulets", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] drinks = new String[]{"11030", "11031", "11040"};
                    x = 723;
                    int i11 = 0;
                    int j11 = drinks.length;
                    while (i11 < j11) {
                        if (this.player.hasItem(drinks[i11], 1, false)) {
                            Item item11 = this.market.getItem(drinks[i11]);
                            Image image11 = this.getImage(item11.pictureStatus);
                            this.panel.add(new Drawable(x, y + 24, 10, 20, 3, image11, "mf.gotoStatus(3,\"" + item11.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item11.name) + "\u00a7" + item11.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i11;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(652, y + 30, 300, 20, 2, "- drinks", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] buckles = new String[]{"11050", "11051", "11052", "11053", "11054", "11055", "11056"};
                    x = 723;
                    increment = 20;
                    int i12 = 0;
                    int j12 = buckles.length;
                    while (i12 < j12) {
                        if (this.player.hasItem(buckles[i12], 1, false)) {
                            Item item12 = this.market.getItem(buckles[i12]);
                            Image image12 = this.getImage(item12.pictureStatus);
                            this.panel.add(new Drawable(x, y + 54, 13, 22, 3, image12, "mf.gotoStatus(3,\"" + item12.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item12.name) + "\u00a7" + item12.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i12;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(652, y + 60, 300, 20, 2, "- buckles", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] rosary = new String[]{"11020", "11025"};
                    x = 723;
                    increment = 50;
                    int i13 = 0;
                    int j13 = rosary.length;
                    while (i13 < j13) {
                        if (this.player.hasItem(rosary[i13], 1, false)) {
                            Item item13 = this.market.getItem(rosary[i13]);
                            Image image13 = this.getImage(item13.pictureStatus);
                            this.panel.add(new Drawable(x, y + 87, 60, 50, 3, image13, "mf.gotoStatus(3,\"" + item13.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item13.name) + "\u00a7" + item13.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i13;
                    }
                    if (foundp) {
                        if (this.player.hasItem("11020")) {
                            this.panel.add(new Drawable(652, y + 90, 300, 20, 2, "- rosary", statusFont, Color.BLACK));
                        } else {
                            this.panel.add(new Drawable(652, y + 90, 300, 20, 2, "- talisman", statusFont, Color.BLACK));
                        }
                    }
                    foundp = false;
                    String[] flying = new String[]{"10335", "10345", "10355"};
                    x = 723;
                    increment = 50;
                    int i14 = 0;
                    int j14 = flying.length;
                    while (i14 < j14) {
                        if (this.player.hasItem(flying[i14], 1, false)) {
                            Item item14 = this.market.getItem(flying[i14]);
                            Image image14 = this.getImage(item14.pictureStatus);
                            this.panel.add(new Drawable(x, y + 105, 60, 50, 3, image14, "mf.gotoStatus(3,\"" + item14.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item14.name) + "\u00a7" + item14.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i14;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(652, y + 120, 300, 20, 2, "- flying", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    String[] others = new String[]{"11700", "13000"};
                    x = 723;
                    increment = 40;
                    int i15 = 0;
                    int j15 = others.length;
                    while (i15 < j15) {
                        if (this.player.hasItem(others[i15], 1, false)) {
                            Item item15 = this.market.getItem(others[i15]);
                            Image image15 = this.getImage(item15.pictureStatus);
                            this.panel.add(new Drawable(x, y + 150, 60, 50, 3, image15, "mf.gotoStatus(3,\"" + item15.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item15.name) + "\u00a7" + item15.description));
                            x += increment;
                            foundsuperp = true;
                            foundp = true;
                        }
                        ++i15;
                    }
                    if (foundp) {
                        this.panel.add(new Drawable(652, y + 150, 300, 20, 2, "- others", statusFont, Color.BLACK));
                    }
                    foundp = false;
                    if (!foundsuperp) break;
                    this.panel.add(new Drawable(652, y - 30, 300, 20, 2, "SUPERNATURAL", statusFontBold, Color.BLACK));
                    break;
                }
                case 1: {
                    int _x = 150;
                    int per = 16;
                    Item item = null;
                    Vector inventory = this.player.getInventory();
                    int i = page * per;
                    int j = inventory.size() - 1;
                    if (j >= per) {
                        if (page > 0) {
                            this.panel.add(new Drawable(190, 340, 80, 20, 2, "<< Previous", "mf.gotoStatus(1, \"\", " + String.valueOf(page - 1) + ", " + state + ", 0);", "Goto previous page"));
                        }
                        if ((j = (page + 1) * per - 1) > inventory.size()) {
                            j = inventory.size();
                        }
                        int k = 0;
                        String strPage = "";
                        _y = 312;
                        int l = (inventory.size() - 1) / per;
                        while (k <= l) {
                            strPage = k == l ? String.valueOf(k + 1) : String.valueOf(String.valueOf(k + 1)) + ",";
                            if (page == k) {
                                this.panel.add(new Drawable(290 + k * 20, 340, 18, 20, 2, strPage, "mf.gotoStatus(1, \"\", " + String.valueOf(k) + ", " + state + ", 0);", "Goto page " + String.valueOf(k + 1), this.fontBold, Color.RED));
                            } else {
                                this.panel.add(new Drawable(290 + k * 20, 340, 18, 20, 2, strPage, "mf.gotoStatus(1, \"\", " + String.valueOf(k) + ", " + state + ", 0);", "Goto page " + String.valueOf(k + 1)));
                            }
                            ++k;
                        }
                        if (page < (inventory.size() - 1) / per) {
                            this.panel.add(new Drawable(290 + k * 20, 340, 80, 20, 2, "Next >>", "mf.gotoStatus(1, \"\", " + String.valueOf(page + 1) + ", " + state + ", 0);", "Goto next page"));
                        }
                    }
                    _y = 360;
                    if (inventory.size() >= per && page != inventory.size() / per || page == 0 && inventory.size() != per) {
                        ++j;
                    }
                    int l = i;
                    while (l < j) {
                        if (_y > 500) {
                            _x += 94;
                            _y = 360;
                        }
                        item = (Item)inventory.get(l);
                        Image image = this.getImage(item.picture);
                        ++i;
                        this.panel.add(new Drawable(_x + (47 - image.getWidth(this) / 2), _y + (50 - image.getHeight(this) / 2), 70, 70, 3, this.getImage(item.picture), "mf.gotoStatus(3,\"" + item.helpId + "\", " + page + ", " + state + ", 0);", String.valueOf(item.name) + "\u00a7" + item.description));
                        _y += 100;
                        ++l;
                    }
                    break;
                }
                case 2: {
                    int increment = 20;
                    int y = 370;
                    this.panel.add(new Drawable(177, y - 30, 300, 20, 2, "OPEN QUESTS", statusFontBold, Color.BLACK));
                    Enumeration tasks = this.player.journal.tasksOpen.keys();
                    String task = "";
                    String additional = "";
                    int counter = 0;
                    int x = 177;
                    while (tasks.hasMoreElements()) {
                        task = (String)tasks.nextElement();
                        if (task == null) continue;
                        additional = this.player.journal.get(task);
                        if (!additional.equals("") && additional.charAt(0) == '!') {
                            additional = additional.indexOf("\u00a7") == -1 ? "" : additional.substring(additional.indexOf("\u00a7"), additional.length());
                        }
                        if (this.player.journal.getString(task, "Display") != null && this.player.journal.getString(task, "Text") != null) {
                            this.panel.add(new Drawable(x, y, 180, 20, 2, this.player.journal.getString(task, "Display"), "res=false;", String.valueOf(this.player.journal.getString(task, "Text")) + additional, statusFont, Color.BLACK));
                        }
                        y += increment;
                        if (++counter != 9) continue;
                        y = 370;
                        x += 180;
                    }
                    increment = 20;
                    y = 370;
                    counter = 0;
                    x = 450;
                    this.panel.add(new Drawable(450, y - 30, 300, 20, 2, "QUESTS DONE", statusFontBold, Color.BLACK));
                    if (this.player.journal.tasksClosed.size() > 18 + more) {
                        this.panel.add(new Drawable(750, y - 30, 300, 20, 2, "MORE >>", "mf.gotoStatus(" + state + ", \"\", " + page + ", " + from + ", " + (more + 18) + ");", statusFontBold, Color.BLACK));
                    }
                    if (more > 0) {
                        this.panel.add(new Drawable(650, y - 30, 300, 20, 2, "<< LESS", "mf.gotoStatus(" + state + ", \"\", " + page + ", " + from + ", " + (more - 18) + ");", statusFontBold, Color.BLACK));
                    }
                    tasks = this.player.journal.tasksClosed.keys();
                    task = "";
                    int looper = 0;
                    while (tasks.hasMoreElements()) {
                        task = (String)tasks.nextElement();
                        if (looper >= more) {
                            this.panel.add(new Drawable(x, y, 180, 20, 2, this.player.journal.getString(task, "Display"), "res=false;", String.valueOf(this.player.journal.getString(task, "Text")) + this.player.journal.get(task), statusFont, Color.BLACK));
                            y += increment;
                            if (++counter == 9) {
                                y = 370;
                                x += 180;
                            } else if (counter == 18) break;
                        }
                        ++looper;
                    }
                    int amount = Integer.parseInt("12");
                    break;
                }
                case 3: {
                    if (id.equals("")) {
                        String[] alphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
                        Vector helps = this.market.getHelp(alphabet[more]);
                        Color hcolor = Color.BLACK;
                        int k = 0;
                        int l = alphabet.length;
                        while (k < l) {
                            hcolor = k == more ? Color.RED : Color.BLACK;
                            this.panel.add(new Drawable(190 + k * 27, 310, 15, 15, 2, alphabet[k], "mf.gotoStatus(" + state + ", \"\", " + page + ", " + from + ", " + String.valueOf(k) + ");", "Show help for letter " + alphabet[k], statusFontBold, hcolor));
                            ++k;
                        }
                        _y = 340;
                        int _x = 177;
                        Iterator iter = helps.iterator();
                        while (iter.hasNext()) {
                            Item help = (Item)iter.next();
                            this.panel.add(new Drawable(_x, _y, 230, 20, 2, help.name, "mf.gotoStatus(" + state + ", \"" + help.id + "\", " + page + ", " + state + ", 0);", statusFontBold, Color.BLACK));
                            if ((_y += 30) > 530) {
                                _y = 340;
                                _x += 190;
                            }
                            if (_x > 750) break block1;
                        }
                        break;
                    }
                    Item item = this.market.getItem(id);
                    Image image = this.getImage(item.pictureBig);
                    this.panel.add(new Drawable(275 - image.getWidth(this) / 2, 419 - image.getHeight(this) / 2, 0, 0, 3, image));
                    this.panel.add(new Drawable(410, 210, 460, 20, 2, item.name, this.fontBold, Color.BLACK));
                    Drawable d = new Drawable(410, 240, 460, 380, 2, item.description);
                    String str = "mf.converter=mf.panel.size();mf.paintConverter(\"mf.gotoStatus(" + state + ", \\\"" + id + "\\\", " + page + ", " + from + ", " + more + ");\");";
                    this.panel.add(new Drawable(750, 529, 120, 20, 2, "Calendar converter", str));
                    if (d.textVector.size() > 15 && more == 0) {
                        d.textVector.setSize(16);
                        this.panel.add(new Drawable(570, 529, 40, 20, 2, "More", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more + 1) + ");"));
                    } else if (more == 1) {
                        int l = 14;
                        while (l >= 0) {
                            d.textVector.remove(l);
                            --l;
                        }
                        if (d.textVector.size() > 15) {
                            d.textVector.setSize(16);
                            this.panel.add(new Drawable(550, 529, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more - 1) + ");"));
                            this.panel.add(new Drawable(590, 529, 40, 20, 2, "More", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more + 1) + ");"));
                        } else {
                            this.panel.add(new Drawable(570, 529, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more - 1) + ");"));
                        }
                    } else if (more == 2) {
                        int l = 29;
                        while (l >= 0) {
                            d.textVector.remove(l);
                            --l;
                        }
                        if (d.textVector.size() > 15) {
                            d.textVector.setSize(16);
                            this.panel.add(new Drawable(550, 529, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more - 1) + ");"));
                            this.panel.add(new Drawable(590, 529, 40, 20, 2, "More", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more + 1) + ");"));
                        } else {
                            this.panel.add(new Drawable(570, 529, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more - 1) + ");"));
                        }
                    } else if (more == 3) {
                        int l = 44;
                        while (l >= 0) {
                            d.textVector.remove(l);
                            --l;
                        }
                        this.panel.add(new Drawable(570, 529, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more - 1) + ");"));
                    }
                    this.panel.add(d);
                    this.panel.add(new Drawable(780, 570, 65, 20, 2, "<< Back", "mf.gotoStatus(" + from + ", \"\", " + page + ", 0, 0);"));
                    break;
                }
                case 4: {
                    _y = 370;
                    int _x = 177;
                    int counter = this.player.log.size() - 1;
                    this.panel.add(new Drawable(_x, _y - 30, 100, 200, 2, "LOG", statusFontBold, Color.BLACK));
                    Drawable d = null;
                    while (_y < 500 && counter > -1) {
                        if (counter <= more) {
                            LogItem logItem = (LogItem)this.player.log.elementAt(counter);
                            d = new Drawable(_x, _y, 700, 200, 2, logItem.toString(), statusFont, Color.BLACK);
                            this.panel.add(d);
                            _y += d.textVector.size() * 11 + 3;
                        }
                        --counter;
                    }
                    if (more > 0) {
                        int left = more - 2;
                        if (left < 0) {
                            left = 0;
                        }
                        this.panel.add(new Drawable(590, 545, 40, 20, 2, "More", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + left + ");"));
                        if (more >= this.player.log.size() - 1) break;
                        this.panel.add(new Drawable(550, 545, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more + 2) + ");"));
                        break;
                    }
                    if (more >= this.player.log.size() - 1) break;
                    this.panel.add(new Drawable(550, 545, 40, 20, 2, "Less", "mf.gotoStatus(" + state + ", \"" + id + "\", " + page + ", " + from + ", " + (more + 2) + ");"));
                    break;
                }
                case 5: {
                    String death = null;
                    int x = 327;
                    int y = 360;
                    int width = 270;
                    int height = 200;
                    switch (this.player.deathType) {
                        case 1: {
                            death = "/pics/bagdad/characters/dead001.png";
                            x = 420;
                            y = 350;
                            break;
                        }
                        case 2: {
                            death = "/pics/bagdad/characters/dead003.png";
                            x = 528;
                            y = 177;
                            height = 400;
                            break;
                        }
                        case 3: {
                            death = "/pics/bagdad/characters/dead004.png";
                            x = 420;
                            y = 350;
                            break;
                        }
                        case 4: {
                            death = "/pics/bagdad/characters/dead005.png";
                            x = 400;
                            y = 280;
                            break;
                        }
                        default: {
                            death = "/pics/bagdad/characters/dead002.png";
                            x = 400;
                            y = 350;
                        }
                    }
                    String action = "mf.showStatus=false;mf.player.logo=\"logoDeath2\";mf.gotoPlace(\"gameoverparadise\");";
                    if (this.player.moral < 0) {
                        action = "mf.showStatus=false;mf.player.logo=\"logoDeath2\";mf.gotoPlace(\"gameoverhell\");";
                    }
                    this.panel.add(new Drawable(x, y, width, height, 3, this.getImage(death), action, "Game over"));
                    break;
                }
                case 6: {
                    _y = 370;
                    int _x = 177;
                    this.panel.add(new Drawable(510, 310, 510, 570, Color.BLUE, 7, 1.0f));
                    Font cfont = null;
                    Color left = Color.RED;
                    Color right = Color.BLUE;
                    Color pink = new Color(220, 0, 255);
                    int k = 0;
                    int l = Player.cities.length;
                    while (k < l) {
                        cfont = Player.cities[k].equals(this.player.city) ? new Font("Arial", 2, 10) : statusFont;
                        int culture = this.player.getCulture(Player.cities[k]);
                        if (culture < 0) {
                            left = culture > -16 ? pink : Color.RED;
                            this.panel.add(new Drawable(510 + culture * 2, 315 + k * 15, -(culture * 2), 10, 9, "", null, left));
                            this.panel.add(new Drawable(515, 312 + k * 15, 100, 10, 2, Player.niceCities[k], cfont, Color.BLACK));
                        } else {
                            right = culture < 16 ? pink : Color.BLUE;
                            this.panel.add(new Drawable(510, 315 + k * 15, culture * 2, 10, 9, "", null, right));
                            Drawable dc = new Drawable(505, 312 + k * 15, 100, 10, 2, Player.niceCities[k], cfont, Color.BLACK);
                            dc.x -= dc.textWidth;
                            this.panel.add(dc);
                        }
                        ++k;
                    }
                    this.panel.add(new Drawable(760, 475, 10, 10, 9, "", null, Color.RED));
                    this.panel.add(new Drawable(773, 472, 140, 10, 2, "European influence strong", cfont, Color.BLACK));
                    this.panel.add(new Drawable(760, 500, 10, 10, 9, "", null, Color.BLUE));
                    this.panel.add(new Drawable(773, 497, 140, 10, 2, "My influence strong", cfont, Color.BLACK));
                    this.panel.add(new Drawable(760, 525, 10, 10, 9, "", null, pink));
                    this.panel.add(new Drawable(773, 522, 140, 10, 2, "Close to neutral", cfont, Color.BLACK));
                }
            }
            Color color = Color.BLACK;
            color = state == 0 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(170, 570, 80, 20, 2, "Status", "mf.isStatus=false;mf.gotoStatus(0, \"\", " + page + ", " + state + ", 0);", this.fontBold, color));
            color = state == 1 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(270, 570, 80, 20, 2, "Inventory", "mf.player.chooseFace();mf.isStatus=false;mf.gotoStatus(1, \"\", " + page + ", " + state + ", 0);", this.fontBold, color));
            color = state == 2 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(370, 570, 80, 20, 2, "Diary", "mf.player.chooseFace();mf.isStatus=false;mf.gotoStatus(2, \"\", " + page + ", " + state + ", 0);", this.fontBold, color));
            color = state == 3 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(470, 570, 80, 20, 2, "Help", "mf.player.chooseFace();mf.isStatus=false;mf.gotoStatus(3, \"\", " + page + ", 0 , 0);", this.fontBold, color));
            color = state == 4 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(570, 570, 80, 20, 2, "Log", "mf.player.chooseFace();mf.isStatus=true;mf.gotoStatus(4, \"\", " + page + ", " + state + ", (mf.player.log.size()-1));", this.fontBold, color));
            color = state == 6 ? Color.RED : Color.BLACK;
            this.panel.add(new Drawable(670, 570, 80, 20, 2, "Culture", "mf.player.chooseFace();mf.isStatus=false;mf.gotoStatus(6, \"\", " + page + ", " + state + ", 0);", this.fontBold, color));
            color = state == 5 ? Color.RED : Color.BLACK;
            String go = "gameoverparadise";
            if (this.player.moral < 0) {
                go = "gameoverhell";
            }
            if (this.player.inGameOver) {
                this.panel.add(new Drawable(850, 570, 60, 20, 2, "DEATH!", "mf.showStatus=false;mf.player.logo=\"logoDeath2\";mf.gotoPlace(\"" + go + "\");", this.fontBold, color));
            } else {
                this.panel.add(new Drawable(850, 570, 60, 20, 2, "Close", "mf.player.chooseFace();mf.isStatus=false;mf.gotoPlace(mf.player.place);", this.fontBold, color));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        try {
            String save = this.xstream.toXML(this.player);
            FileDialog fd = new FileDialog((Frame)this, "Save game", 1);
            fd.setDirectory(".");
            fd.setFile("spicetrade.sav");
            fd.show();
            String file = String.valueOf(fd.getDirectory()) + fd.getFile();
            if (file == null) {
                return;
            }
            this.tools.writeFile(file, save);
            this.sounds.playSound("/music/fx_signal_bell_hitlink.ogg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveSettings() {
        try {
            Settings settings = new Settings();
            settings.difficulty = this.player.difficulty;
            settings.musicOn = this.sounds.musicOn;
            settings.fullScreen = this.player.fullScreen;
            String save = this.xstream.toXML(settings);
            this.tools.writeFile("spicetrade.properties", save);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSettings() {
        try {
            String load = this.tools.readFile("spicetrade.properties", false);
            Settings settings = new Settings();
            if (load != null && !load.equals("")) {
                settings = (Settings)this.xstream.fromXML(load);
            }
            this.player.difficulty = settings.difficulty;
            this.sounds.musicOn = settings.musicOn;
            this.player.fullScreen = settings.fullScreen;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        try {
            this.sounds.stopAll();
            FileDialog fd = new FileDialog((Frame)this, "Load game", 0);
            fd.setDirectory(".");
            fd.setFile("spicetrade.sav");
            fd.show();
            String file = String.valueOf(fd.getDirectory()) + fd.getFile();
            if (fd.getFile() == null) {
                return;
            }
            String load = this.tools.readFile(file, false);
            this.sounds.playSound("/music/fx_signal_bell_hitlink.ogg");
            this.player = (Player)this.xstream.fromXML(load);
            this.showStatus = true;
            if (this.player.hasItem("10620") || this.player.hasItem("10630")) {
                this.showMapGlobe = true;
            }
            this.player.chooseFace();
            this.refresh();
            Thread.sleep(50L);
            this.gotoPlace(this.player.place);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Image getImage(String image) {
        return this.getImage("", image, false);
    }

    public Image getImage(String name, boolean cache) {
        return this.getImage(name, "", cache);
    }

    public Image getImage(String name, String image, boolean cache) {
        return this.getImage(name, image, cache, false);
    }

    public Image getImage(String name, String image, boolean cache, boolean removeCache) {
        Image i = null;
        try {
            if (name == null || name.equals("")) {
                name = image;
            }
            if (this.images.containsKey(name) && !removeCache) {
                return (Image)this.images.get(name);
            }
            i = this.tools.loadImage(this, image);
            if (i == null) {
                i = (Image)this.images.get("notavailable");
                System.out.println("Image " + image + " not available.");
            }
            this.images.remove(name);
            if (cache) {
                this.images.put(name, i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            i = (Image)this.images.get("notavailable");
        }
        return i;
    }

    public boolean rB(int lower, int upper) {
        return this.nextInt >= lower && this.nextInt < upper;
    }

    public boolean rMore(int limit) {
        return this.nextInt > limit;
    }

    public boolean rLess(int limit) {
        return this.nextInt < limit;
    }

    public void exit() {
        System.exit(0);
    }

    public void this_windowClosed(WindowEvent e) {
        System.exit(0);
    }

    public void this_mouseClicked(MouseEvent e) {
        block9: {
            try {
                if (this.player.place.equals("fields") || this.player.place.equals("witchmountain") || this.player.place.equals("hermitcave")) {
                    Thread.sleep(1000L);
                }
                Vector v = null;
                boolean foundp = false;
                v = this.isModal ? this.panel : this.objects;
                Drawable d = null;
                String text = null;
                int i = v.size() - 1;
                while (i >= this.converter) {
                    d = (Drawable)v.elementAt(i);
                    if (d.contains(e.getPoint()) && d.action != null) {
                        text = this.player.place.equals("map") ? d.text : (d.niceText != null ? d.niceText : (d.text != null ? d.text : d.action));
                        if (!(this.isStatus || "Minimize".equals(text) || "Load".equals(text) || "Save".equals(text) || "Close".equals(text))) {
                            this.player.addLog(text, d.action, this.player.day + this.player.month * 30 + this.player.year * 360);
                        }
                        this.bsh.eval(String.valueOf(this.bshimport) + d.action);
                        foundp = true;
                        break;
                    }
                    --i;
                }
                if (foundp || this.isModal) break block9;
                i = this.glass.size() - 1;
                while (i >= 0) {
                    d = (Drawable)this.glass.elementAt(i);
                    if (d.contains(e.getPoint()) && d.action != null) {
                        text = this.player.place.equals("map") ? d.text : (d.niceText != null ? d.niceText : (d.text != null ? d.text : d.action));
                        if (!this.isStatus) {
                            this.player.addLog(text, d.action, this.player.day + this.player.month * 30 + this.player.year * 360);
                        }
                        this.bsh.eval(String.valueOf(this.bshimport) + d.action);
                        break;
                    }
                    --i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void this_mouseMoved(MouseEvent e) {
        try {
            if (this.idle) {
                this.player.chooseFace();
                this.paintGlass();
                this.idle = false;
            }
            Vector v = null;
            v = this.isModal ? this.panel : this.objects;
            Drawable d = null;
            int x = 0;
            int y = 0;
            int w = this.getWidth();
            int h = this.getHeight();
            String t = "";
            String old = "";
            boolean repaintp = false;
            boolean foundp = false;
            if (this.flyover != null) {
                repaintp = true;
            }
            this.flyover = null;
            int i = v.size() - 1;
            while (i >= this.converter) {
                d = (Drawable)v.elementAt(i);
                if (d.contains(e.getPoint()) && d.action != null) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    x = e.getX();
                    y = e.getY();
                    t = d.niceText != null ? d.niceText : (d.text != null ? d.text : d.action);
                    this.flyover = new Drawable(x + 10, y + 10, 300, 20, 5, t);
                    repaintp = true;
                    foundp = true;
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                --i;
            }
            if (!foundp && !this.isModal) {
                i = this.glass.size() - 1;
                while (i >= 0) {
                    d = (Drawable)this.glass.elementAt(i);
                    if (d.contains(e.getPoint()) && d.action != null) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                        x = e.getX();
                        y = e.getY();
                        t = d.niceText != null ? d.niceText : (d.text != null ? d.text : d.action);
                        this.flyover = new Drawable(x + 10, y + 10, 300, 20, 5, t);
                        repaintp = true;
                        break;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    --i;
                }
            }
            if (repaintp) {
                if (this.flyover != null) {
                    int tw = this.flyover.textWidth;
                    if (x + tw * 2 > w) {
                        x -= tw + 30;
                    }
                    if (y + 40 > h) {
                        y -= 40;
                    }
                    this.flyover.x = x + 10;
                    this.flyover.y = y + 10;
                }
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refresh() {
        this.player.journal.refresh();
    }

    public void createTimer(String action, int delay, int speed, int times) {
        this.createTimer(action, delay, speed, times, false, "");
    }

    public void createTimer(String action, int delay, int speed, int times, String doAfter) {
        this.createTimer(action, delay, speed, times, false, doAfter);
    }

    public void createTimer(String action, int delay, int speed, int times, boolean gotoPlace) {
        this.createTimer(action, delay, speed, times, gotoPlace, "");
    }

    public void createTask(String action, int delay, int speed, int times) {
        this.createTask(action, delay, speed, times, "");
    }

    public void createTask(String action, int delay, int speed, int times, String doAfter) {
        this.timer2 = new Task(action, times, false, doAfter, speed);
        this.timer2.start();
    }

    public void createTimer(String action, int delay, int speed, int times, boolean gotoPlace, String doAfter) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new TimedTask(action, times, gotoPlace, doAfter), delay, (long)speed);
    }

    class TimedTask
    extends TimerTask {
        String action = "";
        int times = 1;
        int counter = 1;
        Interpreter bshint = new Interpreter();
        boolean gotoPlace = false;
        String doAfter = "";

        public TimedTask(String action, int times, boolean gotoPlace, String doAfter) {
            this.action = action;
            this.times = times;
            this.gotoPlace = gotoPlace;
            this.doAfter = doAfter;
        }

        public void run() {
            try {
                String a = this.action.replaceAll("!counter", String.valueOf(this.counter++));
                --this.times;
                if (this.times < 1) {
                    Mainframe.this.timer.cancel();
                    a = a.replaceAll("!donep", "true");
                    if (this.gotoPlace) {
                        Mainframe.this.gotoPlace(Mainframe.this.player.place);
                    } else {
                        this.bshint.set("mf", me);
                        this.bshint.eval(String.valueOf(Mainframe.this.bshimport) + a);
                    }
                    if (this.doAfter != null && !this.doAfter.equals("")) {
                        this.bshint.set("mf", me);
                        this.bshint.eval(String.valueOf(Mainframe.this.bshimport) + this.doAfter);
                    }
                } else {
                    a = a.replaceAll("!donep", "false");
                    this.bshint.set("mf", me);
                    this.bshint.eval(String.valueOf(Mainframe.this.bshimport) + a);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

