/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.core.util.IntQueue;
import com.thoughtworks.xstream.core.util.StringStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XppReader
implements HierarchicalStreamReader {
    private final XmlPullParser parser;
    private final StringStack elementStack = new StringStack(16);
    private final IntQueue lookaheadQueue = new IntQueue(4);

    public XppReader(Reader reader) {
        try {
            this.parser = this.createParser();
            this.parser.setInput(new BufferedReader(reader));
            this.moveDown();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
    }

    protected XmlPullParser createParser() {
        return new MXParser();
    }

    public boolean hasMoreChildren() {
        while (true) {
            switch (this.lookahead()) {
                case 2: {
                    return true;
                }
                case 1: 
                case 3: {
                    return false;
                }
            }
        }
    }

    private int lookahead() {
        try {
            int n = this.parser.next();
            this.lookaheadQueue.write(n);
            return n;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private int next() {
        if (!this.lookaheadQueue.isEmpty()) {
            return this.lookaheadQueue.read();
        }
        try {
            return this.parser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void moveDown() {
        int n = this.elementStack.size();
        while (this.elementStack.size() <= n) {
            this.read();
            if (this.elementStack.size() >= n) continue;
            throw new RuntimeException();
        }
    }

    public void moveUp() {
        int n = this.elementStack.size();
        while (this.elementStack.size() >= n) {
            this.read();
        }
    }

    public String getNodeName() {
        return this.elementStack.peek();
    }

    public String getValue() {
        if (this.lookahead() == 4) {
            String string = this.parser.getText();
            return string == null ? "" : string;
        }
        return "";
    }

    public String getAttribute(String string) {
        return this.parser.getAttributeValue(null, string);
    }

    public Object peekUnderlyingNode() {
        throw new UnsupportedOperationException();
    }

    private void read() {
        switch (this.next()) {
            case 2: {
                this.elementStack.push(this.parser.getName());
                break;
            }
            case 1: 
            case 3: {
                this.elementStack.pop();
            }
        }
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.parser.getLineNumber()));
    }
}

