/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Base64Encoder {
    private static final char[] SIXTY_FOUR_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] REVERSE_MAPPING = new int[123];

    public String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            int n2 = Math.min(3, byArray.length - i);
            int n3 = (byArray[i] & 0xFF) << 16 | (n2 <= 1 ? 0 : byArray[i + 1] & 0xFF) << 8 | (n2 <= 2 ? 0 : byArray[i + 2] & 0xFF);
            for (int j = 0; j < 4; ++j) {
                stringBuffer.append(n2 + 1 > j ? SIXTY_FOUR_CHARS[0x3F & n3 >> 6 * (3 - j)] : (char)'=');
            }
            if ((n += 4) % 76 != 0) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public byte[] decode(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StringReader stringReader = new StringReader(string);
            for (int i = 0; i < string.length(); i += 4) {
                int[] nArray = new int[]{this.mapCharToInt(stringReader), this.mapCharToInt(stringReader), this.mapCharToInt(stringReader), this.mapCharToInt(stringReader)};
                int n = (nArray[0] & 0x3F) << 18 | (nArray[1] & 0x3F) << 12 | (nArray[2] & 0x3F) << 6 | nArray[3] & 0x3F;
                for (int j = 0; j < 3; ++j) {
                    if (nArray[j + 1] < 0) continue;
                    byteArrayOutputStream.write(0xFF & n >> 8 * (2 - j));
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error(iOException + ": " + iOException.getMessage());
        }
    }

    private int mapCharToInt(Reader reader) throws IOException {
        int n;
        while ((n = reader.read()) != -1) {
            int n2 = REVERSE_MAPPING[n];
            if (n2 != 0) {
                return n2 - 1;
            }
            if (n != 61) continue;
            return -1;
        }
        return -1;
    }

    static {
        for (int i = 0; i < SIXTY_FOUR_CHARS.length; ++i) {
            Base64Encoder.REVERSE_MAPPING[Base64Encoder.SIXTY_FOUR_CHARS[i]] = i + 1;
        }
    }
}

