/*
 * Decompiled with CFR 0.152.
 */
package solarex.util;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;

public class RandomHelper {
    public static Random createRNG() {
        Random rng;
        try {
            rng = new SecureRandom();
        }
        catch (Exception ex) {
            System.err.println("Cannot get a high quality RNG, using a normal one.");
            rng = new Random();
        }
        return rng;
    }

    public static Random createRNG(long seed) {
        Random rng = RandomHelper.createRNG();
        rng.setSeed(seed);
        return rng;
    }

    public static <T> T oneOf(Random rng, T[] array) {
        return array[rng.nextInt(array.length)];
    }

    public static <T> T oneOf(List<T> list) {
        return list.get((int)(Math.random() * (double)list.size()));
    }

    public static <T> T oneOf(T[] array) {
        return array[(int)(Math.random() * (double)array.length)];
    }

    public static int oneOfWeightedList(Random rng, int[] weights) {
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            sum += weights[i];
        }
        int weight = (int)((double)sum * rng.nextDouble());
        sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            int high = sum + weights[i];
            if (sum <= weight && weight < high) {
                return i;
            }
            sum = high;
        }
        return -1;
    }
}

