/*
 * Decompiled with CFR 0.152.
 */
package solarex.quest;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JOptionPane;
import solarex.galaxy.Galaxy;
import solarex.quest.Quest;
import solarex.ship.Cargo;
import solarex.ship.Good;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.util.Problem;

public class WantedResource
implements Quest {
    private String message;
    private final String htmlMessage;
    private int howMuch;
    private Good want;
    private double price;

    public WantedResource(int level, Solar here, Good good) {
        this.want = good;
        if (level < 0) {
            this.howMuch = 1 + level / -50;
            this.message = "Looking for " + this.howMuch + " units of " + good.type.toString().toLowerCase() + ".";
            this.htmlMessage = "<html><font color='#EEBBBB'>&nbsp;" + this.message + "</font></html>";
            this.price = (double)((int)(good.salesPrice * (double)this.howMuch * 600.0)) / 100.0;
        } else if (level < 200) {
            this.howMuch = 1 + level / 70;
            this.message = "Desperately needed: " + this.howMuch + " units of " + good.type.toString().toLowerCase() + ".";
            this.htmlMessage = "<html><font color='#EEBBBB'>&nbsp;" + this.message + "</font></html>";
            this.price = (double)((int)(good.salesPrice * (double)this.howMuch * 300.0)) / 100.0;
        } else if (level < 500) {
            this.howMuch = 1 + (level - 200) / 70;
            this.message = "Needed: " + this.howMuch + " units of " + good.type.toString().toLowerCase() + ".";
            this.htmlMessage = "<html><font color='#EEBBBB'>&nbsp;" + this.message + "</font></html>";
            this.price = (double)((int)(good.salesPrice * (double)this.howMuch * 200.0)) / 100.0;
        } else {
            this.howMuch = 1 + (level - 500) / 100;
            this.message = "Want to buy " + this.howMuch + " units of " + good.type.toString().toLowerCase() + ".";
            this.htmlMessage = "<html><font color='#EEBBBB'>&nbsp;" + this.message + "</font></html>";
            this.price = (double)((int)(good.salesPrice * (double)this.howMuch * 150.0)) / 100.0;
        }
        this.message = " " + this.message;
    }

    @Override
    public String getQuestHeadline() {
        return this.htmlMessage;
    }

    @Override
    public String getQuestDetails() {
        return "<html>" + this.message + "<br><br>" + "Offer: <font color='#FFFFFF'>" + this.price + "Cr</font></html>";
    }

    @Override
    public Problem isAcceptable(Ship ship) {
        Cargo cargo = ship.cargo;
        for (int i = 0; i < cargo.goods.length; ++i) {
            Good have = cargo.goods[i];
            if (have.type != this.want.type || have.units < this.howMuch) continue;
            return Problem.NO_PROBLEM;
        }
        return new Problem(1, "You don't have the wanted goods.");
    }

    @Override
    public boolean testSolved(Galaxy galaxy, Solar station, Ship ship) {
        Cargo cargo = ship.cargo;
        for (int i = 0; i < cargo.goods.length; ++i) {
            Good have = cargo.goods[i];
            if (have.type != this.want.type || have.units < this.howMuch) continue;
            have.units -= this.howMuch;
            cargo.money += this.price;
            return true;
        }
        return false;
    }

    @Override
    public void showSuccessMessage(Component component) {
        JOptionPane.showMessageDialog(component, "<html>Thanks a lot. The " + this.price + "Cr have been<br>" + "transferred to your account.<br></html>");
    }

    @Override
    public void save(Writer writer) throws IOException {
    }

    @Override
    public void load(BufferedReader reader) throws IOException {
    }
}

