/*
 * Decompiled with CFR 0.152.
 */
package solarex.galaxy;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import solarex.galaxy.SystemLocation;
import solarex.system.Society;
import solarex.system.Solar;

public class Galaxy {
    private BufferedImage spiral = new BufferedImage(128, 128, 10);

    public Galaxy(Image spiralImg) {
        this.spiral.getGraphics().drawImage(spiralImg, 0, 0, null);
    }

    public List<Solar> findSettlements(int range, SystemLocation here) {
        ArrayList<SystemLocation> destinations = new ArrayList<SystemLocation>(64);
        for (int j = here.galacticSectorJ - range; j <= here.galacticSectorJ + range; ++j) {
            for (int i = here.galacticSectorI - range; i <= here.galacticSectorI + range; ++i) {
                List<SystemLocation> sector = this.buildSector(i, j);
                destinations.addAll(sector);
            }
        }
        ArrayList<Solar> settlements = new ArrayList<Solar>(256);
        for (SystemLocation location : destinations) {
            Solar system = new Solar(location, true);
            Society.populate(system);
            system.listSettlements(settlements);
        }
        return settlements;
    }

    public List<SystemLocation> buildSector(int i, int j) {
        ArrayList<SystemLocation> list = new ArrayList<SystemLocation>();
        long seed = this.calcSectorSeed(i, j);
        Random rng = new Random(seed);
        int xp = i + 80 & 0xFF;
        int yp = j + 80 & 0xFF;
        int anz = 0;
        if (xp >= 0 && xp < 128 && yp >= 0 && yp < 128) {
            anz = (this.spiral.getRGB(xp, yp) & 0xFF) >>> 5;
        }
        int n = 0;
        while (n < anz) {
            SystemLocation loca = new SystemLocation();
            loca.galacticSectorI = i;
            loca.galacticSectorJ = j;
            loca.systemNumber = n++;
            loca.ioff = rng.nextInt(128);
            loca.joff = rng.nextInt(128);
            loca.systemSeed = rng.nextLong();
            list.add(loca);
        }
        return list;
    }

    private long calcSectorSeed(int i, int j) {
        long GAMANUM = 1L;
        return (long)((Math.abs(i + 4999) + Math.abs(j + 5000) * 10000) * 20) + 1L;
    }
}

