/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import net.yura.grasshopper.BugSubmitter;
import net.yura.grasshopper.ScreenShot;

public class BugUIInfo {
    public static ScreenShot[] getFrames() {
        Window[] frames;
        try {
            frames = Window.getWindows();
        }
        catch (Throwable th) {
            frames = Frame.getFrames();
        }
        Vector<ScreenShot> images = new Vector<ScreenShot>();
        for (int c = 0; c < frames.length; ++c) {
            Window frame = frames[c];
            if (!frame.isVisible()) continue;
            ScreenShot ss = new ScreenShot();
            images.add(ss);
            try {
                BufferedImage img = new BufferedImage(frame.getWidth(), frame.getHeight(), 4);
                try {
                    Graphics g = img.getGraphics();
                    frame.paintAll(g);
                    g.dispose();
                }
                catch (Throwable th) {
                    ss.setError(BugSubmitter.getStackTrace(th));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "PNG", out);
                ss.setEncodedData(out.toByteArray());
                ss.setFileType("png");
                continue;
            }
            catch (Throwable ex) {
                ss.setError(BugSubmitter.getStackTrace(ex));
            }
        }
        return images.toArray(new ScreenShot[images.size()]);
    }

    public static String getLookAndFeel() {
        String info = "LookAndFeel=";
        try {
            info = info + UIManager.getLookAndFeel().toString();
        }
        catch (Throwable th) {
            info = info + th.toString();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        info = info + "\nScreenResolution=" + toolkit.getScreenResolution();
        info = info + "\nScreenSize=" + toolkit.getScreenSize();
        info = info + "\nMaximumWindowBounds=" + graphicsEnvironment.getMaximumWindowBounds();
        info = info + "\nCenterPoint=" + graphicsEnvironment.getCenterPoint();
        info = info + "\nScreenInsets=" + toolkit.getScreenInsets(graphicsConfiguration);
        info = info + "\nBounds=" + graphicsConfiguration.getBounds();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        for (int c = 0; c < graphicsDevices.length; ++c) {
            GraphicsConfiguration gc = graphicsDevices[c].getDefaultConfiguration();
            DisplayMode displayMode = graphicsDevices[c].getDisplayMode();
            info = info + "\nGraphicsDevice[" + c + "].IDstring=" + graphicsDevices[c].getIDstring();
            info = info + "\nGraphicsDevice[" + c + "].Type=" + graphicsDevices[c].getType();
            info = info + "\nGraphicsDevice[" + c + "].Bounds=" + gc.getBounds();
            info = info + "\nGraphicsDevice[" + c + "].ScreenInsets=" + toolkit.getScreenInsets(gc);
            info = info + "\nGraphicsDevice[" + c + "].DisplayChangeSupported=" + graphicsDevices[c].isDisplayChangeSupported();
            info = info + "\nGraphicsDevice[" + c + "].FullScreenSupported=" + graphicsDevices[c].isFullScreenSupported();
            info = info + "\nGraphicsDevice[" + c + "].PixelSize=" + gc.getColorModel().getPixelSize();
            info = info + "\nGraphicsDevice[" + c + "].RefreshRate=" + displayMode.getRefreshRate();
        }
        return info;
    }
}

