/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.yura.grasshopper.PopupBug;
import rescue.MissionLoader;
import rescue.RescueListener;
import rescue.RunRescue;
import rescue.gui.AboutDialog;
import rescue.gui.AspectRatio;
import rescue.gui.MissionSetup;
import rescue.gui.PrefDialog;
import rescue.gui.SFrame;
import rescue.gui.SplashScreen;
import rescue.panels.ContainerPanel;

public class RescueGUI
extends JPanel
implements ActionListener,
RescueListener,
Runnable {
    private RunRescue rescue;
    private Component bigmap;
    private Vector panels;
    private Component[] inGameMenus;
    private Component[] outGameMenus;
    private Vector Windows;
    private JDesktopPane desktop;
    private JMenu windowsMenu;
    private Image icon;
    private String missions;
    private int counter = 0;

    public RescueGUI(RunRescue rr, String m) {
        this.missions = m;
        this.setLayout(new BorderLayout());
        this.icon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icon.png"));
        this.rescue = rr;
        this.inGameMenus = new Component[9];
        this.outGameMenus = new Component[6];
        this.desktop = new JDesktopPane();
        this.desktop.setDragMode(0);
        JToolBar mainToolbar = new JToolBar();
        mainToolbar.setRollover(true);
        JButton button = new JButton("New Game");
        button.setActionCommand("new");
        button.addActionListener(this);
        mainToolbar.add(button);
        this.outGameMenus[2] = button;
        this.inGameMenus[8] = mainToolbar.add(this.rescue.getAction("pause"));
        this.inGameMenus[2] = mainToolbar.add(this.rescue.getAction("endgame"));
        mainToolbar.addSeparator();
        button = new JButton("Preferences...");
        button.setActionCommand("preferences");
        button.addActionListener(this);
        mainToolbar.add(button);
        this.outGameMenus[3] = button;
        button = new JButton("Mission Setup...");
        button.setActionCommand("mission");
        button.addActionListener(this);
        mainToolbar.add(button);
        this.outGameMenus[4] = button;
        mainToolbar.addSeparator();
        mainToolbar.add(this.rescue.getAction("quit"));
        mainToolbar.add(this.rescue.getAction("help"));
        button = new JButton("About");
        button.setActionCommand("about");
        button.addActionListener(this);
        mainToolbar.add(button);
        JPanel toolpanel = new JPanel(new BorderLayout());
        this.add((Component)this.createMenuBar(), "North");
        this.add(toolpanel);
        toolpanel.add((Component)mainToolbar, "North");
        toolpanel.add(this.desktop);
        for (int i = 0; i < this.inGameMenus.length; ++i) {
            this.inGameMenus[i].setEnabled(false);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void newGame(MissionLoader cm) {
        JMenuItem menuItem;
        int i;
        Vector w = cm.getWindows();
        this.bigmap = cm.getBigMap();
        this.panels = cm.getPanels();
        this.Windows = new Vector();
        JFrame main = null;
        for (i = 0; i < w.size(); ++i) {
            Container frame;
            Container sframe;
            ContainerPanel containerPanel = (ContainerPanel)w.elementAt(i);
            String name = containerPanel.getName();
            if (this.rescue.getMode()) {
                if (i == 0) {
                    main = new JFrame(name);
                    main.setResizable(false);
                    main.setIconImage(this.icon);
                    sframe = main;
                    main.setContentPane(containerPanel);
                } else {
                    sframe = new JDialog((Frame)main, name);
                    ((JDialog)sframe).setResizable(false);
                    ((JDialog)sframe).setContentPane(containerPanel);
                }
                ((Window)sframe).setLocation(containerPanel.getPreferredLocation());
                ((Window)sframe).pack();
                ((Window)sframe).addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        RescueGUI.this.rescue.closeCurrentMission();
                    }
                });
                this.Windows.add(sframe);
                frame = sframe;
            } else {
                sframe = new SFrame(name, containerPanel);
                ((JInternalFrame)sframe).pack();
                ((JInternalFrame)sframe).setResizable(false);
                ((JInternalFrame)sframe).setDefaultCloseOperation(1);
                ((JInternalFrame)sframe).setFrameIcon(new ImageIcon(this.icon));
                this.Windows.add(sframe);
                this.desktop.add(sframe);
                menuItem = new JMenuItem(name);
                menuItem.setActionCommand("window " + i);
                menuItem.addActionListener(this);
                this.windowsMenu.add(menuItem);
                frame = sframe;
            }
            frame.addComponentListener(new AspectRatio(containerPanel.getWidth(), containerPanel.getHeight()));
        }
        if (this.rescue.getMode()) {
            for (int i2 = 0; i2 < this.Windows.size(); ++i2) {
                Window a = (Window)this.Windows.elementAt(i2);
                a.setVisible(true);
            }
            RescueGUI.findParentFrame(this).setVisible(false);
        } else {
            this.windowsMenu.addSeparator();
            menuItem = new JMenuItem("Use Default Positions");
            menuItem.setMnemonic(85);
            menuItem.setActionCommand("w default");
            menuItem.addActionListener(this);
            this.windowsMenu.add(menuItem);
            this.defaultWindowPositions();
            for (i = 0; i < this.inGameMenus.length; ++i) {
                this.inGameMenus[i].setEnabled(true);
            }
            for (i = 0; i < this.outGameMenus.length; ++i) {
                this.outGameMenus[i].setEnabled(false);
            }
        }
        this.repaint();
    }

    public void closeGame() {
        if (this.rescue.getMode()) {
            for (int i = 0; i < this.Windows.size(); ++i) {
                ((Window)this.Windows.elementAt(i)).setVisible(false);
                ((Window)this.Windows.elementAt(i)).dispose();
            }
            RescueGUI.findParentFrame(this).setVisible(true);
        } else {
            int i;
            for (i = 0; i < this.Windows.size(); ++i) {
                ((SFrame)this.Windows.elementAt(i)).dispose();
                this.desktop.remove((SFrame)this.Windows.elementAt(i));
            }
            this.windowsMenu.removeAll();
            for (i = 0; i < this.inGameMenus.length; ++i) {
                this.inGameMenus[i].setEnabled(false);
            }
            for (i = 0; i < this.outGameMenus.length; ++i) {
                this.outGameMenus[i].setEnabled(true);
            }
        }
        this.Windows = null;
        this.bigmap = null;
    }

    public void dead() {
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Frame frame = this.rescue.getMode() ? (Frame)this.Windows.elementAt(0) : RescueGUI.findParentFrame(this);
        JOptionPane.showMessageDialog(frame, "You are dead!", "Dead", -1);
        this.rescue.closeCurrentMission();
    }

    public void defaultWindowPositions() {
        for (int i = 0; i < this.Windows.size(); ++i) {
            SFrame a = (SFrame)this.Windows.elementAt(i);
            a.setLocation(a.getPreferredLocation());
            a.setSize(a.getPreferredSize());
            a.setVisible(true);
            try {
                a.setIcon(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Game");
        menu.setMnemonic(71);
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic(78);
        menuItem.setActionCommand("new");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.outGameMenus[0] = menuItem;
        this.inGameMenus[6] = menu.add(this.rescue.getAction("pause"));
        this.inGameMenus[7] = menu.add(this.rescue.getAction("endgame"));
        menu.addSeparator();
        menuItem = new JMenuItem("Preferences...");
        menuItem.setMnemonic(80);
        menuItem.setActionCommand("preferences");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.outGameMenus[5] = menuItem;
        menuItem = new JMenuItem("Mission Setup...");
        menuItem.setMnemonic(77);
        menuItem.setActionCommand("mission");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.outGameMenus[1] = menuItem;
        menu.addSeparator();
        menu.add(this.rescue.getAction("quit"));
        menuBar.add(menu);
        menu = new JMenu("Select");
        menu.setMnemonic(83);
        menu.add(this.rescue.getAction("select_all"));
        menu.add(this.rescue.getAction("select_enemies"));
        menu.add(this.rescue.getAction("select_manual"));
        menuBar.add(menu);
        this.inGameMenus[0] = menu;
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuItem = new JMenu("Sound");
        menuItem.setMnemonic(83);
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(this.rescue.getAction("headsup"));
        menuBar.add(menu);
        this.inGameMenus[1] = menu;
        menu = new JMenu("Starfleet");
        menu.setMnemonic(83);
        menu.add(this.rescue.getAction("dock"));
        menu.add(this.rescue.getAction("board"));
        menu.addSeparator();
        menu.add(this.rescue.getAction("beam_down"));
        menu.add(this.rescue.getAction("beam_up"));
        menu.addSeparator();
        JMenu menu2 = new JMenu("Evasive Maneuvers");
        menu2.setMnemonic(69);
        menu2.add(this.rescue.getAction("evasive 1"));
        menu2.add(this.rescue.getAction("evasive 2"));
        menu2.add(this.rescue.getAction("evasive 3"));
        menu.add(menu2);
        menuBar.add(menu);
        this.inGameMenus[3] = menu;
        menu = new JMenu("Engineering");
        menu.setMnemonic(69);
        menu.add(this.rescue.getAction("divert"));
        menu.addSeparator();
        menu.add(this.rescue.getAction("reserve"));
        menuBar.add(menu);
        this.inGameMenus[4] = menu;
        menu = new JMenu("Window");
        menu.setMnemonic(87);
        this.windowsMenu = menu;
        menuBar.add(menu);
        this.inGameMenus[5] = menu;
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.add(this.rescue.getAction("help"));
        menuItem = new JMenuItem("Send Bug Report");
        menuItem.setActionCommand("bug report");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("About Rescue!");
        menuItem.setMnemonic(82);
        menuItem.setActionCommand("aboutr");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("About Rescue! Max");
        menuItem.setMnemonic(65);
        menuItem.setActionCommand("about");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void update() {
        try {
            this.bigmap.repaint();
            ++this.counter;
            if (this.counter >= 10 || this.rescue.getPause()) {
                for (int i = 0; i < this.panels.size(); ++i) {
                    ((Component)this.panels.elementAt(i)).list();
                }
                this.counter = 0;
            }
        }
        catch (Exception e) {
            System.out.print("error updating gui: " + e + "\n");
            this.counter = 0;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("new")) {
            this.rescue.loadCurrentMission();
            return;
        }
        if (e.getActionCommand().equals("mission")) {
            MissionSetup mDialog = new MissionSetup(RescueGUI.findParentFrame(this), true, this.rescue, this.missions);
            mDialog.setVisible(true);
            return;
        }
        if (e.getActionCommand().equals("preferences")) {
            PrefDialog aboutDialog = new PrefDialog(RescueGUI.findParentFrame(this), true, this.rescue, this, this.rescue.getKeymap());
            Dimension frameSize = this.getSize();
            Dimension aboutSize = aboutDialog.getPreferredSize();
            int x = this.getLocation().x + (frameSize.width - aboutSize.width) / 2;
            int y = this.getLocation().y + (frameSize.height - aboutSize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            aboutDialog.setLocation(x, y);
            aboutDialog.setVisible(true);
            return;
        }
        if (e.getActionCommand().equals("about")) {
            AboutDialog aboutDialog = new AboutDialog(RescueGUI.findParentFrame(this), true, "Rescue! Max", "1.0.0.3");
            Dimension frameSize = this.getSize();
            Dimension aboutSize = aboutDialog.getPreferredSize();
            int x = this.getLocation().x + (frameSize.width - aboutSize.width) / 2;
            int y = this.getLocation().y + (frameSize.height - aboutSize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            aboutDialog.setLocation(x, y);
            aboutDialog.setVisible(true);
            return;
        }
        if (e.getActionCommand().equals("aboutr")) {
            JDialog aboutDialog = new JDialog(RescueGUI.findParentFrame(this), "Rescue!", true);
            aboutDialog.getContentPane().add(new JLabel(new ImageIcon(this.getClass().getResource("credits.png"))));
            aboutDialog.setResizable(false);
            aboutDialog.pack();
            Dimension frameSize = this.getSize();
            Dimension aboutSize = aboutDialog.getPreferredSize();
            int x = this.getLocation().x + (frameSize.width - aboutSize.width) / 2;
            int y = this.getLocation().y + (frameSize.height - aboutSize.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            aboutDialog.setLocation(x, y);
            aboutDialog.setVisible(true);
            return;
        }
        if (!e.getActionCommand().equals("bug report")) {
            if (e.getActionCommand().equals("w default")) {
                this.defaultWindowPositions();
                return;
            }
            if (e.getActionCommand().startsWith("window ")) {
                int i = Integer.parseInt(e.getActionCommand().substring(7));
                ((SFrame)this.Windows.elementAt(i)).setVisible(true);
                try {
                    ((SFrame)this.Windows.elementAt(i)).setIcon(false);
                    ((SFrame)this.Windows.elementAt(i)).setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            System.out.print("unknown command " + e.getActionCommand() + "\n");
            return;
        }
        System.err.println("bug report");
    }

    public static void main(String[] argv) {
        try {
            PopupBug.initSimple("Rescue! Max", "1.0.0.3", "");
        }
        catch (Throwable th) {
            System.out.println("grasshopper failed to load " + th);
        }
        SplashScreen ss = new SplashScreen();
        ss.setVisible(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RunRescue rr = new RunRescue(new File("missions").toURI().toURL());
            final RescueGUI gui = new RescueGUI(rr, null);
            JFrame frame = new JFrame("Rescue! Max");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    gui.exitForm(evt);
                }
            });
            frame.setContentPane(gui);
            frame.setIconImage(gui.getIcon());
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            frame.setBounds(screenSize);
            frame.setVisible(true);
            rr.addRescueListener(gui);
            ss.setVisible(false);
            ss.dispose();
            rr.run();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            String info = "";
            for (int i = 0; i < st.length; ++i) {
                info = info + st[i] + "\n";
            }
            JOptionPane.showMessageDialog(null, "Error Loading default config file: " + e.getMessage() + "\n\n" + e.toString() + "\n" + info, "Load error!", 0);
            System.exit(0);
        }
    }

    public static Frame findParentFrame(Container c) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
    }
}

