/*
 * Decompiled with CFR 0.152.
 */
package model;

import fachkonzept.Plane;
import java.util.BitSet;
import java.util.Observable;

public class PlaneModel
extends Observable {
    private Plane plane;

    public PlaneModel() {
        this(new Plane());
    }

    public PlaneModel(Plane plane) {
        this.plane = plane;
    }

    public final void init(int color) {
        this.plane.init(color);
        BitSet mask = new BitSet(9);
        mask.set(0, 8);
        this.setChanged();
        this.notifyObservers(new Integer(2303));
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
        BitSet mask = new BitSet(9);
        mask.set(0, 8);
        this.setChanged();
        this.notifyObservers(new Integer(2303));
    }

    public int[] getRow(int y) {
        return this.plane.getRow(y);
    }

    public int[] getColumn(int x) {
        return this.plane.getColumn(x);
    }

    public int getCell(int x, int y) {
        return this.plane.getCell(x, y);
    }

    public void setRow(int y, int[] row, boolean reverse) {
        this.plane.setRow(y, row, reverse);
        BitSet mask = new BitSet(9);
        mask.set(y * 3, y * 3 + 2);
        this.setChanged();
        this.notifyObservers(mask);
    }

    public void setColumn(int x, int[] column, boolean reverse) {
        this.plane.setColumn(x, column, reverse);
        BitSet mask = new BitSet(9);
        for (int i = x; i < 9; i += 3) {
            mask.set(i);
        }
        this.setChanged();
        this.notifyObservers(mask);
    }

    public void setCell(int x, int y, int color) {
        this.plane.setCell(x, y, color);
        BitSet mask = new BitSet(9);
        mask.set(x + 3 * y);
        this.setChanged();
        this.notifyObservers(mask);
    }

    public void upsideDown() {
        this.plane = this.plane.upsideDown();
        BitSet mask = new BitSet(9);
        mask.set(0, 8);
        this.setChanged();
        this.notifyObservers(mask);
    }

    public void rotateRight() {
        this.plane = this.plane.rotateRight();
        BitSet mask = new BitSet(9);
        mask.set(0, 8);
        mask.flip(4);
        this.setChanged();
        this.notifyObservers(mask);
    }

    public void rotateLeft() {
        this.plane = this.plane.rotateLeft();
        BitSet mask = new BitSet(9);
        mask.set(0, 8);
        mask.flip(4);
        this.setChanged();
        this.notifyObservers(mask);
    }
}

