/*
 * Decompiled with CFR 0.152.
 */
package fachkonzept;

import fachkonzept.Console;

public class Plane {
    private int[] cell = new int[9];

    public Plane() {
        this(0);
    }

    public Plane(int color) {
        this.init(color);
    }

    public Plane(Plane plane) {
        this.cell = (int[])plane.cell.clone();
    }

    public Plane clone() {
        return new Plane(this);
    }

    public final void init(int color) {
        if (color < 0 || color > 5) {
            throw new IllegalArgumentException("Not a valid cell color: " + color);
        }
        for (int i = 0; i < 9; ++i) {
            this.cell[i] = color;
        }
    }

    public int getCell(int x, int y) {
        if (x < 0 || x > 2 || y < 0 || y > 2) {
            throw new IndexOutOfBoundsException("Not a valid cell position: " + x + ", " + y);
        }
        return this.cell[x + y * 3];
    }

    public void setCell(int x, int y, int color) {
        if (x < 0 || x > 2 || y < 0 || y > 2) {
            throw new IndexOutOfBoundsException("Not a valid cell position: " + x + ", " + y);
        }
        if (color < 0 || color > 5) {
            throw new IllegalArgumentException("Not a valid cell color: " + color);
        }
        this.cell[x + y * 3] = color;
    }

    public int[] getRow(int y) {
        if (y < 0 || y > 2) {
            throw new IndexOutOfBoundsException("Not a valid row position: " + y);
        }
        int[] row = new int[3];
        for (int x = 0; x < 3; ++x) {
            row[x] = this.getCell(x, y);
        }
        return row;
    }

    public void setRow(int y, int[] row, boolean reverse) {
        if (y < 0 || y > 2) {
            throw new IndexOutOfBoundsException("Not a valid row position: " + y);
        }
        for (int x = 0; x < 3; ++x) {
            if (reverse) {
                this.setCell(2 - x, y, row[x]);
                continue;
            }
            this.setCell(x, y, row[x]);
        }
    }

    public int[] getColumn(int x) {
        if (x < 0 || x > 2) {
            throw new IndexOutOfBoundsException("Not a valid column position: " + x);
        }
        int[] column = new int[3];
        for (int y = 0; y < 3; ++y) {
            column[y] = this.getCell(x, y);
        }
        return column;
    }

    public void setColumn(int x, int[] column, boolean reverse) {
        if (x < 0 || x > 2) {
            throw new IndexOutOfBoundsException("Not a valid column position: " + x);
        }
        for (int y = 0; y < 3; ++y) {
            if (reverse) {
                this.setCell(x, 2 - y, column[y]);
                continue;
            }
            this.setCell(x, y, column[y]);
        }
    }

    public Plane permutate(int[] permutation) {
        Plane plane = new Plane(this);
        int tmp = plane.cell[permutation[0]];
        for (int i = 0; i < permutation.length - 1; ++i) {
            plane.cell[permutation[i]] = plane.cell[permutation[i + 1]];
        }
        plane.cell[permutation[permutation.length - 1]] = tmp;
        return plane;
    }

    public Plane swap(int a, int b) {
        Plane plane = new Plane(this);
        int tmp = plane.cell[a];
        plane.cell[a] = plane.cell[b];
        plane.cell[b] = tmp;
        return plane;
    }

    public Plane rotateRight() {
        int[] p = new int[]{0, 6, 8, 2};
        int[] p1 = new int[]{3, 7, 5, 1};
        return this.permutate(p).permutate(p1);
    }

    public Plane rotateLeft() {
        int[] p = new int[]{0, 2, 8, 6};
        int[] p1 = new int[]{1, 5, 7, 3};
        return this.permutate(p).permutate(p1);
    }

    public Plane upsideDown() {
        return this.swap(0, 8).swap(1, 7).swap(2, 6).swap(3, 5);
    }

    public void print(Console console, int xp, int yp) {
        String colors = "012345";
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                console.setChar(x + xp, y + yp, colors.charAt(this.getCell(x, y)));
            }
        }
    }

    public String toString() {
        Console console = new Console(3, 3);
        this.print(console, 0, 0);
        return console.toString();
    }

    public static void main(String[] args) {
        Plane p = new Plane();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                p.setCell(i, j, (int)(Math.random() * 6.0));
            }
        }
        System.out.println(p);
        int[] row = p.getColumn(0);
        p.setColumn(1, row, true);
        System.out.println(p);
        System.out.println(p.upsideDown());
    }
}

