/*
 * Decompiled with CFR 0.152.
 */
package datentyp;

import datentyp.Vector3d;

public class Matrix3d {
    private double[][] x = new double[3][3];

    public Matrix3d() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.x[j][i] = 0.0;
            }
        }
    }

    public Matrix3d(double[] a) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.x[j][i] = a[i + j * 3];
            }
        }
    }

    public Matrix3d(double a, double b, double c, double d, double e, double f, double g, double h, double i) {
        this.x[0][0] = a;
        this.x[0][1] = b;
        this.x[0][2] = c;
        this.x[1][0] = d;
        this.x[1][1] = e;
        this.x[1][2] = f;
        this.x[2][0] = g;
        this.x[2][1] = h;
        this.x[2][2] = i;
    }

    public static Matrix3d getNormal() {
        return new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public double getX(int i, int j) {
        return this.x[j][i];
    }

    public void setX(int i, int j, double a) {
        this.x[j][i] = a;
    }

    public Matrix3d add(Matrix3d m) {
        Matrix3d e = new Matrix3d();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                e.x[j][i] = this.x[j][i] + m.x[j][i];
            }
        }
        return e;
    }

    public Matrix3d sub(Matrix3d m) {
        Matrix3d e = new Matrix3d();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                e.x[j][i] = this.x[j][i] - m.x[j][i];
            }
        }
        return e;
    }

    public Matrix3d mult(double a) {
        Matrix3d e = new Matrix3d();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                e.x[j][i] = this.x[j][i] * a;
            }
        }
        return e;
    }

    public Matrix3d div(double a) {
        Matrix3d e = new Matrix3d();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                e.x[j][i] = this.x[j][i] / a;
            }
        }
        return e;
    }

    public Matrix3d mult(Matrix3d m) {
        Matrix3d e = new Matrix3d();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                e.x[j][i] = this.x[j][0] * m.x[0][i] + this.x[j][1] * m.x[1][i] + this.x[j][2] * m.x[2][i];
            }
        }
        return e;
    }

    public Vector3d mult(Vector3d m) {
        return new Vector3d(this.x[0][0] * m.getA() + this.x[0][1] * m.getB() + this.x[0][2] * m.getC(), this.x[1][0] * m.getA() + this.x[1][1] * m.getB() + this.x[1][2] * m.getC(), this.x[2][0] * m.getA() + this.x[2][1] * m.getB() + this.x[2][2] * m.getC());
    }
}

