/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GeneticCodePanel;
import biogenesis.LabWindow;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Organism;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class InfoToolbar
extends JToolBar {
    private static final long serialVersionUID = 700L;
    protected Organism _selOrganism;
    protected JLabel _lEnergy;
    protected JLabel _lID;
    protected JLabel _lGeneration;
    protected JLabel _lAge;
    protected JLabel _lChildren;
    protected JLabel _lKills;
    protected JLabel _lInfected;
    protected JLabel _lMass;
    protected JLabel _lReproduceEnergy;
    protected JButton _buttonGenes;
    protected GeneticCodePanel _geneticCodePanel;
    private static NumberFormat _nf = NumberFormat.getInstance();
    protected MainWindow _mainWindow;
    private JLabel _lT_REPRODUCTION;
    private JLabel _lT_ID;
    private JLabel _lT_GENERATION;
    private JLabel _lT_AGE;
    private JLabel _lT_ENERGY;
    private JLabel _lT_CHILDREN;
    private JLabel _lT_VICTIMS;
    private JLabel _lT_INFECTED;
    private JLabel _lT_MASS;

    public void setSelectedOrganism(Organism selectedOrganism) {
        this._selOrganism = selectedOrganism;
        this._lID.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getID()) : "-1");
        this._lGeneration.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getGeneration()) : "0");
        this._lReproduceEnergy.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getGeneticCode().getReproduceEnergy()) : "0");
        this.recalculate();
        this.changeNChildren();
        this.changeNKills();
        this.changeNInfected();
        this._buttonGenes.setEnabled(this._selOrganism != null);
        this._geneticCodePanel.setGeneticCode(this._selOrganism != null ? this._selOrganism.getGeneticCode() : null);
        this._geneticCodePanel.repaint();
        this.setVisible(this._selOrganism != null);
    }

    public void recalculate() {
        this._lEnergy.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getEnergy()) : "0");
        this._lAge.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getAge() >> 8) : "0");
        this._lMass.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getMass()) : "0");
    }

    public void changeNChildren() {
        this._lChildren.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalChildren()) : "0");
    }

    public void changeNKills() {
        this._lKills.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalKills()) : "0");
    }

    public void changeNInfected() {
        this._lInfected.setText(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalInfected()) : "0");
    }

    public InfoToolbar(Organism selectedOrganism, MainWindow mainWindow) {
        Dimension dimension = new Dimension(60, 10);
        this._selOrganism = selectedOrganism;
        this._mainWindow = mainWindow;
        _nf.setMaximumFractionDigits(1);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 3;
        this._geneticCodePanel = new GeneticCodePanel(this._selOrganism != null ? this._selOrganism.getGeneticCode() : null, this._mainWindow.getVisibleWorld());
        this._geneticCodePanel.setPreferredSize(new Dimension(50, 50));
        this.add((Component)this._geneticCodePanel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this._lT_ID = new JLabel(Messages.getString("T_ID"), 0);
        this.add((Component)this._lT_ID, gridBagConstraints);
        this._lID = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getID()) : "-1", 0);
        this._lID.setPreferredSize(dimension);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lID, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this._lT_GENERATION = new JLabel(Messages.getString("T_GENERATION"), 0);
        this.add((Component)this._lT_GENERATION, gridBagConstraints);
        this._lGeneration = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getGeneration()) : "0", 0);
        this._lGeneration.setPreferredSize(dimension);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lGeneration, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this._lT_AGE = new JLabel(Messages.getString("T_AGE"), 0);
        this.add((Component)this._lT_AGE, gridBagConstraints);
        this._lAge = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getAge() >> 8) : "0", 0);
        this._lAge.setPreferredSize(dimension);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lAge, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this._lT_ENERGY = new JLabel(Messages.getString("T_ENERGY"), 0);
        this.add((Component)this._lT_ENERGY, gridBagConstraints);
        this._lEnergy = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getEnergy()) : "0", 0);
        this._lEnergy.setPreferredSize(dimension);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lEnergy, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this._lT_CHILDREN = new JLabel(Messages.getString("T_CHILDREN"), 0);
        this.add((Component)this._lT_CHILDREN, gridBagConstraints);
        this._lChildren = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalChildren()) : "0", 0);
        this._lChildren.setPreferredSize(dimension);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this._lChildren, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this._lT_VICTIMS = new JLabel(Messages.getString("T_VICTIMS"), 0);
        this.add((Component)this._lT_VICTIMS, gridBagConstraints);
        this._lKills = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalKills()) : "0", 0);
        this._lKills.setPreferredSize(dimension);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.add((Component)this._lKills, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this._lT_INFECTED = new JLabel(Messages.getString("T_INFECTED"), 0);
        this.add((Component)this._lT_INFECTED, gridBagConstraints);
        this._lInfected = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getTotalInfected()) : "0", 0);
        this._lInfected.setPreferredSize(dimension);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        this.add((Component)this._lInfected, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        this._lT_MASS = new JLabel(Messages.getString("T_MASS"), 0);
        this.add((Component)this._lT_MASS, gridBagConstraints);
        this._lMass = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getMass()) : "0", 0);
        this._lMass.setPreferredSize(dimension);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        this.add((Component)this._lMass, gridBagConstraints);
        this._buttonGenes = new JButton(Messages.getString("T_EXAMINE_GENES"));
        this._buttonGenes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LabWindow(InfoToolbar.this._mainWindow, InfoToolbar.this._selOrganism.getGeneticCode());
            }
        });
        this._buttonGenes.setEnabled(this._selOrganism != null);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this._buttonGenes, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this._lT_REPRODUCTION = new JLabel(Messages.getString("T_REPRODUCTION"), 0);
        this.add((Component)this._lT_REPRODUCTION, gridBagConstraints);
        this._lReproduceEnergy = new JLabel(this._selOrganism != null ? _nf.format(this._selOrganism.getGeneticCode().getReproduceEnergy()) : "0", 0);
        this._lReproduceEnergy.setPreferredSize(dimension);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        this.add((Component)this._lReproduceEnergy, gridBagConstraints);
        this.setSize(200, 200);
        this.setVisible(this._selOrganism != null);
    }

    public void changeLocale() {
        this._lT_ID.setText(Messages.getString("T_ID"));
        this._lT_GENERATION.setText(Messages.getString("T_GENERATION"));
        this._lT_AGE.setText(Messages.getString("T_AGE"));
        this._lT_ENERGY.setText(Messages.getString("T_ENERGY"));
        this._lT_CHILDREN.setText(Messages.getString("T_CHILDREN"));
        this._lT_VICTIMS.setText(Messages.getString("T_VICTIMS"));
        this._lT_INFECTED.setText(Messages.getString("T_INFECTED"));
        this._lT_MASS.setText(Messages.getString("T_MASS"));
        this._buttonGenes.setText(Messages.getString("T_EXAMINE_GENES"));
        this._lT_REPRODUCTION.setText(Messages.getString("T_REPRODUCTION"));
    }
}

