/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Gene;
import biogenesis.GeneticCode;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BioXMLParser
implements ErrorHandler {
    protected DocumentBuilder builder = null;
    protected Document doc = null;

    public BioXMLParser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static void writeGeneticCode(PrintStream ps, GeneticCode geneticCode) {
        ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ps.println("<!DOCTYPE genetic_code [");
        ps.println("<!ELEMENT genetic_code (gene+)>");
        ps.println("<!ATTLIST genetic_code symmetry (1|2|3|4|5|6|7|8) #REQUIRED>");
        ps.println("<!ATTLIST genetic_code mirror (yes|no) #REQUIRED>");
        ps.println("<!ATTLIST genetic_code disperse (yes|no) #REQUIRED>");
        ps.println("<!ELEMENT gene EMPTY>");
        ps.println("<!ATTLIST gene length CDATA #REQUIRED>");
        ps.println("<!ATTLIST gene theta CDATA #REQUIRED>");
        ps.println("<!ATTLIST gene color (red|green|blue|cyan|yellow|gray|white) #REQUIRED>");
        ps.println("]>");
        ps.println("<genetic_code symmetry=\"" + Integer.toString(geneticCode.getSymmetry()) + "\" mirror=\"" + (geneticCode.getMirror() == 0 ? "no" : "yes") + "\" disperse=\"" + (geneticCode.getDisperseChildren() ? "yes" : "no") + "\">");
        int i = 0;
        while (i < geneticCode.getNGenes()) {
            BioXMLParser.writeGene(ps, geneticCode.getGene(i));
            ++i;
        }
        ps.println("</genetic_code>");
    }

    public static void writeGene(PrintStream ps, Gene gene) {
        ps.println("\t<gene length=\"" + Double.toString(gene.getLength()) + "\" theta=\"" + Double.toString(gene.getTheta()) + "\" color=\"" + BioXMLParser.colorToString(gene.getColor()) + "\" />");
    }

    public GeneticCode parseGeneticCode(File f) throws SAXException, IOException {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        this.doc = this.builder.parse(f);
        Element geneticCode = this.doc.getDocumentElement();
        if (geneticCode.getNodeName().equals("genetic_code")) {
            boolean disperse;
            int mirror;
            int symmetry;
            String s = geneticCode.getAttribute("symmetry");
            try {
                symmetry = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new SAXException("Symmetry has not an allowed value.");
            }
            if (symmetry < 1 || symmetry > 8) {
                throw new SAXException("Symmetry has not an allowed value.");
            }
            s = geneticCode.getAttribute("mirror");
            if (s.equals("yes")) {
                mirror = 1;
            } else if (s.equals("no")) {
                mirror = 0;
            } else {
                throw new SAXException("Mirror has not an allowed value.");
            }
            s = geneticCode.getAttribute("disperse");
            if (s.equals("yes")) {
                disperse = true;
            } else if (s.equals("no")) {
                disperse = false;
            } else {
                throw new SAXException("Disperse has not an allowed value.");
            }
            Node gene = geneticCode.getFirstChild();
            gene = BioXMLParser.getNextElement(gene);
            while (gene != null) {
                genes.add(this.parseGene((Element)gene));
                gene = BioXMLParser.getNextElement(gene.getNextSibling());
            }
            return new GeneticCode(genes, symmetry, mirror, disperse);
        }
        throw new SAXException("This file does not contain a genetic_code.");
    }

    private static Node getNextElement(Node n) {
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        return n;
    }

    public Gene parseGene(Element gene) throws SAXException {
        if (gene.getNodeName().equals("gene")) {
            Color color;
            double theta;
            double length;
            try {
                length = Double.parseDouble(gene.getAttribute("length"));
                theta = Double.parseDouble(gene.getAttribute("theta"));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Attributes length and theta do not exist or have not an allowed value.");
            }
            try {
                color = BioXMLParser.stringToColor(gene.getAttribute("color"));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Attribute color does not exist or has not an allowed value.");
            }
            return new Gene(length, theta, color);
        }
        throw new SAXException("Parse error. " + gene.getNodeName() + " found but gene expected.");
    }

    private static Color stringToColor(String s) throws IllegalArgumentException {
        if (s.equals("green")) {
            return Color.GREEN;
        }
        if (s.equals("red")) {
            return Color.RED;
        }
        if (s.equals("blue")) {
            return Color.BLUE;
        }
        if (s.equals("cyan")) {
            return Color.CYAN;
        }
        if (s.equals("gray")) {
            return Color.GRAY;
        }
        if (s.equals("white")) {
            return Color.WHITE;
        }
        if (s.equals("yellow")) {
            return Color.YELLOW;
        }
        throw new IllegalArgumentException();
    }

    private static String colorToString(Color c) {
        if (c.equals(Color.RED)) {
            return "red";
        }
        if (c.equals(Color.GREEN)) {
            return "green";
        }
        if (c.equals(Color.BLUE)) {
            return "blue";
        }
        if (c.equals(Color.CYAN)) {
            return "cyan";
        }
        if (c.equals(Color.WHITE)) {
            return "white";
        }
        if (c.equals(Color.GRAY)) {
            return "gray";
        }
        if (c.equals(Color.YELLOW)) {
            return "yellow";
        }
        return "";
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
        throw new SAXException(arg0.getMessage());
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
        throw new SAXException(arg0.getMessage());
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
        throw new SAXException(arg0.getMessage());
    }
}

