/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.match;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.NoTriangleException;
import de.andreasroerig.match.Match;
import de.andreasroerig.match.RegParams;
import de.andreasroerig.match.Star;
import de.andreasroerig.match.StarTriangle;
import de.andreasroerig.match.Trans;
import de.andreasroerig.util.SLogger;
import java.util.Arrays;

public class MatchFinderTS
implements Runnable {
    private Bild bild1;
    private Bild bild2;
    private Bild registeredImage;
    private Star[] sa1;
    private Star[] sa2;
    private RegParams theParams = RegParams.instance();
    private StarTriangle[] tSpace1;
    private StarTriangle[] tSpace2;
    private int bestMatchIndex;
    private int secondBestMatchIndex;
    private boolean rotated;

    public MatchFinderTS() {
    }

    public MatchFinderTS(Bild b1, Bild b2) {
        this();
        this.rotated = false;
        this.bild1 = b1;
        this.bild2 = b2;
        this.init();
    }

    public void init() {
        this.secondBestMatchIndex = 0;
        this.bestMatchIndex = 0;
        this.registeredImage = null;
        this.sa1 = this.bild1.getStarArray();
        this.sa2 = this.bild2.getStarArray();
    }

    public void run() {
    }

    public Bild do_register() {
        boolean counter = false;
        this.bild2.findStars();
        Match myMatch = new Match();
        myMatch.setBild1(this.bild1);
        myMatch.setBild2(this.bild2);
        Trans theTrans = myMatch.findTrans();
        if (theTrans != null) {
            theTrans.print();
            this.bild2 = this.theParams.getBicubicInterpol() ? this.bild2.transformInterpol(theTrans, this.bild1.getWidth(), this.bild1.getLen()) : this.bild2.transform(theTrans, this.bild1.getWidth(), this.bild1.getLen());
        } else {
            SLogger.debug("theTrans is null");
            this.bild2 = null;
        }
        return this.bild2;
    }

    protected double calcAngle(double a, double b, double c) {
        double cosine = (Math.pow(b, 2.0) + Math.pow(c, 2.0) - Math.pow(a, 2.0)) / (2.0 * b * c);
        return Math.toDegrees(Math.acos(cosine));
    }

    protected double calcRotationAngle(Star s1b1, Star s2b1, Star s1b2, Star s2b2) {
        double xdiff1 = s2b1.dx - s1b1.dx;
        double ydiff1 = s2b1.dy - s1b1.dy;
        double xdiff2 = s2b2.dx - s1b2.dx;
        double ydiff2 = s2b2.dy - s1b2.dy;
        double dist1 = s1b1.calcDistance(s2b1);
        double dist2 = s1b2.calcDistance(s2b2);
        double a1 = this.calcAngle(Math.abs(ydiff1), Math.abs(xdiff1), dist1);
        double a2 = this.calcAngle(Math.abs(ydiff2), Math.abs(xdiff2), dist2);
        if (xdiff1 < 0.0) {
            if (ydiff1 < 0.0) {
                a1 += 180.0;
                SLogger.debug("Fall 1");
            } else {
                a1 = 180.0 - a1;
                SLogger.debug("Fall 2");
            }
        } else if (ydiff1 < 0.0) {
            a1 = 360.0 - a1;
            SLogger.debug("Fall 3");
        } else {
            SLogger.debug("Fall 4");
        }
        if (xdiff2 < 0.0) {
            if (ydiff2 < 0.0) {
                a2 += 180.0;
                SLogger.debug("Fall 1");
            } else {
                a2 = 180.0 - a2;
                SLogger.debug("Fall 2");
            }
        } else if (ydiff2 < 0.0) {
            a2 = 360.0 - a2;
            SLogger.debug("Fall 3");
        } else {
            SLogger.debug("Fall 4");
        }
        SLogger.debug("a1=" + a1 + ", a2=" + a2);
        if (a1 - a2 == Double.NaN) {
            return -1000.0;
        }
        return a1 - a2;
    }

    public void findMatch() {
        int matchCount = 0;
        int maxLoopIdx = this.theParams.getMaxNumStars();
        int maxIdx1 = Math.min(this.bild1.getStarCount() - 3, maxLoopIdx);
        int maxIdx2 = Math.min(this.bild2.getStarCount() - 3, maxLoopIdx);
        StarTriangle st1 = new StarTriangle();
        StarTriangle st2 = new StarTriangle();
        this.tSpace1 = new StarTriangle[maxIdx1];
        this.tSpace2 = new StarTriangle[maxIdx2];
        SLogger.debug("findMatch started!");
        try {
            int idx;
            int i;
            if (this.theParams.getSearchBrightness()) {
                this.bild1.sortStarArray(2);
                this.bild2.sortStarArray(2);
                SLogger.debug("findMatch first stage: bright triangles!");
                i = 0;
                while (i < maxIdx1) {
                    try {
                        this.tSpace1[i] = st1 = this.getBrightStarTriangle(i, this.sa1);
                        Thread.sleep(1L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace1);
                i = 0;
                while (i < maxIdx2) {
                    try {
                        this.tSpace2[i] = st2 = this.getBrightStarTriangle(i, this.sa2);
                        Thread.sleep(1L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace2);
                i = 0;
                while (i < maxIdx1) {
                    idx = this.findMatchingST(i);
                    if (idx >= 0) {
                        this.bild1.addMatch(this.tSpace1[i]);
                        this.bild2.addMatch(this.tSpace2[idx]);
                        this.bild1.setSt(this.tSpace1[i]);
                        this.bild2.setSt(this.tSpace2[idx]);
                        ++matchCount;
                        Thread.sleep(0L);
                    }
                    ++i;
                }
                SLogger.debug("--------------------------------------------------------");
                SLogger.debug("findMatch after first section! matchCount=" + matchCount);
                SLogger.debug("--------------------------------------------------------");
                Thread.sleep(1000L);
                matchCount = this.bild1.getNumMatches();
            }
            if (this.theParams.getSearchCenterDistance() && matchCount < 50) {
                this.bild1.sortStarArray(1);
                this.bild2.sortStarArray(1);
                this.tSpace1 = new StarTriangle[maxIdx1];
                this.tSpace2 = new StarTriangle[maxIdx2];
                i = 0;
                while (i < maxIdx1) {
                    try {
                        this.tSpace1[i] = st1 = this.getCloseStarTriangle(i, this.sa1);
                        Thread.sleep(0L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace1);
                i = 0;
                while (i < maxIdx2) {
                    try {
                        this.tSpace2[i] = st2 = this.getCloseStarTriangle(i, this.sa2);
                        Thread.sleep(0L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace2);
                i = 0;
                while (i < maxIdx1) {
                    idx = this.findMatchingST(i);
                    if (idx >= 0) {
                        this.bild1.addMatch(this.tSpace1[i]);
                        this.bild2.addMatch(this.tSpace2[idx]);
                        this.bild1.setSt(this.tSpace1[i]);
                        this.bild2.setSt(this.tSpace2[idx]);
                        ++matchCount;
                        Thread.sleep(0L);
                    }
                    ++i;
                }
                SLogger.debug("--------------------------------------------------------");
                SLogger.debug("findMatch after second section! matchCount=" + matchCount);
                SLogger.debug("--------------------------------------------------------");
            }
            if (this.theParams.getSearchOriginDistance() && matchCount < 100) {
                this.bild1.sortStarArray(0);
                this.bild2.sortStarArray(0);
                this.tSpace1 = new StarTriangle[maxIdx1];
                this.tSpace2 = new StarTriangle[maxIdx2];
                i = 0;
                while (i < maxIdx1) {
                    try {
                        this.tSpace1[i] = st1 = this.getCloseStarTriangle(i, this.sa1);
                        Thread.sleep(0L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace1);
                i = 0;
                while (i < maxIdx2) {
                    try {
                        this.tSpace2[i] = st2 = this.getCloseStarTriangle(i, this.sa2);
                        Thread.sleep(0L);
                    }
                    catch (NoTriangleException e) {
                        SLogger.debug("NoTriangleException.");
                    }
                    ++i;
                }
                Arrays.sort(this.tSpace2);
                i = 0;
                while (i < maxIdx1) {
                    idx = this.findMatchingST(i);
                    if (idx >= 0) {
                        this.bild1.addMatch(this.tSpace1[i]);
                        this.bild2.addMatch(this.tSpace2[idx]);
                        this.bild1.setSt(this.tSpace1[i]);
                        this.bild2.setSt(this.tSpace2[idx]);
                        ++matchCount;
                        Thread.sleep(0L);
                    }
                    ++i;
                }
                SLogger.debug("--------------------------------------------------------");
                SLogger.debug("findMatch after third section! matchCount=" + matchCount);
                SLogger.debug("--------------------------------------------------------");
            }
            this.verifyMatches();
            Thread.sleep(1000L);
            this.bild1.removeInvalidMatches();
            this.bild2.removeInvalidMatches();
            SLogger.debug("findMatch ended! Final matchCount=" + this.bild1.getNumMatches());
            this.calcBestMatchIndices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int findMatchingST(int i) {
        double eps = 0.002;
        int result = -1;
        StarTriangle st1 = this.tSpace1[i];
        this.bild1.setSt(st1);
        int idx = Arrays.binarySearch(this.tSpace2, st1);
        if (idx < 0) {
            idx = -idx;
        }
        double xt1 = st1.xt;
        double yt1 = st1.yt;
        try {
            double minDistance = 1.0;
            int minIndex = idx;
            int j = idx - 10;
            while (j < idx + 10) {
                if (j >= 0 && j < this.tSpace2.length - 1) {
                    this.bild2.setSt(this.tSpace2[j]);
                    double xt2 = this.tSpace2[j].xt;
                    double yt2 = this.tSpace2[j].yt;
                    double aQuadrat = Math.pow(xt1 - xt2, 2.0);
                    double bQuadrat = Math.pow(yt1 - yt2, 2.0);
                    double distance = Math.sqrt(aQuadrat + bQuadrat);
                    if (distance < eps && distance < minDistance) {
                        minDistance = distance;
                        st1.setTsDistance(distance);
                        this.tSpace2[j].setTsDistance(distance);
                        result = j;
                    }
                }
                ++j;
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void verifyMatches() {
        double avgScaleFactor = 0.0;
        double medianScaleFactor = 0.0;
        double medianAngle = 0.0;
        int vecSize = this.bild1.getNumMatches();
        int i = 0;
        SLogger.debug("Verifying Matches...");
        try {
            StarTriangle b2m1;
            StarTriangle b1m1;
            i = 0;
            while (i < vecSize) {
                b1m1 = this.bild1.getMatch(i);
                b2m1 = this.bild2.getMatch(i);
                if (b1m1.xt < 0.9 && b2m1.xt < 0.9) {
                    b1m1.setVerified(true);
                    b2m1.setVerified(true);
                }
                ++i;
            }
            this.bild1.removeInvalidMatches();
            this.bild2.removeInvalidMatches();
            vecSize = this.bild1.getNumMatches();
            if (this.theParams.getSameScale()) {
                medianScaleFactor = 1.0;
            } else {
                medianScaleFactor = this.calcMedianScaleFactor();
                SLogger.debug("medianScaleFactor=" + medianScaleFactor);
            }
            i = 0;
            while (i < vecSize) {
                b1m1 = this.bild1.getMatch(i);
                b2m1 = this.bild2.getMatch(i);
                double dist1 = b1m1.s2.calcDistance(b1m1.s3);
                double dist2 = b2m1.s2.calcDistance(b2m1.s3);
                double scaleFactor = dist1 / dist2;
                if (this.theParams.getSameScale()) {
                    medianScaleFactor = 1.0;
                }
                if (Math.abs(medianScaleFactor - scaleFactor) > medianScaleFactor / 25.0) {
                    b1m1.setVerified(false);
                    b2m1.setVerified(false);
                    SLogger.debug("Verify scale failed i=" + i);
                } else {
                    b1m1.setVerified(true);
                    b2m1.setVerified(true);
                    SLogger.debug("Verify ok i=" + i);
                }
                ++i;
            }
            this.bild1.removeInvalidMatches();
            this.bild2.removeInvalidMatches();
            vecSize = this.bild1.getNumMatches();
            medianAngle = this.calcMedianAngle();
            SLogger.debug("medianAngle=" + medianAngle);
            if (medianAngle != Double.NaN) {
                i = 0;
                while (i < vecSize) {
                    b1m1 = this.bild1.getMatch(i);
                    b2m1 = this.bild2.getMatch(i);
                    Star s1b1 = b1m1.getS2();
                    Star s2b1 = b1m1.getS3();
                    Star s1b2 = b2m1.getS2();
                    Star s2b2 = b2m1.getS3();
                    double angle = this.calcRotationAngle(s1b1, s2b1, s1b2, s2b2);
                    if (Math.abs(Math.abs(medianAngle) - Math.abs(angle)) > 90.0) {
                        b1m1.setVerified(false);
                        b2m1.setVerified(false);
                        SLogger.debug("Verify failed i=" + i);
                    } else {
                        b1m1.setVerified(true);
                        b2m1.setVerified(true);
                        SLogger.debug("Verify ok i=" + i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SLogger.debug("vecsize = " + vecSize + ", i = " + i);
        }
    }

    private void calcBestMatchIndices() {
        int secondIdx = 0;
        int bestIdx = 0;
        double second = 999.0;
        double best = 999.0;
        int vecSize = this.bild1.getNumMatches();
        double medianScaleFactor = this.calcMedianScaleFactor();
        int i = 0;
        while (i < vecSize) {
            double dist2;
            StarTriangle b1m1 = this.bild1.getMatch(i);
            StarTriangle b2m1 = this.bild2.getMatch(i);
            double dist1 = b1m1.s2.calcDistance(b1m1.s3);
            double sf = dist1 / (dist2 = b2m1.s2.calcDistance(b2m1.s3));
            double cur = Math.abs(sf - medianScaleFactor);
            if (cur < best) {
                best = cur;
                bestIdx = i;
            } else if (cur > best && cur < second) {
                second = cur;
                secondIdx = i;
            }
            ++i;
        }
        this.bestMatchIndex = bestIdx;
        this.secondBestMatchIndex = secondIdx;
    }

    private double calcMedianAngle() {
        int vecSize = this.bild1.getNumMatches();
        double[] ang = new double[vecSize];
        int i = 0;
        while (i < vecSize) {
            StarTriangle b1m1 = this.bild1.getMatch(i);
            StarTriangle b2m1 = this.bild2.getMatch(i);
            Star s1b1 = b1m1.getS2();
            Star s2b1 = b1m1.getS3();
            Star s1b2 = b2m1.getS2();
            Star s2b2 = b2m1.getS3();
            ang[i] = this.calcRotationAngle(s1b1, s2b1, s1b2, s2b2);
            ++i;
        }
        Arrays.sort(ang);
        return this.calcMedian(ang);
    }

    private double calcMedianScaleFactor() {
        int vecSize = this.bild1.getNumMatches();
        double[] sf = new double[vecSize];
        int i = 0;
        while (i < vecSize) {
            StarTriangle b1m1 = this.bild1.getMatch(i);
            StarTriangle b2m1 = this.bild2.getMatch(i);
            double dist1 = b1m1.s2.calcDistance(b1m1.s3);
            double dist2 = b2m1.s2.calcDistance(b2m1.s3);
            sf[i] = dist1 / dist2;
            ++i;
        }
        Arrays.sort(sf);
        double medianScaleFactor = this.calcMedian(sf);
        return medianScaleFactor;
    }

    private double calcMedian(double[] ar) {
        int len = ar.length;
        boolean oddIndices = len / 2 * 2 != len;
        int medIndex = len / 2;
        if (len == 2) {
            medIndex = 0;
        }
        if (len == 1) {
            medIndex = 0;
        }
        if (len == 0) {
            return Double.NaN;
        }
        double median = oddIndices ? ar[medIndex] : (ar[medIndex] + ar[medIndex + 1]) / 2.0;
        return median;
    }

    private double calcAvgScaleFactor() {
        double avgScaleFactor = 0.0;
        int vecSize = this.bild1.getNumMatches();
        int i = 0;
        while (i < vecSize) {
            StarTriangle b1m1 = this.bild1.getMatch(i);
            StarTriangle b2m1 = this.bild2.getMatch(i);
            double dist1 = b1m1.s2.calcDistance(b1m1.s3);
            double dist2 = b2m1.s2.calcDistance(b2m1.s3);
            avgScaleFactor += dist1 / dist2;
            ++i;
        }
        SLogger.debug("avgScaleFactor=" + (avgScaleFactor /= (double)vecSize));
        return avgScaleFactor;
    }

    private StarTriangle getCloseStarTriangle(int sIdx, Star[] ar) throws NoTriangleException {
        double closest = Double.MAX_VALUE;
        double secondclosest = Double.MAX_VALUE;
        int closestIdx = 0;
        int secondIdx = 0;
        int hI = this.theParams.getHalfIntervall();
        int startIdx = sIdx - hI < 0 ? 0 : sIdx - hI;
        int endIdx = sIdx + hI >= ar.length ? ar.length - 1 : sIdx + hI;
        int i = startIdx;
        while (i < endIdx) {
            double curDist = ar[sIdx].calcDistance(ar[i]);
            if (curDist <= closest && i != sIdx) {
                secondIdx = closestIdx;
                secondclosest = closest;
                closestIdx = i;
                closest = curDist;
            } else if (curDist <= secondclosest && i != sIdx) {
                secondIdx = i;
                secondclosest = curDist;
            }
            ++i;
        }
        return new StarTriangle(ar[sIdx], sIdx, ar[closestIdx], closestIdx, ar[secondIdx], secondIdx);
    }

    private StarTriangle getBrightStarTriangle(int sIdx, Star[] ar) throws NoTriangleException {
        if (sIdx < ar.length - 3) {
            return new StarTriangle(ar[sIdx], sIdx, ar[sIdx + 1], sIdx + 1, ar[sIdx + 2], sIdx + 2);
        }
        return null;
    }

    public Bild getRegisteredImage() {
        return this.registeredImage;
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

