/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.gui.ImageLabel;
import de.andreasroerig.gui.ImagePopupMenu;
import de.andreasroerig.util.SLogger;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;

public class ImageFrame
extends JInternalFrame
implements MouseListener,
ActionListener,
KeyListener {
    private static final String cln = "ImageFrame";
    Image img = null;
    public int width = 0;
    public int height = 0;
    public Bild theBild;
    private String name;
    private JScrollPane areaScrollPane;
    private ImageLabel imgLabel;
    private int blackPt;
    private int whitePt;
    private ImagePopupMenu popup;

    public ImageFrame(String sz, Image picture) {
        super(sz, true, true, true, true);
        SLogger.debug("ImageFrame sz=" + sz);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.blackPt = 0;
        this.whitePt = 255;
        this.name = sz;
        this.img = picture;
        if (this.img != null) {
            this.width = this.img.getWidth(this);
            this.height = this.img.getHeight(this);
        }
        if (this.img == null || this.width < 1 || this.height < 1) {
            this.width = 256;
            this.height = 256;
        }
        SLogger.debug("Width = " + this.width + ", Height = " + this.height);
        this.blackPt = 0;
        this.whitePt = 255;
        this.imgLabel = new ImageLabel(new ImageIcon(this.img));
        this.imgLabel.setBiWidth(this.width);
        this.imgLabel.setBiHeight(this.height);
        this.setSize(this.width + this.getInsets().left + this.getInsets().right, this.height + this.getInsets().top + this.getInsets().bottom);
        this.areaScrollPane = new JScrollPane(this.imgLabel);
        this.areaScrollPane.setVerticalScrollBarPolicy(20);
        this.areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.getContentPane().add(this.areaScrollPane);
        this.popup = new ImagePopupMenu(this);
        this.areaScrollPane.addMouseListener(this);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.setResizable(true);
        this.pack();
        this.setVisible(true);
        this.theBild = null;
    }

    private void zoomIn() {
        int zoom = this.theBild.getZoom();
        if (--zoom > 0) {
            this.refreshImage(this.getBlackPt(), this.getWhitePt(), zoom);
        }
    }

    private void zoomOut() {
        int zoom = this.theBild.getZoom();
        if (++zoom < 20) {
            this.refreshImage(this.getBlackPt(), this.getWhitePt(), zoom);
        }
    }

    private void zoomTo1() {
        this.refreshImage(this.getBlackPt(), this.getWhitePt(), 1);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equalsIgnoreCase("Zoom in")) {
            this.zoomIn();
        }
        if (event.getActionCommand().equalsIgnoreCase("Zoom out")) {
            this.zoomOut();
        }
        if (event.getActionCommand().equalsIgnoreCase("Zoom to 1:1")) {
            this.zoomTo1();
        }
    }

    public void close() {
        this.setVisible(false);
        this.theBild.setTheFrame(null);
        this.theBild = null;
        this.img = null;
        this.dispose();
        try {
            this.finalize();
        }
        catch (Throwable e) {
            SLogger.debug("ImageFrame.close() Fehler");
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.theBild = null;
        this.img = null;
        this.imgLabel = null;
    }

    public Bild getTheBild() {
        return this.theBild;
    }

    public void setTheBild(Bild myBild) {
        this.theBild = myBild;
        if (this.theBild != null) {
            this.setTitle(String.valueOf(this.name) + "  Zoom: 1/" + myBild.getZoom());
            this.theBild.setTheFrame(this);
            this.imgLabel.setMyBild(myBild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setScreenStretch(int black, int white) {
        if (black != this.blackPt || white != this.whitePt) {
            this.blackPt = black;
            this.whitePt = white;
            this.refreshImage(black, white);
        }
    }

    public void refreshImage(int black, int white, int zoom) {
        this.blackPt = black;
        this.whitePt = white;
        this.img = this.theBild.getBufferedImage(black, white, zoom);
        if (this.img != null) {
            this.width = this.img.getWidth(this);
            this.height = this.img.getHeight(this);
        }
        if (this.img == null || this.width < 1 || this.height < 1) {
            this.width = 256;
            this.height = 256;
        }
        this.getContentPane().remove(this.areaScrollPane);
        ImageIcon icon = new ImageIcon(this.img);
        this.imgLabel = new ImageLabel(icon);
        this.imgLabel.setMyBild(this.theBild);
        this.imgLabel.setBiWidth(this.width);
        this.imgLabel.setBiHeight(this.height);
        this.areaScrollPane = new JScrollPane(this.imgLabel);
        this.areaScrollPane.setVerticalScrollBarPolicy(20);
        this.areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.areaScrollPane.addMouseListener(this);
        this.getContentPane().add(this.areaScrollPane);
        this.setTitle(String.valueOf(this.name) + "  Zoom: 1/" + zoom);
        this.forceRepaint();
    }

    public void refreshImage(int black, int white) {
        this.refreshImage(black, white, this.theBild.getZoom());
    }

    public void forceRepaint() {
        this.setLocation(this.getX(), this.getY());
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getBlackPt() {
        return this.blackPt;
    }

    public void setBlackPt(int blackPt) {
        this.blackPt = blackPt;
    }

    public int getWhitePt() {
        return this.whitePt;
    }

    public void setWhitePt(int whitePt) {
        this.whitePt = whitePt;
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow(true);
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyChar()) {
            case '+': {
                this.zoomIn();
                break;
            }
            case '-': {
                this.zoomOut();
                break;
            }
            case '1': {
                this.zoomTo1();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

